/*
 * Decompiled with CFR 0.152.
 */
package org.cups;

import java.io.IOException;
import java.util.List;
import org.cups.Cups;
import org.cups.IPPAttribute;
import org.cups.IPPValue;

public class CupsPrinter {
    String printer_name;
    String printer_location;
    String printer_info;
    String printer_more_info;
    String[] printer_uri_supported;
    String[] uri_authentication_supported;
    String[] uri_security_supported;
    String attributes_charset;
    String attributes_natural_language;
    int printer_state;
    String printer_state_text;
    String printer_state_reasons;
    boolean printer_is_accepting_jobs;
    long printer_up_time;
    long printer_current_time;
    int queued_job_count;
    String[] pdl_override_supported;
    String[] ipp_versions_supported;
    int[] operations_supported;
    boolean multiple_document_jobs_supported;
    int multiple_operation_time_out;
    int[] multiple_document_handling_supported;
    String charset_configured;
    String natural_language_configured;
    String generated_natural_language_supported;
    String[] charset_supported;
    String document_format_default;
    String[] document_format_supported;
    String[] compression_supported;
    int job_priority_default;
    int job_priority_supported;
    int copies_default;
    int lower_copies_supported;
    int upper_copies_supported;
    boolean page_ranges_supported;
    int number_up_default;
    int[] number_up_supported;
    int orientation_requested_default;
    int[] orientation_requested_supported;
    int job_quota_period;
    int job_k_limit;
    int job_page_limit;
    String job_sheets_default;
    String[] job_sheets_supported;
    String device_uri;
    boolean color_supported;
    int pages_per_minute;
    String printer_make_and_model;
    String media_default;
    String[] media_supported;
    int finishings_default;
    int[] finishings_supported;
    int printer_type;

    public CupsPrinter(Cups cups) {
        this.setDefaults();
    }

    public CupsPrinter(Cups cups, String string) {
        this.setDefaults();
        this.printer_name = string;
        this.getStatus(cups);
        this.getAttributes(cups);
    }

    public void setDefaults() {
        this.printer_name = "";
        this.printer_location = "";
        this.printer_info = "";
        this.printer_more_info = "";
        this.printer_uri_supported = null;
        this.uri_authentication_supported = null;
        this.uri_security_supported = null;
        this.attributes_charset = "us-ascii";
        this.attributes_natural_language = "en";
        this.printer_state = -1;
        this.printer_state_text = "";
        this.printer_state_reasons = "";
        this.printer_is_accepting_jobs = false;
        this.printer_up_time = 0L;
        this.printer_current_time = 0L;
        this.queued_job_count = 0;
        this.pdl_override_supported = null;
        this.ipp_versions_supported = null;
        this.operations_supported = null;
        this.multiple_document_jobs_supported = false;
        this.multiple_operation_time_out = 0;
        this.multiple_document_handling_supported = null;
        this.charset_configured = "";
        this.natural_language_configured = "";
        this.generated_natural_language_supported = "";
        this.charset_supported = null;
        this.document_format_default = "";
        this.document_format_supported = null;
        this.compression_supported = null;
        this.job_priority_default = -1;
        this.job_priority_supported = -1;
        this.copies_default = 1;
        this.lower_copies_supported = 1;
        this.upper_copies_supported = 1;
        this.page_ranges_supported = false;
        this.number_up_default = 0;
        this.number_up_supported = null;
        this.orientation_requested_default = 0;
        this.orientation_requested_supported = null;
        this.job_quota_period = 0;
        this.job_k_limit = 0;
        this.job_page_limit = 0;
        this.job_sheets_default = "none,none";
        this.job_sheets_supported = null;
        this.device_uri = "";
        this.color_supported = false;
        this.pages_per_minute = 0;
        this.printer_make_and_model = "";
        this.media_default = "";
        this.media_supported = null;
        this.finishings_default = 0;
        this.finishings_supported = null;
        this.printer_type = 0;
    }

    public boolean getStatus(Cups cups) {
        try {
            List list = cups.cupsGetPrinterStatus(this.printer_name);
            int n = 0;
            while (n < list.size()) {
                IPPAttribute iPPAttribute = (IPPAttribute)list.get(n);
                this.updateAttribute(iPPAttribute);
                ++n;
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean getAttributes(Cups cups) {
        try {
            List list = cups.cupsGetPrinterAttributes(this.printer_name);
            int n = 0;
            while (n < list.size()) {
                IPPAttribute iPPAttribute = (IPPAttribute)list.get(n);
                this.updateAttribute(iPPAttribute);
                ++n;
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void updateAttribute(IPPAttribute iPPAttribute) {
        if (iPPAttribute.name.compareTo("printer-name") == 0) {
            IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(0);
            this.printer_name = iPPValue.text;
        } else if (iPPAttribute.name.compareTo("printer-location") == 0) {
            IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(0);
            this.printer_location = iPPValue.text;
        } else if (iPPAttribute.name.compareTo("printer-info") == 0) {
            IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(0);
            this.printer_info = iPPValue.text;
        } else if (iPPAttribute.name.compareTo("printer-more-info") == 0) {
            IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(0);
            this.printer_more_info = iPPValue.text;
        } else if (iPPAttribute.name.compareTo("printer-uri-supported") == 0) {
            this.printer_uri_supported = new String[iPPAttribute.values.size()];
            int n = 0;
            while (n < iPPAttribute.values.size()) {
                IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(n);
                this.printer_uri_supported[n] = iPPValue.text;
                ++n;
            }
        } else if (iPPAttribute.name.compareTo("uri-authentication-supported") == 0) {
            this.uri_authentication_supported = new String[iPPAttribute.values.size()];
            int n = 0;
            while (n < iPPAttribute.values.size()) {
                IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(n);
                this.uri_authentication_supported[n] = iPPValue.text;
                ++n;
            }
        } else if (iPPAttribute.name.compareTo("uri-security-supported") == 0) {
            this.uri_security_supported = new String[iPPAttribute.values.size()];
            int n = 0;
            while (n < iPPAttribute.values.size()) {
                IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(n);
                this.uri_security_supported[n] = iPPValue.text;
                ++n;
            }
        } else if (iPPAttribute.name.compareTo("attributes-charset") == 0) {
            IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(0);
            this.attributes_charset = iPPValue.text;
        } else if (iPPAttribute.name.compareTo("attributes-natural-language") == 0) {
            IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(0);
            this.attributes_natural_language = iPPValue.text;
        } else if (iPPAttribute.name.compareTo("printer-state") == 0) {
            IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(0);
            this.printer_state = iPPValue.integer_value;
            switch (this.printer_state) {
                case 3: {
                    this.printer_state_text = "idle";
                    break;
                }
                case 4: {
                    this.printer_state_text = "processing";
                    break;
                }
                case 5: {
                    this.printer_state_text = "stopped";
                }
            }
        } else if (iPPAttribute.name.compareTo("printer-state-reasons") == 0) {
            IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(0);
            this.printer_state_reasons = iPPValue.text;
        } else if (iPPAttribute.name.compareTo("printer-is-accepting-jobs") == 0) {
            IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(0);
            this.printer_is_accepting_jobs = iPPValue.boolean_value;
        } else if (iPPAttribute.name.compareTo("printer-up-time") == 0) {
            IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(0);
            this.printer_up_time = iPPValue.integer_value;
        } else if (iPPAttribute.name.compareTo("printer-current-time") == 0) {
            IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(0);
            this.printer_current_time = iPPValue.unix_time;
        } else if (iPPAttribute.name.compareTo("queue-job-count") == 0) {
            IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(0);
            this.queued_job_count = iPPValue.integer_value;
        } else if (iPPAttribute.name.compareTo("pdl-override-supported") == 0) {
            this.pdl_override_supported = new String[iPPAttribute.values.size()];
            int n = 0;
            while (n < iPPAttribute.values.size()) {
                IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(n);
                this.pdl_override_supported[n] = iPPValue.text;
                ++n;
            }
        } else if (iPPAttribute.name.compareTo("ipp-versions-supported") == 0) {
            this.ipp_versions_supported = new String[iPPAttribute.values.size()];
            int n = 0;
            while (n < iPPAttribute.values.size()) {
                IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(n);
                this.ipp_versions_supported[n] = iPPValue.text;
                ++n;
            }
        } else if (iPPAttribute.name.compareTo("operations-supported") == 0) {
            this.operations_supported = new int[iPPAttribute.values.size()];
            int n = 0;
            while (n < iPPAttribute.values.size()) {
                IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(n);
                this.operations_supported[n] = iPPValue.integer_value;
                ++n;
            }
        } else if (iPPAttribute.name.compareTo("multiple-document-jobs-supported") == 0) {
            IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(0);
            this.multiple_document_jobs_supported = iPPValue.boolean_value;
        } else if (iPPAttribute.name.compareTo("multiple-operation-time-out") == 0) {
            IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(0);
            this.multiple_operation_time_out = iPPValue.integer_value;
        } else if (iPPAttribute.name.compareTo("multiple-document-handling-supported") == 0) {
            this.multiple_document_handling_supported = new int[iPPAttribute.values.size()];
            int n = 0;
            while (n < iPPAttribute.values.size()) {
                IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(n);
                this.multiple_document_handling_supported[n] = iPPValue.integer_value;
                ++n;
            }
        } else if (iPPAttribute.name.compareTo("charset-configured") == 0) {
            IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(0);
            this.charset_configured = iPPValue.text;
        } else if (iPPAttribute.name.compareTo("natural-language-configured") == 0) {
            IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(0);
            this.natural_language_configured = iPPValue.text;
        } else if (iPPAttribute.name.compareTo("generated-natural-language-supported") == 0) {
            IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(0);
            this.generated_natural_language_supported = iPPValue.text;
        } else if (iPPAttribute.name.compareTo("charset-supported") == 0) {
            this.charset_supported = new String[iPPAttribute.values.size()];
            int n = 0;
            while (n < iPPAttribute.values.size()) {
                IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(n);
                this.charset_supported[n] = iPPValue.text;
                ++n;
            }
        } else if (iPPAttribute.name.compareTo("document-format-default") == 0) {
            IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(0);
            this.document_format_default = iPPValue.text;
        } else if (iPPAttribute.name.compareTo("document-format-supported") == 0) {
            this.document_format_supported = new String[iPPAttribute.values.size()];
            int n = 0;
            while (n < iPPAttribute.values.size()) {
                IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(n);
                this.document_format_supported[n] = iPPValue.text;
                ++n;
            }
        } else if (iPPAttribute.name.compareTo("compression-supported") == 0) {
            this.compression_supported = new String[iPPAttribute.values.size()];
            int n = 0;
            while (n < iPPAttribute.values.size()) {
                IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(n);
                this.compression_supported[n] = iPPValue.text;
                ++n;
            }
        } else if (iPPAttribute.name.compareTo("job-priority-default") == 0) {
            IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(0);
            this.job_priority_default = iPPValue.integer_value;
        } else if (iPPAttribute.name.compareTo("job-priority-supported") == 0) {
            IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(0);
            this.job_priority_supported = iPPValue.integer_value;
        } else if (iPPAttribute.name.compareTo("copies-default") == 0) {
            IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(0);
            this.copies_default = iPPValue.integer_value;
        } else if (iPPAttribute.name.compareTo("copies-supported") == 0) {
            IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(0);
            this.lower_copies_supported = iPPValue.lower;
            this.upper_copies_supported = iPPValue.upper;
        } else if (iPPAttribute.name.compareTo("page-ranges-supported") == 0) {
            IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(0);
            this.page_ranges_supported = iPPValue.boolean_value;
        } else if (iPPAttribute.name.compareTo("number-up-default") == 0) {
            IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(0);
            this.number_up_default = iPPValue.integer_value;
        } else if (iPPAttribute.name.compareTo("number-up-supported") == 0) {
            this.number_up_supported = new int[iPPAttribute.values.size()];
            int n = 0;
            while (n < iPPAttribute.values.size()) {
                IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(n);
                this.number_up_supported[n] = iPPValue.integer_value;
                ++n;
            }
        } else if (iPPAttribute.name.compareTo("orientation-requested-default") == 0) {
            IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(0);
            this.orientation_requested_default = iPPValue.integer_value;
        } else if (iPPAttribute.name.compareTo("orientation-requested-supported") == 0) {
            this.orientation_requested_supported = new int[iPPAttribute.values.size()];
            int n = 0;
            while (n < iPPAttribute.values.size()) {
                IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(n);
                this.orientation_requested_supported[n] = iPPValue.integer_value;
                ++n;
            }
        } else if (iPPAttribute.name.compareTo("job-quota-period") == 0) {
            IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(0);
            this.job_quota_period = iPPValue.integer_value;
        } else if (iPPAttribute.name.compareTo("job-k-limit") == 0) {
            IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(0);
            this.job_k_limit = iPPValue.integer_value;
        } else if (iPPAttribute.name.compareTo("job-page-limit") == 0) {
            IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(0);
            this.job_page_limit = iPPValue.integer_value;
        } else if (iPPAttribute.name.compareTo("job-sheets-default") == 0) {
            IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(0);
            this.job_sheets_default = iPPValue.text;
        } else if (iPPAttribute.name.compareTo("job-sheets-supported") == 0) {
            this.job_sheets_supported = new String[iPPAttribute.values.size()];
            int n = 0;
            while (n < iPPAttribute.values.size()) {
                IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(n);
                this.job_sheets_supported[n] = iPPValue.text;
                ++n;
            }
        } else if (iPPAttribute.name.compareTo("device-uri") == 0) {
            IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(0);
            this.device_uri = iPPValue.text;
        } else if (iPPAttribute.name.compareTo("color-supported") == 0) {
            IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(0);
            this.color_supported = iPPValue.boolean_value;
        } else if (iPPAttribute.name.compareTo("pages-per-minute") == 0) {
            IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(0);
            this.pages_per_minute = iPPValue.integer_value;
        } else if (iPPAttribute.name.compareTo("printer-make-and-model") == 0) {
            IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(0);
            this.printer_make_and_model = iPPValue.text;
        } else if (iPPAttribute.name.compareTo("media-default") == 0) {
            IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(0);
            this.media_default = iPPValue.text;
        } else if (iPPAttribute.name.compareTo("media-supported") == 0) {
            this.media_supported = new String[iPPAttribute.values.size()];
            int n = 0;
            while (n < iPPAttribute.values.size()) {
                IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(n);
                this.media_supported[n] = iPPValue.text;
                ++n;
            }
        } else if (iPPAttribute.name.compareTo("finishings-default") == 0) {
            IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(0);
            this.finishings_default = iPPValue.integer_value;
        } else if (iPPAttribute.name.compareTo("finishings-supported") == 0) {
            this.finishings_supported = new int[iPPAttribute.values.size()];
            int n = 0;
            while (n < iPPAttribute.values.size()) {
                IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(n);
                this.finishings_supported[n] = iPPValue.integer_value;
                ++n;
            }
        } else if (iPPAttribute.name.compareTo("printer-type") == 0) {
            IPPValue iPPValue = (IPPValue)iPPAttribute.values.get(0);
            this.printer_type = iPPValue.integer_value;
        }
    }

    public String getPrinterName() {
        return this.printer_name;
    }

    public String getStateText() {
        return this.printer_state_text;
    }

    public String getStateReasons() {
        return this.printer_state_reasons;
    }

    public String getLocation() {
        return this.printer_location;
    }

    public String getMakeAndModel() {
        return this.printer_make_and_model;
    }

    public String getJobSheetsDefault() {
        return this.job_sheets_default;
    }

    public String[] getJobSheetsSupported() {
        return this.job_sheets_supported;
    }

    public int getOrientationDefault() {
        return this.orientation_requested_default;
    }

    public int[] getOrientationSupported() {
        return this.orientation_requested_supported;
    }

    public int getLowerCopiesSupported() {
        return this.lower_copies_supported;
    }

    public int getUpperCopiesSupported() {
        return this.upper_copies_supported;
    }

    public int getCopiesDefault() {
        return this.copies_default;
    }

    public boolean getPageRangesSupported() {
        return this.page_ranges_supported;
    }

    void dump() {
        int n;
        System.out.println("Printer Name: " + this.printer_name);
        System.out.println("Location:     " + this.printer_location);
        System.out.println("Printer Info: " + this.printer_info);
        System.out.println("More Info:    " + this.printer_more_info);
        if (this.printer_uri_supported != null) {
            System.out.println("Printer URI's Supported: ");
            n = 0;
            while (n < this.printer_uri_supported.length) {
                System.out.println("  " + this.printer_uri_supported[n]);
                ++n;
            }
        }
        if (this.uri_authentication_supported != null) {
            System.out.println("URI Authentication Supported: ");
            n = 0;
            while (n < this.uri_authentication_supported.length) {
                System.out.println("  " + this.uri_authentication_supported[n]);
                ++n;
            }
        }
        if (this.uri_security_supported != null) {
            System.out.println("URI Security Supported: ");
            n = 0;
            while (n < this.uri_security_supported.length) {
                System.out.println("  " + this.uri_security_supported[n]);
                ++n;
            }
        }
        System.out.println("Attributes Charset: " + this.attributes_charset);
        System.out.println("Attributes Natural Language: " + this.attributes_natural_language);
        System.out.println("Printer State: " + this.printer_state);
        System.out.println("Printer State Text: " + this.printer_state_text);
        System.out.println("Printer State Reasons: " + this.printer_state_reasons);
        if (this.printer_is_accepting_jobs) {
            System.out.println("Accepting Jobs:  Yes");
        } else {
            System.out.println("Accepting Jobs:  No");
        }
    }
}

