/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.AddressException;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.gc_interface.CollectedHeap;
import sun.jvm.hotspot.memory.Universe;
import sun.jvm.hotspot.oops.DefaultHeapVisitor;
import sun.jvm.hotspot.oops.DefaultOopVisitor;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.NamedFieldIdentifier;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopField;
import sun.jvm.hotspot.oops.UnknownOopException;
import sun.jvm.hotspot.runtime.AddressVisitor;
import sun.jvm.hotspot.runtime.JNIHandleBlock;
import sun.jvm.hotspot.runtime.JNIHandles;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.StackFrameStream;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.utilities.LivenessPath;
import sun.jvm.hotspot.utilities.LivenessPathElement;
import sun.jvm.hotspot.utilities.LivenessPathList;
import sun.jvm.hotspot.utilities.MarkBits;

public class LivenessAnalysis {
    private static final boolean DEBUG = false;
    private ProgressThunk progressThunk;
    private long usedSize;
    private long visitedSize;
    private double lastNotificationFraction;
    private static final double MINIMUM_NOTIFICATION_FRACTION = 0.01;
    private Target target;
    private ObjectHeap heap;
    private MarkBits markBits;
    private LivenessPath path;
    private Map result;
    private int depth;

    public void setTarget(Target target) {
        this.target = target;
    }

    public void setTargetObjects(final Set setOfOops) {
        this.target = new Target(){

            public boolean isTarget(Oop obj) {
                return setOfOops.contains(obj);
            }
        };
    }

    public void setProgressThunk(ProgressThunk thunk) {
        this.progressThunk = thunk;
    }

    public void run() {
        if (this.target == null) {
            throw new RuntimeException("Must specify target first");
        }
        VM vm = VM.getVM();
        Universe universe = vm.getUniverse();
        CollectedHeap collHeap = universe.heap();
        this.usedSize = collHeap.used();
        this.visitedSize = 0L;
        this.markBits = new MarkBits(collHeap);
        this.heap = vm.getObjectHeap();
        this.path = new LivenessPath();
        this.result = new HashMap();
        for (JavaThread thread = VM.getVM().getThreads().first(); thread != null; thread = thread.next()) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            thread.printThreadIDOn(new PrintStream(bos));
            String threadDesc = " in thread \"" + thread.getThreadName() + "\" (id " + bos.toString() + ")";
            this.doStack(thread, new RootVisitor("Stack root" + threadDesc));
            this.doJNIHandleBlock(thread.activeHandles(), new RootVisitor("JNI handle root" + threadDesc));
        }
        JNIHandles handles = VM.getVM().getJNIHandles();
        this.doJNIHandleBlock(handles.globalHandles(), new RootVisitor("Global JNI handle root"));
        this.doJNIHandleBlock(handles.weakGlobalHandles(), new RootVisitor("Weak global JNI handle root"));
        this.heap.iteratePerm(new DefaultHeapVisitor(){

            public void doObj(Oop obj) {
                if (obj instanceof InstanceKlass) {
                    InstanceKlass ik = (InstanceKlass)obj;
                    ik.iterateFields(new DefaultOopVisitor(this, ik){
                        private final /* synthetic */ InstanceKlass val$ik;
                        private final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$ik = val$ik;
                        }

                        public void doOop(OopField field, boolean isVMField) {
                            LivenessAnalysis.access$100(2.access$000(this.this$1)).push(new LivenessPathElement(null, new NamedFieldIdentifier("Static field \"" + field.getID().getName() + "\" in class \"" + this.val$ik.getName().asString() + "\"")));
                            try {
                                LivenessAnalysis.access$200(2.access$000(this.this$1), field.getValue(this.val$ik));
                            }
                            catch (AddressException e) {
                                System.err.print("Liveness analysis: WARNING: AddressException at 0x" + Long.toHexString(e.getAddress()) + " while traversing static fields of InstanceKlass ");
                                this.val$ik.printValueOn(System.err);
                                System.err.println();
                            }
                            catch (UnknownOopException e) {
                                System.err.println("Liveness analysis: WARNING: UnknownOopException while traversing static fields of InstanceKlass ");
                                this.val$ik.printValueOn(System.err);
                                System.err.println();
                            }
                            LivenessAnalysis.access$100(2.access$000(this.this$1)).pop();
                        }
                    }, false);
                }
            }

            static /* synthetic */ LivenessAnalysis access$000(2 x0) {
                return x0.LivenessAnalysis.this;
            }
        });
        if (this.progressThunk != null) {
            this.progressThunk.done();
        }
        this.markBits = null;
    }

    public Map result() {
        return this.result;
    }

    private void markAndTraverse(OopHandle handle) {
        try {
            this.markAndTraverse(this.heap.newOop(handle));
        }
        catch (AddressException e) {
            System.err.println("Liveness analysis: WARNING: AddressException at 0x" + Long.toHexString(e.getAddress()) + " while traversing oop at " + handle);
        }
        catch (UnknownOopException e) {
            System.err.println("Liveness analysis: WARNING: UnknownOopException for oop at " + handle);
        }
    }

    private void printHeader() {
        for (int i = 0; i < this.depth; ++i) {
            System.err.print(" ");
        }
    }

    private void markAndTraverse(final Oop obj) {
        boolean isTarget;
        if (obj == null) {
            return;
        }
        if (!this.markBits.mark(obj)) {
            return;
        }
        if (this.progressThunk != null) {
            this.visitedSize += obj.getObjectSize();
            double curFrac = (double)this.visitedSize / (double)this.usedSize;
            if (curFrac > this.lastNotificationFraction + 0.01) {
                this.progressThunk.visitedFractionUpdate(curFrac);
                this.lastNotificationFraction = curFrac;
            }
        }
        if (isTarget = this.target.isTarget(obj)) {
            this.path.push(new LivenessPathElement(obj, null));
            LivenessPathList list = (LivenessPathList)this.result.get(obj);
            if (list == null) {
                list = new LivenessPathList();
                this.result.put(obj, list);
            }
            list.add(this.path.copy());
            this.path.pop();
        }
        try {
            obj.iterate(new DefaultOopVisitor(){

                public void doOop(OopField field, boolean isVMField) {
                    LivenessAnalysis.this.doFieldInObj(obj, field);
                }
            }, false);
        }
        catch (Exception e) {
            System.err.println("LivenessAnalysis: WARNING: " + e + " during traversal");
        }
        if (isTarget) {
            this.markBits.clear(obj);
        }
    }

    private void doFieldInObj(Oop obj, OopField field) {
        if (obj == null) {
            return;
        }
        this.path.push(new LivenessPathElement(obj, field.getID()));
        Oop next = field.getValue(obj);
        this.markAndTraverse(next);
        this.path.pop();
    }

    private void doStack(JavaThread thread, AddressVisitor oopVisitor) {
        StackFrameStream fst = new StackFrameStream(thread);
        while (!fst.isDone()) {
            fst.getCurrent().oopsDo(oopVisitor, fst.getRegisterMap());
            fst.next();
        }
    }

    private void doJNIHandleBlock(JNIHandleBlock handles, AddressVisitor oopVisitor) {
        handles.oopsDo(oopVisitor);
    }

    static /* synthetic */ void access$200(LivenessAnalysis x0, Oop x1) {
        x0.markAndTraverse(x1);
    }

    class RootVisitor
    implements AddressVisitor {
        private String baseRootDescription;

        RootVisitor(String baseRootDescription) {
            this.baseRootDescription = baseRootDescription;
        }

        public void visitAddress(Address addr) {
            LivenessAnalysis.this.path.push(new LivenessPathElement(null, new NamedFieldIdentifier(this.baseRootDescription + " @ " + addr)));
            LivenessAnalysis.this.markAndTraverse(addr.getOopHandleAt(0L));
            LivenessAnalysis.this.path.pop();
        }
    }

    public static interface Target {
        public boolean isTarget(Oop var1);
    }

    public static interface ProgressThunk {
        public void visitedFractionUpdate(double var1);

        public void done();
    }
}

