/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class VirtualSpace
extends VMObject {
    private static AddressField lowField;
    private static AddressField highField;
    private static AddressField lowBoundaryField;
    private static AddressField highBoundaryField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("VirtualSpace");
        lowField = type.getAddressField("_low");
        highField = type.getAddressField("_high");
        lowBoundaryField = type.getAddressField("_low_boundary");
        highBoundaryField = type.getAddressField("_high_boundary");
    }

    public VirtualSpace(Address addr) {
        super(addr);
    }

    public Address low() {
        return lowField.getValue(this.addr);
    }

    public Address high() {
        return highField.getValue(this.addr);
    }

    public Address lowBoundary() {
        return lowBoundaryField.getValue(this.addr);
    }

    public Address highBoundary() {
        return highBoundaryField.getValue(this.addr);
    }

    public long committedSize() {
        return this.high().minus(this.low());
    }

    public long reservedSize() {
        return this.highBoundary().minus(this.lowBoundary());
    }

    public long uncommittedSize() {
        return this.reservedSize() - this.committedSize();
    }

    public boolean contains(Address addr) {
        return this.low().lessThanOrEqual(addr) && addr.lessThan(this.high());
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                VirtualSpace.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

