/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import java.util.ArrayList;
import java.util.List;
import sun.management.BooleanFlag;
import sun.management.Flag;
import sun.management.HotspotRuntimeMBean;
import sun.management.LongFlag;
import sun.management.ManagementFactory;
import sun.management.StringFlag;
import sun.management.VMManagement;

class HotspotRuntime
implements HotspotRuntimeMBean {
    private VMManagement jvm;
    private static final String JAVA_RT = "java.rt.";
    private static final String COM_SUN_RT = "com.sun.rt.";
    private static final String SUN_RT = "sun.rt.";
    private static final String JAVA_PROPERTY = "java.property.";
    private static final String COM_SUN_PROPERTY = "com.sun.property.";
    private static final String SUN_PROPERTY = "sun.property.";
    private static final String RT_COUNTER_NAME_PATTERN = "java.rt.|com.sun.rt.|sun.rt.|java.property.|com.sun.property.|sun.property.";

    HotspotRuntime(VMManagement vMManagement) {
        this.jvm = vMManagement;
    }

    public long getSafepointCount() {
        return this.jvm.getSafepointCount();
    }

    public long getTotalSafepointTime() {
        return this.jvm.getTotalSafepointTime();
    }

    public long getSafepointSyncTime() {
        return this.jvm.getSafepointSyncTime();
    }

    public List getInternalFlagNames() {
        ManagementFactory.checkMonitorAccess();
        String[] stringArray = this.getAllFlagNames();
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            arrayList.add(stringArray[i2]);
        }
        return arrayList;
    }

    public List getInternalFlags() {
        ManagementFactory.checkMonitorAccess();
        int n2 = this.getInternalFlagCount();
        Flag[] flagArray = new Flag[n2];
        int n3 = this.getFlags(null, flagArray, n2);
        ArrayList<Flag> arrayList = new ArrayList<Flag>(n3);
        for (int i2 = 0; i2 < n3; ++i2) {
            arrayList.add(flagArray[i2]);
        }
        return arrayList;
    }

    private native int getFlags(String[] var1, Flag[] var2, int var3);

    private native String[] getAllFlagNames();

    private native int getInternalFlagCount();

    public Flag getFlag(String string) {
        ManagementFactory.checkMonitorAccess();
        if (string == null) {
            throw new NullPointerException();
        }
        Flag[] flagArray = new Flag[1];
        String[] stringArray = new String[]{string};
        int n2 = this.getFlags(stringArray, flagArray, 1);
        if (n2 == 0) {
            return null;
        }
        return flagArray[0];
    }

    public LongFlag setLongFlag(String string, long l2) {
        ManagementFactory.checkControlAccess();
        Flag flag = this.getFlag(string);
        if (flag == null) {
            return null;
        }
        if (!flag.isWriteable()) {
            throw new UnsupportedOperationException("Flag is not writeable");
        }
        if (flag instanceof LongFlag) {
            return null;
        }
        throw new IllegalArgumentException("Flag is not a LongFlag");
    }

    public BooleanFlag setBooleanFlag(String string, boolean bl2) {
        ManagementFactory.checkControlAccess();
        Flag flag = this.getFlag(string);
        if (flag == null) {
            return null;
        }
        if (!flag.isWriteable()) {
            throw new UnsupportedOperationException("Flag is not writeable");
        }
        if (flag instanceof BooleanFlag) {
            return null;
        }
        throw new IllegalArgumentException("Flag is not a BooleanFlag");
    }

    public StringFlag setStringFlag(String string, String string2) {
        ManagementFactory.checkControlAccess();
        Flag flag = this.getFlag(string);
        if (flag == null) {
            return null;
        }
        if (!flag.isWriteable()) {
            throw new UnsupportedOperationException("Flag is not writeable");
        }
        if (flag instanceof StringFlag) {
            return null;
        }
        throw new IllegalArgumentException("Flag is not a StringFlag");
    }

    public List getInternalRuntimeCounters() {
        return this.jvm.getInternalCounters(RT_COUNTER_NAME_PATTERN);
    }

    private static native void initialize();

    static {
        HotspotRuntime.initialize();
    }
}

