/*
 * Decompiled with CFR 0.152.
 */
package javax.print.attribute;

import java.io.Serializable;

public abstract class ResolutionSyntax
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2706743076526672017L;
    private int crossFeedResolution;
    private int feedResolution;
    public static final int DPI = 100;
    public static final int DPCM = 254;

    public ResolutionSyntax(int n2, int n3, int n4) {
        if (n2 < 1) {
            throw new IllegalArgumentException("crossFeedResolution is < 1");
        }
        if (n3 < 1) {
            throw new IllegalArgumentException("feedResolution is < 1");
        }
        if (n4 < 1) {
            throw new IllegalArgumentException("units is < 1");
        }
        this.crossFeedResolution = n2 * n4;
        this.feedResolution = n3 * n4;
    }

    private static int convertFromDphi(int n2, int n3) {
        if (n3 < 1) {
            throw new IllegalArgumentException(": units is < 1");
        }
        int n4 = n3 / 2;
        return (n2 + n4) / n3;
    }

    public int[] getResolution(int n2) {
        return new int[]{this.getCrossFeedResolution(n2), this.getFeedResolution(n2)};
    }

    public int getCrossFeedResolution(int n2) {
        return ResolutionSyntax.convertFromDphi(this.crossFeedResolution, n2);
    }

    public int getFeedResolution(int n2) {
        return ResolutionSyntax.convertFromDphi(this.feedResolution, n2);
    }

    public String toString(int n2, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getCrossFeedResolution(n2));
        stringBuffer.append('x');
        stringBuffer.append(this.getFeedResolution(n2));
        if (string != null) {
            stringBuffer.append(' ');
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public boolean lessThanOrEquals(ResolutionSyntax resolutionSyntax) {
        return this.crossFeedResolution <= resolutionSyntax.crossFeedResolution && this.feedResolution <= resolutionSyntax.feedResolution;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof ResolutionSyntax && this.crossFeedResolution == ((ResolutionSyntax)object).crossFeedResolution && this.feedResolution == ((ResolutionSyntax)object).feedResolution;
    }

    public int hashCode() {
        return this.crossFeedResolution & 0xFFFF | (this.feedResolution & 0xFFFF) << 16;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.crossFeedResolution);
        stringBuffer.append('x');
        stringBuffer.append(this.feedResolution);
        stringBuffer.append(" dphi");
        return stringBuffer.toString();
    }

    protected int getCrossFeedResolutionDphi() {
        return this.crossFeedResolution;
    }

    protected int getFeedResolutionDphi() {
        return this.feedResolution;
    }
}

