/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xpath.internal;

import com.sun.org.apache.xalan.internal.res.XSLMessages;
import com.sun.org.apache.xml.internal.utils.QName;
import com.sun.org.apache.xpath.internal.XPathContext;
import com.sun.org.apache.xpath.internal.objects.XObject;
import javax.xml.transform.TransformerException;

public class VariableStack
implements Cloneable {
    public static final int CLEARLIMITATION = 1024;
    XObject[] _stackFrames = new XObject[8192];
    int _frameTop;
    private int _currentFrameBottom;
    int[] _links = new int[4096];
    int _linksTop;
    private static XObject[] m_nulls = new XObject[1024];

    public VariableStack() {
        this.reset();
    }

    public synchronized Object clone() throws CloneNotSupportedException {
        VariableStack variableStack = (VariableStack)super.clone();
        variableStack._stackFrames = (XObject[])this._stackFrames.clone();
        variableStack._links = (int[])this._links.clone();
        return variableStack;
    }

    public XObject elementAt(int n2) {
        return this._stackFrames[n2];
    }

    public int size() {
        return this._frameTop;
    }

    public void reset() {
        this._frameTop = 0;
        this._linksTop = 0;
        this._links[this._linksTop++] = 0;
        this._stackFrames = new XObject[this._stackFrames.length];
    }

    public void setStackFrame(int n2) {
        this._currentFrameBottom = n2;
    }

    public int getStackFrame() {
        return this._currentFrameBottom;
    }

    public int link(int n2) {
        Object[] objectArray;
        this._currentFrameBottom = this._frameTop;
        this._frameTop += n2;
        if (this._frameTop >= this._stackFrames.length) {
            objectArray = new XObject[this._stackFrames.length + 4096 + n2];
            System.arraycopy(this._stackFrames, 0, objectArray, 0, this._stackFrames.length);
            this._stackFrames = objectArray;
        }
        if (this._linksTop + 1 >= this._links.length) {
            objectArray = new int[this._links.length + 2048];
            System.arraycopy(this._links, 0, objectArray, 0, this._links.length);
            this._links = (int[])objectArray;
        }
        this._links[this._linksTop++] = this._currentFrameBottom;
        return this._currentFrameBottom;
    }

    public void unlink() {
        this._frameTop = this._links[--this._linksTop];
        this._currentFrameBottom = this._links[this._linksTop - 1];
    }

    public void unlink(int n2) {
        this._frameTop = this._links[--this._linksTop];
        this._currentFrameBottom = n2;
    }

    public void setLocalVariable(int n2, XObject xObject) {
        this._stackFrames[n2 + this._currentFrameBottom] = xObject;
    }

    public void setLocalVariable(int n2, XObject xObject, int n3) {
        this._stackFrames[n2 + n3] = xObject;
    }

    public XObject getLocalVariable(XPathContext xPathContext, int n2) throws TransformerException {
        XObject xObject = this._stackFrames[n2 += this._currentFrameBottom];
        if (null == xObject) {
            throw new TransformerException(XSLMessages.createXPATHMessage("ER_VARIABLE_ACCESSED_BEFORE_BIND", null), xPathContext.getSAXLocator());
        }
        if (xObject.getType() == 600) {
            this._stackFrames[n2] = xObject.execute(xPathContext);
            return this._stackFrames[n2];
        }
        return xObject;
    }

    public XObject getLocalVariable(int n2, int n3) throws TransformerException {
        XObject xObject = this._stackFrames[n2 += n3];
        return xObject;
    }

    public XObject getLocalVariable(XPathContext xPathContext, int n2, boolean bl2) throws TransformerException {
        XObject xObject = this._stackFrames[n2 += this._currentFrameBottom];
        if (null == xObject) {
            throw new TransformerException(XSLMessages.createXPATHMessage("ER_VARIABLE_ACCESSED_BEFORE_BIND", null), xPathContext.getSAXLocator());
        }
        if (xObject.getType() == 600) {
            this._stackFrames[n2] = xObject.execute(xPathContext);
            return this._stackFrames[n2];
        }
        return bl2 ? xObject : xObject.getFresh();
    }

    public boolean isLocalSet(int n2) throws TransformerException {
        return this._stackFrames[n2 + this._currentFrameBottom] != null;
    }

    public void clearLocalSlots(int n2, int n3) {
        System.arraycopy(m_nulls, 0, this._stackFrames, n2 += this._currentFrameBottom, n3);
    }

    public void setGlobalVariable(int n2, XObject xObject) {
        this._stackFrames[n2] = xObject;
    }

    public XObject getGlobalVariable(XPathContext xPathContext, int n2) throws TransformerException {
        XObject xObject = this._stackFrames[n2];
        if (xObject.getType() == 600) {
            this._stackFrames[n2] = xObject.execute(xPathContext);
            return this._stackFrames[n2];
        }
        return xObject;
    }

    public XObject getGlobalVariable(XPathContext xPathContext, int n2, boolean bl2) throws TransformerException {
        XObject xObject = this._stackFrames[n2];
        if (xObject.getType() == 600) {
            this._stackFrames[n2] = xObject.execute(xPathContext);
            return this._stackFrames[n2];
        }
        return bl2 ? xObject : xObject.getFresh();
    }

    public XObject getVariableOrParam(XPathContext xPathContext, QName qName) throws TransformerException {
        throw new TransformerException(XSLMessages.createXPATHMessage("ER_VAR_NOT_RESOLVABLE", new Object[]{qName.toString()}));
    }
}

