/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.verifier.structurals;

import com.sun.org.apache.bcel.internal.generic.ASTORE;
import com.sun.org.apache.bcel.internal.generic.ATHROW;
import com.sun.org.apache.bcel.internal.generic.BranchInstruction;
import com.sun.org.apache.bcel.internal.generic.CodeExceptionGen;
import com.sun.org.apache.bcel.internal.generic.GotoInstruction;
import com.sun.org.apache.bcel.internal.generic.IndexedInstruction;
import com.sun.org.apache.bcel.internal.generic.Instruction;
import com.sun.org.apache.bcel.internal.generic.InstructionHandle;
import com.sun.org.apache.bcel.internal.generic.JsrInstruction;
import com.sun.org.apache.bcel.internal.generic.LocalVariableInstruction;
import com.sun.org.apache.bcel.internal.generic.MethodGen;
import com.sun.org.apache.bcel.internal.generic.RET;
import com.sun.org.apache.bcel.internal.generic.ReturnInstruction;
import com.sun.org.apache.bcel.internal.generic.Select;
import com.sun.org.apache.bcel.internal.verifier.exc.AssertionViolatedException;
import com.sun.org.apache.bcel.internal.verifier.exc.StructuralCodeConstraintException;
import com.sun.org.apache.bcel.internal.verifier.structurals.Subroutine;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;

public class Subroutines {
    private Hashtable subroutines = new Hashtable();
    public final Subroutine TOPLEVEL;

    public Subroutines(MethodGen methodGen) {
        InstructionHandle[] instructionHandleArray;
        Serializable serializable;
        Serializable serializable2;
        Object object;
        InstructionHandle[] instructionHandleArray2 = methodGen.getInstructionList().getInstructionHandles();
        CodeExceptionGen[] codeExceptionGenArray = methodGen.getExceptionHandlers();
        this.TOPLEVEL = new SubroutineImpl();
        HashSet<InstructionHandle> hashSet = new HashSet<InstructionHandle>();
        InstructionHandle instructionHandle = instructionHandleArray2[0];
        for (int i2 = 0; i2 < instructionHandleArray2.length; ++i2) {
            object = instructionHandleArray2[i2].getInstruction();
            if (!(object instanceof JsrInstruction)) continue;
            hashSet.add(((JsrInstruction)object).getTarget());
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object = new SubroutineImpl();
            serializable2 = (InstructionHandle)iterator.next();
            ((SubroutineImpl)object).setLocalVariable(((ASTORE)((InstructionHandle)serializable2).getInstruction()).getIndex());
            this.subroutines.put(serializable2, object);
        }
        this.subroutines.put(instructionHandleArray2[0], this.TOPLEVEL);
        hashSet.add(instructionHandleArray2[0]);
        for (int i3 = 0; i3 < instructionHandleArray2.length; ++i3) {
            serializable2 = instructionHandleArray2[i3].getInstruction();
            if (!(serializable2 instanceof JsrInstruction)) continue;
            InstructionHandle instructionHandle2 = ((JsrInstruction)serializable2).getTarget();
            ((SubroutineImpl)this.getSubroutine(instructionHandle2)).addEnteringJsrInstruction(instructionHandleArray2[i3]);
        }
        HashSet<InstructionHandle> hashSet2 = new HashSet<InstructionHandle>();
        serializable2 = new Hashtable();
        for (InstructionHandle instructionHandle2 : hashSet) {
            int n2;
            for (int i4 = 0; i4 < instructionHandleArray2.length; ++i4) {
                ((Hashtable)serializable2).put(instructionHandleArray2[i4], Color.white);
            }
            ((Hashtable)serializable2).put(instructionHandle2, Color.gray);
            serializable = new ArrayList();
            ((ArrayList)serializable).add(instructionHandle2);
            if (instructionHandle2 == instructionHandleArray2[0]) {
                for (n2 = 0; n2 < codeExceptionGenArray.length; ++n2) {
                    ((Hashtable)serializable2).put(codeExceptionGenArray[n2].getHandlerPC(), Color.gray);
                    ((ArrayList)serializable).add(codeExceptionGenArray[n2].getHandlerPC());
                }
            }
            while (((ArrayList)serializable).size() != 0) {
                InstructionHandle instructionHandle3 = (InstructionHandle)((ArrayList)serializable).remove(0);
                instructionHandleArray = Subroutines.getSuccessors(instructionHandle3);
                for (int i5 = 0; i5 < instructionHandleArray.length; ++i5) {
                    if ((Color)((Hashtable)serializable2).get(instructionHandleArray[i5]) != Color.white) continue;
                    ((Hashtable)serializable2).put(instructionHandleArray[i5], Color.gray);
                    ((ArrayList)serializable).add(instructionHandleArray[i5]);
                }
                ((Hashtable)serializable2).put(instructionHandle3, Color.black);
            }
            for (n2 = 0; n2 < instructionHandleArray2.length; ++n2) {
                if (((Hashtable)serializable2).get(instructionHandleArray2[n2]) != Color.black) continue;
                ((SubroutineImpl)(instructionHandle2 == instructionHandleArray2[0] ? this.getTopLevel() : this.getSubroutine(instructionHandle2))).addInstruction(instructionHandleArray2[n2]);
                if (hashSet2.contains(instructionHandleArray2[n2])) {
                    throw new StructuralCodeConstraintException("Instruction '" + instructionHandleArray2[n2] + "' is part of more than one subroutine (or of the top level and a subroutine).");
                }
                hashSet2.add(instructionHandleArray2[n2]);
            }
            if (instructionHandle2 == instructionHandleArray2[0]) continue;
            ((SubroutineImpl)this.getSubroutine(instructionHandle2)).setLeavingRET();
        }
        for (int i6 = 0; i6 < codeExceptionGenArray.length; ++i6) {
            for (serializable = codeExceptionGenArray[i6].getStartPC(); serializable != codeExceptionGenArray[i6].getEndPC().getNext(); serializable = ((InstructionHandle)serializable).getNext()) {
                Enumeration enumeration = this.subroutines.elements();
                while (enumeration.hasMoreElements()) {
                    instructionHandleArray = (InstructionHandle[])enumeration.nextElement();
                    if (instructionHandleArray == this.subroutines.get(instructionHandleArray2[0]) || !instructionHandleArray.contains((InstructionHandle)serializable)) continue;
                    throw new StructuralCodeConstraintException("Subroutine instruction '" + serializable + "' is protected by an exception handler, '" + codeExceptionGenArray[i6] + "'. This is forbidden by the JustIce verifier due to its clear definition of subroutines.");
                }
            }
        }
        this.noRecursiveCalls(this.getTopLevel(), new HashSet());
    }

    private void noRecursiveCalls(Subroutine subroutine, HashSet hashSet) {
        Subroutine[] subroutineArray = subroutine.subSubs();
        for (int i2 = 0; i2 < subroutineArray.length; ++i2) {
            int n2 = ((RET)subroutineArray[i2].getLeavingRET().getInstruction()).getIndex();
            if (!hashSet.add(new Integer(n2))) {
                SubroutineImpl subroutineImpl = (SubroutineImpl)subroutineArray[i2];
                throw new StructuralCodeConstraintException("Subroutine with local variable '" + subroutineImpl.localVariable + "', JSRs '" + subroutineImpl.theJSRs + "', RET '" + subroutineImpl.theRET + "' is called by a subroutine which uses the same local variable index as itself; maybe even a recursive call? JustIce's clean definition of a subroutine forbids both.");
            }
            this.noRecursiveCalls(subroutineArray[i2], hashSet);
            hashSet.remove(new Integer(n2));
        }
    }

    public Subroutine getSubroutine(InstructionHandle instructionHandle) {
        Subroutine subroutine = (Subroutine)this.subroutines.get(instructionHandle);
        if (subroutine == null) {
            throw new AssertionViolatedException("Subroutine requested for an InstructionHandle that is not a leader of a subroutine.");
        }
        if (subroutine == this.TOPLEVEL) {
            throw new AssertionViolatedException("TOPLEVEL special subroutine requested; use getTopLevel().");
        }
        return subroutine;
    }

    public Subroutine subroutineOf(InstructionHandle instructionHandle) {
        for (Subroutine subroutine : this.subroutines.values()) {
            if (!subroutine.contains(instructionHandle)) continue;
            return subroutine;
        }
        System.err.println("DEBUG: Please verify '" + instructionHandle + "' lies in dead code.");
        return null;
    }

    public Subroutine getTopLevel() {
        return this.TOPLEVEL;
    }

    private static InstructionHandle[] getSuccessors(InstructionHandle instructionHandle) {
        InstructionHandle[] instructionHandleArray = new InstructionHandle[]{};
        InstructionHandle[] instructionHandleArray2 = new InstructionHandle[1];
        InstructionHandle[] instructionHandleArray3 = new InstructionHandle[2];
        Instruction instruction = instructionHandle.getInstruction();
        if (instruction instanceof RET) {
            return instructionHandleArray;
        }
        if (instruction instanceof ReturnInstruction) {
            return instructionHandleArray;
        }
        if (instruction instanceof ATHROW) {
            return instructionHandleArray;
        }
        if (instruction instanceof JsrInstruction) {
            instructionHandleArray2[0] = instructionHandle.getNext();
            return instructionHandleArray2;
        }
        if (instruction instanceof GotoInstruction) {
            instructionHandleArray2[0] = ((GotoInstruction)instruction).getTarget();
            return instructionHandleArray2;
        }
        if (instruction instanceof BranchInstruction) {
            if (instruction instanceof Select) {
                InstructionHandle[] instructionHandleArray4 = ((Select)instruction).getTargets();
                InstructionHandle[] instructionHandleArray5 = new InstructionHandle[instructionHandleArray4.length + 1];
                instructionHandleArray5[0] = ((Select)instruction).getTarget();
                System.arraycopy(instructionHandleArray4, 0, instructionHandleArray5, 1, instructionHandleArray4.length);
                return instructionHandleArray5;
            }
            instructionHandleArray3[0] = instructionHandle.getNext();
            instructionHandleArray3[1] = ((BranchInstruction)instruction).getTarget();
            return instructionHandleArray3;
        }
        instructionHandleArray2[0] = instructionHandle.getNext();
        return instructionHandleArray2;
    }

    public String toString() {
        return "---\n" + this.subroutines.toString() + "\n---\n";
    }

    private class SubroutineImpl
    implements Subroutine {
        private final int UNSET = -1;
        private int localVariable = -1;
        private HashSet instructions = new HashSet();
        private HashSet theJSRs = new HashSet();
        private InstructionHandle theRET;

        public boolean contains(InstructionHandle instructionHandle) {
            return this.instructions.contains(instructionHandle);
        }

        public String toString() {
            int n2;
            String string = "Subroutine: Local variable is '" + this.localVariable + "', JSRs are '" + this.theJSRs + "', RET is '" + this.theRET + "', Instructions: '" + this.instructions.toString() + "'.";
            string = string + " Accessed local variable slots: '";
            int[] nArray = this.getAccessedLocalsIndices();
            for (n2 = 0; n2 < nArray.length; ++n2) {
                string = string + nArray[n2] + " ";
            }
            string = string + "'.";
            string = string + " Recursively (via subsub...routines) accessed local variable slots: '";
            nArray = this.getRecursivelyAccessedLocalsIndices();
            for (n2 = 0; n2 < nArray.length; ++n2) {
                string = string + nArray[n2] + " ";
            }
            string = string + "'.";
            return string;
        }

        void setLeavingRET() {
            if (this.localVariable == -1) {
                throw new AssertionViolatedException("setLeavingRET() called for top-level 'subroutine' or forgot to set local variable first.");
            }
            Iterator iterator = this.instructions.iterator();
            InstructionHandle instructionHandle = null;
            while (iterator.hasNext()) {
                InstructionHandle instructionHandle2 = (InstructionHandle)iterator.next();
                if (!(instructionHandle2.getInstruction() instanceof RET)) continue;
                if (instructionHandle != null) {
                    throw new StructuralCodeConstraintException("Subroutine with more then one RET detected: '" + instructionHandle + "' and '" + instructionHandle2 + "'.");
                }
                instructionHandle = instructionHandle2;
            }
            if (instructionHandle == null) {
                throw new StructuralCodeConstraintException("Subroutine without a RET detected.");
            }
            if (((RET)instructionHandle.getInstruction()).getIndex() != this.localVariable) {
                throw new StructuralCodeConstraintException("Subroutine uses '" + instructionHandle + "' which does not match the correct local variable '" + this.localVariable + "'.");
            }
            this.theRET = instructionHandle;
        }

        public InstructionHandle[] getEnteringJsrInstructions() {
            if (this == Subroutines.this.TOPLEVEL) {
                throw new AssertionViolatedException("getLeavingRET() called on top level pseudo-subroutine.");
            }
            InstructionHandle[] instructionHandleArray = new InstructionHandle[this.theJSRs.size()];
            return this.theJSRs.toArray(instructionHandleArray);
        }

        public void addEnteringJsrInstruction(InstructionHandle instructionHandle) {
            if (instructionHandle == null || !(instructionHandle.getInstruction() instanceof JsrInstruction)) {
                throw new AssertionViolatedException("Expecting JsrInstruction InstructionHandle.");
            }
            if (this.localVariable == -1) {
                throw new AssertionViolatedException("Set the localVariable first!");
            }
            if (this.localVariable != ((ASTORE)((JsrInstruction)instructionHandle.getInstruction()).getTarget().getInstruction()).getIndex()) {
                throw new AssertionViolatedException("Setting a wrong JsrInstruction.");
            }
            this.theJSRs.add(instructionHandle);
        }

        public InstructionHandle getLeavingRET() {
            if (this == Subroutines.this.TOPLEVEL) {
                throw new AssertionViolatedException("getLeavingRET() called on top level pseudo-subroutine.");
            }
            return this.theRET;
        }

        public InstructionHandle[] getInstructions() {
            InstructionHandle[] instructionHandleArray = new InstructionHandle[this.instructions.size()];
            return this.instructions.toArray(instructionHandleArray);
        }

        void addInstruction(InstructionHandle instructionHandle) {
            if (this.theRET != null) {
                throw new AssertionViolatedException("All instructions must have been added before invoking setLeavingRET().");
            }
            this.instructions.add(instructionHandle);
        }

        public int[] getRecursivelyAccessedLocalsIndices() {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            int[] nArray = this.getAccessedLocalsIndices();
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                hashSet.add(new Integer(nArray[i2]));
            }
            this._getRecursivelyAccessedLocalsIndicesHelper(hashSet, this.subSubs());
            int[] nArray2 = new int[hashSet.size()];
            Iterator iterator = hashSet.iterator();
            int n2 = -1;
            while (iterator.hasNext()) {
                nArray2[++n2] = (Integer)iterator.next();
            }
            return nArray2;
        }

        private void _getRecursivelyAccessedLocalsIndicesHelper(HashSet hashSet, Subroutine[] subroutineArray) {
            for (int i2 = 0; i2 < subroutineArray.length; ++i2) {
                int[] nArray = subroutineArray[i2].getAccessedLocalsIndices();
                for (int i3 = 0; i3 < nArray.length; ++i3) {
                    hashSet.add(new Integer(nArray[i3]));
                }
                if (subroutineArray[i2].subSubs().length == 0) continue;
                this._getRecursivelyAccessedLocalsIndicesHelper(hashSet, subroutineArray[i2].subSubs());
            }
        }

        public int[] getAccessedLocalsIndices() {
            int n2;
            Object object2;
            HashSet<Integer> hashSet = new HashSet<Integer>();
            if (this.theRET == null && this != Subroutines.this.TOPLEVEL) {
                throw new AssertionViolatedException("This subroutine object must be built up completely before calculating accessed locals.");
            }
            for (Object object2 : this.instructions) {
                if (!(((InstructionHandle)object2).getInstruction() instanceof LocalVariableInstruction) && !(((InstructionHandle)object2).getInstruction() instanceof RET)) continue;
                n2 = ((IndexedInstruction)((Object)((InstructionHandle)object2).getInstruction())).getIndex();
                hashSet.add(new Integer(n2));
                try {
                    int n3;
                    if (!(((InstructionHandle)object2).getInstruction() instanceof LocalVariableInstruction) || (n3 = ((LocalVariableInstruction)((InstructionHandle)object2).getInstruction()).getType(null).getSize()) != 2) continue;
                    hashSet.add(new Integer(n2 + 1));
                }
                catch (RuntimeException runtimeException) {
                    throw new AssertionViolatedException("Oops. BCEL did not like NULL as a ConstantPoolGen object.");
                }
            }
            object2 = new int[hashSet.size()];
            Iterator iterator = hashSet.iterator();
            n2 = -1;
            while (iterator.hasNext()) {
                object2[++n2] = (Integer)iterator.next();
            }
            return object2;
        }

        public Subroutine[] subSubs() {
            Object object;
            HashSet<Subroutine> hashSet = new HashSet<Subroutine>();
            Iterator iterator = this.instructions.iterator();
            while (iterator.hasNext()) {
                object = ((InstructionHandle)iterator.next()).getInstruction();
                if (!(object instanceof JsrInstruction)) continue;
                InstructionHandle instructionHandle = ((JsrInstruction)object).getTarget();
                hashSet.add(Subroutines.this.getSubroutine(instructionHandle));
            }
            object = new Subroutine[hashSet.size()];
            return hashSet.toArray((T[])object);
        }

        void setLocalVariable(int n2) {
            if (this.localVariable != -1) {
                throw new AssertionViolatedException("localVariable set twice.");
            }
            this.localVariable = n2;
        }
    }
}

