/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.generic.CompoundInstruction;
import com.sun.org.apache.bcel.internal.generic.Instruction;
import com.sun.org.apache.bcel.internal.generic.InstructionHandle;
import com.sun.org.apache.bcel.internal.generic.InstructionList;
import com.sun.org.apache.bcel.internal.generic.LOOKUPSWITCH;
import com.sun.org.apache.bcel.internal.generic.Select;
import com.sun.org.apache.bcel.internal.generic.TABLESWITCH;

public final class SWITCH
implements CompoundInstruction {
    private int[] match;
    private InstructionHandle[] targets;
    private Select instruction;
    private int match_length;

    public SWITCH(int[] nArray, InstructionHandle[] instructionHandleArray, InstructionHandle instructionHandle, int n2) {
        this.match = (int[])nArray.clone();
        this.targets = (InstructionHandle[])instructionHandleArray.clone();
        this.match_length = nArray.length;
        if (this.match_length < 2) {
            this.instruction = new TABLESWITCH(nArray, instructionHandleArray, instructionHandle);
        } else {
            this.sort(0, this.match_length - 1);
            if (this.matchIsOrdered(n2)) {
                this.fillup(n2, instructionHandle);
                this.instruction = new TABLESWITCH(this.match, this.targets, instructionHandle);
            } else {
                this.instruction = new LOOKUPSWITCH(this.match, this.targets, instructionHandle);
            }
        }
    }

    public SWITCH(int[] nArray, InstructionHandle[] instructionHandleArray, InstructionHandle instructionHandle) {
        this(nArray, instructionHandleArray, instructionHandle, 1);
    }

    private final void fillup(int n2, InstructionHandle instructionHandle) {
        int n3 = this.match_length + this.match_length * n2;
        int[] nArray = new int[n3];
        InstructionHandle[] instructionHandleArray = new InstructionHandle[n3];
        int n4 = 1;
        nArray[0] = this.match[0];
        instructionHandleArray[0] = this.targets[0];
        for (int i2 = 1; i2 < this.match_length; ++i2) {
            int n5 = this.match[i2 - 1];
            int n6 = this.match[i2] - n5;
            for (int i3 = 1; i3 < n6; ++i3) {
                nArray[n4] = n5 + i3;
                instructionHandleArray[n4] = instructionHandle;
                ++n4;
            }
            nArray[n4] = this.match[i2];
            instructionHandleArray[n4] = this.targets[i2];
            ++n4;
        }
        this.match = new int[n4];
        this.targets = new InstructionHandle[n4];
        System.arraycopy(nArray, 0, this.match, 0, n4);
        System.arraycopy(instructionHandleArray, 0, this.targets, 0, n4);
    }

    private final void sort(int n2, int n3) {
        int n4 = n2;
        int n5 = n3;
        int n6 = this.match[(n2 + n3) / 2];
        while (true) {
            if (this.match[n4] < n6) {
                ++n4;
                continue;
            }
            while (n6 < this.match[n5]) {
                --n5;
            }
            if (n4 <= n5) {
                int n7 = this.match[n4];
                this.match[n4] = this.match[n5];
                this.match[n5] = n7;
                InstructionHandle instructionHandle = this.targets[n4];
                this.targets[n4] = this.targets[n5];
                this.targets[n5] = instructionHandle;
                ++n4;
                --n5;
            }
            if (n4 > n5) break;
        }
        if (n2 < n5) {
            this.sort(n2, n5);
        }
        if (n4 < n3) {
            this.sort(n4, n3);
        }
    }

    private final boolean matchIsOrdered(int n2) {
        for (int i2 = 1; i2 < this.match_length; ++i2) {
            if (this.match[i2] - this.match[i2 - 1] <= n2) continue;
            return false;
        }
        return true;
    }

    public final InstructionList getInstructionList() {
        return new InstructionList(this.instruction);
    }

    public final Instruction getInstruction() {
        return this.instruction;
    }
}

