/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.orbutil;

import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.spi.orb.ORB;

public class CacheTable {
    private boolean noReverseMap;
    static final int INITIAL_SIZE = 16;
    static final int MAX_SIZE = 0x40000000;
    int size;
    int entryCount;
    private Entry[] map;
    private Entry[] rmap;
    private ORB orb;
    private ORBUtilSystemException wrapper;

    private CacheTable() {
    }

    public CacheTable(ORB oRB, boolean bl2) {
        this.orb = oRB;
        this.wrapper = ORBUtilSystemException.get(oRB, "rpc.encoding");
        this.noReverseMap = bl2;
        this.size = 16;
        this.entryCount = 0;
        this.initTables();
    }

    private void initTables() {
        this.map = new Entry[this.size];
        this.rmap = this.noReverseMap ? null : new Entry[this.size];
    }

    private void grow() {
        if (this.size == 0x40000000) {
            return;
        }
        Entry[] entryArray = this.map;
        int n2 = this.size;
        this.size <<= 1;
        this.initTables();
        for (int i2 = 0; i2 < n2; ++i2) {
            Entry entry = entryArray[i2];
            while (entry != null) {
                this.put_table(entry.key, entry.val);
                entry = entry.next;
            }
        }
    }

    private int moduloTableSize(int n2) {
        n2 += ~(n2 << 9);
        n2 ^= n2 >>> 14;
        n2 += n2 << 4;
        n2 ^= n2 >>> 10;
        return n2 & this.size - 1;
    }

    private int hash(Object object) {
        return this.moduloTableSize(System.identityHashCode(object));
    }

    private int hash(int n2) {
        return this.moduloTableSize(n2);
    }

    public final void put(Object object, int n2) {
        if (this.put_table(object, n2)) {
            ++this.entryCount;
            if (this.entryCount > this.size * 3 / 4) {
                this.grow();
            }
        }
    }

    private boolean put_table(Object object, int n2) {
        int n3 = this.hash(object);
        Entry entry = this.map[n3];
        while (entry != null) {
            if (entry.key == object) {
                if (entry.val != n2) {
                    throw this.wrapper.duplicateIndirectionOffset();
                }
                return false;
            }
            entry = entry.next;
        }
        entry = new Entry(object, n2);
        entry.next = this.map[n3];
        this.map[n3] = entry;
        if (!this.noReverseMap) {
            int n4 = this.hash(n2);
            entry.rnext = this.rmap[n4];
            this.rmap[n4] = entry;
        }
        return true;
    }

    public final boolean containsKey(Object object) {
        return this.getVal(object) != -1;
    }

    public final int getVal(Object object) {
        int n2 = this.hash(object);
        Entry entry = this.map[n2];
        while (entry != null) {
            if (entry.key == object) {
                return entry.val;
            }
            entry = entry.next;
        }
        return -1;
    }

    public final boolean containsVal(int n2) {
        return this.getKey(n2) != null;
    }

    public final boolean containsOrderedVal(int n2) {
        return this.containsVal(n2);
    }

    public final Object getKey(int n2) {
        int n3 = this.hash(n2);
        Entry entry = this.rmap[n3];
        while (entry != null) {
            if (entry.val == n2) {
                return entry.key;
            }
            entry = entry.rnext;
        }
        return null;
    }

    public void done() {
        this.map = null;
        this.rmap = null;
    }

    class Entry {
        Object key;
        int val;
        Entry next;
        Entry rnext;

        public Entry(Object object, int n2) {
            this.key = object;
            this.val = n2;
            this.next = null;
            this.rnext = null;
        }
    }
}

