.de EX		\"Begin example
.ne 5
.if n .sp 1
.if t .sp .5
.nf
.in +.5i
..
.de EE
.fi
.in -.5i
.if n .sp 1
.if t .sp .5
..
.TH XScreenSaver 1 "17-Jun-97" "X Version 11"
.SH NAME
munch - munching squares screen hack
.SH SYNOPSIS
.B munch
[\-display \fIhost:display.screen\fP] [\-foreground \fIcolor\fP]
[\-background \fIcolor\fP] [\-window] [\-root] [\-mono] [\-install]
[\-visual \fIvisual\fP] [\-delay \fIseconds\fP] [\-xor] [\-noxor] [\-shift]
[\-noshift] [\-logminwidth \fIminimum width\fP]
.SH DESCRIPTION
The
.I munch
program preforms the munching squares hack until killed.  It picks square
size, position, and gravity randomly; configurable options are listed
below.
.PP
The munching squares hack cosists of drawing Y = X XOR T for a range of X
and T over and over until all the possible combinations of X and T have
come up.  It was reportedly discovered by Jackson Wright in 1962 and took 5
instructions of PDP-6 code.
.SH OPTIONS
.I munch
accepts the following options:
.TP 8
.B \-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-root
Draw on the root window.
.TP 8
.B \-mono 
If on a color display, pretend we're on a monochrome display.
.TP 8
.B \-install
Install a private colormap for the window.
.TP 8
.B \-visual \fIvisual\fP
Specify which visual to use.  Legal values are the name of a visual class,
or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-delay \fIseconds\fP
How long to wait before starting over.  Default 5 seconds.
.TP 8
.B \-xor
Use the XOR drawing function.  (Default.)
.TP 8
.B \-no\-xor
Don't use the XOR drawing function.
.TP 8
.B \-shift
Start drawing the square at weird starting points.  (Default.)
.TP 8
.B \-no\-shift
Don't shift and start drawing the square at weird starting points.
.TP 8
.B \-logminwidth \fIminimum\-width\fP
The logarithm (base 2) of the minimum with of a square (must be a power of
2, or some parts of the square aren't.)
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1),
.BR http://www.inwap.com/pdp10/hbaker/hakmem/hakmem.html,
.BR http://www.comedia.com/Hot/jargon_3.0/JARGON_M/MUNCHSQR.HTML
.SH HISTORY
Quoted from HAKMEM, for historical interest.  As that document says, "Unless
otherwise stated, all computer programs are in PDP-6/10 assembly language."
.TP 8
ITEM 146: MUNCHING SQUARES
Another simple display program. It is thought that this was discovered by
Jackson Wright on the RLE PDP-1 circa 1962.

.EX
    DATAI 2
    ADDB 1,2
    ROTC 2,-22
    XOR 1,2
    JRST .-4
.EE
.RS 8
2=X, 3=Y. Try things like 1001002 in data switches. This also does
interesting things with operations other than XOR, and rotations other 
than -22. (Try IOR; AND; TSC; FADR; FDV(!); ROT -14, -9, -20, ...)
.RE
.TP 8
ITEM 147 (Schroeppel):
Munching squares is just views of the graph Y = X XOR T for consecutive
values of T = time.
.TP 8
ITEM 148 (Cohen, Beeler):
A modification to munching squares which reveals them in frozen states
through opening and closing curtains: insert FADR 2,1 before the XOR. Try
data switches =

.EX
    4000,,4    1000,,2002    2000,,4    0,,1002
.EE
.RS 8
(Notation: <left half>,,<right half>)

Also try the FADR after the XOR, switches = 1001,,1. 
.SH COPYRIGHT
Copyright \(co 1997 by Tim Showalter.  Permission to use, copy, modify, 
distribute, and sell this software and its documentation for any purpose is 
hereby granted without fee, provided that the above copyright notice appear 
in all copies and that both that copyright notice and this permission notice
appear in supporting documentation.  No representations are made about the 
suitability of this software for any purpose.  It is provided "as is" without
express or implied warranty.
.SH AUTHOR
Tim Showalter <tjs@andrew.cmu.edu>, 17-Jun-97, based on what's in the
Jargon File and stealing stuff from existing xscreensaver modules.
