#ifdef DYNIX
$stdunit
#endif DYNIX
*********************************************************
*                                                       *
*  Copyright 1988, by D.M. Etter, All rights reserved;  *
*          EECE Dept, University of New Mexico          *
*         Albuquereque, New Mexico,  87131  USA         *
*                                                       *
*********************************************************




CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C

        Subroutine DataIn (X, Y, Numpt, NumCrv, term)


*********************************************************
*                                                       *
*  Subroutine Data_Input                                *
*                                                       *
*  This routine gets the XY points, for the curve. The  *
*  user is prompted for the type of data input they     *
*  wish to use. Either by standard input or by file(s). *
*                                                       *  
*  Minor error checking is done by this routine. Mainly *
*  to make sure the user enters a legitimate input type *
*                                                       *
*********************************************************


        Integer    fileIn, userIn
        Parameter (fileIn = 1, userIn = 2)

        Integer         max, num, maxC
        Common /Object/ max, num, maxC
        Save   /Object/

        Real     X(max,num), Y(max,num)
        Integer  NumCrv, Numpt(num), device, term


*       (* Prompt the user for the type of input they wish to use. *)
    1   Call clear(term)
        Write (*,10)
   10   Format(/,15x,'Data Input',///,
     +          5x,'What type of input device do you wish to use?',//
     +         10x,'1. Read the data from data files (default)',//
     +         10x,'2. Read the data from the terminal (STDIO)',//
     +          5x,'Enter option (1 - 2) ...')
        Read (*,'(i2)',err=1) device
        IF (device .EQ. 0) device = fileIn

  100   IF (device .LT. 1 .OR. device .GT. 2) THEN
    2     Call clear(term)
          Write (*,'(a1)') Char(7)
          Write (*,10)
          Read (*,'(i2)',err=2) device
          GOTO 100
        ENDIF

*       (* Call the respective input or device module. *)
        IF (device .EQ. fileIn) THEN
          Call File(X, Y, Numpt, NumCrv, term)
        ELSE IF (device .EQ. userIn) THEN
          Call User(X, Y, Numpt, NumCrv, term)
        ENDIF

        RETURN
        END
