/* limits.c */

#include <stdio.h>
#include <math.h>

#include "xyplot.h"

extern int verbose;
extern float modceil();
extern float modfloor();

#define vshowlim(p) if (verbose)\
	fprintf(stderr,". limits: %g %g %g %g\n",p->xmult,p->xlb,p->xub,p->xquant)


struct z {
    float lb, ub, mult, quant;
};

void setloglim(), setlinlim();
 
#define fswap(a,b) { float t; t=a; a=b; b=t; }
#define iswap(a,b) { int t; t=a; a=b; b=t; }
 
setlim(p)
struct xy *p;
{
    float           t, delta, sign;
    struct z        z;
    int             lmark[512], mark[512];
    float           lb, ub;
    int             lbf, ubf;
	
    lb = p->xlb;
    ub = p->xub;
    delta = ub - lb;
    if (p->xqf) {               /* user supplied quant */
        if (delta * p->xquant <= 0) {
            fprintf(stderr, "%e %e %e", p->xlb, p->xub, p->xquant);
            fatal("User-supplied axis limits error");
        }
        /* return; */
    }
    sign = 1;
    lbf = p->xlbf;              /* is user supplied lower bound */
    ubf = p->xubf;              /* is user supplied upper bound */
    if (delta < 0) {
        sign = -1;
        fswap(lb,ub);
		iswap(lbf,ubf);
    } else if (delta == 0) {
        if (ub > 0) {
            ub = 2 * ub;
            lb = 0;
        } else if (lb < 0) {
            lb = 2 * lb;
            ub = 0;
        } else {
            ub = 1;
            lb = -1;
        }
    }
	vshowlim(p);
    if (p->xf == log10 && lb > 0 && ub > lb) {
		vshowlim(p);
        setloglim(&z,lbf, ubf, lb, ub);
        p->xlb = z.lb;
        p->xub = z.ub;
        p->xmult *= z.mult;
		p->xllb = z.quant;
        if (!p->xqf || p->xquant < 10)
			p->xquant = 10;
		vshowlim(p);
        if (countmark(p) < 2) { 
			vshowlim(p);
			/* in this case, make axes more linear-ish */
			p->xlogf = 0;
			lbf = ubf = 1;
            lb = z.lb;
            ub = z.ub;
        } else
            return;
    }
	vshowlim(p);
    setlinlim(&z, lbf, ubf, lb, ub);
    if (sign > 0) {
        p->xlb = z.lb;
        p->xub = z.ub;
    } else {
        p->xlb = z.ub;
        p->xub = z.lb;
    }
	vshowlim(p);
    p->xmult *= z.mult;
	vshowlim(p);
    if (! p->xqf)
		p->xquant = sign * z.quant;
	else
		p->xquant *= z.mult;

	vshowlim(p);
}
 
void
setloglim(v,lbf, ubf, lb, ub)
struct z *v;
int lbf, ubf; 
float lb, ub;
{
    float           r, s, t;
	
	if (verbose) fprintf(stderr,	
						 "setloglim: (%d)%g, (%d)%g\n",
						 lbf,lb,ubf,ub);						 

    for (s = 1; lb * s < 1; s *= 10)
		;/* s = 10^k such that lb < 1/s */
    lb *= s;
    ub *= s;
	/* if lb was less than 10, now 1 <= lb < 10; 
	 *             and ub is similarly rescaled 
	 * otherwise, lb is unchanged
	 */
    for (r = 1; 10 * r <= lb; r *= 10)
		;
	/* r chosen so that: 1 <= lb/r < 10;
	 * nb: r=1 unless original lb was greater than 10
	 */
    for (t = 1; t < ub; t *= 10)
		;

	if (verbose) fprintf(stderr,	
						 "...loglim: lb=%g, ub=%g, s=%g, r=%g\n",
						 lb, ub, s, r);

    v->lb = !lbf ? r : lb;
    v->ub = !ubf ? t : ub;

	if (verbose) fprintf(stderr,	
						 "...loglim: v->lb=%g, v->ub=%g\n",
						 v->lb, v->ub, s, r);

    if (ub / lb < SHORTLOGRANGE) {
        if (!lbf) {
            if (lb >= 5 * v->lb)
                v->lb *= 5;
            else if (lb >= 2 * v->lb)
                v->lb *= 2;
        }
        if (!ubf) {
            if (ub * 5 <= v->ub)
                v->ub /= 5;
            else if (ub * 2 <= v->ub)
                v->ub /= 2;
        }
    }
    v->mult = s;
    v->quant = r;
}
 
 
void
setlinlim(v,lbf, ubf, xlb, xub)
    struct z        *v;
    int             lbf, ubf;
    float           xlb, xub;
{
    float           r, s, delta;
    float           ub, lb;

	if (verbose) fprintf(stderr,	
						 "setlinlim: (%d)%g, (%d)%g\n",
						 lbf,xlb,ubf,xub);						 
 
loop:
    ub = xub;
    lb = xlb;
    delta = ub - lb;
    /* scale up by s, a power of 10, so range (delta) exceeds 1 */
    /* find power of 10 quantum, r, such that delta/10<=r<delta */
    r = s = 1;
 
    while (delta * s < 10)
        s *= 10;
    delta *= s;
 
    while (10 * r < delta)
        r *= 10;
 
    lb *= s;
    ub *= s;
 
    /* set r=(1,2,5)*10**n so that 3-5 quanta cover range */
 
    if (r >= delta / 2)
        r /= 2;
    else if (r < delta / 5)
        r *= 2;
 
	if (verbose) fprintf(stderr,	
						 "...linlim: lb=%g, ub=%g, s=%g, r=%g\n",
						 lb, ub, s, r);

    v->ub = ubf ? ub : modceil(ub, r);
    v->lb = lbf ? lb : modfloor(lb, r);

	if (verbose) fprintf(stderr,	
						 "...linlim: v->lb=%g, v->ub=%g\n",
						 v->lb, v->ub, s, r);
    if (!lbf && v->lb <= r && v->lb > 0) {
        xlb = 0;
        goto loop;
    } else if (!ubf && v->ub >= -r && v->ub < 0) {
        xub = 0;
        goto loop;
    }
    v->quant = r;
    v->mult = s;
}
int countmark(p)
struct xy *p;
{
	float x;
	int xn;
	for (x = p->xllb; x <= p->xub; x *= 10) 
		if ( in_logrange(x,p,EPS) ) 
			++xn;

	return xn;
}
