/* axes.c */
/* part of xyplot source */

extern int verbose;
#include <stdio.h>

#include <math.h>  /* fabs,log10,... */
#include "xyplot.h"

extern struct xy xd;
extern struct xy yd;
extern float axlwidth;
extern int gridstyle;
extern int gridlinestyle;
extern char gridbuf[];

extern int leftx;
extern float tickfactor;
extern int tickSize;
extern int xtickspertick;
extern int ytickspertick;

static int lmark[512];
static int xmark[512];

axes()
{
    int i, xn, yn;

	leftx = xd.xbot; /* needs to be reset before relabeling axes */

	newm(1);
	neww(axlwidth);
    if (gridstyle == 0)
        return;

	if (gridstyle == -1)
		return gs_axes(gridbuf);
 
	axlab('x', &xd );
	axlab('y', &yd );

    /* draw a box */
	if (gridstyle == 3)
	{
		move(xd.xbot, yd.xbot);
		cont(xd.xtop, yd.xbot);
		move(xd.xbot, yd.xbot);
		cont(xd.xbot, yd.xtop);
	}
	else
	{
		move(xd.xbot, yd.xbot);
		cont(xd.xtop, yd.xbot);
		cont(xd.xtop, yd.xtop);
		cont(xd.xbot, yd.xtop);
		cont(xd.xbot, yd.xbot);
	}
 
	/* Put ticks on the x-axis */
    xn = setmark(&xd,xtickspertick);
    for (i = 0; i < xn; i++) {
        if (lmark[i] == 2 && gridstyle == 2) {
			/* full grid */
			newm(gridlinestyle);
            move(xmark[i], yd.xbot);
            cont(xmark[i], yd.xtop);
			newm(1);
        } else {
			/* ticks on lower x axis */
            move(xmark[i], yd.xbot);
            cont(xmark[i], yd.xbot + lmark[i]*tickSize);
			if (! (gridstyle == 3 || gridstyle == 4) )
			{
				/* ticks on upper x axis too */
				move(xmark[i], yd.xtop - lmark[i]*tickSize);
				cont(xmark[i], yd.xtop);
			}
        }
    }
	/* Put ticks on the y-axis */
    yn = setmark(&yd,ytickspertick);
    for (i = 0; i < yn; i++) {
        if (lmark[i] == 2 && gridstyle == 2) {
			/* full grid */
			newm(gridlinestyle);
            move(xd.xbot, xmark[i]);
            cont(xd.xtop, xmark[i]);
			newm(1);
        } else {
			/* ticks on left y axis */
            move(xd.xbot, xmark[i]);
            cont(xd.xbot + lmark[i]*tickSize, xmark[i]);
			if (! (gridstyle == 3 || gridstyle == 4) )
			{
				/* ticks on right y axis */
				move(xd.xtop - lmark[i]*tickSize, xmark[i]);
				cont(xd.xtop, xmark[i]);
			}
        }
    }
}

/* grid string:
   (e)mpty, (f)rame only, (t)icks w/ frame, (l)abel, (L)abel w/ ticks&frame
   BUGS:
     In this form, can't specify gridlines
     Also, can't specify labels w/o ticks.
     Lining up the ticks/axes maybe isn't as clean with a gridstring
     (I'm now thinking the labels should be specified elsewhere)
*/
int
gs_axes(gstring)
char *gstring;
{
    int f;

	/* begin with bottom x-axis and work clockwise:
     *
     *   1222222222
     *   1        3
     *   1        3
     *   1        3
     *   0000000003
     */

	for (f=0; f<4; ++f)
	{
		switch( gstring[f] )
		{
		case 'l':
		case 'L':
			switch(f) {
			case 0:
				axlab('x', &xd );
				break;
			case 1:
				axlab('y', &yd );
				break;
			case 2:
				axlab('X', &xd );
				break;
			case 3:
				axlab('Y', &yd );
				break;
			}
			/* no break! */
		case 't':
		case 'T':
			if (!(gstring[f]=='l')) /* no ticks with 'l' */
			{
				switch(f)
				{
				case 0:
					xyticks('x',1,yd.xbot);
					break;
				case 1:
					xyticks('y',1,xd.xbot);
					break;
				case 2:
					xyticks('x',-1,yd.xtop);
					break;
				case 3:
					xyticks('y',-1,xd.xtop);
					break;
				default:
					fatal("xyticks: bad xy value");
					break;
				}
			}
			/* no break! */
		case 'f':
		case 'F':
			switch(f)
			{
			case 0:
				move(xd.xbot,yd.xbot);
				cont(xd.xtop,yd.xbot);
				break;
			case 1:
				move(xd.xbot,yd.xbot);
				cont(xd.xbot,yd.xtop);
				break;
			case 2:
				move(xd.xbot,yd.xtop);
				cont(xd.xtop,yd.xtop);
				break;
			case 3:
				move(xd.xtop,yd.xtop);
				cont(xd.xtop,yd.xbot);
				break;
			default:
				fatal("gs_axes: bad f value");
				break;
			}
			break;
		case 'e':
		case 'E':
			break;
		default:
			fprintf(stderr,"gstring[%d]=(%c)...",f,gstring[f]);
			fatal("invalid grid string");

		}
	}
}
xyticks(xory,sgn,val)
char xory;  /* is this 'x' or 'y' axis */
int sgn;    /* +1 is lower or left, -1 is upper or right */
int val;    /* val of y if 'x' axis; val of x is 'y' axis */
{
	int i,xn;

	switch(xory)
	{
	case 'x':
		xn = setmark(&xd,xtickspertick);
		break;
	case 'y':
		xn = setmark(&yd,ytickspertick);
		break;
	default:
		fatal("Invalid switch in xyticks");
	}

    for (i = 0; i < xn; i++) 
	{
		switch(xory)
		{
		case 'x':
			move(xmark[i], val);
			cont(xmark[i], val + sgn*lmark[i]*tickSize);
			break;
		case 'y':
			move(val                        ,xmark[i]);
			cont(val + sgn*lmark[i]*tickSize,xmark[i]);
			break;
		default:
			fatal("Invalid switch in xyticks");
		}
	}
}

int 
setmark(p,tickspertick)
struct xy *p;
int tickspertick;
{
    int   i, xn = 0;
    float x, xk, xl, xu, delx;
 
    if (p->xlogf) {
		if (verbose) fprintf(stderr,"[sm] limits: %g %g %g %g\n",
							p->xllb,p->xlb,p->xub,p->xquant);
		/* nb, don't use p->xquant for making marks; only for labels */
		/* in a future, fancier version, would make lmark = 1 for the */
        /* non-xquant's */
        for (x = p->xllb; x <= p->xub; x *= 10) {
  			if ( in_logrange(x,p,EPS) ) {
            	lmark[xn] = 2;
        		xmark[xn] = log10(x) * p->xa + p->xb;
				++xn;
			}
			if (tickspertick > 1 ) {
	            for (i=2; i<10; ++i) { 
  					if ( in_logrange(i*x,p,EPS) ) {
            			lmark[xn] = 1;
        				xmark[xn] = log10(i*x) * p->xa + p->xb;
						++xn;
					}
           		}
			}
        }
    } else {
        outer_range(&xl,&xu,p);
		delx = fabs(p->xquant)/(float)tickspertick;
		xn = 0;
        for(i=0,x=xl; x<=xu; i++,x += delx) {
			if ( !in_range(x,p,EPS) )
				continue;
            xmark[xn] = (*p->xf) (x) * p->xa + p->xb;
            if (i % tickspertick) {
                lmark[xn] = 1;
            } else
                lmark[xn] = 2;
			xn++;
        }
    }
    return xn;
}

setticksize()
{
#if 0
	/* crazy formula to scale tick non-linearly */
    tickSize = TSIZE * tickfactor * 0.471 *
    log(1.0+10.0*((xd.xsize > yd.xsize)? xd.xsize : yd.xsize ));  
#else
	/* here is a linear formula (agrees at xsize==1) */
	/* except that i choose the SMALLER of the ticksizes */
	tickSize = TSIZE * tickfactor * 
		((xd.xsize < yd.xsize)? xd.xsize : yd.xsize );
#endif
 
}
