/*
 * ObjLabelF.c,v 2.2 1992/08/11 00:08:05 pete Exp
 * ObjLabelF.c,v
 * Revision 2.2  1992/08/11  00:08:05  pete
 * Use insensitive stipple.
 *
 * Revision 2.1  1992/07/11  20:05:15  pete
 * Part of the Xo widget set
 *
 *
 */

#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/Xo/ObjLabelFP.h>
#include <X11/Xo/dbug.h>

XoProto (static void, ObjLabelFormatPostscript, (Widget tree, XoHardCopy * hardcopy));

#include <X11/Xo/ObjLFRec.h>

XoProto (static void, GetGCAttr, (XoObjLabelFormatWidget w, XtGCMask *mask,
				  XGCValues *attr));
XoProto (static void, GetFontFamily, (Widget gw));

/*
 *----------------------------------------------------------------------
 * RectObj Class Methods
 *----------------------------------------------------------------------
 */

/*
 * ClassPartInitialize -
 *	Installs a hardcopy extension for Postscript.
 */

static void
ClassPartInitialize (class)
	WidgetClassRec *class;
{
	XoHardcopyAddExtension (class, XoPostscript, 1L, ObjLabelFormatPostscript,
				(XtPointer) NULL);
}

/*
 * Initialize -
 *	1. Creates the font family
 */

static void
Initialize (request, new, arglist, num_args)
	Widget          request;	/* as first created */
	Widget          new;		/* after other parent classes */
	ArgList         arglist;	/* args passed to create */
	Cardinal       *num_args;	/* number of arguments */
{
	XoObjLabelFormatWidget w = (XoObjLabelFormatWidget) new;

	w->obj_label_format.family = NULL;
	if (!w->obj_label_format.family)
		GetFontFamily (new);
}

/*
 * SetValues -
 */

static Boolean
SetValues (current, request, new, args, num_args)
	Widget          current;	/* widget before the XtSetValues() */
	Widget          request;	/* after args applied but no
					 * set_values */
	Widget          new;		/* the allowed changes */
	ArgList         args;		/* list of arguments */
	Cardinal       *num_args;	/* how many arguments */
{
	XoObjLabelFormatWidget w = (XoObjLabelFormatWidget) new;
	XoObjLabelFormatWidget cur = (XoObjLabelFormatWidget) current;
	Boolean         redisplay = False;
	Boolean		need_font_family = False;

	DBUG_ENTER ("ObjLabelFormat.SetValues");

#define COMPARE(field) (cur->obj_label_format.field != w->obj_label_format.field)

	if (COMPARE(font_family))
	{
		need_font_family =  True;
		XtFree (cur->obj_label_format.font_family);
		if (w->obj_label_format.font_family)
			w->obj_label_format.font_family =
				XtNewString (w->obj_label_format.font_family);
	}
	else if (cur->obj_label_format.font_family && w->obj_label_format.font_family
		 && strcmp (cur->obj_label_format.font_family,
			    w->obj_label_format.font_family) != 0)
	{
		need_font_family = True;
	}
	if (need_font_family)
	{
		GetFontFamily (new);
		redisplay = True;
	}

	if (COMPARE (font_size)
	    || COMPARE (font_style)
	    || COMPARE (rotate))
	{
		/* FIX: Need to recreate the string */
	}
	DBUG_RETURN (redisplay);
}

static void
Destroy (gw)
	Widget          gw;
{
	XoObjLabelFormatWidget w = (XoObjLabelFormatWidget) gw;

	if (w->obj_label_format.family)
		AtFontFamilyRelease (w->obj_label_format.family);
}

/*
 *----------------------------------------------------------------------
 * ObjDraw Class Methods
 *----------------------------------------------------------------------
 */

/*
 *----------------------------------------------------------------------
 * ObjLabel Class Methods
 *----------------------------------------------------------------------
 */

static void
LabelMake (gw, line, l)
	Widget		gw;
	String		line;
	XoLines		*l;
{
	XoObjLabelFormatWidget w = (XoObjLabelFormatWidget) gw;
	XtGCMask	mask;
	XGCValues       values;		/* filled in for gc values */

	GetGCAttr (w, &mask, &values);
	GetFontFamily (gw);
	l->label = (XtPointer)
		AtTextCreate ((Widget) w, line, w->obj_label_format.family,
			      w->obj_label_format.font_size,
			      w->obj_label_format.font_style,
			      mask, &values);
	if (w->obj_label_format.rotate)
		AtTextRotate ((AtText *) l->label);
	l->width = AtTextWidth ((AtText *) l->label);
	l->height = AtTextHeight ((AtText *) l->label) * 1.2;
	l->offset_y = AtTextAscent ((AtText *) l->label);
}

static void
LabelDraw (gw, i, y)
	Widget		gw;
	int		i;
	int		y;
{
	XoObjLabelFormatWidget w = (XoObjLabelFormatWidget) gw;
	XoLines		*l;

	l = &w->obj_label.lines->ti_lines[i];
	AtTextDraw (XtDisplayOfObject (gw),
		    XtWindowOfObject (gw),
		    w->obj_label.gc,
		    (AtText *) l->label,
		    _XoObjDrawLeft(w) + l->offset_x,
		    y + l->offset_y);
}

static void
LabelFree (gw, tinfo, i)
	Widget		gw;
	_XoTextInfo	*tinfo;
	int		i;
{
	AtTextDestroy (gw, (AtText *) tinfo->ti_lines[i].label);
}


/*
 *----------------------------------------------------------------------
 * ObjLabelFormat Class Methods
 *----------------------------------------------------------------------
 */


/*
 *----------------------------------------------------------------------
 * Private Utilities
 *----------------------------------------------------------------------
 */

static void
GetGCAttr (w, mask, attr)
	XoObjLabelFormatWidget	w;
	XtGCMask	*mask;
	XGCValues	*attr;
{
	*mask = 0;
	if (XtIsSensitive ((Widget) w))
	{
		attr->fill_style = FillSolid;
		*mask |= GCFillStyle;
	}
	else
	{
		attr->fill_style = FillStippled;
		attr->stipple = w->obj_draw.stipple;
		*mask |= GCFillStyle|GCStipple;
	}
	attr->foreground = w->obj_draw.fg;
	attr->font = w->obj_label.font->fid;
	*mask |= GCForeground|GCFont;
}


static void
GetFontFamily (gw)
	Widget          gw;
{
	XoObjLabelFormatWidget w = (XoObjLabelFormatWidget) gw;

	if (w->obj_label_format.family)
		AtFontFamilyRelease (w->obj_label_format.family);
	w->obj_label_format.family = AtFontFamilyGet (XtDisplayOfObject (gw),
					      w->obj_label_format.font_family);
}


/*
 *----------------------------------------------------------------------
 * Printing extensions
 *----------------------------------------------------------------------
 */

static void
ObjLabelFormatPostscript (gw, hardcopy)
	Widget          gw;
	XoHardCopy     *hardcopy;
{
	XoObjLabelFormatWidget w = (XoObjLabelFormatWidget) gw;

	if (!gw || !hardcopy || !XtIsSubclass (gw, xoObjLabelFormatWidgetClass))
		return;
	if (w->obj_draw.no_draw)
		return;
#ifdef notdef
	y = w->rectangle.y;
	for (i = 0; i < w->obj_label_format.num_lines; i++)
	{
		_xoPStext (hardcopy, gw,
			   w->obj_label_format.font,
			   w->obj_draw.fg,
			   w->rectangle.x + w->obj_label_format.lines[i].offset_x,
			   y + w->obj_label_format.lines[i].offset_y,
			   w->obj_label_format.lines[i].label);
		y += w->obj_label_format.lines[i].height;
	}
#endif
}

