/*
 * MenuButton.c,v 2.3 1992/08/11 00:16:29 pete Exp
 * MenuButton.c,v
 * Revision 2.3  1992/08/11  00:16:29  pete
 * Number of changes to support the FlagWidget.  In particular, insure it
 * is automatically created/destroyed if it has a SubMenu or not.
 * Removed Redisplay() since it is done better by Label.
 *
 * Revision 2.2  1992/07/22  16:01:24  pete
 * (ItemNext) Made it use XoTRAVERSE_RIGHT instead of XoTRAVERSE_NEXT.
 * (ItemPrev): Similar except left and previous.
 *
 * Revision 2.1  1992/06/23  00:28:58  pete
 * Changed interface to _XoMenuNew and _XoMenuDone.
 *
 * Revision 2.0  1992/04/23  02:51:23  ware
 * First public release.
 *
 * Revision 1.17  1992/02/27  14:30:29  ware
 * Compiled with GCC 2.0 and very strict checks.  Fixed Warnings
 *
 * Revision 1.16  1992/02/20  15:11:09  ware
 * Applied new indentation
 *
 * Revision 1.15  1992/02/04  21:22:46  pete
 * Release 44
 *
 * Revision 1.14  1991/11/30  15:51:19  pete
 * Cleaned up some nitpicky compile time warnings.
 *
 * Revision 1.13  1991/08/30  17:39:44  pete
 * Changed to use the new XtNCallbackMenu callback protocol.  Changed
 * Menu to be a subclass of Column.
 *
 * Revision 1.12  91/08/26  11:57:56  pete
 * Use XoProto() for conditional prototypes.  Working on getting traversals
 * and menus to work more efficiently.  Changed to following naming
 * conventions.
 *
 * Revision 1.11  91/07/19  00:59:55  pete
 * Use shorter file names.  Various speedups.
 *
 * Revision 1.10  1991/06/14  10:44:12  pete
 * Changed to use _XoWarn().
 *
 * Revision 1.9  91/06/14  04:46:46  pete
 * Added DBUG macros.
 *
 * Revision 1.8  91/06/01  10:03:17  pete
 * Working on menubar
 *
 * Revision 1.7  91/05/25  11:02:59  pete
 * Adding external menus
 *
 * Revision 1.6  91/05/23  16:49:59  pete
 * An actually working version of popup menus.
 *
 * Revision 1.5  91/05/23  15:23:00  pete
 * Pop submenus down on notify
 *
 * Revision 1.4  1991/05/22  17:49:41  pete
 * Get it to compile cleanely.  Menus almost work.
 *
 * Revision 1.3  91/05/21  17:15:46  pete
 * Working on getting popup's and downs to work correctly.
 *
 * Revision 1.2  91/05/21  15:08:55  pete
 * A minimally working walking menu implementation.
 *
 * Revision 1.1  1991/05/20  17:54:44  pete
 * Initial revision
 *
 */

#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xo/ObjBorder.h>		/* for inverted resource */
#include <X11/Xo/MenuBP.h>
#include <X11/Xo/Menu.h>
#include <X11/Xo/dbug.h>

#include <X11/Xo/MenuBRec.h>

XoProto (static void, FlagWidget, (Widget gw, ArgList args, Cardinal *cnt));

static void
ClassInit ()
{
	_XoRegisterConverters ();
}

static void
Initialize (request, new, arglist, num_args)
	Widget          request;	/* as first created */
	Widget          new;		/* after other parent classes */
	ArgList         arglist;	/* list of arguments */
	Cardinal       *num_args;	/* how many */
{
	XoMenuButtonWidget w = (XoMenuButtonWidget) new;
	Arg             args[10];
	Cardinal        cnt;

	DBUG_ENTER ("MenuButton.Initialize");
	w->menu_button.draw_border = False;
	if (w->menu_button.submenu &&
	    !XtIsShell (XtParent (w->menu_button.submenu)))
	{
		_XoWarn (new, "badParent", "MenuButton",
			 "Parent of submenu must be a shell");
		w->menu_button.submenu = NULL;
	}
	FlagWidget (new, arglist, num_args);
	if (w->simple.border_widget)
	{
		cnt = 0;
		XtSetArg (args[cnt], XtNinverted, True); ++cnt;
		XtSetValues (w->simple.border_widget, args, cnt);
	}
	DBUG_VOID_RETURN;
}

static Boolean
SetValues (current, request, new, args, num_args)
	Widget          current;	/* widget before the XtSetValues() */
	Widget          request;	/* after args applied but no
					 * set_values */
	Widget          new;		/* the allowed changes */
	ArgList         args;		/* list of arguments */
	Cardinal       *num_args;	/* how many arguments */
{
	XoMenuButtonWidget w = (XoMenuButtonWidget) new;
	XoMenuButtonWidget cur = (XoMenuButtonWidget) current;
	Boolean         redisplay = False;

	DBUG_ENTER ("MenuButton.SetValues");
	if (w->menu_button.submenu != cur->menu_button.submenu)
	{
		if (!XtIsShell (XtParent (w->menu_button.submenu)))
		{
			_XoWarn (new, "badParent", "MenuButton.SetValues",
				 "Parent of submenu must be a shell");
			w->menu_button.submenu = NULL;
		}
		if (cur->menu_button.submenu)
		{
			XtDestroyWidget (XtParent (w->menu_button.submenu));
		}
		FlagWidget (new, args, num_args);
	}
	DBUG_RETURN (redisplay);
}

/*
 *----------------------------------------------------------------------
 * Simple Class Methods
 *----------------------------------------------------------------------
 */

/*
 *----------------------------------------------------------------------
 * Label Class Methods
 *----------------------------------------------------------------------
 */

/*
 *----------------------------------------------------------------------
 * Button Class Methods
 *----------------------------------------------------------------------
 */

/*
 *----------------------------------------------------------------------
 * MenuButton Class Methods
 *----------------------------------------------------------------------
 */

/*
 *----------------------------------------------------------------------
 * Actions
 *----------------------------------------------------------------------
 */

static void
WalkMenu (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	XoMenuButtonWidget w = (XoMenuButtonWidget) gw;
	Position	x, y;

	DBUG_ENTER ("MenuButton.WalkMenu");
	/*
	 * If there is no submenu or the submenu is already popped up, just
	 * return without bothering the parent
	 */
	if (!w->menu_button.submenu)
	{
		DBUG_VOID_RETURN;
	}

	/*
	 * Pop this up if the amount moved from the initial position, as set
	 * in Highlight(), is greater than the move_delta resource. If
	 * move_delta is 0 then always popup the menu
	 */
	XoEventLocation (event, &x, &y);
	if ((x - w->menu_button.start_x
	     >= w->menu_button.move_delta) || w->menu_button.move_delta == 0)
	{
		_XoMenuNew (XtParent (gw), w->menu_button.submenu, gw,
			    _XoGravityAction (params, num_params, XoNORTHEAST),
			    event, XoPOPUP_NEW);
	}
	DBUG_VOID_RETURN;
}

static void
Highlight (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	XoMenuButtonWidget w = (XoMenuButtonWidget) gw;
	Widget          parent;
	Arg             args[10];
	Cardinal        cnt;

	DBUG_ENTER ("MenuButton.Highlight");
	DBUG_PRINT ("menu", ("Highlight %s", XoName (gw)));
	parent = XtParent (w);
	/*
	 * Only popdown the existing menu if it is not this items submenu.
	 * This avoids the menu repeatedly popping up and down when the
	 * moveDelta is 0
	 */
	if (!w->menu_button.submenu)
	{
		_XoMenuNew (parent, (Widget) NULL, gw,
			    _XoGravityAction (params, num_params, XoNORTHEAST),
			    event, XoPOPUP_NEW);
	}

	XoEventLocation (event, &w->menu_button.start_x, (Position *) NULL);
	if (w->simple.border_widget)
	{
		cnt = 0;
		XtSetArg (args[cnt], XtNinverted, False); ++cnt;
		XtSetValues (w->simple.border_widget, args, cnt);
	}
	w->menu_button.draw_border = True;
	DBUG_VOID_RETURN;
}

static void
Unhighlight (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	XoMenuButtonWidget w = (XoMenuButtonWidget) gw;
	Arg             args[10];
	Cardinal        cnt;

	DBUG_ENTER ("MenuButton.Unhighlight");
	if (w->simple.border_widget)
	{
		cnt = 0;
		XtSetArg (args[cnt], XtNinverted, True); ++cnt;
		XtSetValues (w->simple.border_widget, args, cnt);
	}
	w->menu_button.draw_border = False;
	DBUG_VOID_RETURN;
}

static void
Notify (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	XoMenuButtonWidget w = (XoMenuButtonWidget) gw;

	DBUG_ENTER ("MenuButton.Notify");
	/*
	 * Cannot execute a submenu?
	 */
	if (w->menu_button.submenu)
	{
		_XoMenuNew (XtParent (gw), (Widget) NULL, (Widget) NULL,
			    _XoGravityAction (params, num_params, XoNORTHEAST),
			    event, XoPOPUP_NONE);
	}
	XtCallCallbackList (gw, w->button.callbacks, (XtPointer) True);
	DBUG_VOID_RETURN;
}


static void
ItemNext (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	XoMenuButtonWidget w = (XoMenuButtonWidget) gw;
	Time            t;

	DBUG_ENTER ("MenuButton.ItemNext");
	/*
	 * If there is no submenu or the submenu is already popped up, just
	 * return without bothering the parent
	 */
	if (!w->menu_button.submenu)
	{
		XoTraverse (gw, XoTRAVERSE_RIGHT, XoEventTime (event));
	}
	else
	{
		
		_XoMenuNew (XtParent (gw), w->menu_button.submenu, gw,
			    _XoGravityAction (params, num_params, XoNORTHEAST),
			    event, XoPOPUP_NEW);
		/*
		 * FIX: Shouldn't I check that the accept focus works?
		 */
		t = XoEventTime (event);
		if (!XtCallAcceptFocus (w->menu_button.submenu, &t))
			printf ("no focus for %s\n", XoName (w->menu_button.submenu));
	}
	DBUG_VOID_RETURN;
}

static void
ItemPrev (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	DBUG_ENTER ("Button.ItemPrev");
	XoTraverse (gw, XoTRAVERSE_LEFT, XoEventTime (event));
	DBUG_VOID_RETURN;
}

/*
 *----------------------------------------------------------------------
 * Private functions
 *----------------------------------------------------------------------
 */

/*
 * FlagWidget -
 *	Make sure their is a flag widget depending on the existance
 *	of a submenu.  Handles creating or destroying the
 *	flag_widget as necessary.
 */

static void
FlagWidget (gw, args, cnt)
	Widget		gw;
	ArgList		args;
	Cardinal	*cnt;
{
	XoMenuButtonWidget	w = (XoMenuButtonWidget) gw;
	Widget		flag = NULL;
	Arg		args_dir[10];	/* for setting arrow direction */
	Cardinal	cnt_dir;

	cnt_dir = 0;
	if (w->menu_button.submenu)
	{
		if (!w->label.flag_widget && w->label.flag_class)
		{
			flag = XtCreateWidget ("flag",
					       w->label.flag_class,
					       (Widget) w, (Arg *) NULL,
					       (Cardinal) 0);
		}
		else
			flag = w->label.flag_widget;
	}
	XtSetArg (args_dir[cnt_dir], XtNflagWidget, flag); ++cnt_dir;
	XtSetValues (gw, args_dir, cnt_dir);

	/*
	 * Make sure the direction of the flag widget is correct
	 */
	if (flag)
	{
		cnt_dir = 0;
		XtSetArg (args_dir[cnt_dir], XtNdirection,
			  w->menu_button.direction);
		++cnt_dir;
		XtSetValues (flag, args_dir, cnt_dir);
	}
}
