/*
 * MenuBox.c,v 2.1 1992/06/23 00:28:56 pete Exp
 * MenuBox.c,v
 * Revision 2.1  1992/06/23  00:28:56  pete
 * Changed interface to _XoMenuNew and _XoMenuDone.
 *
 * Revision 2.0  1992/04/23  02:51:20  ware
 * First public release.
 *
 * Revision 1.5  1992/02/27  14:30:29  ware
 * Compiled with GCC 2.0 and very strict checks.  Fixed Warnings
 *
 * Revision 1.4  1992/02/20  15:11:09  ware
 * Applied new indentation
 *
 * Revision 1.3  1992/02/04  21:22:46  pete
 * Release 44
 *
 * Revision 1.2  1991/11/30  15:51:19  pete
 * Cleaned up some nitpicky compile time warnings.
 *
 * Revision 1.1  1991/08/30  17:41:11  pete
 * Initial revision
 *
 */

#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xo/MenuBoxP.h>
#include <X11/Xo/dbug.h>

#include <X11/Xo/MenuBoxRec.h>

/*
 *----------------------------------------------------------------------
 * Core Class Methods
 *----------------------------------------------------------------------
 */

/*
 * Initialize - Install the callback for XtNcallbackMenu.
 */

static void
Initialize (request, new, arglist, num_args)
	Widget          request;	/* as first created */
	Widget          new;		/* after other parent classes */
	ArgList         arglist;	/* list of arguments */
	Cardinal       *num_args;	/* how many */
{

	DBUG_ENTER ("MenuBox.Initialize");

	/*
	 * Add a callback for children to execute when they want to pop up or
	 * down a submenu.  This allows us to popdown any other submenus that
	 * may have been displayed.
	 */
	if (ThisClass (new).menu_box_class.callback_menu)
	{
		XtAddCallback (new, XtNcallbackMenu,
			       ThisClass (new).menu_box_class.callback_menu,
			       (XtPointer) new);
	}
	DBUG_VOID_RETURN;
}

/*
 *----------------------------------------------------------------------
 * Composite Class Methods
 *----------------------------------------------------------------------
 */

/*
 *----------------------------------------------------------------------
 * MenuBox Class Methods
 *----------------------------------------------------------------------
 */

static void
CallbackMenu (gw, client_data, call_data)
	Widget          gw;
	XtPointer       client_data;
	XtPointer       call_data;
{
	XoMenuBoxWidget w = (XoMenuBoxWidget) gw;
	XoPopupInfo    *cb = (XoPopupInfo *) call_data;
	XoPopupInfo	info;

	DBUG_ENTER ("MenuBox.CallbackMenu");
	if (!cb)
		DBUG_VOID_RETURN;
	info = *cb;
	if (cb->pi_action == XoPOPUP_NONE)
	{
		info.pi_submenu = NULL;
		XoEnablePopups (gw, False);
		_XoMenuDone (XtParent (gw), info.pi_submenu, info.pi_start,
			     info.pi_where, info.pi_event, XoPOPUP_NONE);
	}
	else if (!cb->pi_submenu)
	{
		info.pi_submenu = NULL;
		_XoMenuNew (w->menu_box.popup,  info.pi_submenu, info.pi_start,
			    info.pi_where, info.pi_event, info.pi_action);
	}
	else
	{
		XoEnablePopups (gw,  True);
		_XoMenuNew (w->menu_box.popup, info.pi_submenu, info.pi_start,
			    info.pi_where, info.pi_event, info.pi_action);
	}
	DBUG_VOID_RETURN;
}
