/*
 * Grip.c,v 2.0 1992/04/23 02:50:54 ware Exp
 * Grip.c,v
 * Revision 2.0  1992/04/23  02:50:54  ware
 * First public release.
 *
 * Revision 1.3  1992/02/27  14:30:29  ware
 * Compiled with GCC 2.0 and very strict checks.  Fixed Warnings
 *
 * Revision 1.2  1992/02/20  15:11:09  ware
 * Applied new indentation
 *
 * Revision 1.1  92/02/04  21:26:39  pete
 * Initial revision
 *
 */

#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xo/GripP.h>
#include <X11/Xo/ObjBorder.h>
#include <X11/Xo/dbug.h>

#include <X11/Xo/GripRec.h>

/*
 *----------------------------------------------------------------------
 * Core Class Methods
 *----------------------------------------------------------------------
 */

static void
ClassInit ()
{
	_XoRegisterConverters ();
}

static void
Initialize (request, new, arglist, num_args)
	Widget          request;	/* as first created */
	Widget          new;		/* after other parent classes */
	ArgList         arglist;	/* list of arguments */
	Cardinal       *num_args;	/* how many */
{
}

static void
Redisplay (gw, event, region)
	Widget          gw;
	XEvent         *event;
	Region          region;
{
	XoGripWidget    w = (XoGripWidget) gw;

	DBUG_ENTER ("Grip.Redisplay");
	_XoObjRedraw (w->simple.border_widget, event, region);
	DBUG_VOID_RETURN;
}

/*
 *----------------------------------------------------------------------
 * Actions
 *----------------------------------------------------------------------
 */

static void
Set (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	XoGripWidget    w = (XoGripWidget) gw;
	XoMoveCBdata    d;
	Position        x, y;

	DBUG_ENTER ("Grip.Set");
	XoEventLocation (event, &x, &y);
	d.mcbd_event = event;
	w->grip.x_first = d.mcbd_x = d.mcbd_x_first = gw->core.x + x;
	w->grip.y_first = d.mcbd_y = d.mcbd_y_first = gw->core.y + y;
	XtCallCallbackList (gw, w->grip.move_callbacks,
			    (XtPointer) &d);
	DBUG_VOID_RETURN;
}

static void
Unset (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	DBUG_ENTER ("Grip.Unset");
	DBUG_VOID_RETURN;
}

static void
Notify (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	XoGripWidget    w = (XoGripWidget) gw;
	XoMoveCBdata    d;
	Position        x, y;

	DBUG_ENTER ("Grip.Notify");
	XoEventLocation (event, &x, &y);
	d.mcbd_event = event;
	d.mcbd_x = gw->core.x + x;
	d.mcbd_y = gw->core.y + y;
	d.mcbd_x_first = w->grip.x_first;
	d.mcbd_y_first = w->grip.x_first;
	XtCallCallbackList (gw, w->grip.callbacks,
			    (XtPointer) &d);
	DBUG_VOID_RETURN;
}

static void
MoveNotify (gw, event, params, num_params)
	Widget          gw;
	XEvent         *event;
	String         *params;
	Cardinal       *num_params;
{
	XoGripWidget    w = (XoGripWidget) gw;
	XoMoveCBdata    d;
	Position        x, y;

	DBUG_ENTER ("Grip.MoveNotify");
	d.mcbd_event = event;
	XoEventLocation (event, &x, &y);
	d.mcbd_x = gw->core.x + x;
	d.mcbd_y = gw->core.y + y;
	d.mcbd_x_first = w->grip.x_first;
	d.mcbd_y_first = w->grip.x_first;
	XtCallCallbackList (gw, w->grip.move_callbacks,
			    (XtPointer) &d);
	DBUG_VOID_RETURN;
}
