#
# constraint.spec,v 2.3 1992/08/14 15:49:41 pete Exp
#
# Children of the constraint widget class
#

class ConsBase = {
	superclass = "Constraint";
	class_prefix = "o";
	class_name = "ConsBase";
	public_pre_defines = "
#ifndef _XO_XO_H_
#include <X11/Xo/Xo.h>
#endif
";
	private_pre_defines = "
#ifndef _XO_XOP_H_
#include <X11/Xo/XoP.h>
#endif

/*
 * Define what the procedure for sorting the children looks like.
 */
XoProto (typedef void, (*XoSortProc), (Widget gw));

/*
 * Declare the extension record so all subclasses can have Object's
 * as children.
 */
extern CompositeClassExtensionRec _XoConsExtensionRec;
#define _XoConsExtensionPtr ((XtPointer) & _XoConsExtensionRec)

";
	private_post_defines = "
#define XtInheritTraversalProc ((XtCallbackProc) _XtInherit)
#define XtInheritSortProc ((XoSortProc) _XtInherit)
";
	purpose = "
This class provides the framework for all constraint based widgets in
this widget set.  A constraint resource, sortOrder, is added to each
child.  The application can change this to cause an arbitrary ordering
of the children independent of the creation order.

To support sortOrder a new class method, sort, is used to do the
sorting.  The default one performs a simple insertion sort which has a
worst case run time of $O(n^2)$ however offers the advantage of being
only $O(n)$ if only one element is out of order.

The instance variable doLayout determines when new children and
sorting order is to be taken into account.  Setting this to False
causes any changes to the set of managed children and sorting order to
be ignored.  When it is changed to be True, any such changes are
accounted for.  This allows the application to add, remove or reorder
a number of widgets without causing expensive resize calculations to
be performed.

A traversal callback is added to support arbitrary keyboard
traversals.  This is identical to the CompBase's traversals.  See the
traversal resource for more details.

The geometry policy of this class is quite simple.  All requests for
changes in position and size are granted.  After any such changes, a
new size is calculated as being the right most widget and the
bottom most widget.  The parent is then asked for this new size.";

	class_record cons_base = {
		field = (static, "", "Core.class_part_initialize",
			ClassPartInit, "", "");
		field = (static, "", "Core.set_values", SetValues, "", "");
		field = (static, "", "Core.initialize", Initialize, "", "");
		field = ("", extern, "Core.accept_focus", "XoFocusAcceptComp", "", "");
		field = (static, "", "Composite.geometry_manager",
		         GeometryManager, "", "");
		field = (static, "", "Composite.insert_child", "InsertChild", "", "");
		field = ("", "", "Composite.extension",
			 "_XoConsExtensionPtr", "", "_XoConsExtensionPtr");
		field = (static, "", "Composite.change_managed",
		         ChangeManaged, "", "");
		field = (static, "", "Constraint.set_values", ConstraintSetValues,
		         "", "");
		field = ("extern", "XtCallbackProc", traverse, _XoTraverseCallback,
			"Handler for traverse", XtInheritTraversalProc);
		field = ("static", "XoSortProc", sort, SortChildren,
			"Sorts  children according to constr.", XtInheritSortProc);
	}
	instance cons_base = {
		(Boolean, resize_flag, "set if resize is called",
		 "", "", "", "", "",
		 "When making geometry requests of the parent, this
		 flag is used to determine if the Resize method was
		 actually called.  If not, then we must call it by
		 hand.")
		(WidgetClass, border_class, "Widget Class of border object",
		 borderClass, Class, ObjectClass, String, "\"None\"",
		 "Object class that implements drawing the border.")
		(Widget, border_widget, "draws the border",
		 "borderWidget", "BorderWidget", "Pointer", Immediate, NULL,
		 "This is the instance of the widget that draws the
		  border You have two choices, either set the
		  \res{WidgetClass} at initialization time or create
		  an object with this widget as it's parent and then
		  use \code{XtSetValues()} to set this resource.  The
		  old widget is destroyed.")
		(Pixel, fg, "foreground color",
		 foreground, Foreground,  Pixel, String, XtDefaultForeground,
		 "The color for drawing primary objects such as text
and lines.  Changing this during execution causes the object to change
color.")
		(Boolean, reorder, "children out of order",
		 "", "", "", "", "",
		 "If this flag is set, it indicates that
cons\_base\_class.sort needs to called to sort the children.  It is
usually false.  It is set when a child's sort\_order constraint
changes and do\_layout is False.  When do\_layout is changed to True,
SetValues classes the class sort method and clears reorder.")
		(Boolean, do_layout, "place widgets flag",
		 doLayout, DoLayout, Boolean, Immediate, "(caddr_t) True",
		 "If this flag is set, then the widget should readjust the 
children whenever changes occur.  If the flag is False, the widget should 
ignore changes in the set of manage children and resize events until the
flag is set to True. When the flag changes from False (do not 
reaarange the children) to True, the complete layout is recalculated.

This flag makes it conveniant to create or manage/unmanage a group of widgets 
one at a time without incurring the overhead of constantly rearranging the 
widgets.")
		(XtCallbackList, traverse, "for keyboard traversals",
		 traverse, Traverse, Callback, Immediate, NULL,
		 "List of callbacks executed to accomplish keyboard
traversals.  There should only be one callback on this list.
Behaviour is undefined if there is more than one callback.  If the
application wishes to change the callback executed, it should delete
the callback list and then install it's own private handler.

At initialization time, the Initialize method executes XtAddCallback()
for this callback list with the value of the call method
\code{traverse} as the callback to execute.  To replace the default
traversal method, subclasses should override this value.

The arguments passed in \code{call\_data} is a structure of type
XoTraversalInfo defined as follows:
\begin{verbatim}
typedef enum 
{
        XoTRAVERSE_PREVIOUS, XoTRAVERSE_NEXT, XoTRAVERSE_HOME,
        XoTRAVERSE_END,
} XoDirection;

/*
 * This information is passed to the traverse callback.
 */
typedef struct _xo_traverse_info 
{
        Widget          t_start; /* widget moving relative too */
        XoDirection     t_direction;    /* which way to move */
} XoTraverseInfo;
\end{verbatim}

The functions \code{XoTraverse()} or \code{xoTraverseFromString()} are
typically used to cause traversals to occur.  They are conveniance
routines that search the ancestors for ones that know about the
traverse callback and execute the callbacks.")
		("", "Core.border_width", "", "", "", "", "Immediate", "0", "")
	}
	constraints cons_base = {
		(int, sort_order, "order to display children in",
		 sortOrder, SortOrder, Int, Immediate, "0",
		 "This defines the order that the children are
displayed in.  Never changing this keeps the children in the order
they are inserted in.  If you are reording all the children, it is
useful to set doLayout to False, change each of the children widgets
sortOrder with XtSetValues(), and then set doLayout to True.
Otherwise, each time sortOrder changes,
all the children are layed out, again.")
	}
	function void traverse = {
		args = {
			(Widget, gw, "constraint widget")
			(XtPointer, client_data, "data from app.")
			(XtPointer, call_data, "from widget")
		}
	}
	function void sort = {
		args = {
			(Widget, gw, "constraint widget")
		}
	}
}

class Column =
{
	superclass = ConsBase;
	class_prefix = "o";
	class_name = "Column";
	private_post_defines = "
#define SKIPCHILD(c) (((XoColumnConstraint)((c)->core.constraints))->column.skip)";
	purpose = "The \class{Column} widget class implements a
		   simple geometry policy.  Each child is forced to
		   the width of the widest child and stacked
		   vertically.  No attempt is made to provide multiple
		   columns.
";
	class_record column = {
		field = ("", "int", "filler", "0", "keep compiler happy", "0");
		field = (extern, "", "Core.class_initialize",
			 "_XoClassInit", "", "");
		field = (static, "", "Core.query_geometry",
			 QueryGeometry, "", "");
		field = (static, "", "Core.resize", Resize, "", "");
		field = (static, "", "Composite.geometry_manager",
			 "GeometryManager", "", "");
		field = (static, "", "Composite.change_managed",
			 "ChangeManaged","","");
		field = (static, "", "Constraint.initialize",
			 ConsInitialize, "", "");
		field = ("", "", "Composite.extension",
			 "_XoConsExtensionPtr", "", "_XoConsExtensionPtr");
	}
	instance column = {
		(Dimension, vspace, "distance between widgets",
		 vspace, Space, Dimension, Immediate, "(XtPointer) 5",
		 "The vertical spacing to insert between each widget.")
	}
	constraints column = {
		(int, stretch, "how much to expand this one",
		 "stretch", "Stretch", Int, Immediate, "(XtPointer) 1",
		 "The amount this widget can stretch.  Note that this
		  is not a pixel value and has nothing to do with the
		  number of pixels used.  When the normal height of
		  each of the managed child widgets is summed and this
		  value is less then the current height, then this
		  value is totalled from each of the children.  The
		  amount of extra space is then divided by this and
		  each widget has this value times that factor added
		  to it's height.")
		(int, shrink, "how much shrink this one",
		 "shrink", "Shrink", Int, Immediate, "(XtPointer) 1",
		 "The amount this widget can shrink.  Note that this
		  is not a pixel value and has nothing to do with the
		  number of pixels used.  When the normal height of
		  each of the managed child widgets is summed and this
		  value is greater then the current height, then this
		  value is totalled from each of the children.  The
		  amount of extra space is then divided by this and
		  each widget has this value times that factor
		  subtracted from it's height.")
		(Boolean, skip, "ignore this child",
		 "", "", "", "", "",
		 "Flag that subclasses can set to cause the Column
		  geometry handler and query geometry methods to
		  ignore this child.")
		(Dimension, user_height, "height from user",
		 "", "", "", "", "",
		 "Whenever quering the child for a height, if this is non-zero
		  use this instead of the returned query height.  This allows
		  the Vpane (and other subclasses) to allow the user to
		  change the size of a widget")
	}
}

class Row =
{
	superclass = ConsBase;
	class_prefix = "o";
	class_name = "Row";
	purpose = "
Layout widgets all with the same height and in a single line.
";

	class_record row = {
		field = ("", "int", filler, "0", "keep compiler happy", "0");
		field = ("", extern, "Core.class_initialize", "_XoClassInit", "", "");
		field = (static, "", "Composite.change_managed", "ChangeManaged","","");
		field = (static, "", "Core.resize", Resize, "", "");
		field = ("", "", "Core.resources", NULL, "", "");
		field = ("", "", "Core.num_resources", "0", "", "");
		field = (static, "", "Core.query_geometry", QueryGeometry, "", "");
		field = (static, "", "Composite.geometry_manager",
			 "GeometryManager", "", "");
		field = ("", "", "Composite.extension",
			 "_XoConsExtensionPtr", "", "_XoConsExtensionPtr");
		field = ("", "", "Constraint.resources", "NULL", "", "");
		field = ("", "", "Constraint.num_resources", "0", "", "");
	}
	instance row = {
		("int", "filler", "keep compiler happy",
		 "", "", "", "", "", "")
	}
	constraints row =
	{
		(int, dummy, "keep compiler happy",
		 "", "", "", "", "",
		 "")
	}
}

class MenuBar =
{
	superclass = Row;
	class_prefix = "o";
	class_name = "MenuBar";
	purpose = "
Layout widgets all with the same height and in a single line.
";

	class_record menu_bar = {
		field = ("static", "XtCallbackProc", "callback_menu", CallbackMenu,
		        "for new callback", XtInheritCallbackMenu);
		field = (static, "", "Core.class_part_initialize",
			ClassPartInit, "", "");
		field = (static, "", "Core.initialize", "Initialize", "", "");
		field = ("static", "", "ConsBase.traverse", Traverse, "", "");
		field = ("", "", "Composite.extension",
			 "_XoConsExtensionPtr", "", "_XoConsExtensionPtr");
		field = ("", "", "Constraint.resources", "NULL", "", "");
		field = ("", "", "Constraint.num_resources", "0", "", "");
	}
	instance menu_bar = {
		(XtCallbackList, callback_menu, "execute for new popup",
		 "callbackMenu", "CallbackMenu", Callback, Immediate, NULL,
		 "This list of callbacks is executed to popup/down the menu.")
		(Widget, "popup", "menushell to hold popups",
		"popup", "Popup", "Widget", "Immediate", "NULL",
		"Menu used as the popup shell.  This is popped
up or down by the callbackMenu callback and replaced with the
call\_data from that callback.")
	}
	constraints menu_bar =
	{
		(int, dummy, "keep compiler happy",
		 "", "", "", "", "",
		 "")
	}
	function void callback_menu = {
		args = {
			(Widget, gw, "constraint widget")
			(XtPointer, client_data, "data from app.")
			(XtPointer, call_data, "from widget")
		}
	}
}

class List =
{
	superclass = Column;
	class_prefix = o;
	class_name = List;
	purpose = "Formats a list of RectObj's into rows and columns.";
	class_record list =
	{
		field = (static, "", "Core.initialize", Initialize, "", "");
		field = (static, "", "Core.set_values", SetValues, "", "");
		field = (static, "", "Core.expose", Redisplay, "", "");
		field = (static, "", "Core.destroy", Destroy, "", "");
		field = (extern, "", "Core.class_initialize", "_XoClassInit",
			 "", "");
		field = ("", "", "Core.tm_table", "translations", "", "");
		field = ("", "", "Core.accept_focus", XtInheritAcceptFocus, "", "");
		field = ("", "", "Constraint.resources", "NULL", "", "");
		field = ("", "", "Constraint.num_resources", "0", "", "");
		field = ("", "", "Composite.extension",
			 "_XoConsExtensionPtr", "", "_XoConsExtensionPtr");
	}
	instance list =
	{
		(XtCallbackList, callbacks, "executed when selected",
		 callback, Callback, Callback, Immediate, NULL,
		 "List of functions executed by the Notify() action or
		  whenever the currently selected object is changed.")
		(Widget, current, "currently selected",
		 current, Current, Widget, Immediate, NULL,
		 "The currently selected object.  This can be changed
		  either by the user clicking on one of the objects
		  and causing the Notify() action or by using
		  XtSetValues() to change this value.  In either case,
		  the XtNselected resource of the object is set to
		  True and the previously selected object's
		  XtNselected resource is set to False.

		  If you want to have widgets, such as Button, be in
		  this list, then the application code should add a
		  callback to the Button (or whichever) widget and
		  use XtSetValues() to update the XtNcurrent in the callback.
		  However, if a widget is used, the List widget does
		  not modify the translations of that widget in any
		  way -- so it is up to the child widget to implement
		  notifing the application and the application
		  notifying the list of the change in selected items.

		  Changing this value executes the XtNcallback.")
		(int, which, "index of selected widget",
		 "", "", "", "", "",
		 "Keeps track of which widget is currently selected.
		  This is calculated by the CurrentLocate() action.
		  Setting this to -1 indicates nothing is selected.
		  The CurrentSet() action uses this index to set the
		  currently selected widget.")
	}
	constraints menu =
	{
		(int, dummy, "keep compiler happy",
		 "", "", "", "", "",
		 "")
	}
	actions =
	{
		(Notify, Notify,
		 "Executes the XtNcallback list.  Used to notify the
		  application that a new item on the list has been selected.")
		(CurrentClear, CurrentClear,
		 "Tells the currently selected widget that it is no longer
		  selected.  Sets the internal value of the currently
		  selected widget to NULL.")
		(CurrentLocate, CurrentLocate,
		 "Uses the x and y coordinates of the event to locate
		  an object.  If none is found, then the internal
		  value of \code{which} is set to -1 to indicate
		  nothing was found.")
		(CurrentSet, CurrentSet,
		 "Updates the currently selected widget.")
	}
	translations =
	{
		("<Btn1Down>", "CurrentClear()",
		 "Remove any selected item from the list.")
		("<Btn1Up>", "CurrentLocate() CurrentSet() Notify()",
		 "Choose the new item and notify the application a
		  new selection is made.")
	}
}
	
class Menu =
{
	superclass = Column;
	class_prefix = "o";
	class_name = "Menu";
	public_pre_defines = "
XoProto (extern Widget, XoMenuMake, (String name, WidgetClass class, Widget parent, Arg *args, Cardinal cnt));
XoProto (extern Widget, XoMenuMakeUtil, (String base, Widget parent, Arg *args, Cardinal cnt));
";
	purpose = "The \class{Menu} widget class implements a simple
		   geometry policy and is used to provide popup menus.
		   Hierarchical (walking) menus are supported. Each
		   child is forced to the width of the widest child
		   and stacked vertically.  No attempt is made to
		   provide multiple columns.

		   The \class{Menu} widget follows a simple protocol
		   to support popup, pulldown and walking menus for
		   each of those.  The method is independent of the
		   widgets being used, however those widgets need
		   special code to cooperate with the menuing system.
		   In particular, the \class{Menu} widget does not add
		   or change any translations of the child widgets.
		   ";
	class_record menu = {
		field = ("static", "XtCallbackProc", "callback_menu",
			 CallbackMenu, "for new callback",
			 XtInheritCallbackMenu);
		field = (static, "", "Core.class_part_initialize",
			ClassPartInit, "", "");
		field = (static, "", "Core.initialize", "Initialize", "", "");
		field = ("", extern, "Core.class_initialize", "_XoClassInit", "", "");
		field = ("", "", "Constraint.resources", "NULL", "", "");
		field = ("", "", "Constraint.num_resources", "0", "", "");
		field = ("static", "", "ConsBase.traverse", Traverse, "", "");
		field = ("", "", "Composite.extension",
			 "_XoConsExtensionPtr", "", "_XoConsExtensionPtr");
	}
	instance menu = {
		(XtCallbackList, callback_menu, "execute for new popup",
		 "callbackMenu", "CallbackMenu", Callback, Immediate, NULL,
		 "This list of callbacks is executed to popup/down the menu.")
		(Widget, "popup", "menushell to hold popups",
		"popup", "Popup", "Widget", "Immediate", "NULL",
		"Menu used as the popup shell.  This is popped
		 up or down by the callbackMenu callback and replaced with the
		 call\_data from that callback.")
	}
	constraints menu = {
		(int, dummy, "keep compiler happy",
		 "", "", "", "", "",
		 "")
	}
	function void callback_menu = {
		args = {
			(Widget, gw, "constraint widget")
			(XtPointer, client_data, "data from app.")
			(XtPointer, call_data, "from widget")
		}
	}
}

class Vpane = {
	superclass = "Column";
	class_prefix = "o";
	class_name = "Vpane";
	private_pre_defines = "
typedef enum {XoCHILD, XoGRIP} XoChildType;
#define VPCONS(w) (XoVpaneConstraint) ((w)->core.constraints)
";
	purpose = "
Arranges children in a vertical fashion.  All children are forced to
the same width.  Children can have something much like TeX's glue
attached to indicate how the widgets should be resized in relation to
each other.  There is a stretchability and shrinkability factor with 0
indicate none.  The total glue
is added and any extra space or stretching is used to adjust the
heights.
";
	class_record vpane = {
		field = ("", "int", "filler", "0", "compiler joy", "0");
		field = (static, "", "Core.initialize", Initialize, "", "");
		field = (static, "", "Core.resize", Resize, "", "");
		field = (static, "", "Core.realize", Realize, "", "");
		field = (static, "", "Core.set_values", SetValues, "", "");
		field = (static, "", "Core.destroy", Destroy, "", "");
		field = (static, "", "Core.expose", Redisplay, "", "");
		field = (static, "", "Composite.insert_child", "InsertChild",
			 "", "");
		field = (static, "", "Composite.change_managed", "ChangeManaged",
			 "", "");
		field = (static, "", "Constraint.initialize", ConsInitialize, "", "");
		field = ("", "", "Composite.extension",
			 "_XoConsExtensionPtr", "", "_XoConsExtensionPtr");
	}
	instance vpane = {
		("", "Column.vspace", "", "", "", "", "", "(XtPointer) 10", "")
		(GC, gc, "for drawing lines",
		 "", "", "", "", "",
		 "Used to draw the lines seperating the children.")
		(GC, move_gc, "for drawing lines",
		 "", "", "", "", "",
		 "Used to draw the lines seperating the children while
		  the grips are moving.")
		(int, total_stretch, "summary of stretch",
		 "", "", "", "", "",
		 "This internal value is used to keep track of the
total stretchability from all the currently managed widgets.")
		(int, total_shrink, "summary of shrink",
		 "", "", "", "", "",
		 "This internal value is used to keep track of the
total shrinkability from all the currently managed widgets.")
		(Position, start_y, "starting position",
		 "", "", "", "", "",
		 "This gives the initial y coordinate of the grip
currently being moved.  This is used to determine how much to resize
the child corresponding to this grip.")
		(Widget, moving_grip, "grip currentl moving",
		 "", "", "", "", "",
		 "The grip widget that is currently being moved.  NULL if
one is not being moved.  This is used as a flag to indicate when
\code{start\_y} should be initialized.")
		(WidgetClass, grip_class, "what widget to create",
		 gripClass, Class, ObjectClass, String, "\"Grip\"",
		 "Specifies the widget class for creating grips.
For $n-1$ children (all but the last) a grip is created to allow the
user to interactively resize the child.  This class is passed to
create the appropiate widget.  It is expected to have an
XtNmoveCallback that passes an XoMoveCBdata structure for the call
data -- typically on each motion notify event.

This could be generalized to support other methods of notification but
this seems adequate.")
		(int, grip_count, "number of grips",
		 "", "", "", "", "",
		 "How many grip widgets are in \code{grips}.")
		("Widget *", grips, "list of grips",
		 "", "", "", "", "",
		 "List of grips, each associated with a particular
child through the constraint resources.")
		(int, layout_grips, "safe to place grips",
		 "", "", "", "", "",
		 "Set to True if it is safe to layout the grips.  This
is set to False when grips are being added and destroyed.")
	}
	constraints vpane = {
		(XoChildType, type, "is this Grip or other",
		 childType, ChildType, ChildType, Immediate, XoCHILD,
		 "This is set to XoGRIP for widgets the vpane creates
and XoCHILD for all others.  This allows us to distuinguish between
the widgets.  Applications should not be setting this value since it
is used internally by the Vpane.")
		(Widget, before, "matching child to grip",
		 "", "", "", "", "",
		 "Which child this grip is placed below.")
		(Widget, after, "matching child to grip",
		 "", "", "", "", "",
		 "Which child this grip is placed above.")
		(Position, orig_y, "normal y position",
		 "", "", "", "", "",
		 "The position this grip would be in without the user moving
		  things around.")
	}
}

