/*
 * table.c,v
 * Revision 2.0  1992/04/23  02:49:45  ware
 * First public release.
 *
 * Revision 1.2  1992/02/16  23:52:40  ware
 * Added prototypes for malloc() et al. so it compiles cleanly.
 *
 * Revision 1.1  1991/05/01  13:31:07  pete
 * Initial revision
 *
 */

#include	<stdio.h>
#include	"table.h"

#ifdef _USE_PROTO_
extern void	free (char *p);
extern void	bzero (char *p, int len);
extern char	*malloc (int len);
#else /* !_USE_PROTO_ */
extern char	*malloc ();
extern void	bzero ();
extern char	*malloc ();
#endif

Table *
table_init ()
{
	Table		*table;		/* newly created table */

	table = (Table *) malloc (sizeof (Table));
	if (!table)
	{
		return (Table *) NULL;
	}
	bzero ((char *) table, sizeof (Table));
	return table;
}

int
table_add (table, datum)
Table		*table;			/* table to add to */
char		*datum;
{
	int	status;

	if (!table || !datum || !table->t_private)
	{
		return ERR;
	}

	status = (*table->t_add) (table->t_private, datum);
	if (status != ERR)
	{
		++table->t_count;
	}
	return status;
}

char *
table_find (table, datum)
Table		*table;			/* table to find datum in */
char		*datum;			/* datum to search for */
{
	if (!table || !datum || !table->t_private)
	{
		return (char *) NULL;
	}

	return (*table->t_find) (table->t_private, datum);
}

int
table_delete (table, datum)
Table		*table;			/* table to delete datum from */
char		*datum;			/* datum to search and delete */
{
	if (!table || !datum || !table->t_private)
	{
		return ERR;
	}

	return (*table->t_delete) (table->t_private, datum, table->t_user_free);
}

int
table_first (table)
Table		*table;			/* table to start at first element */
{
	if (!table || !table->t_private)
	{
		return ERR;
	}
	return (*table->t_first) (table->t_private);
}

char *
table_next (table)
Table		*table;			/* returns the next element on table */
{
	if (!table || !table->t_private)
	{
		return (char *) NULL;
	}
	return (*table->t_next) (table->t_private);
}
