#ifndef _XO_XO_UNISTD_H_
#define _XO_XO_UNISTD_H_
/*
 * XoUnistd.h,v 2.2 1992/08/11 00:19:53 pete Exp
 * XoUnistd.h,v
 * Revision 2.2  1992/08/11  00:19:53  pete
 * Insure CONST is properly defined.  Add FREE_TYPE.
 *
 * Revision 2.1  1992/07/23  19:05:10  pete
 * Added several prototypes for some system functions.  Added macros for
 * defining return type of malloc() and free().  Added new macro,
 * XoPArgs() to allow typedef's and functions as parameters to include
 * function prototypes easily.
 *
 * Revision 2.0  1992/04/23  02:47:06  ware
 * First public release.
 *
 * Revision 1.4  1991/12/31  16:34:54  pete
 * Merged prototypes from build.h into this file.  Moved XoProto() and
 * various other defines into here.
 *
 * Revision 1.3  1991/08/26  11:07:36  pete
 * Went to some effor to insure CONST and size_t are appropriately defined.
 * The size_t typedef is used as the return type from strlen() on some
 * machines and not others.  Added XoProto() to allow prototypes
 * to be conditional.
 *
 * Revision 1.2  91/06/14  04:51:56  pete
 * Works under sun and e&s.
 * 
 * Revision 1.1  91/05/29  09:35:40  pete
 * Initial revision
 * 
 *
 * Provide some prototypes for various system library functions.  The brave,
 * new world of ANSI C and POSIX causes various incompatibilities between
 * systems.  I compile this source on:
 *
 *	Sun 3	gcc -Wall	SunOS 4.1
 *	Sun 4	gcc -Wall	SunOS 4.1.1
 *	SGI	cc -prototypes	IRIX 4.0
 *	E&S	cc		RiscOS 2.0
 *
 * and as you can see, add the compiler flags to get all kinds of warnings.
 * The following prototypes should be added as needed and carefully
 * conditionallized to work on many architectures.
 */

/*
 * Figure out the characteristics of this machine.  In the code, the
 * following defines are system dependent:
 * INCLUDEFILEOPS	Name of the include file for defines in access()
 * INCLUDESTRINGS	Either <string.h> or <strings.h>
 * CONST		Either "const" or "" -- the E&S does not support
 * STRLEN_TYPE		Either "size_t" or "int".  Indicates what type
 *			str*() are defined to return.
 * MALLOC_TYPE		Either "char" or "void".   Indicates type of pointer
 *			malloc() returns and free() takes as a parameter.
 * MALLOC_SIZE		Indicates the type of the size  argument passed
 *			to malloc.
 */

#if (defined(SYSTYPE_SYSV) || defined(_SYSTYPE_SYSV)) && !defined(INCLUDEFILEOPS)
#	define INCLUDEFILEOPS <unistd.h>
#endif
#if (defined(SYSTYPE_BSD43) || defined(_SYSTYPE_BSD43)) && !defined(INCLUDEFILEOPS)
#	define INCLUDEFILEOPS <sys/file.h>
#endif
#if defined(__STDC__) && !defined(INCLUDEFILEOPS)
#	define INCLUDEFILEOPS <unistd.h>
#endif
#ifndef INCLUDEFILEOPS
#	define INCLUDEFILEOPS <sys/file.h>
#endif

#if (defined(SYSTYPE_SYSV) || defined(_SYSTYPE_SYSV)) && !defined(INCLUDESTRINGS)
#	define INCLUDESTRINGS <string.h>
#endif
#if (defined(SYSTYPE_BSD43) || defined(_SYSTYPE_BSD43)) && !defined(INCLUDESTRINGS)
#	define INCLUDESTRINGS <strings.h>
#endif
#ifndef INCLUDESTRINGS
#	define INCLUDESTRINGS <strings.h>
#endif

/*
 * Try to figure out if stdio.h has already been included
 */
#if !defined(FILE) && !defined(BUFSIZ)
#include <stdio.h>
#endif

#if !defined(HAVE_PROTOS) && defined(sgi)
#include <stddef.h>
#include <unistd.h>
#include <stdlib.h>
#define HAVE_PROTOS
#endif

#if !defined(HAVE_PROTOS) && defined(sun) /* && !defined(__GNUC__)*/
#include <sys/stdtypes.h>
#include <unistd.h>
/*#include <stdlib.h>*/
/*#define HAVE_PROTOS*/
#endif

/*
 * Test if this is an E&S workstation
 */
#ifdef arches
#	define CONST
#endif

#if !defined(CONST) && (defined(__STDC__) || defined(__EXTENSIONS__))
#	undef const
#	define CONST const
#endif
#ifndef CONST
#	define CONST
#endif

#ifndef NeedFunctionPrototypes
#	if defined(FUNCPROTO) || defined(__STDC__) || defined(__cplusplus) || defined(c_plusplus)
#		define NeedFunctionPrototypes 1
#	else
#		define NeedFunctionPrototypes 0
#	endif /* __STDC__ */
#endif /* NeedFunctionPrototypes */

#ifndef XoProto
#	if NeedFunctionPrototypes
#		define XoProto(type,name,args) type name args
#		define XoPArgs(args) args
#	else
#		define XoProto(type,name,args) type name ()
#		define XoPArgs(args)
#	endif /* !NeedFunctionPrototypes */
#endif /* !XoProto */

#if (defined(SYSTYPE_SYSV) || defined(_SYSTYPE_SYSV)) && !defined(STRLEN_TYPE)
#	define STRLEN_TYPE size_t
#endif
#if (defined(SYSTYPE_BSD43) || defined(_SYSTYPE_BSD43)) && !defined(STRLEN_TYPE)
#	define STRLEN_TYPE int
#endif
#ifndef STRLEN_TYPE
#	define STRLEN_TYPE int
#endif /* STRLEN_TYPE */

/*
 * Indicate the return types and parameters of malloc and free.
 * 
 */

#if !defined(MALLOC_TYPE_DEF)
#	if defined(__GNUC__)
#		define MALLOC_TYPE void
#		define MALLOC_SIZE size_t
#		define FREE_TYPE void
#	endif
#endif

#if !defined(MALLOC_TYPE)
#	define MALLOC_TYPE char
#endif
#if !defined(MALLOC_SIZE)
#	define MALLOC_SIZE unsigned
#endif
#if !defined(FREE_TYPE)
#	define FREE_TYPE int
#endif

/*
 * This is modeled after the unistd.h as spec'd by ANSI C.
 */
#if !defined(HAVE_PROTOS)
#	ifndef CONST
#		define CONST
#	endif
#	if !defined(_SIZE_T_) && !defined(__sys_stdtypes_h)
#		define _SIZE_T_
		typedef unsigned size_t;
#	endif
#endif

XoProto (extern void,	abort,	(void));
XoProto (extern int,	abs,	(int));
XoProto (extern double,	atof,	(CONST char* ));
XoProto (extern int,	atoi,	(CONST char*));
XoProto (extern void,	bcopy,	(void *src, void *dst, size_t size));
XoProto (extern void*,	bsearch, (CONST void*, CONST void*, size_t, size_t, int (*) (CONST void*, CONST void*)));
XoProto (extern void*,	calloc,	(size_t, size_t));
XoProto (extern void,	exit,	(int));
XoProto (extern int,	fclose,	(FILE *fptr));
XoProto (extern int,	fflush, (FILE *fptr));
XoProto (extern int,	_flsbuf, (int ch, FILE *fptr));
XoProto (extern  int,	fprintf, (FILE*, CONST char*, ...));
XoProto (extern int,	fputc,	(int ch, FILE*fptr));
XoProto (extern int,	fputs,	(char *s, FILE *fptr));
XoProto (extern FREE_TYPE, free, (MALLOC_TYPE *));
XoProto (extern int,	fwrite,	(char *buf, int size, int nitems, FILE *stream));
XoProto (extern char*,	getenv,	(CONST char*));
XoProto (extern long int, atol,	(CONST char*));
XoProto (extern unsigned long int, strtoul, (CONST char*, char**, int));
XoProto (extern MALLOC_TYPE *,	malloc,	(MALLOC_SIZE));
XoProto (extern int,	mkdir,	(CONST char*path, int mode));
XoProto (extern void,	perror,	(CONST char*));
XoProto (extern  int,	printf,	(CONST char*, ...));
XoProto (extern void,	qsort,	(void*, size_t, size_t, int (*) (CONST void*, CONST void*)));
XoProto (extern int,	rand,	(void));
XoProto (extern int,	read,	(int fd, char *buf, int size));
XoProto (extern char*,	realloc, (char*, unsigned));
XoProto (extern int,	rename,	(CONST char*, CONST char*));
XoProto (extern void,	srand,	(unsigned int));
XoProto (extern char*,	strcat,	(char*s1, CONST char*s2));
XoProto (extern int,	strcmp,	(CONST char*s1, CONST char*s2));
XoProto (extern char*,	strcpy,	(char*s1, CONST char*s2));
XoProto (extern STRLEN_TYPE, strlen, (CONST char*));
XoProto (extern char*,	strncpy, (char*s1, CONST char*s2, int len));
XoProto (extern int,	system,	(CONST char*));
#ifndef tolower
	XoProto (extern int,	tolower, (int ch));
#endif
#ifndef toupper
	XoProto (extern int,	toupper, (int ch));
#endif
#endif /* _XO_XO_UNISTD_H_ */
