/* UNIX includes. */
#include <sys/types.h>
#include <stdio.h>

/* X includes. */
#include "xincludes.h"
#include <X11/keysym.h>

/* XGobi defines and includes. */
#define XGOBIINTERN
#include "xgobitypes.h"
xgobidata xgobi;
#include "xgobivars.h"
#include "xgobitop.h"

/* YourProg includes. */
#define PROGINTERN
#include "prog.h"

static XtResource panel_resources[] = {
  {"font", "Font", XtRFontStruct, sizeof(XFontStruct *),
  XtOffset(PanelDataPtr, Font), XtRString, "*"},
};

char filename[50];

/*
 * Routines you might want
*/
void
initialize_data(ac, av)
  int ac;
  char **av;
{
  strcat(filename, av[1]);
}

void
initialize_variables(ac, av)
  int ac;
  char **av;
{
}

/*
 This is just a demo routine to show you some of the
 values you can change.
*/
void
loop_once(xg)
  xgobidata *xg;
{
  int i, j, k;
  static int count = 0;
  static int mult = 1;

/*
 * Cycle the data values for columns 2 and 3.
 * Cycle the glyph and color for each point.
*/
  for (i=0; i<xg->nrows; i++)
  {
    k = i-1;
    if (i == 0)
      k = xg->nrows-1 ;

    for (j=1; j<xg->ncols_used; j++)
      xg->raw_data[k][j] = xg->raw_data[i][j] ;

    xg->color_now[k] = xg->color_now[i] ;
    xg->glyph_now[k].type = xg->glyph_now[i].type ;
    xg->glyph_now[k].size = xg->glyph_now[i].size ;
  }

  count++;
  if (count == xg->nrows)
    count = 0;
}

/*
An X program always has an event loop running, looking for
input:  usually user-generated mouse motions and so forth.  The
XGobi event loop is called XGobiMainLoop() and it's in
xgobitop.h.

A work proc is a routine that runs once whenever the event loop
finds no events, a sort of run-while-idle routine.  In XGobi,
continuous processes such as rotation are handled using work
procs:  for example, if no user input is found, spin_once().
Usually, an X programmer doesn't write her own RunWorkProcs()
routine, but we found it necessary to do so for XGobi.

In prog, we added one additional background routine to the set
used in XGobi -- it is called loop_once() and it changes the
color, plotting character and location of each point every time
it runs.
*/

Boolean
RunWorkProcs()
{
  int i;
  int keepgoing = 0;
  int replot = 0;

  if (xgobi.is_realized)
  {
    if (is_running)
    {
      keepgoing = replot = 1;
/*
 Here's the line you'll want to replace with your own
 background routine or routines.
*/
      loop_once(&xgobi);

/*
 Here is where the change to xg->raw_data[][] made in
 loop_once() is sent through the data pipeline so that
 it will show up on the screen at the next plot_once().
*/
      copy_raw_to_tform(&xgobi);
      update_lims(&xgobi);
      update_world(&xgobi);
      world_to_plane(&xgobi);
      plane_to_screen(&xgobi);
    }

    if (RunWorkProc((xgobidata *) &xgobi))
      keepgoing = 1;

    if (replot)
    {
      /* Plot */
      plot_once(&xgobi);
    }
  }

  if (keepgoing)
    return FALSE;
  else
    return TRUE;
}

/*
This routine is meant to handle the case where you have
both an XGobi resource file and a resource file for your
parent program, and you'd like to read them both and
fold them together.  You can lift this routine as is,
or leave it out if you aren't interested in using a
resource file for your parent program.
*/

XrmDatabase
GetExtraResources(dpy, classname)
/*
 * Read in the resource file for the application named "classname".
 * Use the shell variables XFILESEARCHPATH and/or XUSERFILESEARCHPATH,
 * or use XAPPLRESDIR.  If none of those exists, return NULL.
*/
  Display *dpy;
  String classname;
{
  char *filename;
  XrmDatabase rdb = NULL;
  XrmDatabase xpathrdb = NULL, xuserpathrdb = NULL, xapplpathrdb = NULL;
  extern char *getenv();

  char *xpath = getenv("XFILESEARCHPATH");
  char *xuserpath = getenv("XUSERFILESEARCHPATH");
  char *xapplpath = getenv("XAPPLRESDIR");

  if (xpath)
  {
    if ((filename = XtResolvePathname(dpy, NULL, classname, NULL,
        xpath, NULL, 0, NULL)) != NULL)
    {
      xpathrdb = XrmGetFileDatabase(filename);
    }
  }

  if (xuserpath)
  {
    if ((filename = XtResolvePathname(dpy, NULL, classname, NULL,
        xuserpath, NULL, 0, NULL)) != NULL)
    {
      xuserpathrdb = XrmGetFileDatabase(filename);
    }
  }

  if (!xpath && !xuserpath)
  {
    if ((filename = XtResolvePathname(dpy, NULL, classname, NULL,
        xapplpath, NULL, 0, NULL)) != NULL)
    {
      xapplpathrdb = XrmGetFileDatabase(filename);
    }
  }

  if (xpathrdb)
  {
    if (xuserpathrdb)
    {
      XrmMergeDatabases(xuserpathrdb, &xpathrdb);
    }
    rdb = xpathrdb;
  }
  else
  {
    if (xuserpathrdb)
      rdb = xuserpathrdb;
    else if (xapplpathrdb)
      rdb = xapplpathrdb;
  }
  return rdb;
}

/* xgvis main */
main(argc, argv)
  int argc;
  char *argv[];
{
  int i;
  XrmDatabase xgobidb;

/*
Mandatory X initialization line; replace YourProg with your
own application name.  This name could be used in resource
files or to provide the name that appears in the title 
bar.
*/
  shell = XtAppInitialize(&app_con, "Prog", NULL, 0,
    &argc, argv, fallback_resources, NULL, 0);
  display = XtDisplay(shell);
  XtAppAddActions(app_con, added_actions, XtNumber(added_actions));
  find_mono(&mono);

/*
Here's the initialization routine for the parent program.
Here you might strip off certain command line arguments,
for example, or do other variable initialization.

XGobi requires data upon startup.  When running by itself,
it reads the data from a file or from stdin.  Here we have
read in a data file, and we then allocate additional space
and pad the array with small random numbers.  You can do
either:  read in a data file, in initialize_data() above,
or create your own data.  The data array with its dimensions
are three of the arguments to make_xgobi().
*/
  initialize_data(argc, argv);
  initialize_variables(argc, argv);

/* More X and XGobi stuff having to do with resources. */
  XtGetApplicationResources(shell, &panel_data, panel_resources, 
    XtNumber(panel_resources), NULL, 0);
  xgobidb = GetExtraResources(display, "XGobi");
  if (xgobidb)
    XrmMergeDatabases(xgobidb, &display->db);  

/*
 Here you create the control panel for your parent application.
*/
  make_prog_widgets();

/*
 Here all the widgets created so far are 'realized.' (X jargon)
*/
  XtRealizeWidget(shell);

/*
 Some XGobi variables that require initialization.
*/
  xgobi.std_type = 0;
  xgobi.std_width = 2.0;
  xgobi.is_realized = 1;
  Sprocess = Snetwork = 0;

/*
Initiate XGobi.  This argument list is rather kludgy,
I'm sorry to say, written to cover perhaps too many cases.

 dataflag: Boolean, Have input data structures already been built?
  If this is True, you must supply datap, nr, and nc. 
    You may also want to supply collab and rowlab, and perhaps
    connecting_lines.
  If this is False, you must supply data_name.
    You may also want to supply col_name, row_name, although if
    you name them according to the usual XGobi conventions, you
    can leave col_name and row_name NULL.

 data_name: char *, name of a file containing data for XGobi
  to read.  Must provide if dataflag is False.

 col_name, row_name: char *; Just leave these NULL; they aren't
  used at present.

 datap: float **, pointer to a two-dimensional array; this is
  the initial data for XGobi.
 nr:  int, number of rows in datap.
 nc:  int, number of columns of datap.
  All these must be provided if dataflag is True.

 collab, rowlab:  char **, pointers to arrays of character
  pointers, the names to be used as column and row labels.
  Can be provided if dataflag is True.

 nlinks:  int, number of connecting line segments.
 connecting_lines: of type connect_lines; struct {int a, b;}
  This data structure is used by XGobi to define an arbitrary
  number of line segments connecting points, where  a and b are
  the row numbers that identify these points.  If these arguments
  are NULL, XGobi's default is to build a structure in which 
  row 1 is connected to row 2, row 2 to row 3, and so forth.
  These are optional and can be provided if dataflag is True.

  xgobi: address of the xgobi data array; must be used.
  parent: shell, the widget id returned by XtAppInitialize().
  name: just let this be a NULL string
*/

/*  
Here's what it might look like if you have initialized the data.
  if (make_xgobi (True, "",
   data, nrows, ncols,
   rowlab, (char **) NULL, 
   nlinks, xg_links,
   &xgobi,
   shell, "") == 0)
  {
    return(0);
  }
  else
    XGobiMainLoop(&xgobi);
*/

/*
 And here's a case where we're using a named file.
*/
  if (make_xgobi (False,
   filename,
   (float **) NULL, (int) NULL, (int) NULL,
   (int) NULL, (char **) NULL, 
   (int) NULL, (connect_lines *) NULL,
   &xgobi,
   shell, "") == 0)
  {
    return(0);
  }
  else
    XGobiMainLoop(&xgobi);
}
