/************************************************************
 *                                                          *
 *  Permission is hereby granted  to  any  individual   or  *
 *  institution   for  use,  copying, or redistribution of  *
 *  the xgobi code and associated documentation,  provided  *
 *  that   such  code  and documentation are not sold  for  *
 *  profit and the  following copyright notice is retained  *
 *  in the code and documentation:                          *
 *     Copyright (c) 1990,1991,1992,1993 Bellcore           *
 *                                                          *
 *  We welcome your questions and comments, and request     *
 *  that you share any modifications with us.               *
 *                                                          *
 *    Deborah F. Swayne            Dianne Cook              *
 *     dfs@bellcore.com      dcook@stat.rutgers.edu         *
 *      (201) 829-4263                                      *
 *                                                          *
 ************************************************************/

#include <sys/types.h>
#include <stdio.h>
#include "xincludes.h"
#include "xgobitypes.h"
#include "xgobivars.h"

/* Functions used in this file */
int Sread_array();
void read_array();
int read_rowlabels(), read_collabels();
int read_brush_indices();
int read_erase(), read_extra_resources();
int read_vgroups(), read_connecting_lines();
void add_menupb_help(), add_pb_help(), add_sbar_help();
void alloc_tour(), alloc_plot_arrays();
void alloc_pipeline_arrays();
void copy_raw_to_tform();
void dotplot_cycle_proc();
void fill_extra_column();
void id_proc();
void init_tour_pp_GCs();
void init_GCs();
void init_axes(), init_brush_colors();
void init_brush_menus(), init_help(), init_line_colors();
void init_plotwindow_vars(), init_stdview_menu(), init_ticks();
void init_tour(), init_tour_pp_menu(), init_tour_interp_menu();
void init_vars();
void interp_proc();
void line_edit_proc();
void make_arrows(), make_brush(), make_dotplot();
void make_identify(), make_line_editor(), make_plot_window();
void make_plotwindow_mouse_labels(), make_rotate();
void make_scaling(), make_stdview(), make_tour();
void make_varpanel(), make_widgets(), make_xyplot();
void ob_rotate_proc();
void plane_to_screen(), plot_once(), refresh_vlab();
void reinit_brush_colors(), reset_rows_in_plot();
void rock_proc(), scale_proc();
void scaling_proc();
void set_shift_wrld0(), sphered_data_fn();
void set_title_and_icon();
void shift_proc();
void spin_proc(), tour_proc();
void update_lims(), update_world(), world_to_plane();
void xy_cycle_proc(), xy_scroll_proc();
Boolean read_line_colors();
void alloc_transform_types();
void init_transform_types();
void init_options();
void init_dotplot_vars();
void init_xyplot_vars();
void init_rotate_vars();
void init_brush_vars();
void init_scale_vars();
void init_identify_vars();
void init_line_edit_vars();
void build_options_menu();
void alloc_brush_arrays();
void alloc_rotate_arrays();
void alloc_axis_arrays();
void alloc_line_edit_arrays();
/* */

static XtResource resources[] = {
/* Monochrome defaults */
  {XtNforeground, XtCForeground, XtRPixel, sizeof(Pixel),
  XtOffset(AppDataPtr, fg), XtRString, "Black"},
  {XtNbackground, XtCBackground, XtRPixel, sizeof(Pixel),
  XtOffset(AppDataPtr, bg), XtRString, "White"},
  {XtNborderColor, XtCBorderColor, XtRPixel, sizeof(Pixel),
  XtOffset(AppDataPtr, border), XtRString, "Black"},
/* Font for labels and buttons */
  {"font", "Font", XtRFontStruct, sizeof(XFontStruct *),
  XtOffset(AppDataPtr, font), XtRString,
    "-*-helvetica-medium-r-*-*-12-*-*-*-*-*-*-*"},
/* Font for PlotWindow */
  {"plotFont", "PlotFont", XtRFontStruct, sizeof(XFontStruct *),
  XtOffset(AppDataPtr, plotFont), XtRString,
    "-*-helvetica-medium-r-*-*-14-*-*-*-*-*-*-*"},
/* Help font */
  {"helpFont", "HelpFont", XtRFontStruct, sizeof (XFontStruct *),
  XtOffset(AppDataPtr, helpFont), XtRString,
    "-*-helvetica-medium-r-*-*-14-*-*-*-*-*-*-*"},
/* Brushing color defaults */
  {"brushColor0", "BrushColor0", XtRString, sizeof(String),
  XtOffset(AppDataPtr, brushColor0), XtRString, "Red"},
  {"brushColor1", "BrushColor1", XtRString, sizeof(String),
  XtOffset(AppDataPtr, brushColor1), XtRString, "Orange"},
  {"brushColor2", "BrushColor2", XtRString, sizeof(String),
  XtOffset(AppDataPtr, brushColor2), XtRString, "Yellow"},
  {"brushColor3", "BrushColor3", XtRString, sizeof(String),
  XtOffset(AppDataPtr, brushColor3), XtRString, "SkyBlue"},
  {"brushColor4", "BrushColor4", XtRString, sizeof(String),
  XtOffset(AppDataPtr, brushColor4), XtRString, "Blue"},
  {"brushColor5", "BrushColor5", XtRString, sizeof(String),
  XtOffset(AppDataPtr, brushColor5), XtRString, "PaleGreen"},
  {"brushColor6", "BrushColor6", XtRString, sizeof(String),
  XtOffset(AppDataPtr, brushColor6), XtRString, "Green"},
  {"brushColor7", "BrushColor7", XtRString, sizeof(String),
  XtOffset(AppDataPtr, brushColor7), XtRString, "Maroon"},
  {"brushColor8", "BrushColor8", XtRString, sizeof(String),
  XtOffset(AppDataPtr, brushColor8), XtRString, "Orchid"},
  {"brushColor9", "BrushColor9", XtRString, sizeof(String),
  XtOffset(AppDataPtr, brushColor9), XtRString, "Peru"},
/* Should axes, points, lines be drawn on startup? */
  {"showAxes", "ShowAxes", XtRBoolean, sizeof(Boolean),
  XtOffset(AppDataPtr, showAxes), XtRString, "True"},
  {"showPoints", "ShowPoints", XtRBoolean, sizeof(Boolean),
  XtOffset(AppDataPtr, showPoints), XtRString, "True"},
  {"showLines", "ShowLines", XtRBoolean, sizeof(Boolean),
  XtOffset(AppDataPtr, showLines), XtRString, "True"},
/* Linking options */
  {"linkBrush", "LinkBrush", XtRBoolean, sizeof(Boolean),
  XtOffset(AppDataPtr, linkBrush), XtRString, "True"},
  {"linkIdentify", "LinkIdentify", XtRBoolean, sizeof(Boolean),
  XtOffset(AppDataPtr, linkIdentify), XtRString, "True"},
  {"linkTour", "LinkTour", XtRBoolean, sizeof(Boolean),
  XtOffset(AppDataPtr, linkTour), XtRString, "False"},
/* Brushing options */
  {"jumpBrush", "JumpBrush", XtRBoolean, sizeof(Boolean),
  XtOffset(AppDataPtr, jumpBrush), XtRString, "True"},
  {"reshapeBrush", "ReshapeBrush", XtRBoolean, sizeof(Boolean),
  XtOffset(AppDataPtr, reshapeBrush), XtRString, "False"},
  {"carryVars", "CarryVars", XtRBoolean, sizeof(Boolean),
  XtOffset(AppDataPtr, carryVars), XtRString, "False"},
/* Starting glyph type and size */
  {"glyphType", "GlyphType", XtRInt, sizeof(int),
  XtOffset(AppDataPtr, glyphType), XtRString, "1"},
  {"glyphSize", "GlyphSize", XtRInt, sizeof(int),
  XtOffset(AppDataPtr, glyphSize), XtRString, "1"},   /* TINY */
/* pointer color */
  {"pointerColor", "PointerColor", XtRString, sizeof(String),
  XtOffset(AppDataPtr, pointerColor), XtRString, "Red"},
};

Boolean
RunWorkProc(xg)
  xgobidata *xg;
/*
 * If there is a work proc attached to this xgobi, run it.
*/
{
  Boolean run_work_proc = False;

  if (xg->is_identify)
  {
    id_proc(xg);
    run_work_proc = True;
  }
  else if (xg->is_line_editing)
  {
    line_edit_proc(xg);
    run_work_proc = True;
  }
  else if (xg->is_scaling)
  {
    if (xg->run_scale_proc)
      scale_proc(xg);
    if (xg->run_shift_proc)
      shift_proc(xg);
    scaling_proc(xg);
    run_work_proc = True;
  }
  else if (xg->run_tour_proc)
  {
    tour_proc(xg);
    run_work_proc = True;
  }
  else if (xg->run_spin_oblique_proc)
  {
    ob_rotate_proc(xg);
    run_work_proc = True;
  }
  else if (xg->run_spin_axis_proc)
  {
    spin_proc(xg);
    run_work_proc = True;
  }
  else if (xg->run_rock_proc)
  {
    rock_proc(xg);
    run_work_proc = True;
  }
  else if (xg->run_interp_proc)
  {
    interp_proc(xg);
    run_work_proc = True;
  }
  else if (xg->is_xyplotting)
  {
    if (xg->is_xy_cycle)
    {
      xy_cycle_proc(xg);
      run_work_proc = True;
    }
  }
  else if (xg->is_dotplot_cycle)
  {
    dotplot_cycle_proc(xg);
    run_work_proc = True;
  }

  return(run_work_proc);
}

void
find_mono(mono)
  int *mono;
{
  Visual *vis;
  int scrn;
  /*
   * Determine whether this is a monochrome display -- treat
   * grayscale machines as monochrome for now.
  */
  scrn = DefaultScreen(display);
  depth = DefaultDepth(display, scrn);
  vis = DefaultVisual(display, scrn);
  if (depth == 1)
    *mono = 1;
  else if (vis->class == GrayScale || vis->class == StaticGray)
    *mono = 1;
  else
    *mono = 0;
}

int
make_xgobi(datapflag, data_in,
  datap, nr, nc, rowp, colp, nlinks, connecting_lines,
  xg, parent, name )

  Boolean datapflag;  /* calling program supplies pointer to data? */
  char *data_in;      /* datapflag = F; name of the data file */
  float **datap;      /* datapflag = T; data pointer */
  int nr, nc;         /* datapflag = T (for xgvis);
                       * number of rows and cols */
  char **rowp, **colp;  /* datapflag = T; pointers to row and col labels */
  int nlinks;         /* datapflag = T */
  connect_lines *connecting_lines;   /* datapflag = T; pointer to lines */

  xgobidata *xg;
  Widget parent;
  char *name;
{
  int i, j;
  int wkfg = 0;
  Colormap cmap;
  XColor cfore, cback;
  int is_named = 0;
  static int firsttime = 1;
  void srand48();
  long time();

  xg->is_realized = False;

  if (firsttime)
  {
    /*
     * Initialize the strings in the save_types[] array.
    */
    SAVE_SPIN_COEFS = "spin coefs";
    SAVE_TOUR_COEFS = "tour coefs";
    SAVE_TOUR_HIST = "tour savehist";
    SAVE_POINT_COLORS_GLYPHS = "brush vec";
    READ_DATA = "new data";
    READ_TOUR_HIST = "tour readhist";
    OPEN_BITMAP_FILE = "open bitmap file";
    SAVE_LINES = "save lines";
    READ_LINES = "read lines";
    SAVE_RESOURCES = "save resources";
    SAVE_DATA = "save data";
    SAVE_LINE_COLORS = "save line colors";

    /*
     * Initialize Atoms used to pass xg->rows_in_plot
    */
    XG_ROWSINPLOT_ANNC = XInternAtom(display,
      "Announce Rows in Plot", 0);
    XG_ROWSINPLOT_ANNC_TYPE = XInternAtom(display,
      "Announce Rows in Plot Type", 0);
    XG_ROWSINPLOT = XInternAtom(display,
      "Rows in Plot", 0);
    XG_ROWSINPLOT_TYPE = XInternAtom(display,
      "Rows in Plot Type", 0);

    /*
     * Initialize Atoms used in linked brushing.
    */
    XG_NEWPAINT_ANNC = XInternAtom(display,
      "Announce New Paint", 0);
    XG_NEWPAINT_ANNC_TYPE = XInternAtom(display,
      "Announce New Paint Type", 0);
    XG_NEWPAINT = XInternAtom(display,
      "New Paint", 0);
    XG_NEWPAINT_TYPE = XInternAtom(display,
      "New Paint Type", 0);

    /*
     * Initialize Atoms used in linked identification.
    */
    XG_IDS_ANNC = XInternAtom(display,
      "Announce NearestPoint", 0);
    XG_IDS_ANNC_TYPE = XInternAtom(display,
      "Announce NearestPoint Type", 0);
    XG_IDS = XInternAtom(display,
      "NearestPoint", 0);
    XG_IDS_TYPE = XInternAtom(display,
      "NearestPoint Type", 0);

    /*
     * Initialize Atoms used in linked touring.
    */
    XG_NEWTOUR_ANNC = XInternAtom(display,
      "Announce New Tour Coefs", 0);
    XG_NEWTOUR_ANNC_TYPE = XInternAtom(display,
      "Announce New Tour Coefs Type", 0);
    XG_NEWTOUR = XInternAtom(display,
      "New Tour Coefs", 0);
    XG_NEWTOUR_TYPE = XInternAtom(display,
      "New Tour Coefs Type", 0);

  }

  /*
   * Create the shell if it hasn't already been created.
  */
  if (parent)
    xg->shell = XtVaCreatePopupShell("XGobi",
       topLevelShellWidgetClass, parent,
       NULL);


  /*
   * Read data-specific resource file and merge all resources.
  */
  (void) read_extra_resources(data_in);
  /*
   * Set title and icon names if the -name argument is absent.
  */
  if (!name || (name && strlen(name) == 0))
    set_title_and_icon(data_in, xg);

  /*
   * Input data:
   *  If data is being supplied by by a calling program,
   *  set up xg->nrows and xg->ncols and grab the data:
   *  either copy it into xg->raw_data or assign it.
   *  If data is coming from S over the network, use Sread*()
   *  functions.
   *  Else, read data from ascii files.
  */
  if (parent && datapflag)
  {
   /*
    * Parent can override previous definitions made in
    *  set_title_and_icon()
    * Parent responsible for definition of the following:
    *  nrows, ncols, nlinks
    * Parent responsible for allocation and definition of the following:
    *  raw_data[]
    *  vgroup_ids[]
    *  erased[]
    *  collab[], collab_tform[], rowlab[]
    *  connecting_lines[]
    * Parent could handle read_extra_resources() in some other way.
   */
    xg->nrows = nr;
    xg->ncols = nc;
    xg->ncols_used = nc-1;
    xg->raw_data = datap;
    /* Populates extra columns */
    fill_extra_column(xg);

    xg->vgroup_ids = (int *) XtMalloc(
      (Cardinal) xg->ncols * sizeof(int));
    for (j=0; j<xg->ncols_used; j++)
      xg->vgroup_ids[j] = 0;
    xg->vgroup_ids[xg->ncols_used] = 1;

    if (xg->nrows < 1 || xg->ncols_used < 1 || xg->raw_data == NULL)
    {
      (void) fprintf(stderr, "problem with input data\n");
      return(0);
    }
    /*
     * Assume the links will always be supplied.
    */
    xg->nlinks = nlinks;
    xg->connecting_lines = connecting_lines ;

    if (rowp)
      xg->rowlab = rowp;
    else
      /* Allocate and create default row labels */
    {
      xg->rowlab = (char **) XtMalloc((Cardinal)
          xg->nrows * sizeof (char *));
      for (i=0; i<xg->nrows; i++)
        xg->rowlab[i] = (char *) XtMalloc((Cardinal)
          ROWLABLEN * sizeof(char));

      for (i=0; i<xg->nrows; i++)
        (void) sprintf(xg->rowlab[i], "%d", i+1);
    }

    if (colp)
      xg->collab = colp;
    else
    {
      /* Allocate and create default column labels */
      xg->collab = (char **) XtMalloc( (Cardinal)
        xg->ncols * sizeof (char *));
      for (j=0; j<(xg->ncols); j++)
        xg->collab[j] = (char *) XtMalloc( (Cardinal)
          COLLABLEN * sizeof(char));

      for (i=0; i<(xg->ncols); i++)
        (void) sprintf(xg->collab[i], "Var %d", i+1);
    }

    /*
     * Allocate collab_tform and copy collab into it.
    */
    xg->collab_tform = (char **) XtMalloc(
        (Cardinal) (xg->ncols) * sizeof (char *));
    for (j=0; j<(xg->ncols); j++)
        xg->collab_tform[j] = (char *) XtMalloc(
            (Cardinal) (COLLABLEN+8) * sizeof(char));
    /*
     * Set the label for the last variable
    */
    strcpy(xg->collab[xg->ncols-1], "group");
    for (j=0; j<(xg->ncols); j++)
        (void) strcpy(xg->collab_tform[j], xg->collab[j]);

    /*
     * Let these default for now
    (void) read_collabels(data_in, xg);
    (void) read_rowlabels(data_in, xg);
    */

    (void) read_erase(data_in, xg);

  /*
   * End of xgobi-as-subroutine section
  */
  }
  else
  {
    /* Read input data files */
    if (Sprocess)
      (void) Sread_array(data_in, xg);
    else
    {
      (void) read_array(data_in, xg);
      fill_extra_column(xg);
    }

    (void) read_collabels(data_in, xg);
    (void) read_rowlabels(data_in, xg);
    (void) read_vgroups(data_in, xg);
    (void) read_connecting_lines(data_in, False, xg);
    (void) read_erase(data_in, xg);
  }

  if (Sprocess)
    strcpy(xg->datafilename, name);
  else
  {
    if (strcmp(data_in, "stdin") != 0)
      strcpy(xg->datafilename, data_in);
    else
      strcpy(xg->datafilename, "");
  }

  xg->nrows_in_plot = xg->nrows;

  /*
   * Get the application foreground and background colors, as well
   * as the brushing colors.
   * This needs to be done after read_extra_resources()
  */
    if (parent)
      XtGetApplicationResources(parent, &appdata, resources,
        XtNumber(resources), NULL, 0);
    else
      XtGetApplicationResources(xg->shell, &appdata, resources,
        XtNumber(resources), NULL, 0);

    if (mono)
      if (appdata.fg == appdata.bg)
        appdata.fg = !appdata.bg;

    if (!mono)
      init_brush_colors(&appdata);
/* */

  /*
   * Initialize variables: the sequence of these is important.
  */
  alloc_pipeline_arrays(xg);
  alloc_plot_arrays(xg);

  /*
   * Set up the widgets and add the callbacks.
  */
  init_help(xg);
  make_widgets(xg, parent);

  init_options(xg);
  build_options_menu(xg);

  make_arrows(xg);

  init_dotplot_vars(xg);
  make_dotplot(xg);

  init_xyplot_vars(xg);
  make_xyplot(xg);

  alloc_rotate_arrays(xg);
  init_rotate_vars(xg);
  make_rotate(xg);

  alloc_brush_arrays(xg);
  init_brush_vars(xg);
  make_brush(xg);

  init_scale_vars(xg);
  make_scaling(xg);
  make_stdview(xg);

  init_identify_vars(xg);
  make_identify(xg);

  if (xg->ncols > 2)
    alloc_tour(xg);
  if (xg->ncols > 2)
    init_tour(xg, 1);   /* Some lines here have to precede sphered_data_fn() */
  make_tour(xg);

  alloc_line_edit_arrays(xg);
  init_line_edit_vars(xg);
  make_line_editor(xg);

  make_plotwindow_mouse_labels(xg);
  /* This must be made late, after at least one mouse label */
  make_plot_window(xg);

  alloc_transform_types(xg);
  init_transform_types(xg);
  make_varpanel(xg);
  /*
   * Put a NULL at the end of the help tables.
  */
  add_pb_help(&xg->nhelpids.pb, (Widget) NULL, "");
  add_menupb_help(&xg->nhelpids.menupb, (Widget) NULL, "");
  add_sbar_help(&xg->nhelpids.sbar, (Widget) NULL, "");

  XtRealizeWidget(xg->shell);

  if (firsttime)
  {
    /*
     * Get the colors of the plot window and the tour_pp plotting window.
     * These are needed for setting the GC colors.
    */
    XtVaGetValues(xg->pp_plot_wksp,
      XtNforeground, (Pixel) &tour_pp_colors.fg,
      XtNbackground, (Pixel) &tour_pp_colors.bg,
      XtNborderColor, (Pixel) &tour_pp_colors.border,
      NULL);
    init_tour_pp_GCs(xg);

    XtVaGetValues(xg->workspace,
      XtNforeground, (Pixel) &plotcolors.fg,
      XtNbackground, (Pixel) &plotcolors.bg,
      XtNborderColor, (Pixel) &plotcolors.border,
      NULL);
    init_GCs(xg);


    /*
     * Define cursors, set their colors.
    */
    default_cursor = XCreateFontCursor(display, XC_center_ptr);
    scale_cursor = XCreateFontCursor(display, XC_fleur);
    spin_cursor = XCreateFontCursor(display, XC_hand2);
    /* used in identify and projection pursuit */
    crosshair_cursor = XCreateFontCursor(display, XC_tcross);

    cmap = DefaultColormap(display, DefaultScreen(display));
    if (!mono)
    {
      XColor exact;
      if (XParseColor(display, cmap, appdata.pointerColor, &exact))
      {
        if (XAllocColor(display, cmap, &exact))
          cfore.pixel = exact.pixel;
        else
          cfore.pixel = plotcolors.fg ;
      }
      /*
       * Test to see whether we've made the pointer invisible,
       * and if so, assume that to be a mistake.  Make the
       * pointer the same color as the plotting foreground
       * color.
      */
      if (cfore.pixel == plotcolors.bg)
        cfore.pixel = plotcolors.fg;
    }
    else
      cfore.pixel = plotcolors.fg;

    cback.pixel = plotcolors.bg ;
    if (!mono)
    {
      XQueryColor(display, cmap, &cfore);
      XQueryColor(display, cmap, &cback);
    }
    XRecolorCursor(display, default_cursor, &cfore, &cback);
    XRecolorCursor(display, spin_cursor, &cfore, &cback);
    XRecolorCursor(display, scale_cursor, &cfore, &cback);
    XRecolorCursor(display, crosshair_cursor, &cfore, &cback);

    menu_mark = XCreateBitmapFromData(display,
      RootWindowOfScreen(XtScreen(xg->shell)),
      target_bits, target_width, target_height);
    /*
     * Find out whether the foreground color of the plot_window
     * is included in the brushing colors.  If it is not, then
     * append it to the list of colors and add it to the color
     * brushing menu.
    */
    for (j=0; j<ncolors; j++)
    {
      if (color_nums[j] == plotcolors.fg)
      {
        wkfg = 1;
        break;
      }
    }
    if (!wkfg)
      reinit_brush_colors(xg);
    firsttime = 0;
  }

  /*
   * Create the background pixmap and clear it.
  */
  XtVaGetValues(xg->workspace,
    XtNwidth, &xg->plotsize.width,
    XtNheight, &xg->plotsize.height, NULL);

  xg->plot_window = XtWindow(xg->workspace);
  xg->pixmap0 = XCreatePixmap(display, xg->plot_window,
    xg->plotsize.width,
    xg->plotsize.height,
    depth);
  XFillRectangle(display, xg->pixmap0, clear_GC,
    0, 0, xg->plotsize.width, xg->plotsize.height);

/*
 * These are the vars which depend on the plot window having
 * been realized: size, color.
*/
  init_plotwindow_vars(xg, 1);
  /* Moving here from init_vars because it depends on minxy */
  set_shift_wrld0(xg); /* depends on xg->minxy */

  copy_raw_to_tform(xg);
  if (xg->ncols_used > 2)
    sphered_data_fn(xg);
  update_lims(xg);
  update_world(xg);

  /*
   * The line color arrays are set up in allocate_line_edit_arrays(),
   * after which we can try to read in the line colors file.
  */
  if (xg->nlinks > 0)
    if (read_line_colors(data_in, False, xg) == 0)
      init_line_colors(xg);

  /*
   * Mark the default menu selections.
  */
  init_brush_menus();
  init_stdview_menu(xg);
  init_tour_interp_menu(xg);
  init_tour_pp_menu(xg);
  /*
   * Scale data to planar and then to screen coordinates.
  */
  world_to_plane(xg);
  plane_to_screen(xg);
  /*
   * Initialize axes and ticks.
  */
  alloc_axis_arrays(xg);
  init_axes(xg, 1);
  init_ticks(&xg->xy_vars, xg);

  if (parent)
  {
    XtPopup(xg->shell, XtGrabNone);
  }
  XDefineCursor(display, XtWindow(xg->form0), default_cursor);
  xg->is_realized = True;

/*
 * This needs to be done after the brush menus are initialized
 * and the brushing arrays are allocated.
*/
  (void) read_brush_indices(data_in, xg);

  /*
   * First scatter plot.
  */
  if (xg->delete_erased_pts)
    reset_rows_in_plot(xg, True);
  plot_once(xg);
  refresh_vlab(xg->xy_vars.x, xg);
  refresh_vlab(xg->xy_vars.y, xg);

  /* initialize a seed for drand48() */
  srand48((long) time((long *) 0));

  return(1);
}
