/************************************************************
 *                                                          *
 *  Permission is hereby granted  to  any  individual   or  *
 *  institution   for  use,  copying, or redistribution of  *
 *  the xgobi code and associated documentation,  provided  *
 *  that   such  code  and documentation are not sold  for  *
 *  profit and the  following copyright notice is retained  *
 *  in the code and documentation:                          *
 *     Copyright (c) 1990,1991,1992,1993 Bellcore           *
 *                                                          *
 *  We welcome your questions and comments, and request     *
 *  that you share any modifications with us.               *
 *                                                          *
 *    Deborah F. Swayne            Dianne Cook              *
 *     dfs@bellcore.com      dcook@stat.rutgers.edu         *
 *      (201) 829-4263                                      *
 *                                                          *
 ************************************************************/

#define XGOBIINTERN

#include <sys/types.h>
#include <stdio.h>
#include "xincludes.h"
#include "xgobitypes.h"
#include "xgobivars.h"
#include <X11/keysym.h>

xgobidata xgobi;
#include "xgobitop.h"

Boolean
RunWorkProcs()
{
  Boolean RunWorkProc();

  if (RunWorkProc(&xgobi))
    return FALSE;
  else
    return TRUE;
}

int
main(argc, argv)
  int argc;
  char *argv[];
{
  char data_in[100];
  char name[50];
  int i;
  int atoi();
  int make_xgobi();
  void find_mono();
/*
  int fprintf();  The sgi doesn't like this one.
  int fwrite();
*/

/*
 * Find out whether the -name argument is being used.
*/
  name[0] = '\0';
  for (i=0; i<argc; i++)
  {
    if (strcmp(argv[i], "-name") == 0)
    {
      strcpy(name, argv[i+1]);
      break;
    }
  }
  /*printf("%s\n", name);*/

  xgobi.shell = XtAppInitialize(&app_con, "XGobi", NULL, 0,
    &argc, argv, fallback_resources, NULL, 0);
  display = XtDisplay(xgobi.shell);
  XtAppAddActions(app_con, added_actions, XtNumber(added_actions));
  find_mono(&mono);

  xgobi.std_type = 0;
  xgobi.std_width = 2.0;
  Sprocess = Snetwork = 0;
/*
 * Parse command line
*/
  for( ; argc>1 && argv[1][0]=='-'; argc--,argv++)
  {
    /*
     * -s:  xgobi initiated from inside S
    */
    if (strcmp(argv[1], "-s") == 0)
    {
      Sprocess = 1;
    }
    /*
     * -std:  look for one of mmx (default), msd, or mmd
    */
    else if (strcmp(argv[1], "-std") == 0)
    {
      if (strcmp(argv[2], "mmx") == 0)
      {
        xgobi.std_type = 0;
        argv++; argc--;
      }
      else if (strcmp(argv[2], "msd") == 0)
      {
        xgobi.std_type = 1;
        argv++; argc--;
      }
      else if (strcmp(argv[2], "mmd") == 0)
      {
        xgobi.std_type = 2;
        argv++; argc--;
      }
    }
    /*
     * -dev:  look for a float.  Only meaningful in msd or mmd cases.
    */
    else if (strcmp(argv[1], "-dev") == 0)
    {
      xgobi.std_width = atof(argv[2]);
      argv++; argc--;
    }
  }
  argc--;
  argv++;
/*
 * Test the values
*/
  if (xgobi.std_type != 0 && xgobi.std_type != 1 && xgobi.std_type != 2)
  {
    (void) fprintf(stderr,
      "std: Standardization type not valid; aborting.\n");
  }
  if (xgobi.std_width <= 0 || xgobi.std_width >= 100.)
  {
    (void) fprintf(stderr,
      "dev: Deviation value not valid; aborting.\n");
    return(0);
  }

  if (Sprocess)
  {
    if (argc<3)
    {
      (void) fprintf(stderr,
        "Usage: xgobi [-s nrows ncols path] filename\n");
      return(0);
    }
    else
    {
      xgobi.nrows = atoi(*argv); argv++;
      xgobi.ncols_used = atoi(*argv); argv++;
      xgobi.ncols = xgobi.ncols_used + 1;
      (void) strcpy(Spath0, *argv); argv++;
      (void) strcat(Spath0, "/");
      (void) strcpy(data_in, *argv);
    }
  }

  else
  {
    if (!argc)
      (void) strcpy(data_in, "stdin");
    else
      (void) strcpy(data_in, *argv);
  }

/*
 * make_xgobi( dataflag,
 *   data_name,
 *   datap, nr, nc,
 *      collab, rowlab,
 *      nlinks, connecting_lines,
 *   &xgobi,
 *   parent, name)
*/

  /*
   * In the local version, send mail when
   * xgobi is initiated.
  system("/usr/ucb/mail -s 'Starting XGobi' dfs@bellcore.com <<.\n.");
     But not in my own hacking version!
  */

  if (make_xgobi(False,
    data_in,
    (float **) NULL, (int) NULL, (int) NULL,
    (char **) NULL, (char **) NULL,
    (int) NULL, (connect_lines *) NULL,
    &xgobi,
    (Widget) NULL, name) == 0)
  {
    return(0);
  }
  else
    XGobiMainLoop(&xgobi);

  return(1);
}
