/************************************************************
 *                                                          *
 *  Permission is hereby granted  to  any  individual   or  *
 *  institution   for  use,  copying, or redistribution of  *
 *  the xgobi code and associated documentation,  provided  *
 *  that   such  code  and documentation are not sold  for  *
 *  profit and the  following copyright notice is retained  *
 *  in the code and documentation:                          *
 *     Copyright (c) 1990,1991,1992,1993 Bellcore           *
 *                                                          *
 *  We welcome your questions and comments, and request     *
 *  that you share any modifications with us.               *
 *                                                          *
 *  Deborah F. Swayne      Dianne Cook                      *
 *   dfs@bellcore.com    dcook@stat.rutgers.edu             *
 *    (201) 829-4263                                        *
 *                                                          *
 ************************************************************/

#include <stdio.h>
#include "xincludes.h"
#include "xgobitypes.h"
#include "xgobivars.h"

/* Functions used in this file */
XtConvertSelectionProc pack_rowsinplot_data();
XtSelectionDoneProc pack_brush_done();
XtLoseSelectionProc pack_brush_lose();
void set_mono();
Widget CreateToggle(), CreateCommand();
void reset_rows_in_plot();
void copy_brushinfo_to_senddata();
void announce_rows_in_plot();
void plot_once();
void show_message();
void assign_points_to_bins();
/* */

static Widget spopup, sframe, sform;
static Widget block_cmd, from_label, to_label, from_text, to_text;
static Widget rescale_cmd;
static Boolean rescale = False;
/* */
static char *from_str, *to_str;
static Widget sample_cmd, sample_label, sample_text;
static char *sample_str;
static Widget everyn_cmd, everyn_label, everyn_text;
static Widget everyn_init_label, everyn_init_text;
static char *everyn_str, *everyn_init_str;
static Widget apply, restore, close;
static Boolean block = False, sample = True, everyn = False;

/* ARGSUSED */
XtCallbackProc
rescale_cback(w, xgobi, callback_data)
  Widget w;
  XtPointer *xgobi;
  caddr_t callback_data;
{
  rescale = !rescale;
}

/* ARGSUSED */
XtCallbackProc
subset_cback(w, xgobi, callback_data)
  Widget w;
  XtPointer *xgobi;
  caddr_t callback_data;
{
  int i, k;
  xgobidata *xg = (xgobidata *) xgobi;
  int doneit = 0;
  int atoi();

  if (block)
  {
    int from_n, to_n;

    XtVaGetValues(from_text, XtNstring, (String) &from_str, NULL);
    XtVaGetValues(to_text, XtNstring, (String) &to_str, NULL);

    from_n = atoi(from_str);
    to_n = atoi(to_str);

    if (to_n > 0 && from_n <= xg->nrows && to_n > from_n)
    {

      for (i=0; i<xg->nrows; i++)
        xg->erased[i] = 1;

      for (i=(from_n - 1), k=0; i<to_n; i++, k++)
      {
        xg->erased[i] = 0;
        xg->rows_in_plot[k] = i;
      }
      xg->nrows_in_plot = to_n - from_n + 1;

      xg->delete_erased_pts = True;
      doneit = 1;
    }
    else
    {
      char message[200];
      sprintf(message, "The limits aren't correctly specified.\n");
      show_message(message, xg);
    }
  }
  else if (sample)
  /*
   * This algorithm taken from Knuth, Seminumerical Algorithms;
   * Vol 2 of his series.
  */
  {
    int t, sample_n, m;
    float rrand;
    double drand48();

    XtVaGetValues(sample_text, XtNstring, (String) &sample_str, NULL);

    sample_n = atoi(sample_str);
    if (sample_n > 0 && sample_n < xg->nrows)
    {
      for (i=0; i<xg->nrows; i++)
        xg->erased[i] = 1;

      for (t=0, m=0; t<xg->nrows, m<sample_n; t++)
      {
        rrand = (float) drand48();    /* rrand on [0.0,1.0] */

        if ( ((xg->nrows - t) * rrand) < (sample_n - m) )
        {
          xg->erased[t] = 0;
          xg->rows_in_plot[m++] = t;
        }
      }
      xg->nrows_in_plot = sample_n;
      doneit = 1;
    }
  }
  else if (everyn)
  {
    int everyn_n, everyn_init;

    XtVaGetValues(everyn_text, XtNstring, (String) &everyn_str, NULL);
    everyn_n = atoi(everyn_str);

    XtVaGetValues(everyn_init_text, XtNstring, (String) &everyn_init_str, NULL);
    everyn_init = atoi(everyn_init_str);

    if (everyn_n > 0 && everyn_n < xg->nrows &&
      everyn_init > 0 && everyn_init < (xg->nrows-1) )
    {
      for (i=0; i<xg->nrows; i++)
        xg->erased[i] = 1;

      for (i=(everyn_init-1), k=0; i<xg->nrows; i=i+everyn_n, k++)
      {
        xg->erased[i] = 0;
        xg->rows_in_plot[k] = i;
      }
      xg->nrows_in_plot = k+1;
      doneit = 1;
    }
    else
    {
      char message[200];
      sprintf(message, "Interval 'n' not correctly specified.\n");
      show_message(message, xg);
    }
  }

  if (doneit)
  {
    reset_rows_in_plot(xg, rescale);
    copy_brushinfo_to_senddata(xg);
    if (xg->linked_brushing)
    {
      XtOwnSelection( (Widget) xg->workspace,
        (Atom) XG_ROWSINPLOT,
        (Time) CurrentTime, /* doesn't work with XtLastTimeStamp...? */
        /*(Time) XtLastTimestampProcessed(display),*/
        (XtConvertSelectionProc) pack_rowsinplot_data,
        (XtLoseSelectionProc) pack_brush_lose ,
        (XtSelectionDoneProc) pack_brush_done );
      announce_rows_in_plot(xg);
    }
    assign_points_to_bins(xg);
    plot_once(xg);
  }
}

/* ARGSUSED */
XtCallbackProc
restore_cback(w, xgobi, callback_data)
  Widget w;
  XtPointer *xgobi;
  caddr_t callback_data;
{
  int i;
  xgobidata *xg = (xgobidata *) xgobi;

  for (i=0; i<xg->nrows; i++)
  {
    xg->erased[i] = 0;
    xg->rows_in_plot[i] = i;
  }
  xg->nrows_in_plot = xg->nrows;

  reset_rows_in_plot(xg, True);
  copy_brushinfo_to_senddata(xg);
  if (xg->linked_brushing)
  {
    XtOwnSelection( (Widget) xg->workspace,
      (Atom) XG_ROWSINPLOT,
      (Time) CurrentTime, /* doesn't work with XtLastTimeStamp...? */
      /*(Time) XtLastTimestampProcessed(display),*/
      (XtConvertSelectionProc) pack_rowsinplot_data,
      (XtLoseSelectionProc) pack_brush_lose ,
      (XtSelectionDoneProc) pack_brush_done );
    announce_rows_in_plot(xg);
  }
  assign_points_to_bins(xg);
  plot_once(xg);
}

/* ARGSUSED */
XtCallbackProc
close_cback(w, xgobi, callback_data)
  Widget w;
  XtPointer *xgobi;
  caddr_t callback_data;
{
  XtPopdown(spopup);
}

/* ARGSUSED */
XtCallbackProc
block_cback(w, xgobi, callback_data)
  Widget w;
  XtPointer *xgobi;
  caddr_t callback_data;
{
  block = !block;
}

/* ARGSUSED */
XtCallbackProc
sample_cback(w, xgobi, callback_data)
  Widget w;
  XtPointer *xgobi;
  caddr_t callback_data;
{
  sample = !sample;
}

/* ARGSUSED */
XtCallbackProc
everyn_cback(w, xgobi, callback_data)
  Widget w;
  XtPointer *xgobi;
  caddr_t callback_data;
{
  everyn = !everyn;
}

/* ARGSUSED */
XtCallbackProc
subset_panel_cback(w, xgobi, callback_data)
  Widget w;
  XtPointer *xgobi;
  caddr_t callback_data;
{
  Dimension width, height;
  Position x, y;
  xgobidata *xg = (xgobidata *) xgobi;
  static int initd = 0;

  if (!initd)
  {
    from_str = (char *) XtMalloc((Cardinal) 20 * sizeof(char));
    to_str = (char *) XtMalloc((Cardinal) 20 * sizeof(char));
    everyn_str = (char *) XtMalloc((Cardinal) 20 * sizeof(char));
    everyn_init_str = (char *) XtMalloc((Cardinal) 20 * sizeof(char));
    sample_str = (char *) XtMalloc((Cardinal) 20 * sizeof(char));
    (void) sprintf(from_str, "1");
    (void) sprintf(to_str, "%d", xg->nrows);
    (void) sprintf(everyn_str, "1");
    (void) sprintf(everyn_init_str, "1");
    (void) sprintf(sample_str, "%d", xg->nrows);
    /* initiate a seed for drand48() */
    /*srand48((long) time((long *) 0));*/

    XtVaGetValues(w,
      XtNwidth, &width,
      XtNheight, &height, NULL);
    XtTranslateCoords(w,
      (Position) (width/2), (Position) (height/2), &x, &y);
    /*
     * Create the popup to solicit printing arguments.
    */
    spopup = XtVaCreatePopupShell("Subset0",
      /*transientShellWidgetClass, w,*/
      topLevelShellWidgetClass, w,
      XtNx, (Position) x,
      XtNy, (Position) y,
      XtNinput, (Boolean) True,
      XtNallowShellResize, (Boolean) True,
      XtNtitle, (String) "Subset data",
      NULL);
    if (mono) set_mono(spopup);

    /*
     * Create a paned widget so the 'Click here ...'
     * can be all across the bottom.
    */
    sframe = XtVaCreateManagedWidget("Form",
      panedWidgetClass, spopup,
      XtNorientation, (XtOrientation) XtorientVertical,
      NULL);
    /*
     * Create the form widget.
    */
    sform = XtVaCreateManagedWidget("Subset",
      formWidgetClass, sframe,
      NULL);
    if (mono) set_mono(sform);

    block_cmd = (Widget) CreateToggle(xg, "Consec. block",
      True, (Widget) NULL, (Widget) NULL, (Widget) NULL,
      block, ONE_OF_MANY, sform, "Subset");
    XtManageChild(block_cmd);
    XtAddCallback(block_cmd, XtNcallback,
      (XtCallbackProc) block_cback, (XtPointer) xg);

    from_label = XtVaCreateManagedWidget("Subset",
      labelWidgetClass, sform,
      XtNfromHoriz, (Widget) block_cmd,
      XtNlabel, (String) "From row ",
      NULL);
    if (mono) set_mono(from_label);

    from_text = XtVaCreateManagedWidget("Subset",
      asciiTextWidgetClass, sform,
      XtNfromHoriz, (Widget) from_label,
      XtNleft, (XtEdgeType) XtChainLeft,
      XtNright, (XtEdgeType) XtChainRight,
      XtNtop, (XtEdgeType) XtChainTop,
      XtNbottom, (XtEdgeType) XtChainTop,
      XtNresizable, (Boolean) True,
      XtNeditType, (int) XawtextEdit,
      XtNresize, (XawTextResizeMode) XawtextResizeWidth,
      XtNstring, (String) from_str,
      NULL);
    if (mono) set_mono(from_text);

    to_label = XtVaCreateManagedWidget("Subset",
      labelWidgetClass, sform,
      XtNfromHoriz, (Widget) from_text,
      XtNlabel, (String) "to row ",
      NULL);
    if (mono) set_mono(to_label);

    to_text = XtVaCreateManagedWidget("Subset",
      asciiTextWidgetClass, sform,
      XtNfromHoriz, (Widget) to_label,
      XtNleft, (XtEdgeType) XtChainLeft,
      XtNright, (XtEdgeType) XtChainRight,
      XtNtop, (XtEdgeType) XtChainTop,
      XtNbottom, (XtEdgeType) XtChainTop,
      XtNresizable, (Boolean) True,
      XtNeditType, (int) XawtextEdit,
      XtNresize, (XawTextResizeMode) XawtextResizeWidth,
      XtNstring, (String) to_str,
      NULL);
    if (mono) set_mono(to_text);

    sample_cmd = (Widget) CreateToggle(xg, "Random sample w/o repl.",
      True, (Widget) NULL, (Widget) block_cmd, (Widget) block_cmd,
      sample, ONE_OF_MANY, sform, "Subset");
    XtManageChild(sample_cmd);
    XtAddCallback(sample_cmd, XtNcallback,
      (XtCallbackProc) sample_cback, (XtPointer) xg);

    sample_label = XtVaCreateManagedWidget("Subset",
      labelWidgetClass, sform,
      XtNfromHoriz, (Widget) sample_cmd,
      XtNfromVert, (Widget) from_label,
      XtNlabel, (String) "Sample of size",
      NULL);
    if (mono) set_mono(sample_label);

    sample_text = XtVaCreateManagedWidget("Subset",
      asciiTextWidgetClass, sform,
      XtNfromHoriz, (Widget) sample_label,
      XtNfromVert, (Widget) from_label,
      XtNleft, (XtEdgeType) XtChainLeft,
      XtNright, (XtEdgeType) XtChainRight,
      XtNtop, (XtEdgeType) XtChainTop,
      XtNbottom, (XtEdgeType) XtChainTop,
      XtNresizable, (Boolean) True,
      XtNeditType, (int) XawtextEdit,
      XtNresize, (XawTextResizeMode) XawtextResizeWidth,
      XtNstring, (String) sample_str,
      NULL);
    if (mono) set_mono(sample_text);

    everyn_cmd = (Widget) CreateToggle(xg, "Every nth row",
      True, (Widget) NULL, (Widget) sample_cmd, (Widget) block_cmd,
      everyn, ONE_OF_MANY, sform, "Subset");
    XtManageChild(everyn_cmd);
    XtAddCallback(everyn_cmd, XtNcallback,
      (XtCallbackProc) everyn_cback, (XtPointer) xg);

    everyn_label = XtVaCreateManagedWidget("Subset",
      labelWidgetClass, sform,
      XtNfromHoriz, (Widget) everyn_cmd,
      XtNfromVert, (Widget) sample_label,
      XtNlabel, (String) " n ",
      NULL);
    if (mono) set_mono(everyn_label);

    everyn_text = XtVaCreateManagedWidget("Subset",
      asciiTextWidgetClass, sform,
      XtNfromHoriz, (Widget) everyn_label,
      XtNfromVert, (Widget) sample_label,
      XtNleft, (XtEdgeType) XtChainLeft,
      XtNright, (XtEdgeType) XtChainRight,
      XtNtop, (XtEdgeType) XtChainTop,
      XtNbottom, (XtEdgeType) XtChainTop,
      XtNresizable, (Boolean) True,
      XtNeditType, (int) XawtextEdit,
      XtNresize, (XawTextResizeMode) XawtextResizeWidth,
      XtNstring, (String) everyn_str,
      NULL);
    if (mono) set_mono(everyn_text);

    everyn_init_label = XtVaCreateManagedWidget("Subset",
      labelWidgetClass, sform,
      XtNfromHoriz, (Widget) everyn_text,
      XtNfromVert, (Widget) sample_label,
      XtNlabel, (String) "starting with",
      NULL);
    if (mono) set_mono(everyn_init_label);

    everyn_init_text = XtVaCreateManagedWidget("Subset",
      asciiTextWidgetClass, sform,
      XtNfromHoriz, (Widget) everyn_init_label,
      XtNfromVert, (Widget) sample_label,
      XtNleft, (XtEdgeType) XtChainLeft,
      XtNright, (XtEdgeType) XtChainRight,
      XtNtop, (XtEdgeType) XtChainTop,
      XtNbottom, (XtEdgeType) XtChainTop,
      XtNresizable, (Boolean) True,
      XtNeditType, (int) XawtextEdit,
      XtNresize, (XawTextResizeMode) XawtextResizeWidth,
      XtNstring, (String) everyn_init_str,
      NULL);
    if (mono) set_mono(everyn_init_text);

    rescale_cmd = (Widget) CreateToggle(xg, "Rescale when subsetting",
      True, (Widget) NULL, (Widget) everyn_cmd, (Widget) NULL,
      rescale, ANY_OF_MANY, sform, "SubsetRescale");
    XtManageChild(rescale_cmd);
    XtAddCallback(rescale_cmd, XtNcallback,
      (XtCallbackProc) rescale_cback, (XtPointer) xg);

    apply = (Widget) CreateCommand(xg, "Subset the data",
      1, (Widget) NULL, (Widget) rescale_cmd,
      sform, "Subset");
    XtManageChild(apply);
    XtAddCallback(apply, XtNcallback,
      (XtCallbackProc) subset_cback, (XtPointer) xg);

    restore = (Widget) CreateCommand(xg, "Include all data",
      1, (Widget) apply, (Widget) rescale_cmd,
      sform, "Subset");
    XtManageChild(restore);
    XtAddCallback(restore, XtNcallback,
      (XtCallbackProc) restore_cback, (XtPointer) xg);

    close = XtVaCreateManagedWidget("Close",
      commandWidgetClass, sframe,
      XtNshowGrip, (Boolean) False,
      XtNskipAdjust, (Boolean) True,
      XtNlabel, (String) "Click here to dismiss",
      NULL);
    if (mono) set_mono(close);
    XtAddCallback(close, XtNcallback,
      (XtCallbackProc) close_cback, (XtPointer) xg);

    initd = 1;
  }

  XtPopup(spopup, (XtGrabKind) XtGrabNone);
  XRaiseWindow(display, XtWindow(spopup));
}
