/************************************************************
 *                                                          *
 *  Permission is hereby granted  to  any  individual   or  *
 *  institution   for  use,  copying, or redistribution of  *
 *  the xgobi code and associated documentation,  provided  *
 *  that   such  code  and documentation are not sold  for  *
 *  profit and the  following copyright notice is retained  *
 *  in the code and documentation:                          *
 *     Copyright (c) 1990,1991,1992,1993 Bellcore           *
 *                                                          *
 *  We welcome your questions and comments, and request     *
 *  that you share any modifications with us.               *
 *                                                          *
 *    Deborah F. Swayne            Dianne Cook              *
 *     dfs@@bellcore.com      dcook@@stat.rutgers.edu       *
 *      (201) 829-4263                                      *
 *                                                          *
 ************************************************************/

#include <stdio.h>
#include "xincludes.h"
#include "xgobitypes.h"
#include "xgobivars.h"

/* Functions used in this file */
Boolean RunWorkProcs();
Widget CreateCommand(), CreateToggle();
XtConvertSelectionProc pack_ids();
XtEventHandler set_sticky();
float NiceValue();
int set_deci();
void adjust_limits();
void set_mono();
void number_length();
void plot_once();
void quickplot_once();
void set_fac_and_offsets();
/* */

static Widget identify_panel, rm_sticky_cmd;
/* To plot the case profile, linked to identification */
static Widget cprof_plot_cmd;
static Widget cprof_plot_shell, cprof_form, cprof_panel, cprof_plot_wksp;
static Widget cprof_cmd[2];
static Drawable cprof_plot_window, cprof_pixmap;
#define LBMARGIN 50  /* left margin */
#define RTMARGIN 20  /* right and top margins -- and bottom? */
static Dimension cprof_height, cprof_width;
static Dimension left_margin = LBMARGIN;
/*
 * By making these first three into arrays, I can plot points
 * and lines for nearest_point plus the sticky guys.
*/
static fcoords *cprof_tform;
static lcoords *cprof_plane;
static icoords *cprof_screen;

static XPoint *points;
static XSegment *segs;
static XRectangle *open_rectangles;
static XRectangle *filled_rectangles;
static XArc *open_circles;
static XArc *filled_circles;

static XSegment *connsegs;

static int *cprof_selectedvars;
static int cprof_nselectedvars;
static lcoords cprof_is;
static int cprof_midx;
static int cprof_midy;
static long cprof_shift_wrld;
static lims cprof_xlim;
static lims cprof_ylim;
static lims cprof_xnicelim;
static lims cprof_ynicelim;
static icoords cprof_screen_axes[3];
static int cprof_xdeci;
static int cprof_ydeci;
static float cprof_xtickdelta;
static float cprof_ytickdelta;
static tickinfo cprof_ticks;
static XSegment cprof_xtick_segs[50];
static XSegment cprof_ytick_segs[50];
/*
typedef struct {
  int nticks[NCOLS];   [0] for x; [1] for y;
  float xticks[NTICKS];
  float yticks[NTICKS];
  lcoords plane[NTICKS];
  icoords screen[NTICKS];
} tickinfo;
*/
static Boolean cprof_showlines = True;
static Boolean cprof_showpoints = True;

void
init_identify_vars(xg)
  xgobidata *xg;
{
  xg->is_cprof_plotting = False;
  xg->is_identify = False;
  xg->nearest_point = -1;
  xg->nsticky_ids = 0;
}

/*
 * Code for ticks and axes on case profile plotting window.
*/

void
make_cprof_screen_axes()
/*
 * Since there's no shifting or scaling of this plot, just
 * force the axes to be stable.
*/
{
/*     .(axes[0].x, axes[0].y
 *     |
 *     |
 *     |
 *     |
 *     |
 *     |
 *     .----------------. (axes[2].x, axes[2].y)
 * (axes[1].x, axes[1].y)
*/

/*
 * This value LBMARGIN is bogus -- I should be finding
 * out the longest possible tick value and using XTextWidth()
*/

  cprof_screen_axes[0].x =
    cprof_screen_axes[1].x = left_margin ;
  cprof_screen_axes[2].x = cprof_width - RTMARGIN ;

  cprof_screen_axes[0].y = RTMARGIN ;
  cprof_screen_axes[1].y =
    cprof_screen_axes[2].y = cprof_height - LBMARGIN ;
}

void
generate_cprof_xticks()
{
/*
 * nticks: number of ticks used by each column
 * cprof_xtickdelta: increment between subsequent ticks
 * This routine will take the ticks up to their planar
 * values -- that is, the locations of the x ticks in
 * plane coordinates.
*/
  int j;
  float tmpf, precis, nicearg;
/*
 * Drawn from SetNiceRange()
*/
  cprof_ticks.nticks[0] = 6;

  nicearg = (cprof_xlim.max - cprof_xlim.min) /
            (float) (cprof_ticks.nticks[0] - 1) ;
  cprof_xtickdelta = (float) NiceValue((float) nicearg );
  /* sometimes trouble occurs here, for no good reason */

  cprof_xnicelim.min = (float)
    floor((double) (cprof_xlim.min / cprof_xtickdelta)) *
    cprof_xtickdelta;
  cprof_xnicelim.max = (float)
    ceil((double) (cprof_xlim.max / cprof_xtickdelta)) *
    cprof_xtickdelta;

  /* add .01 for rounding */
  cprof_ticks.nticks[0] = 1 +
    (.01 + (cprof_xnicelim.max - cprof_xnicelim.min) / cprof_xtickdelta);

  cprof_xdeci = set_deci(cprof_xtickdelta);

/*
 * Drawn from generate_ticks()
*/
  cprof_ticks.xticks[0] = cprof_xnicelim.min;
  j = 1;
  while ( cprof_ticks.xticks[j-1] + cprof_xtickdelta <=
          cprof_xlim.max + cprof_xtickdelta/2 )
  {
    cprof_ticks.xticks[j] = cprof_ticks.xticks[j-1] + cprof_xtickdelta ;
    if (j++ == NTICKS-1)
    {
      (void) fprintf(stderr, "warning: (generate_ticks) too many x ticks\n");
      return;
    }
  }
  cprof_ticks.nticks[0] = j;

/*
 * Drawn from scale_ticks()
*/
  precis = PRECISION1;

  for (j=0; j<cprof_ticks.nticks[0]; j++)
  {
    tmpf = -1.0 + 2.0*(cprof_ticks.xticks[j] - cprof_xlim.min)
        /(cprof_xlim.max - cprof_xlim.min);
    cprof_ticks.plane[j].x = (long) (precis * tmpf);
  }

}

void
generate_cprof_yticks()
{
/*
 * nticks: number of ticks used by each column
 * cprof_ytickdelta: increment between subsequent ticks
 * This routine will take the ticks up to their planar
 * values -- that is, the locations of the y ticks in
 * plane coordinates.
*/
  int j;
  float tmpf, precis, nicearg;

/*
 * Drawn from SetNiceRange()
*/
  cprof_ticks.nticks[1] = 4;

  nicearg = (cprof_ylim.max - cprof_ylim.min) /
            (float) (cprof_ticks.nticks[1] - 1) ;
  cprof_ytickdelta = NiceValue( nicearg );
  /* sometimes trouble occurs here, for no good reason */

  cprof_ynicelim.min = (float)
    floor((double) (cprof_ylim.min / cprof_ytickdelta)) *
    cprof_ytickdelta;
  cprof_ynicelim.max = (float)
    ceil((double) (cprof_ylim.max / cprof_ytickdelta)) *
    cprof_ytickdelta;

  /* add .01 for rounding */
  cprof_ticks.nticks[1] = 1 +
    (.01 + (cprof_ynicelim.max - cprof_ynicelim.min) / cprof_ytickdelta);

  cprof_ydeci = set_deci(cprof_ytickdelta);

/*
 * Drawn from generate_ticks()
*/
  cprof_ticks.yticks[1] = cprof_ynicelim.min;
  j = 1;
  while (cprof_ticks.yticks[j-1] + cprof_ytickdelta <=
     cprof_ylim.max + cprof_ytickdelta/2 )
  {
    cprof_ticks.yticks[j] = cprof_ticks.yticks[j-1] + cprof_ytickdelta ;
    if (j++ == NTICKS-1)
    {
      (void) fprintf(stderr, "warning: (generate_ticks) too many y ticks\n");
      return;
    }
  }
  cprof_ticks.nticks[1] = j;
/*
 * Drawn from scale_ticks()
*/
  precis = PRECISION1;

  for (j=0; j<cprof_ticks.nticks[1]; j++)
  {
    tmpf = -1.0 + 2.0*(cprof_ticks.yticks[j] - cprof_ylim.min)
        /(cprof_ylim.max - cprof_ylim.min);
    cprof_ticks.plane[j].y = (long) (precis * tmpf);
  }

}

void
convert_cprof_ticks()
{
  int j;
  long nx, ny;

  for (j=0; j<cprof_ticks.nticks[0]; j++)
  {
    nx = (cprof_ticks.plane[j].x + cprof_shift_wrld) * cprof_is.x ;
    cprof_ticks.screen[j].x = (int) (nx >> EXP1) ;
    cprof_ticks.screen[j].x += cprof_midx ;
  }

  for (j=0; j<cprof_ticks.nticks[1]; j++)
  {
    /* Invert y here for ticks */
    ny = (cprof_height - (cprof_ticks.plane[j].y + cprof_shift_wrld)) *
      cprof_is.y ;
    cprof_ticks.screen[j].y = (int) (ny >> EXP1) ;
    cprof_ticks.screen[j].y += cprof_midy ;
  }
}

void
build_cprof_tick_segs()
{
  int j;

/* build x tick segments */
  for (j=0; j<cprof_ticks.nticks[0]; j++)
  {
    cprof_xtick_segs[j].x1 = cprof_ticks.screen[j].x;
    cprof_xtick_segs[j].x2 = cprof_ticks.screen[j].x;
    cprof_xtick_segs[j].y1 = cprof_screen_axes[1].y;
    cprof_xtick_segs[j].y2 = cprof_screen_axes[1].y + 5;
  }

/* build y tick segments */
  for (j=0; j<cprof_ticks.nticks[1]; j++)
  {
    cprof_ytick_segs[j].x1 = cprof_screen_axes[1].x;
    cprof_ytick_segs[j].x2 = cprof_screen_axes[1].x - 5;
    cprof_ytick_segs[j].y1 = cprof_ticks.screen[j].y;
    cprof_ytick_segs[j].y2 = cprof_ticks.screen[j].y;
  }
}

void
find_cprof_tick_label(deci, tickn, ticknos, str)
  int deci;
  int tickn;
  float *ticknos;
  char str[50];
{
  int length;
  float ftmp;
  int src, dest;

/*
 * deci:  number of decimal places in each tickdelta; one per column
 * ticknos: xticks or yticks, vector of ticklabel values
 * tickn: indec into ticknos array
*/
  if ((deci > 4 ||
       fabs((double) ticknos[tickn]) >= 10000.) &&
       ticknos[tickn] != 0.0)
  {
    number_length(ticknos[tickn], &length);
    ftmp = (float) ticknos[tickn]/pow((double)10, (double)(length-1));
    if (ftmp == (float)(int)ftmp)
      (void) sprintf (str, "%.0e", ticknos[tickn]);
    else
      (void) sprintf (str, "%.2e", ticknos[tickn]);
  }
  else
  {
    switch(deci)
    {
      case 0:
        (void) sprintf (str, "%3.0f", ticknos[tickn]);
        break;
      case 1:
        (void) sprintf (str, "%3.1f", ticknos[tickn]);
        break;
      case 2:
        (void) sprintf (str, "%3.2f", ticknos[tickn]);
        break;
      case 3:
        (void) sprintf (str, "%3.3f", ticknos[tickn]);
        break;
      case 4:
        (void) sprintf (str, "%3.4f", ticknos[tickn]);
        break;
    }
    /*
     * To get better placement, strip blanks.
    */
    for (src=0, dest=0; src<(strlen(str)+1); src++)
      if (str[src] != ' ')
        str[dest++] = str[src];
  }
}

static int
find_cprof_xtick_offset()
{
  int j, offset = 0;

  for (j=0; j<cprof_ticks.nticks[0]; j++)
  {
    if (cprof_screen_axes[1].x > cprof_ticks.screen[j].x )
      offset++;
    else
      break;
  }
  return(offset);
}

static int
find_cprof_xtick_toomany()
{
  int j, toomany = 0;

  for (j=(cprof_ticks.nticks[0]-1); j>=0; j--)
  {
    if (cprof_screen_axes[2].x < cprof_ticks.screen[j].x )
      toomany++;
    else
      break;
  }
  return(toomany);
}

static int
find_cprof_ytick_offset()
{
  int j, offset = 0;

  for (j=0; j<cprof_ticks.nticks[1]; j++)
  {
    if (cprof_screen_axes[1].y < cprof_ticks.screen[j].y )
      offset++;
    else
      break;
  }
  return(offset);
}

static int
find_cprof_ytick_toomany()
{
  int j, toomany = 0;

  for (j=(cprof_ticks.nticks[1]-1); j>=0; j--)
  {
    if (cprof_screen_axes[0].y > cprof_ticks.screen[j].y )
      toomany++;
    else
      break;
  }
  return(toomany);
}


void
add_cprof_axes()
{
  int j, offset, toomany, width;
  XPoint vpnts[2];
  char str[50];

  if (!mono)
    XSetForeground(display, copy_GC, plotcolors.fg);
/*
 * Draw x axis
*/
  for (j=0; j<2; j++)
  {
    vpnts[j].x = cprof_screen_axes[j+1].x;
    vpnts[j].y = cprof_screen_axes[j+1].y;
  }
  XDrawLines(display, cprof_pixmap, copy_GC, vpnts, 2, CoordModeOrigin);

/*
 * Draw y axis
*/
  for (j=0; j<2; j++)
  {
    vpnts[j].x = cprof_screen_axes[j].x;
    vpnts[j].y = cprof_screen_axes[j].y;
  }
  XDrawLines(display, cprof_pixmap, copy_GC, vpnts, 2, CoordModeOrigin);

/*
 * Draw x ticks
*/
  offset = find_cprof_xtick_offset();
  toomany = find_cprof_xtick_toomany();

  XDrawSegments(display, cprof_pixmap, copy_GC,
    cprof_xtick_segs + offset,
    cprof_ticks.nticks[0] - offset - toomany);
  /*
   * Simply skip the first tick if it's to the left of the Y axis
  */
  for (j=offset; j<(cprof_ticks.nticks[0]-toomany); j++)
  {
    find_cprof_tick_label(cprof_xdeci, j, cprof_ticks.xticks, str);

    width = XTextWidth(appdata.plotFont, str, strlen(str));
    XDrawImageString(display, cprof_pixmap, copy_GC,
      cprof_ticks.screen[j].x - width/2,
      cprof_screen_axes[1].y + FONTHEIGHT(appdata.plotFont)+7,
      str, strlen(str));
  }

/*
 * Draw y ticks
*/
  offset = find_cprof_ytick_offset();
  toomany = find_cprof_ytick_toomany();

  XDrawSegments(display, cprof_pixmap, copy_GC,
    cprof_ytick_segs + offset,
    cprof_ticks.nticks[1] - offset - toomany);
  /*
   * Simply skip the first tick if it's to the below the X axis
  */
  for (j=offset; j<(cprof_ticks.nticks[1] - toomany); j++)
  {
    find_cprof_tick_label(cprof_ydeci, j, cprof_ticks.yticks, str);
    width = XTextWidth(appdata.plotFont, str, strlen(str));
    XDrawImageString(display, cprof_pixmap, copy_GC,
      cprof_screen_axes[1].x-width-7,
      cprof_ticks.screen[j].y + 5,
      str, strlen(str));
  }
}

/*
 * End of ticks and axes section.
*/

static void
init_cprof_plane_x()
{
  int i;
  float min, max, rdiff, dtmp;
  float precis = PRECISION1;

/*
 * Create cprof_tform[].x
*/
  for (i=0; i<cprof_nselectedvars; i++)
    cprof_tform[i].x = (float) (cprof_selectedvars[i]+1) ;

/*
 * Scale cprof_tform[].x into cprof_plane[].x
*/
  min = max = cprof_tform[0].x ;
  for (i=1; i<cprof_nselectedvars; i++)
  {
    if (cprof_tform[i].x < min)
      min = cprof_tform[i].x ;
    else if (cprof_tform[i].x > max)
      max = cprof_tform[i].x ;
  }
  adjust_limits(&min, &max);
  rdiff = max - min;
  for (i=0; i<cprof_nselectedvars; i++)  /* the minimum number of these */
  {
    dtmp = -1.0 + 2.0*(cprof_tform[i].x - min)/rdiff;
    cprof_plane[i].x = (long) (precis * dtmp);
  }
/*
 * For use in constructing ticks and axes.
*/
  cprof_xlim.min = min;
  cprof_xlim.max = max;
}

void
cprof_tform_to_plane(xg)
  xgobidata *xg;
{
/*
 * Create cprof_tform[].y from tform_data[] and scale it
 * into cprof_plane[].y, the planar values.
*/
  int i, j, k, m;
  float ftmp;
  float precis = PRECISION1;
  float min, max;
  float rdiff;
  static int id = 0;

  if (xg->nearest_point != -1)
    id = xg->nearest_point;
/*
 * Create cprof_tform[].y.  The first cprof_nselectedvars positions
 * are occupied by nearest_point; the remainder by the values
 * corresponding to the sticky ids.
*/
  for (j=0; j<cprof_nselectedvars; j++)
  {
    i = cprof_selectedvars[j];
    cprof_tform[j].y = xg->tform_data[id][i] ;
  }

  for (i=0; i<xg->nsticky_ids; i++)
  {
    k = (i+1) * cprof_nselectedvars ;
    for (m=0; m<cprof_nselectedvars; m++)
    {
      j = cprof_selectedvars[m];
      cprof_tform[k + m].y = xg->tform_data[ xg->sticky_ids[i] ][j] ;
    }
  }

/*
 * Scale cprof_tform[].y into cprof_plane[].y
*/
  min = max = cprof_tform[0].y ;
  for (i=1; i<(xg->nsticky_ids+1)*cprof_nselectedvars; i++)
  {
    if (cprof_tform[i].y < min)
      min = cprof_tform[i].y ;
    else if (cprof_tform[i].y > max)
      max = cprof_tform[i].y ;
  }
  adjust_limits(&min, &max);
  rdiff = max - min;
  /*
   * Invert y here.
  */
  for (i=0; i<(xg->nsticky_ids+1)*cprof_nselectedvars; i++)
  {
    ftmp = -1.0 + 2.0*(cprof_tform[i].y - min)/rdiff;
    cprof_plane[i].y = - (long) (precis * ftmp);
  }

/*
 * For use in constructing ticks and axes.
*/
  cprof_ylim.min = min;
  cprof_ylim.max = max;
}

void
cprof_plane_to_screen(xg)
  xgobidata *xg;
{
/*
 * Take the values in
 *  xg->world_data[nearest_point, sticky][] for the y variable
 *  a scaled up version of 1 to the number of columns for x
 * and scale them into cprof_screen for plotting.
*/
  int j, k;
  long nx, ny;
  /* Don't know where this 50 came from. */
  float cprof_scale_x = (float) (cprof_width - left_margin - 40) /
  /*float cprof_scale_x = (float) (cprof_width - LBMARGIN - 40) /*/
    (float) cprof_width ;
  float cprof_scale_y = (float) (cprof_height - LBMARGIN - 40) /
    (float) cprof_height ;

  /*cprof_shift_wrld = (float) ((LBMARGIN + 25) * PRECISION1) /*/
  /*cprof_shift_wrld = (float) (LBMARGIN * PRECISION1) /*/
  cprof_shift_wrld = (float) (left_margin * PRECISION1) /
    (float) (cprof_width * cprof_scale_x) ;

  cprof_midx = cprof_width/2 ;
  cprof_midy = cprof_height/2 ;

  cprof_is.x = (long) (cprof_width * cprof_scale_x / 2);
  cprof_is.y = (long) (cprof_height * cprof_scale_y / 2);

  for (j=0; j<(xg->nsticky_ids+1)*cprof_nselectedvars; j++)
  {
    /* Only have nselectedvars cprof_plane[].x values */
    k = j % cprof_nselectedvars;
    nx = (cprof_plane[k].x + cprof_shift_wrld) * cprof_is.x ;
    /* But we're building all the cprof_screen[].x values */
    cprof_screen[j].x = (int) (nx >> EXP1);
    cprof_screen[j].x += cprof_midx ;

    ny = (cprof_plane[j].y - cprof_shift_wrld) * cprof_is.y ;
    cprof_screen[j].y = (int) (ny >> EXP1);
    cprof_screen[j].y += cprof_midy ;
  }
}

/* OBSOLETE
void
build_cprof_segs(xg)
  xgobidata *xg;
{
  int i, n;
  short size = 1;

  for (i=0, n=0; i<(xg->nsticky_ids+1)*cprof_nselectedvars; i++)
  {
    segs[n].x1 = (short) cprof_screen[i].x - size;
    segs[n].x2 = (short) cprof_screen[i].x + size;
    segs[n].y1 = segs[n].y2 = (short) cprof_screen[i].y;
    n++;
    segs[n].x1 = segs[n].x2 = (short) cprof_screen[i].x;
    segs[n].y1 = (short) cprof_screen[i].y - size;
    segs[n].y2 = (short) cprof_screen[i].y + size;
    n++;
  }
}
*/

void
build_cprof_connect_segs(xg)
  xgobidata *xg;
{
  int i, k, n;
  int count = 0;

  for (i=0,n=0; i<(xg->nsticky_ids+1)*(cprof_nselectedvars-1); i++,n++)
  {
    k = n % cprof_nselectedvars ;
    connsegs[i].x1 = (short) cprof_screen[k].x ;
    connsegs[i].x2 = (short) cprof_screen[k+1].x ;
    connsegs[i].y1 = (short) cprof_screen[n].y ;
    connsegs[i].y2 = (short) cprof_screen[n+1].y ;

    count++;
    if (count == cprof_nselectedvars - 1)
    {
      count = 0;
      n++;
    }
  }
}

void
cprof_plot_once(xg)
  xgobidata *xg;
{
  int i, j, sticky_id, width;
  static int id = 0;
  XGCValues *gv = &copy_GC->values;
  int np, ns, nr_open, nr_filled, nc_open, nc_filled;
  void build_glyph();

/*
 * In order to make the plot update itself during brushing,
 * there are two lines at the end of brush_once().  This
 * is not pretty, since it is another violation of modularity.
 * Can this be handled in the event loop?
*/

  XFillRectangle(display, cprof_pixmap, clear_GC,
    0, 0, cprof_width, cprof_height );

  if (xg->nearest_point != -1 || xg->nsticky_ids != 0)
  {
    id = xg->nearest_point;

    /* If there's a nearest_point: ie, if the cursor is in the window .. */
    if (id != -1)
    {
      if (cprof_showpoints)
      {
        np = ns = nr_open = nr_filled = nc_open = nc_filled = 0;

        /* Build the glyphs for the nearest point */
        for (i=0; i<cprof_nselectedvars; i++)
          build_glyph(xg, id, cprof_screen, i,
            points, &np,
            segs, &ns,
            open_rectangles, &nr_open,
            filled_rectangles, &nr_filled,
            open_circles, &nc_open,
            filled_circles, &nc_filled);

        /*
         * Draw the glyphs for nearest point.
        */
        if (!mono)
          XSetForeground(display, copy_GC, xg->color_now[id]);

        if (np)
          XDrawPoints(display, cprof_pixmap, copy_GC,
            points, np, CoordModeOrigin);
        else if (ns)
          XDrawSegments(display, cprof_pixmap, copy_GC,
            segs, ns);
        else if (nr_open)
          XDrawRectangles(display, cprof_pixmap, copy_GC,
            open_rectangles, nr_open);
        else if (nr_filled)
        {
          XDrawRectangles(display, cprof_pixmap, copy_GC,
            filled_rectangles, nr_filled);
          XFillRectangles(display, cprof_pixmap, copy_GC,
            filled_rectangles, nr_filled);
        }
        else if (nc_open)
          XDrawArcs(display, cprof_pixmap, copy_GC,
            open_circles, nc_open);
        else if (nc_filled)
        {
          XDrawArcs(display, cprof_pixmap, copy_GC,
            filled_circles, nc_filled);
          XFillArcs(display, cprof_pixmap, copy_GC,
            filled_circles, nc_filled);
        }
      }
      if (cprof_showlines)
      {
        build_cprof_connect_segs(xg);
        /*
         * Draw the connected lines for nearest_point; use plotcolors.fg.
        */

        /*Doubling line width in all cases for strong pictures.*/
        width = 2;

        XSetForeground(display, copy_GC, xg->color_now[id]);
        XSetLineAttributes(display, copy_GC, width, LineSolid,
          gv->cap_style, gv->join_style);
        XDrawSegments(display, cprof_pixmap, copy_GC,
          connsegs, cprof_nselectedvars - 1 );

        XSetLineAttributes(display, copy_GC, 0, LineSolid,
          gv->cap_style, gv->join_style);
      }
    }

    /* Now do the sticky guys */
    if (cprof_showpoints)
    {
      /*
       * Looping over the sticky guys, first build the glyphs for
       * each, then draw them.
      */
      for (j=0; j<xg->nsticky_ids; j++)
      {
        np = ns = nr_open = nr_filled = nc_open = nc_filled = 0;
        sticky_id = xg->sticky_ids[j];
        for (i=0; i<cprof_nselectedvars; i++)
          build_glyph(xg,
            sticky_id, &cprof_screen[cprof_nselectedvars*(j+1)], i,
            points, &np,
            segs, &ns,
            open_rectangles, &nr_open,
            filled_rectangles, &nr_filled,
            open_circles, &nc_open,
            filled_circles, &nc_filled);

        if (!mono)
          XSetForeground(display, copy_GC, xg->color_now[sticky_id]);

        if (np)
          XDrawPoints(display, cprof_pixmap, copy_GC,
            points, np, CoordModeOrigin);
        else if (ns)
          XDrawSegments(display, cprof_pixmap, copy_GC,
            segs, ns);
        else if (nr_open)
          XDrawRectangles(display, cprof_pixmap, copy_GC,
            open_rectangles, nr_open);
        else if (nr_filled)
        {
          XDrawRectangles(display, cprof_pixmap, copy_GC,
            filled_rectangles, nr_filled);
          XFillRectangles(display, cprof_pixmap, copy_GC,
            filled_rectangles, nr_filled);
        }
        else if (nc_open)
          XDrawArcs(display, cprof_pixmap, copy_GC,
            open_circles, nc_open);
        else if (nc_filled)
        {
          XDrawArcs(display, cprof_pixmap, copy_GC,
            filled_circles, nc_filled);
          XFillArcs(display, cprof_pixmap, copy_GC,
            filled_circles, nc_filled);
        }
      }
    }

    if (cprof_showlines)
    {

      /*
       * Draw the connected lines for the sticky ids; use dotted lines
       * without.
      */

      /*Doubling line width in all cases for strong pictures.*/
      width = 2;

      XSetLineAttributes(display, copy_GC, width, LineOnOffDash,
        gv->cap_style, gv->join_style);

      for (j=0; j<xg->nsticky_ids; j++)
      {
        sticky_id = xg->sticky_ids[j];

        if (!mono)
          XSetForeground(display, copy_GC, xg->color_now[sticky_id] );

        XDrawSegments(display, cprof_pixmap, copy_GC,
          connsegs + (j+1) * (cprof_nselectedvars - 1),
          cprof_nselectedvars - 1 );
      }

      XSetLineAttributes(display, copy_GC, 0, LineSolid,
        gv->cap_style, gv->join_style);
    }
  }

  build_cprof_tick_segs();
  add_cprof_axes();

  XCopyArea(display, cprof_pixmap, cprof_plot_window, copy_GC,
    0, 0, cprof_width, cprof_height, 0, 0 );
}

void
update_cprof_selectedvars(xg)
  xgobidata *xg;
{
  int j, k = 0;

  for (j=0; j<xg->ncols_used; j++)
    cprof_selectedvars[k++] = j ;

  cprof_nselectedvars = k;
}

void
update_cprof_plot(xg)
  xgobidata *xg;
{
/*
 * This is called when a variable transformation occurs,
 * when nselectedvars changes, when the passive window
 * receives new data, and so forth.
*/
  int j;
  char str[100];
  Dimension width;

  cprof_tform_to_plane(xg);
  cprof_plane_to_screen(xg);
  /*
   * Calculate the ticks and axes for the
   * y axis; scale ticks and axes.
  */
  generate_cprof_yticks();
  convert_cprof_ticks();

  /*
   * Check the length of the y axis labels.  If the length
   * of any axis plus 5 for the tick length plus 2 for breathing
   * room is greater than the margin, then reinitialize the axes.
  */
  width = 0;
  for (j=0; j<cprof_ticks.nticks[1]; j++)
  {
    find_cprof_tick_label(cprof_ydeci, j, cprof_ticks.yticks, str);
    width = MAX(width, XTextWidth(appdata.plotFont, str, strlen(str)));
  }
  width = width+5+2 ;
  if (width > left_margin)
  {
    left_margin = width;
    make_cprof_screen_axes();
    cprof_plane_to_screen(xg);
    convert_cprof_ticks();
  }

  cprof_plot_once(xg);
}


void
realloc_tform(xg)
  xgobidata *xg;
{
  int npts = xg->nsticky_ids+1;

  cprof_tform = (fcoords *) XtRealloc( (XtPointer) cprof_tform,
    (Cardinal) (npts * xg->ncols_used * sizeof(fcoords)));
  cprof_plane = (lcoords *) XtRealloc( (XtPointer) cprof_plane,
    (Cardinal) (npts * xg->ncols_used * sizeof(lcoords)));
  cprof_screen = (icoords *) XtRealloc( (XtPointer) cprof_screen,
    (Cardinal) (npts * xg->ncols_used * sizeof(icoords)));

  points = (XPoint *) XtRealloc( (XtPointer) points,
    (Cardinal) (npts * xg->ncols_used) * sizeof(XPoint));
  segs = (XSegment *) XtRealloc( (XtPointer) segs,
    (Cardinal) (2 * npts * xg->ncols_used) * sizeof(XSegment));
  open_rectangles = (XRectangle *) XtRealloc( (XtPointer) open_rectangles,
    (Cardinal) (npts * xg->ncols_used) * sizeof(XRectangle));
  filled_rectangles = (XRectangle *) XtRealloc( (XtPointer) filled_rectangles,
    (Cardinal) (npts * xg->ncols_used) * sizeof(XRectangle));
  open_circles = (XArc *) XtRealloc( (XtPointer) open_circles,
    (Cardinal) (npts * xg->ncols_used) * sizeof(XArc));
  filled_circles = (XArc *) XtRealloc( (XtPointer) filled_circles,
    (Cardinal) (npts * xg->ncols_used) * sizeof(XArc));

  connsegs = (XSegment *) XtRealloc( (XtPointer) connsegs,
    (Cardinal) (npts * (xg->ncols_used-1)) * sizeof(XSegment));
}


/* ARGSUSED */
XtCallbackProc
cprof_resize_cback(w, xgobi, callback_data)
  Widget w;
  XtPointer *xgobi;
  caddr_t callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;

  XtVaGetValues(cprof_plot_wksp,
    XtNwidth, &cprof_width,
    XtNheight, &cprof_height,
    NULL);

  XFreePixmap(display, cprof_pixmap);
  cprof_pixmap = XCreatePixmap(display, cprof_plot_window,
    cprof_width, cprof_height, depth);
  XFillRectangle(display, cprof_pixmap, clear_GC,
    0, 0, cprof_width, cprof_height );

  cprof_tform_to_plane(xg);
  cprof_plane_to_screen(xg);

  make_cprof_screen_axes();
  generate_cprof_yticks();
  convert_cprof_ticks();

  cprof_plot_once(xg);
}

/* ARGSUSED */
XtCallbackProc
cprof_expose_cback(w, xgobi, callback_data)
  Widget w;
  XtPointer *xgobi;
  caddr_t callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;

  cprof_tform_to_plane(xg);
  cprof_plane_to_screen(xg);
  cprof_plot_once(xg);
}

/* ARGSUSED */
XtCallbackProc
cprof_showlines_cback(w, xgobi, callback_data)
  Widget w;
  XtPointer *xgobi;
  caddr_t callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;

  cprof_showlines = !cprof_showlines;
  cprof_plot_once(xg);
}

/* ARGSUSED */
XtCallbackProc
cprof_showpoints_cback(w, xgobi, callback_data)
  Widget w;
  XtPointer *xgobi;
  caddr_t callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;

  cprof_showpoints = !cprof_showpoints;
  cprof_plot_once(xg);
}

/* ARGSUSED */
XtCallbackProc
cprof_plot_cback(w, xgobi, callback_data)
  Widget w;
  XtPointer *xgobi;
  caddr_t callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;

  if (!xg->is_cprof_plotting)
  {
    int npts = xg->nsticky_ids + 1;
    /*
     * Allocate enough space to plot the points and lines
     * for all the sticky ids for the current id.
    */
    cprof_tform = (fcoords *) XtMalloc( (Cardinal)
      npts * xg->ncols_used * sizeof(fcoords));
    cprof_plane = (lcoords *) XtMalloc( (Cardinal)
      npts * xg->ncols_used * sizeof(lcoords));
    cprof_screen = (icoords *) XtMalloc( (Cardinal)
      npts * xg->ncols_used * sizeof(icoords));

    points = (XPoint *) XtMalloc( (Cardinal)
      npts * xg->ncols_used * sizeof(XPoint));
    segs = (XSegment *) XtMalloc( (Cardinal)
      2 * npts * xg->ncols_used * sizeof(XSegment));
    open_rectangles = (XRectangle *) XtMalloc( (Cardinal)
      npts * xg->ncols_used * sizeof(XRectangle));
    filled_rectangles = (XRectangle *) XtMalloc( (Cardinal)
      npts * xg->ncols_used * sizeof(XRectangle));
    open_circles = (XArc *) XtMalloc( (Cardinal)
      npts * xg->ncols_used * sizeof(XArc));
    filled_circles = (XArc *) XtMalloc( (Cardinal)
      npts * xg->ncols_used * sizeof(XArc));

    connsegs = (XSegment *) XtMalloc( (Cardinal)
      npts * (xg->ncols_used-1) * sizeof(XSegment));

    cprof_width = 400;
    cprof_height = 200;

    cprof_plot_shell = XtVaCreatePopupShell("CaseProfile",
      topLevelShellWidgetClass, cprof_plot_cmd,
      XtNtitle, (String) "XGobi: Case Profile Window",
      XtNiconName, (String) "XGobi: Case Profile Window",
      NULL);
    if (mono) set_mono(cprof_plot_shell);

    cprof_form = XtVaCreateManagedWidget("Form1",
      formWidgetClass, cprof_plot_shell,
      NULL);
    if (mono) set_mono(cprof_form);

    cprof_panel = XtVaCreateManagedWidget("CProfPanel",
      boxWidgetClass, cprof_form,
      XtNleft, (XtEdgeType) XtChainLeft,
      XtNright, (XtEdgeType) XtChainLeft,
      XtNtop, (XtEdgeType) XtChainTop,
      XtNbottom, (XtEdgeType) XtChainTop,
      XtNorientation, (XtOrientation) XtorientVertical,
      NULL);
    if (mono) set_mono(cprof_panel);

    cprof_cmd[0] = (Widget) CreateToggle(xg, "Show lines",
      True, (Widget) NULL, (Widget) NULL, (Widget) NULL,
      cprof_showlines, ANY_OF_MANY,
      cprof_panel, "CProfPlot");
    XtManageChild(cprof_cmd[0]);
    XtAddCallback(cprof_cmd[0], XtNcallback,
      (XtCallbackProc) cprof_showlines_cback, (XtPointer) xg);

    cprof_cmd[1] = (Widget) CreateToggle(xg, "Show points",
      True, (Widget) NULL, (Widget) NULL, (Widget) NULL,
      cprof_showpoints, ANY_OF_MANY,
      cprof_panel, "CProfPlot");
    XtManageChild(cprof_cmd[1]);
    XtAddCallback(cprof_cmd[1], XtNcallback,
      (XtCallbackProc) cprof_showpoints_cback, (XtPointer) xg);

    cprof_plot_wksp = XtVaCreateManagedWidget("CaseProfile",
      labelWidgetClass, cprof_form,
      XtNlabel, (String) "",
      XtNforeground, (Pixel) plotcolors.fg,
      XtNbackground, (Pixel) plotcolors.bg,
      XtNwidth, (Dimension) cprof_width,
      XtNfromHoriz, (Widget) cprof_panel,
      XtNheight, (Dimension) cprof_height,
      XtNleft, (XtEdgeType) XtChainLeft,
      XtNright, (XtEdgeType) XtChainRight,
      XtNtop, (XtEdgeType) XtChainTop,
      XtNbottom, (XtEdgeType) XtChainBottom,
      NULL);
    if (mono) set_mono(cprof_plot_wksp);

    XtAddEventHandler(cprof_plot_wksp, ExposureMask,
      FALSE, (XtEventHandler) cprof_expose_cback, (XtPointer) xg);
    XtAddEventHandler(cprof_plot_wksp, StructureNotifyMask,
      FALSE, (XtEventHandler) cprof_resize_cback, (XtPointer) xg);

    XtPopup(cprof_plot_shell, XtGrabNone);
    XRaiseWindow(display, XtWindow(cprof_plot_shell));

    cprof_plot_window = XtWindow( cprof_plot_wksp );
    cprof_pixmap = XCreatePixmap(display, cprof_plot_window,
      cprof_width, cprof_height, depth);

    update_cprof_selectedvars(xg);

    /*
     * The cprof_plane[].x values don't change, so just
     * set them up here.  The same goes for the x ticks,
     * and the axes only need to be initialized once.
    */
    init_cprof_plane_x();

    make_cprof_screen_axes();
    generate_cprof_xticks();

    xg->is_cprof_plotting = True;
  }
  else
  {
    xg->is_cprof_plotting = False;

    XtDestroyWidget( cprof_plot_shell );
    XFreePixmap( display, cprof_pixmap );
    XtFree( (XtPointer) cprof_tform );
    XtFree( (XtPointer) cprof_plane );
    XtFree( (XtPointer) cprof_screen );
    XtFree( (XtPointer) segs );
  }
}

void
passive_update_cprof_plot(xg)
  xgobidata *xg;
{
/*
 * This is called when the passive window receives new data.
*/
  static int onsticky = 0;

  if (xg->is_cprof_plotting)
  {
    if (xg->nsticky_ids != onsticky)
      realloc_tform(xg);  /* Done when nsticky_ids changes. */
    update_cprof_plot(xg);
  }
}

void
reset_group_cprof_plot(xg)
  xgobidata *xg;
{
/*
 * If case profile plotting when an additional variable is
 * added or changed, then do this:
*/
  if (xg->is_cprof_plotting)
  {
    /*
     * This isn't always necessary, but I don't know
     * how to tell when it is, so I'll do it in any case.
    */
    realloc_tform(xg);

    init_cprof_plane_x();

    generate_cprof_xticks();
    update_cprof_plot(xg);
  }
}

/*
 * Used by print_plotwin
*/
void
get_cprof_win_dims(maxx, maxy, xg)
  float *maxx, *maxy;
  xgobidata *xg;
{
  if (xg->is_cprof_plotting)
  {
    *maxx = (float) cprof_width ;
    *maxy = (float) cprof_height ;
  }
  else
    *maxx = *maxy = 0 ;
}

void
check_cprof_fac_and_offsets(minx, maxx, maxy, fac, xoff, yoff,
pointsize)
  float *minx, *maxx, *maxy, *fac, *xoff, *yoff ;
  int pointsize;
{
  /*
   * Shift x axis.  The constant 4.5 comes from the header file.
  */
  while (72.*((*maxy - cprof_screen_axes[1].y) * *fac + *yoff) -
             4.0*pointsize < 72. * *yoff)
  {
    *maxy = 1.02 * *maxy ;
    set_fac_and_offsets(*minx, *maxx, *maxy, fac, xoff, yoff);
  }

  /*
   * Shift x axis.  The constant 4.5 comes from the header file.
  */
  while (72.*((cprof_screen_axes[1].x - *minx) * *fac + *xoff) -
         4.0*pointsize < 72. * *xoff)
  {
    *minx = *minx - .02 * (*maxx - *minx) ;
    /**maxx = 1.02 * *maxx ;*/
    set_fac_and_offsets(*minx, *maxx, *maxy, fac, xoff, yoff);
  }
}

void
print_cprof_win(xg, psfile, minx, maxy, fac, xoff, yoff, fg,
rgb_table, rgb_lines)
  xgobidata *xg;
  FILE *psfile;
  float minx, maxy, fac, xoff, yoff;
  XColor *fg;
  XColor *rgb_table, *rgb_lines;
{
  int i, j, indx;
  int offset, toomany;
  char str[50];

  /*
   * Values for the usual foreground.
  */
  rgb_lines[0].red = fg->red;
  rgb_lines[0].green = fg->green;
  rgb_lines[0].blue = fg->blue;

  /*
   * Values for the first brushing color.
  */
  rgb_lines[1].red = rgb_table[0].red;
  rgb_lines[1].green = rgb_table[0].green;
  rgb_lines[1].blue = rgb_table[0].blue;

  /*
   * Add the line for nearest_point.  Draw it using rgb_lines[0].
  */
  (void) fprintf(psfile, "%% ln: red green blue x1 y1 x2 y2\n");
  (void) fprintf(psfile, "%%  draw line from (x1,y1) to (x2,y2)\n");

  for (i=0; i<cprof_nselectedvars-1; i++)
  {
    (void) fprintf(psfile, "%f %f %f %f %f %f %f ln\n",
      (float) rgb_lines[0].red / (float) 65535,
      (float) rgb_lines[0].green / (float) 65535,
      (float) rgb_lines[0].blue / (float) 65535,
      (float) (connsegs[i].x1 - minx) * fac + xoff,
      (float) (maxy - connsegs[i].y1) * fac + yoff,
      (float) (connsegs[i].x2 - minx) * fac + xoff,
      (float) (maxy - connsegs[i].y2) * fac + yoff );
  }

  for (j=0; j<xg->nsticky_ids; j++)
  {
    for (i=0; i<cprof_nselectedvars-1; i++)
    {
      indx = (j+1) * (cprof_nselectedvars-1) + i ;
      (void) fprintf(psfile, "%f %f %f %f %f %f %f lndashed\n",
        (float) rgb_lines[1].red / (float) 65535,
        (float) rgb_lines[1].green / (float) 65535,
        (float) rgb_lines[1].blue / (float) 65535,
        (float) (connsegs[indx].x1 - minx) * fac + xoff,
        (float) (maxy - connsegs[indx].y1) * fac + yoff,
        (float) (connsegs[indx].x2 - minx) * fac + xoff,
        (float) (maxy - connsegs[indx].y2) * fac + yoff );
    }
  }

  /*
   * Draw y axis
  */
  (void) fprintf(psfile, "%% yax: (label) red green blue x1 y1 x2 y2\n");
  (void) fprintf(psfile, "%%  draw y axis (and null label)\n");
  (void) fprintf(psfile, "(%s) %f %f %f %f %f %f %f yax\n",
    "",
    (float) fg->red / (float) 65535,
    (float) fg->green / (float) 65535,
    (float) fg->blue / (float) 65535,
    (float) (cprof_screen_axes[1].x - minx) * fac + xoff,
    (float) (maxy - cprof_screen_axes[1].y) * fac + yoff,
    (float) (cprof_screen_axes[0].x - minx) * fac + xoff,
    (float) (maxy - cprof_screen_axes[0].y) * fac + yoff );

  (void) fprintf(psfile, "%% ytx: (label) red green blue x y\n");
  (void) fprintf(psfile, "%%  draw y axis tick and label\n");
  offset = find_cprof_ytick_offset();
  toomany = find_cprof_ytick_toomany();
  for (i=offset; i<cprof_ticks.nticks[1]-toomany; i++)
  {
    find_cprof_tick_label(cprof_ydeci, i, cprof_ticks.yticks, str);
    (void) fprintf(psfile, "(%s) %f %f %f %f %f ytx\n",
      str,
      (float) fg->red / (float) 65535,
      (float) fg->green / (float) 65535,
      (float) fg->blue / (float) 65535,
      (float) (cprof_screen_axes[1].x - minx) * fac + xoff,
      (float) (maxy - cprof_ticks.screen[i].y) * fac + yoff);
  }

  /*
   * Draw x axis
  */
  (void) fprintf(psfile, "%% xax: (label) red green blue x1 y1 x2 y2\n");
  (void) fprintf(psfile, "%%  draw x axis (and null label)\n");
  (void) fprintf(psfile, "(%s) %f %f %f %f %f %f %f xax\n",
    "Variable Number",
    (float) fg->red / (float) 65535,
    (float) fg->green / (float) 65535,
    (float) fg->blue / (float) 65535,
    (float) (cprof_screen_axes[1].x - minx) * fac + xoff,
    (float) (maxy - cprof_screen_axes[1].y) * fac + yoff,
    (float) (cprof_screen_axes[2].x - minx) * fac + xoff,
    (float) (maxy - cprof_screen_axes[2].y) * fac + yoff );

  (void) fprintf(psfile, "%% xtx: (label) red green blue x y\n");
  (void) fprintf(psfile, "%%  draw x axis tick and label\n");
  offset = find_cprof_xtick_offset();
  toomany = find_cprof_xtick_toomany();
  for (i=offset; i<cprof_ticks.nticks[0]-toomany; i++)
  {
    find_cprof_tick_label(cprof_xdeci, i, cprof_ticks.xticks, str);
    (void) fprintf(psfile, "(%s) %f %f %f %f %f xtx\n",
      str,
      (float) fg->red / (float) 65535,
      (float) fg->green / (float) 65535,
      (float) fg->blue / (float) 65535,
      (float) (cprof_ticks.screen[i].x - minx) * fac + xoff,
      (float) (maxy - cprof_screen_axes[1].y) * fac + yoff);
  }
}

/*____End of case profile plotting section___*/
/*___Beginning of linked identification section___*/


/* ARGSUSED */
XtConvertSelectionProc
pack_ids(w, selection, target,
type_ret, retdata, length_ret, format_ret )
  Widget w;          /* owning widget, xg->workspace */
  Atom *selection;   /* XG_IDS */
  Atom *target;      /* XG_IDS_TYPE */
  Atom *type_ret;    /* XG_IDS_TYPE again */
  XtPointer *retdata;         /* xg->nrows + xg->sticky_ids */
  unsigned long *length_ret;  /* 3 + xg->nsticky_ids */
  int *format_ret;            /* type of retdata */
{
/*
 * pack up the nearest_point and the sticky_ids to send
*/
  extern xgobidata xgobi;
  int i;
  unsigned long *rdata;

  if (*target == XG_IDS_TYPE)
  {
    rdata = (unsigned long *) XtMalloc((Cardinal)
      (3+xgobi.nsticky_ids) * sizeof(unsigned long) );

    rdata[0] = (unsigned long) xgobi.nrows;
    rdata[1] = (unsigned long) xgobi.nearest_point;
    rdata[2] = (unsigned long) xgobi.nsticky_ids;
    for (i=0; i<xgobi.nsticky_ids; i++)
      rdata[i+3] = (unsigned long) xgobi.sticky_ids[i] ;

    *type_ret = XG_IDS_TYPE ;
    *retdata = (XtPointer) rdata ;
    *length_ret = (unsigned long) (3+xgobi.nsticky_ids) ;
    *format_ret = (int) 32 ;
  }
}

void
announce_ids(xg)
  xgobidata *xg;
{
/*
 * Execute XChangeProperty(), sending no data, just to let
 * linked XGobis know that new ids are available.
*/
  XChangeProperty( display,
    RootWindowOfScreen(XtScreen(xg->shell)),
    XG_IDS_ANNC, XG_IDS_ANNC_TYPE,
    (int) 32, (int) PropModeReplace,
    (unsigned char *) NULL, 0);
}


/* ARGSUSED */
XtSelectionCallbackProc
unpack_ids(w, xgobiptr, atom, atom_type, retdata, lendata, fmt)
  Widget w;
  XtPointer xgobiptr;
  Atom *atom;         /* should be XG_IDS */
  Atom *atom_type;    /* should be XG_IDS_TYPE */
  XtPointer retdata;
  unsigned long *lendata;
  int *fmt;           /* should be 32 */
{
  xgobidata *xg = (xgobidata *) xgobiptr;
  int i, nids, nr;
  unsigned long *rdata;

  if (*atom == XG_IDS &&
      /**atom_type != NULL &&*/
      *atom_type &&
      *atom_type == XG_IDS_TYPE )
  {
    if (*lendata > 0)
    {
      rdata = (unsigned long *) retdata;

      nr = (int) *rdata++ ;
      {
        if (nr == xg->nrows)
        {
          xg->nearest_point = (int) *rdata++ ;
          nids = (int) *rdata++ ;
          xg->nsticky_ids = nids ;
          xg->sticky_ids = (unsigned int *) XtRealloc(
            (XtPointer) xg->sticky_ids,
            (unsigned int) xg->nsticky_ids * sizeof(unsigned int) );

          for (i=0; i<xg->nsticky_ids; i++)
            xg->sticky_ids[i] = (int) *rdata++ ;

          plot_once(xg);
          passive_update_cprof_plot(xg);
        }
      }
    }
  }
  XtFree((XtPointer) retdata) ;
}

void
read_ids(xg)
  xgobidata *xg;
{
  XtGetSelectionValue(
    xg->workspace,
    (Atom) XG_IDS,
    (Atom) XG_IDS_TYPE,
    (XtSelectionCallbackProc) unpack_ids,
    (XtPointer) xg,
    (Time) XtLastTimestampProcessed(display) );
    /*(Time) CurrentTime );*/
}

void
turn_off_cprof_plotting(xg)
  xgobidata *xg;
{
  XtCallCallbacks(cprof_plot_cmd, XtNcallback, (XtPointer) xg);
}

/*___End of linked identification section___*/

void
map_identify(xg, ident)
  xgobidata *xg;
  Boolean ident;
{
  if (ident)
  {
    XtMapWidget(xg->identify_mouse);
    XtMapWidget(identify_panel);
  }
  else
  {
    XtUnmapWidget(xg->identify_mouse);
    XtUnmapWidget(identify_panel);
  }
}

/* ARGSUSED */
XtCallbackProc
identify_cback(w, xgobi, callback_data)
  Widget w;
  XtPointer *xgobi;
  caddr_t callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;

  if (!xg->is_identify)
  {
    (void) XtAppAddWorkProc(app_con, RunWorkProcs, NULL);
    XtAddEventHandler(xg->workspace, ButtonPressMask,
      FALSE, (XtEventHandler) set_sticky, (XtPointer) xg);
    XDefineCursor(display, XtWindow(xg->workspace), crosshair_cursor);
    xg->is_identify = True;
    map_identify(xg, True);

    XtOwnSelection( (Widget) xg->workspace,
      (Atom) XG_IDS,
      (Time) CurrentTime, /* doesn't work with XtLastTimeStamp...? */
      /*(Time) XtLastTimestampProcessed(display),*/
      (XtConvertSelectionProc) pack_ids,
      (XtLoseSelectionProc) NULL ,
      (XtSelectionDoneProc) NULL );
  }
  else
  {
    XtDisownSelection( (Widget) xg->workspace,
      (Atom) XG_IDS,
      (Time) XtLastTimestampProcessed(display));

    XtRemoveEventHandler(xg->workspace,
      XtAllEvents, TRUE,
      (XtEventHandler) set_sticky, (XtPointer) xg);
    XDefineCursor(display, XtWindow(xg->workspace), default_cursor);
    xg->is_identify = False;
    xg->nearest_point = -1;
    map_identify(xg, False);
    plot_once(xg);
  }
}

/* ARGSUSED */
XtCallbackProc
link_ident_cback(w, xgobi, callback_data)
  Widget w;
  XtPointer *xgobi;
  XtPointer callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;

  xg->linked_identify = !xg->linked_identify;
}


/* ARGSUSED */
XtCallbackProc
rm_sticky_cback(w, xgobi, callback_data)
  Widget w;
  XtPointer *xgobi;
  caddr_t callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;

  xg->nsticky_ids = 0;

  plot_once(xg);
  if (xg->is_cprof_plotting)
  {
    realloc_tform(xg);  /* Done when nsticky_ids changes. */
    update_cprof_plot(xg);
  }

  if (xg->linked_identify)
    announce_ids(xg);
}

/* ARGSUSED */
XtActionProc
NullNearestPoint(w, evnt, params, nparams)
  Widget w;
  XEvent *evnt;
  String *params;
  Cardinal nparams;
{
  extern xgobidata xgobi;

  if (xgobi.is_identify)
  {
    xgobi.nearest_point = -1;
    /*
     * Plot once ... then there won't be an id in the plot
     * if the cursor is outside the plot window.
    */
    quickplot_once(&xgobi);
    if (xgobi.linked_identify)
      announce_ids(&xgobi);
  }
}

int
find_nearest_point(cursor_pos, xg)
  icoords *cursor_pos;
  xgobidata *xg;
{
/*
 * Returns index of nearest un-erased point incremented by one
*/
  int i, sqdist, near, xdist, ydist, npoint;

  npoint = 0;
  near = 1000*PRECISION1;

  for (i=0; i<xg->nrows_in_plot; i++)
  {
    if (!xg->erased[ xg->rows_in_plot[i] ])
    {
      xdist = xg->screen[ xg->rows_in_plot[i] ].x - cursor_pos->x;
      ydist = xg->screen[ xg->rows_in_plot[i] ].y - cursor_pos->y;
      sqdist = xdist*xdist + ydist*ydist;
      if (sqdist < near)
      {
        near = sqdist;
        npoint = xg->rows_in_plot[i];
      }
    }
  }
  return(npoint);
}

void
id_proc(xg)
  xgobidata *xg;
{
  int root_x, root_y;
  unsigned int kb;
  Window root, child;
  static int ocpos_x = 0, ocpos_y = 0;
  icoords cpos;
  static int inwindow = 1;
  int wasinwindow;

  wasinwindow = inwindow;
/*
 * Get the current pointer position.
*/
  if (XQueryPointer(display, xg->plot_window, &root, &child,
            &root_x, &root_y, &cpos.x, &cpos.y, &kb))
  {
    inwindow = (0 < cpos.x && cpos.x < xg->max.x &&
                0 < cpos.y && cpos.y < xg->max.y) ;
    /*
     * If the pointer is inside the plotting region ...
    */
    if (inwindow)
    {
      /*
       * If the pointer has moved ...
      */
      if ((cpos.x != ocpos_x) || (cpos.y != ocpos_y))
      {
        ocpos_x = cpos.x;
        ocpos_y = cpos.y;
        /*
         * nearest_point ranges from 0 to nrows-1; if
         * it is -1, it won't be drawn.
        */
        if ( (xg->nearest_point = find_nearest_point(&cpos, xg)) != -1)
        {
          quickplot_once(xg);
          if (xg->linked_identify)
          {
            XtOwnSelection( (Widget) xg->workspace,
              (Atom) XG_IDS,
              (Time) CurrentTime, /* doesn't work with XtLastTimeStamp...? */
              /*(Time) XtLastTimestampProcessed(display),*/
              (XtConvertSelectionProc) pack_ids,
              (XtLoseSelectionProc) NULL ,
              (XtSelectionDoneProc) NULL );
            announce_ids(xg);
          }
          if (xg->is_cprof_plotting)
            update_cprof_plot(xg);
        }
      }
    }
  }

  if (!inwindow && wasinwindow)
  {
    xg->nearest_point = -1;
    if (xg->is_cprof_plotting)
      update_cprof_plot(xg);
  }
}

void
plot_nearest_id(xg, win)
/*
 * Draw the id of the nearest point.
*/
  xgobidata *xg;
  Drawable win;
{
  XDrawString(display, win, copy_GC,
    xg->screen[ xg->nearest_point ].x + 3,
    xg->screen[ xg->nearest_point ].y - 3,
    xg->rowlab[ xg->nearest_point ],
    strlen(xg->rowlab[ xg->nearest_point ]));
}

void
update_sticky_ids(xg)
  xgobidata *xg;
/*
 * Called from the case selection procedures -- done when
 * new variables are selected using the case list.
*/
{
  int *sticky_guys;
  int nsticky_guys = 0;
  int i, k, initval = 20, numinits = 1;

  sticky_guys = (int *) XtMalloc((Cardinal) initval * sizeof(int));

  for (i=0; i<xg->nrows_in_plot; i++)
  {
  k = xg->rows_in_plot[i] ;
    sticky_guys[nsticky_guys++] = k ;
    if (nsticky_guys >= initval*numinits)
    {
      numinits++ ;
      sticky_guys = (int *) XtRealloc((XtPointer) sticky_guys,
        (Cardinal) (numinits * initval) * sizeof(Cardinal));
    }
  }

  xg->nsticky_ids = nsticky_guys;
  xg->sticky_ids = (Cardinal *) XtRealloc((XtPointer) xg->sticky_ids,
    (Cardinal) xg->nsticky_ids * sizeof(Cardinal));

  for (i=0; i<xg->nsticky_ids; i++)
    xg->sticky_ids[i] = sticky_guys[i];

  XtFree((XtPointer) sticky_guys);
}

/* ARGSUSED */
XtEventHandler
set_sticky(w, xg, evnt)
  Widget w;
  xgobidata *xg;
  XEvent *evnt;
{
  XButtonEvent *xbutton = (XButtonEvent *) evnt;

  if (xbutton->button == 1 || xbutton->button == 2)
  {
    int i, j, found = 0;

    for (i=0; i<xg->nsticky_ids; i++)
    {
       if (xg->sticky_ids[i] == xg->nearest_point)
       {
         found = 1;
         xg->nsticky_ids-- ;
         for (j=i; j<xg->nsticky_ids; j++)
         {
           xg->sticky_ids[j] = xg->sticky_ids[j+1] ;
         }
         xg->sticky_ids = (unsigned int *) XtRealloc( (XtPointer)
           xg->sticky_ids,
           (unsigned) xg->nsticky_ids * sizeof(unsigned int) );

         break;
       }
    }
    if (!found)
    {
      xg->nsticky_ids++ ;
      xg->sticky_ids = (unsigned int *) XtRealloc( (XtPointer)
        xg->sticky_ids,
        (unsigned) xg->nsticky_ids * sizeof(unsigned int) );
      xg->sticky_ids[xg->nsticky_ids-1] = xg->nearest_point;
    }

    plot_once(xg);
    if (xg->is_cprof_plotting)
    {
      realloc_tform(xg);  /* Done when nsticky_ids changes. */
      update_cprof_plot(xg);
    }
    if (xg->linked_identify)
      announce_ids(xg);
  }
}

void
make_identify(xg)
    xgobidata *xg;
{
/*
 * IdentifyPanel
*/
  identify_panel = XtVaCreateManagedWidget("IdentifyPanel",
    boxWidgetClass, xg->box0,
    XtNleft, (XtEdgeType) XtChainLeft,
    XtNright, (XtEdgeType) XtChainLeft,
    XtNtop, (XtEdgeType) XtChainTop,
    XtNbottom, (XtEdgeType) XtChainTop,
    XtNmappedWhenManaged, (Boolean) False,
    NULL);
  if (mono) set_mono(identify_panel);
/*
 * Reset identification labels button
*/
  rm_sticky_cmd = CreateCommand(xg, "Remove Labels",
    True, (Widget) NULL, (Widget) NULL,
    (Widget) identify_panel, "Id_RmLabels");
  XtManageChild(rm_sticky_cmd);

  XtAddCallback(rm_sticky_cmd, XtNcallback,
    (XtCallbackProc) rm_sticky_cback, (XtPointer) xg);
/*
 * Add a button to create and activate the case profile plotting
 * window.
*/
  cprof_plot_cmd = CreateToggle(xg, "Case profile",
    True, (Widget) NULL, (Widget) NULL, (Widget) NULL, False, ANY_OF_MANY,
    (Widget) identify_panel, "CProfPlot");
  XtManageChild(cprof_plot_cmd);

  XtAddCallback(cprof_plot_cmd, XtNcallback,
    (XtCallbackProc) cprof_plot_cback, (XtPointer) xg);

/*
 * Initialize a couple of variables needed for linking case plotting
 * to the variable list.
*/
  cprof_selectedvars = (int *) XtMalloc((Cardinal)
    xg->ncols * sizeof(int));
/*  Will need to do this later, probably ... but maybe not,
 * since it's done in the cprof_plot_cback.
  update_cprof_selectedvars(xg);
*/
}

#undef LBMARGIN
#undef RTMARGIN
