/************************************************************
 *                                                          *
 *  Permission is hereby granted  to  any  individual   or  *
 *  institution   for  use,  copying, or redistribution of  *
 *  the xgobi code and associated documentation,  provided  *
 *  that   such  code  and documentation are not sold  for  *
 *  profit and the  following copyright notice is retained  *
 *  in the code and documentation:                          *
 *     Copyright (c) 1990,1991,1992,1993 Bellcore           *
 *                                                          *
 *  We welcome your questions and comments, and request     *
 *  that you share any modifications with us.               *
 *                                                          *
 *  Deborah F. Swayne      Dianne Cook                      *
 *   dfs@bellcore.com    dcook@stat.rutgers.edu             *
 *    (201) 829-4263                                        *
 *                                                          *
 ************************************************************/

#include <stdio.h>
#include "xincludes.h"
#include "xgobitypes.h"
#include "xgobivars.h"

/* Functions called in this file */
XtCallbackProc brush_active_cback();
XtCallbackProc paint_cback();
XtCallbackProc choose_color_cback();
XtCallbackProc br_perst_cback();
XtCallbackProc br_trans_cback();
XtCallbackProc br_undo_cback();
XtCallbackProc br_erase_cback();
XtCallbackProc br_complement_cback();
XtCallbackProc br_update_cback();
XtCallbackProc reset_brush_cback();
XtCallbackProc reset_point_colors_cback();
XtCallbackProc reset_line_colors_cback();
XtCallbackProc reset_glyphs_cback();
XtCallbackProc reset_erase_cback();
XtCallbackProc br_place_pts_popup();
XtCallbackProc br_place_lines_popup();
XtCallbackProc br_save_to_group_var();
XtCallbackProc delete_erased_cback();
XtCallbackProc undelete_erased_cback();
XtCallbackProc brush_points_cback();
XtCallbackProc brush_lines_cback();
Widget CreateToggle(), CreateCommand();
int fclose();
void init_glyph_ids(), init_color_ids();
void add_menupb_help();
void plot_once();
void set_mono();
void show_message();
/* */

static Widget brush_panel[4] ;
static Widget brush_active_cmd;
static Widget glyph_menu_cmd, glyph_menu, glyph_menu_btn[NGLYPHS+1] ;
static Widget color_menu_cmd, color_menu, color_menu_btn[NCOLORS+2];
static Widget br_type[3], br_update;
static Widget reset_menu_cmd, reset_menu, reset_menu_btn[4];
static Widget erase_cmd;
static Widget erase_menu_cmd, erase_menu, erase_menu_btn[3];
static Widget io_menu_cmd, io_menu, io_menu_item[3];
static Widget brush_points_cmd, brush_lines_cmd;
static Widget mk_group_var_cmd;

#define SAVE_POINT_INFO io_menu_item[0]
#define SAVE_LINE_INFO io_menu_item[1]

#define PANEL0 brush_panel[0]
#define PANEL1 brush_panel[1]
#define PANEL2 brush_panel[2]
#define PANEL3 brush_panel[3]

void
reinit_brush_colors(xg)
  xgobidata *xg;
{
  char clab[20];
  XtCallbackProc choose_color_cback();

  color_nums[ncolors] = plotcolors.fg;
  color_names[ncolors] = "Default";

  (void) sprintf((char *) clab, "%s", color_names[ncolors]);

  color_menu_btn[ncolors+1] = XtVaCreateManagedWidget("Command",
    smeBSBObjectClass, color_menu,
    XtNlabel, (String) clab,
    XtNleftMargin, (Dimension) 24,
    XtNforeground, color_nums[ncolors],
    NULL);
  XtAddCallback(color_menu_btn[ncolors+1], XtNcallback,
    (XtCallbackProc) choose_color_cback, (XtPointer) xg);

  ncolors++;
}

static Boolean
choose_color(xg, color_btn)
  xgobidata *xg;
  int color_btn;
{
  int i;
  Boolean is_cpainting;
/*
 * Turn off margin indicator on each menu item.
*/
  for (i=0; i<ncolors+1; i++)
    XtVaSetValues(color_menu_btn[i],
      XtNleftBitmap, None,
      NULL);
/*
 * Shade the menu button to indicate that it is presently inactive.
*/
  if (color_btn == 0)
    is_cpainting = False;
  else
  {
    is_cpainting = True;
    xg->color_id = (unsigned long) color_nums[color_btn-1];
  }

  XtVaSetValues(color_menu_btn[color_btn],
    XtNleftBitmap, menu_mark,
    NULL);

  return(is_cpainting);
}

/* ARGSUSED */
XtCallbackProc
choose_color_cback(w, xgobi, callback_data)
/*
 * Choose brushing color:  only available on color displays.
*/
  Widget w;
  XtPointer *xgobi;
  caddr_t callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;
  int j;
  int color_btn;

  for (j=0; j<ncolors+1; j++)
  {
    if (color_menu_btn[j] == w)
    {
      color_btn = j;
      break;
    }
  }

  if (xg->is_undo)
  {
    char message[200];
    sprintf(message, "Cannot change color when in undo brushing mode\n");
    show_message(message, xg);
  }
  else
  {
    xg->is_color_painting = choose_color(xg, color_btn);

    for (j=0; j<xg->nrows; j++)
    {
      xg->color_prev[j] = xg->color_ids[j];
    }

    plot_once(xg);
  }
}

static void
find_glyph_type_and_size(gid, glyph)
  int gid;
  glyphv *glyph;
{
  glyph->type = ( (gid-1) / (int) NGLYPHSIZES ) + 1 ;
  glyph->size = ( (gid-1) % (int) NGLYPHSIZES ) + 1 ;
}


static Boolean
choose_glyph(xg, glyph_btn)
  xgobidata *xg;
  int glyph_btn;
{
  Boolean is_gpainting;
  glyphv glyph;
  int i;

  for (i=0; i<NGLYPHS+1; i++)
    XtVaSetValues(glyph_menu_btn[i],
      XtNleftBitmap, None,
      NULL);

  if (glyph_btn == 0)
  {
    is_gpainting = False;
  }
  else
  {
    is_gpainting = True;

    find_glyph_type_and_size(glyph_btn, &glyph);
    xg->glyph_id.type = glyph.type ;
    xg->glyph_id.size = glyph.size ;
  }

  XtVaSetValues(glyph_menu_btn[glyph_btn],
    XtNleftBitmap, menu_mark,
    NULL);

  return(is_gpainting);
}

/* ARGSUSED */
XtCallbackProc
choose_glyph_cback(w, xgobi, callback_data)
  Widget w;
  XtPointer *xgobi;
  caddr_t callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;
  int j;
  int glyph_btn;

  for (j=0; j<NGLYPHS+1; j++)
  {
    if (glyph_menu_btn[j] == w)
    {
      glyph_btn = j;
      break;
    }
  }

  if (xg->is_undo)
  {
    char message[200];
    sprintf(message, "Cannot change glyph when in undo brushing mode\n");
    show_message(message, xg);
  }

  else
  {
    xg->is_glyph_painting = choose_glyph(xg, glyph_btn);

    for (j=0; j<xg->nrows; j++)
    {
      xg->glyph_prev[j].type = xg->glyph_ids[j].type;
      xg->glyph_prev[j].size = xg->glyph_ids[j].size;
    }
  }
}

void
make_color_menu(xg, parent)
  xgobidata *xg;
  Widget parent;
{
  int i, j;
  char clab[20];

/*
 * Menu for choosing the current brushing color.
*/
  color_menu_cmd = XtVaCreateManagedWidget("MenuButton",
    menuButtonWidgetClass, parent,
    XtNlabel, (String) "Color",
    XtNmenuName, (String) "Menu",
    NULL);
  if (mono)
  {
    set_mono(color_menu_cmd);
    XtVaSetValues(color_menu_cmd,
      XtNsensitive, (Boolean) False,
      NULL);
  }
  add_menupb_help(&xg->nhelpids.menupb,
    color_menu_cmd, "Br_ColorMenu");

  color_menu = XtVaCreatePopupShell("Menu",
    simpleMenuWidgetClass, color_menu_cmd,
    NULL);
/*
 * Color brushing starts out disabled for now ...
*/
  color_menu_btn[0] = XtVaCreateWidget("Command",
    smeBSBObjectClass, color_menu,
    XtNlabel, (String) "Disable Color Painting",
    XtNleftMargin, (Dimension) 24,
    NULL);

  for (j=0; j<ncolors; j++)
  {
    (void) sprintf((char *) clab, "%s", color_names[j]);
    color_menu_btn[j+1] = XtVaCreateWidget("Command",
      smeBSBObjectClass, color_menu,
      XtNlabel, (String) clab,
      XtNleftMargin, (Dimension) 24,
      XtNforeground, color_nums[j],
      NULL);
  }
  XtManageChildren(color_menu_btn, ncolors+1);

  for (i=0; i<ncolors+1; i++)
  {
    XtAddCallback(color_menu_btn[i], XtNcallback,
      (XtCallbackProc) choose_color_cback, (XtPointer) xg);
  }
}

void
make_glyph_menu(xg, parent)
  xgobidata *xg;
  Widget parent;
{
  int j;
  char *glyph_names[NGLYPHS];
/*
 * Menu for choosing the current brushing glyph.
*/
  glyph_menu_cmd = XtVaCreateManagedWidget("MenuButton",
    menuButtonWidgetClass, parent,
    XtNlabel, (String) "Glyph",
    XtNmenuName, (String) "Menu",
    NULL);
  if (mono) set_mono(glyph_menu_cmd);
  add_menupb_help(&xg->nhelpids.menupb,
    glyph_menu_cmd, "Br_GlyphMenu");

  glyph_menu = XtVaCreatePopupShell("Menu",
    simpleMenuWidgetClass, glyph_menu_cmd,
    NULL);
  if (mono) set_mono(glyph_menu);
/*
 * Set the background of the initial glyph.
*/
  glyph_menu_btn[0] = XtVaCreateWidget("Command",
    smeBSBObjectClass, glyph_menu,
    XtNlabel, (String) "Disable Glyph Painting",
    XtNleftMargin, (Dimension) 24,
    NULL);
  if (mono) set_mono(glyph_menu_btn[0]);

  for (j=0; j<NGLYPHS; j++)
    glyph_names[j] = (char *) XtMalloc((Cardinal) 30 * sizeof(char));

  strcpy(glyph_names[0],  "Tiny Plus (1)");
  strcpy(glyph_names[1],  "Small Plus (2)");
  strcpy(glyph_names[2],  "Medium Plus (3)");
  strcpy(glyph_names[3],  "Large Plus (4)");
  strcpy(glyph_names[4],  "Jumbo Plus (5)");
  strcpy(glyph_names[5],  "Tiny X (6)");
  strcpy(glyph_names[6],  "Small X (7)");
  strcpy(glyph_names[7],  "Medium X (8)");
  strcpy(glyph_names[8],  "Large X (9)");
  strcpy(glyph_names[9],  "Jumbo X (10)");
/* dfs addglyph */
  strcpy(glyph_names[10],  "Tiny Open Rectangle (11)");
  strcpy(glyph_names[11],  "Small Open Rectangle (12)");
  strcpy(glyph_names[12],  "Medium Open Rectangle (13)");
  strcpy(glyph_names[13],  "Large Open Rectangle (14)");
  strcpy(glyph_names[14],  "Jumbo Open Rectangle (15)");
  strcpy(glyph_names[15],  "Tiny Filled Rectangle (16)");
  strcpy(glyph_names[16],  "Small Filled Rectangle (17)");
  strcpy(glyph_names[17],  "Medium Filled Rectangle (18)");
  strcpy(glyph_names[18],  "Large Filled Rectangle (19)");
  strcpy(glyph_names[19],  "Jumbo Filled Rectangle (20)");
  strcpy(glyph_names[20],  "Tiny Open Circle (21)");
  strcpy(glyph_names[21],  "Small Open Circle (22)");
  strcpy(glyph_names[22],  "Medium Open Circle (23)");
  strcpy(glyph_names[23],  "Large Open Circle (24)");
  strcpy(glyph_names[24],  "Jumbo Open Circle (25)");
  strcpy(glyph_names[25],  "Tiny Filled Circle (26)");
  strcpy(glyph_names[26],  "Small Filled Circle (27)");
  strcpy(glyph_names[27],  "Medium Filled Circle (28)");
  strcpy(glyph_names[28],  "Large Filled Circle (29)");
  strcpy(glyph_names[29],  "Jumbo Filled Circle (30)");
  strcpy(glyph_names[30],  "Point (31)");

  for (j=0; j<NGLYPHS; j++)
  {
    glyph_menu_btn[j+1] = XtVaCreateWidget("Command",
      smeBSBObjectClass, glyph_menu,
      XtNlabel, (String) glyph_names[j],
      XtNleftMargin, (Dimension) 24,
      NULL);
    if (mono) set_mono(glyph_menu_btn[j+1]);
  }
  XtManageChildren(glyph_menu_btn, NGLYPHS+1);

  for (j=0; j<NGLYPHS+1; j++)
    XtAddCallback(glyph_menu_btn[j], XtNcallback,
      (XtCallbackProc) choose_glyph_cback, (XtPointer) xg);

  for (j=0; j<NGLYPHS; j++)
    XtFree((XtPointer) glyph_names[j]);
}

void
make_erase_menu(xg, parent)
/*
 * Build a menu to contain erase operations.
*/
  xgobidata *xg;
  Widget parent;
{
  int j;
  char *erase_names[4];

  erase_menu_cmd = XtVaCreateManagedWidget("MenuButton",
    menuButtonWidgetClass, parent,
    XtNlabel, (String) "Erase",
    XtNmenuName, (String) "Menu",
    NULL);
  if (mono) set_mono(erase_menu_cmd);
  add_menupb_help(&xg->nhelpids.menupb,
    erase_menu_cmd, "Br_EraseMenu");

  erase_menu = XtVaCreatePopupShell("Menu",
    simpleMenuWidgetClass, erase_menu_cmd,
    NULL);
  if (mono) set_mono(erase_menu);

  for (j=0; j<4; j++)
    erase_names[j] = (char *) XtMalloc((Cardinal) 25 * sizeof(char));

  strcpy(erase_names[0], "Complement");
  strcpy(erase_names[1], "Delete erased points");
  strcpy(erase_names[2], "Undelete erased points");
  strcpy(erase_names[3], "Restore erased points");

  for (j=0; j<4; j++)
  {
    erase_menu_btn[j] = XtVaCreateWidget("Command",
      smeBSBObjectClass, erase_menu,
      XtNlabel, (String) erase_names[j],
      NULL);
    if (mono) set_mono(erase_menu_btn[j]);
  }
  XtManageChildren(erase_menu_btn, 4);

  XtAddCallback(erase_menu_btn[0], XtNcallback,
    (XtCallbackProc) br_complement_cback, (XtPointer) xg);
  XtAddCallback(erase_menu_btn[1], XtNcallback,
    (XtCallbackProc) delete_erased_cback, (XtPointer) xg);
  XtAddCallback(erase_menu_btn[2], XtNcallback,
    (XtCallbackProc) undelete_erased_cback, (XtPointer) xg);
  XtAddCallback(erase_menu_btn[3], XtNcallback,
    (XtCallbackProc) reset_erase_cback, (XtPointer) xg);

  for (j=0; j<4; j++)
    XtFree((XtPointer) erase_names[j]);
}


void
make_reset_menu(xg, parent)
/*
 * Build a menu to contain brushing reset operations.
*/
  xgobidata *xg;
  Widget parent;
{
  int j;
  char *reset_names[4];

  reset_menu_cmd = XtVaCreateManagedWidget("MenuButton",
    menuButtonWidgetClass, parent,
    XtNlabel, (String) "Reset",
    XtNmenuName, (String) "Menu",
    NULL);
  if (mono) set_mono(reset_menu_cmd);
  add_menupb_help(&xg->nhelpids.menupb,
    reset_menu_cmd, "Br_ResetMenu");

  reset_menu = XtVaCreatePopupShell("Menu",
    simpleMenuWidgetClass, reset_menu_cmd,
    NULL);
  if (mono) set_mono(reset_menu);

  for (j=0; j<4; j++)
    reset_names[j] = (char *) XtMalloc((Cardinal) 25 * sizeof(char));

  strcpy(reset_names[0], "Reset brush size");
  strcpy(reset_names[1], "Reset point colors");
  strcpy(reset_names[2], "Reset line colors");
  strcpy(reset_names[3], "Reset glyphs");

  for (j=0; j<4; j++)
  {
    reset_menu_btn[j] = XtVaCreateWidget("Command",
      smeBSBObjectClass, reset_menu,
      XtNlabel, (String) reset_names[j],
      NULL);
    if (mono) set_mono(reset_menu_btn[j]);
  }
  XtManageChildren(reset_menu_btn, 4);

  XtAddCallback(reset_menu_btn[0], XtNcallback,
    (XtCallbackProc) reset_brush_cback, (XtPointer) xg);
  XtAddCallback(reset_menu_btn[1], XtNcallback,
    (XtCallbackProc) reset_point_colors_cback, (XtPointer) xg);
  XtAddCallback(reset_menu_btn[2], XtNcallback,
    (XtCallbackProc) reset_line_colors_cback, (XtPointer) xg);
  XtAddCallback(reset_menu_btn[3], XtNcallback,
    (XtCallbackProc) reset_glyphs_cback, (XtPointer) xg);

  for (j=0; j<4; j++)
    XtFree((XtPointer) reset_names[j]);
}

void
make_io_menu(xg, parent)
/*
 * Build a menu to contain brushing save operations.
*/
  xgobidata *xg;
  Widget parent;
{
  io_menu_cmd = XtVaCreateManagedWidget("MenuButton",
    menuButtonWidgetClass, parent,
    XtNlabel, (String) "I/O",
    XtNmenuName, (String) "Menu",
    NULL);
  if (mono) set_mono(io_menu_cmd);
  add_menupb_help(&xg->nhelpids.menupb,
    io_menu_cmd, "Br_IOMenu");

  io_menu = XtVaCreatePopupShell("Menu",
    simpleMenuWidgetClass, io_menu_cmd,
    NULL);
  if (mono) set_mono(io_menu);

  SAVE_POINT_INFO = XtVaCreateWidget("Command",
    smeBSBObjectClass, io_menu,
    XtNlabel, (String) "Save point glyphs and colors in files",
    NULL);
  if (mono) set_mono(SAVE_POINT_INFO);
  XtAddCallback(SAVE_POINT_INFO, XtNcallback,
    (XtCallbackProc) br_place_pts_popup, (XtPointer) xg);

  SAVE_LINE_INFO = XtVaCreateWidget("Command",
    smeBSBObjectClass, io_menu,
    XtNlabel, (String) "Save line colors in a file",
    NULL);
  if (mono) set_mono(SAVE_LINE_INFO);
  XtAddCallback(SAVE_LINE_INFO, XtNcallback,
    (XtCallbackProc) br_place_lines_popup, (XtPointer) xg);

  XtManageChildren(io_menu_item, 2);
}

void
make_brush(xg)
  xgobidata *xg;
{
/*
 * BrushPanel:  define but don't map.  It goes in the same spot
 * occupied by spin_panel[0].
*/
  PANEL0 = XtVaCreateManagedWidget("BrushPanel",
    boxWidgetClass, xg->box0,
    XtNleft, (XtEdgeType) XtChainLeft,
    XtNright, (XtEdgeType) XtChainLeft,
    XtNtop, (XtEdgeType) XtChainTop,
    XtNbottom, (XtEdgeType) XtChainTop,
    XtNmappedWhenManaged, (Boolean) False,
    XtNorientation, (XtOrientation) XtorientVertical,
    NULL);
  if (mono) set_mono(PANEL0);
/*
 * Button to turn active painting on and off.
*/
  brush_active_cmd = CreateToggle(xg, "Brush on",
    True, (Widget) NULL, (Widget) NULL, (Widget) NULL, True, ANY_OF_MANY,
    PANEL0, "Br_BrushOn");
  XtManageChild(brush_active_cmd);
  XtAddCallback(brush_active_cmd, XtNcallback,
    (XtCallbackProc) brush_active_cback, (XtPointer) xg);

/*
 * Panel for specifying line and/or point brushing.
*/
  PANEL1 = XtVaCreateManagedWidget("Panel",
    boxWidgetClass, PANEL0,
    XtNorientation, (XtOrientation) XtorientHorizontal,
    NULL);
  if (mono) set_mono(PANEL1);
  brush_points_cmd = CreateToggle(xg, "Points",
    True, (Widget) NULL, (Widget) NULL, (Widget) NULL, True, ANY_OF_MANY,
    PANEL1, "Br_PointsLines");
  XtManageChild(brush_points_cmd );
  XtAddCallback(brush_points_cmd, XtNcallback,
    (XtCallbackProc) brush_points_cback, (XtPointer) xg);
  brush_lines_cmd = CreateToggle(xg, "Lines",
    True, (Widget) NULL, (Widget) NULL, (Widget) NULL, False, ANY_OF_MANY,
    PANEL1, "Br_PointsLines");
  XtManageChild(brush_lines_cmd );
  XtAddCallback(brush_lines_cmd, XtNcallback,
    (XtCallbackProc) brush_lines_cback, (XtPointer) xg);
/*
 * Menus for choosing the brushing color and glyph.
*/
  make_color_menu(xg, PANEL0 );
  make_glyph_menu(xg, PANEL0 );
/*
 * Next, the labels to indicate the brushing type: persistent, transient,
 * undo.
*/
  PANEL2 = XtVaCreateManagedWidget("Panel",
    boxWidgetClass, PANEL0,
    XtNorientation, (XtOrientation) XtorientVertical,
    NULL);
  if (mono) set_mono(PANEL2);

  br_type[0] = CreateToggle(xg, "Persistent",
    True, (Widget) NULL, (Widget) NULL, (Widget) NULL, True, ONE_OF_MANY,
    PANEL2, "Brush_Modes");
  br_type[1] = CreateToggle(xg, "Transient",
    True, (Widget) NULL, (Widget) NULL, br_type[0], False, ONE_OF_MANY,
    PANEL2, "Brush_Modes");
  br_type[2] = CreateToggle(xg, "Undo",
    True, (Widget) NULL, (Widget) NULL, br_type[0], False, ONE_OF_MANY,
    PANEL2, "Brush_Modes");
  XtManageChildren(br_type, 3);

  XtAddCallback(br_type[0], XtNcallback,
    (XtCallbackProc) br_perst_cback, (XtPointer) xg);
  XtAddCallback(br_type[1], XtNcallback,
    (XtCallbackProc) br_trans_cback, (XtPointer) xg);
  XtAddCallback(br_type[2], XtNcallback,
    (XtCallbackProc) br_undo_cback, (XtPointer) xg);
/*
 * Panel to contain the erase commands
*/
  PANEL3 = XtVaCreateManagedWidget("Panel",
    boxWidgetClass, PANEL0,
    XtNorientation, (XtOrientation) XtorientVertical,
    NULL);
  if (mono) set_mono(PANEL3);

  erase_cmd = CreateToggle(xg, "Erase",
    True, (Widget) NULL, (Widget) NULL, (Widget) NULL, False, ANY_OF_MANY,
    PANEL3, "Brush_Erase");
  XtManageChild(erase_cmd);
  XtAddCallback(erase_cmd, XtNcallback,
    (XtCallbackProc) br_erase_cback, (XtPointer) xg);

  make_erase_menu(xg, PANEL3 );

  mk_group_var_cmd = CreateCommand(xg, "Make Group Var",
    True, (Widget) NULL, (Widget) NULL,
    PANEL0, "Br_MkGroupVar");
  XtManageChild(mk_group_var_cmd);
  XtAddCallback(mk_group_var_cmd, XtNcallback,
    (XtCallbackProc) br_save_to_group_var, (XtPointer) xg);

  br_update = CreateCommand(xg, "Send Update",
    True, (Widget) NULL, (Widget) NULL,
    PANEL0, "Br_SendUpdate");
  XtManageChild(br_update);
  XtAddCallback(br_update, XtNcallback,
    (XtCallbackProc) br_update_cback, (XtPointer) xg);

/*
 * Labels to indicate brushing commands: reset brush or points.
*/
  make_reset_menu(xg, PANEL0 );

  make_io_menu(xg, PANEL0 );

}

void
reset_br_types(xg)
  xgobidata *xg;
{
  XtVaSetValues(br_type[0],
    XtNsensitive, (Boolean) !xg->is_erase,
    XtNstate, (Boolean) xg->is_persistent,
    NULL);

  XtVaSetValues(br_type[1],
    XtNsensitive, (Boolean) !xg->is_erase,
    XtNstate, (Boolean) xg->is_transient,
    NULL);

  XtVaSetValues(br_type[2],
    XtNsensitive, (Boolean) !xg->is_erase,
    XtNstate, (Boolean) xg->is_undo,
    NULL);
}

void
init_brush_menus()
{
/*
Not sure whether this section is needed; leave it in place
but commented out.
  int i;
 * Turn off margin indicator on each menu item.
  for (i=0; i<ncolors+1; i++)
    XtVaSetValues(color_menu_btn[i],
      XtNleftBitmap, None,
      NULL);
  for (i=0; i<NGLYPHS+1; i++)
    XtVaSetValues(glyph_menu_btn[i],
      XtNleftBitmap, None,
      NULL);
*/

/*
 * Now add the mark beside the default values.
*/
  XtVaSetValues(color_menu_btn[0],
    XtNleftBitmap, menu_mark,
    NULL);
  XtVaSetValues(glyph_menu_btn[0],
    XtNleftBitmap, menu_mark,
    NULL);
}

void
map_brush(xg, brushon)
  xgobidata *xg;
  int brushon;
{
  if (brushon)
  {
    XtMapWidget( PANEL0 );
    XtMapWidget( xg->brush_mouse );
  }
  else
  {
    XtUnmapWidget( PANEL0 );
    XtUnmapWidget(xg->brush_mouse);
  }
}

int
read_brush_indices(data_in, xg)
  char *data_in;
  xgobidata *xg;
{
  int ok = 1;
  char  lab_file[100];
  int i, found;
  char color_name[20];
  int gid;
  glyphv glyph;
  FILE *fopen(), *fp;

  if (strcmp(data_in,"stdin") != 0)
  {
  /*
   * Check if glyphs file exists.
  */
    (void) strcpy(lab_file, data_in);
    (void) strcat(lab_file, ".glyphs");
    if ( (fp = fopen(lab_file,"r")) != NULL)
      found = 1;
    else
      found = 0;

    if (!found)
      init_glyph_ids(xg);
    else
    {
      for (i=0; i<xg->nrows; i++)
      {
        if (fscanf(fp, "%d", &gid) > 0)
        {
          (void) find_glyph_type_and_size(gid, &glyph);
          xg->glyph_ids[i].type = xg->glyph_now[i].type =
            xg->glyph_prev[i].type = glyph.type;
          xg->glyph_ids[i].size = xg->glyph_now[i].size =
            xg->glyph_prev[i].size = glyph.size;
        }
        else
        {
/* not changing this one; reading before xgobi startup */
          (void) fprintf(stderr, "Error in reading %s; using defaults.\n",
            lab_file);

          init_glyph_ids(xg);
          break;
        }
      }
      fclose(fp);
    }

  /*
   * If color, check if colors file exists.
  */
    if (!mono)
    {
      Colormap cmap = DefaultColormap(display, DefaultScreen(display));
      XColor exact;

      (void) strcpy(lab_file, data_in);
      (void) strcat(lab_file, ".colors");
      if ( (fp = fopen(lab_file,"r")) != NULL)
        found = 1;
      else
        found = 0;

      if (!found)
        init_color_ids(xg);
      else
      {
        xg->got_new_paint = True;
        for (i=0; i<xg->nrows; i++)
        {
          if (fscanf(fp, "%s", color_name) > 0)
          {
            if (strcmp(color_name, "Default") == 0)
            {
              xg->color_ids[i] = xg->color_now[i] =
                xg->color_prev[i] = plotcolors.fg;
            }
            else if
              (XParseColor(display, cmap, color_name, &exact) &&
               XAllocColor(display, cmap, &exact) )
            {
              xg->color_ids[i] = xg->color_now[i] =
                xg->color_prev[i] = exact.pixel;
            }
            else
            {
              fprintf(stderr, "Error in reading %s; using defaults.\n",
                lab_file);
              init_color_ids(xg);
              break;
            }
          }
        }
        fclose(fp);
      }
    }
  }

  else
  {
    init_glyph_ids(xg);
    if (!mono)
    	init_color_ids(xg);
  }

  return(ok);
}

Boolean
read_line_colors(data_in, literal, xg)
  char *data_in;
  Boolean literal;
  xgobidata *xg;
{
  int i;
  Boolean ok = False;
  char  lab_file[100];
  char color_name[20];
  FILE *fopen(), *fp;
  Colormap cmap = DefaultColormap(display, DefaultScreen(display));
  XColor exact;

  if (strcmp(data_in,"stdin") != 0)
  {
    if (!mono)
    {
      /*
       * Check if line colors file exists.
      */
      (void) strcpy(lab_file, data_in);
      if (literal == False)
        (void) strcat(lab_file, ".linecolors");
      fp = fopen(lab_file, "r") ;
      if (fp == NULL)
        return(False);
      else   /*  if (fp != NULL) */
      {
        xg->got_new_paint = True;
        ok = True;
        for (i=0; i<xg->nlinks; i++)
        {
          if (fscanf(fp, "%s", color_name) > 0)
          {
            if (strcmp(color_name, "Default") == 0)
            {
              xg->line_color_ids[i] = xg->line_color_now[i] =
                xg->line_color_prev[i] = plotcolors.fg;
            }
            else if
              (XParseColor(display, cmap, color_name, &exact) &&
               XAllocColor(display, cmap, &exact) )
            {
              xg->line_color_ids[i] = xg->line_color_now[i] =
                xg->line_color_prev[i] = exact.pixel;
            }
            else
            {
              fprintf(stderr, "Error in reading %s; using defaults.\n",
                lab_file);
              ok = False;
              break;
            }
          }
        }
        fclose(fp);
      }
    }
  }
  return(ok);
}



#undef PANEL0
#undef PANEL1
#undef PANEL2
#undef PANEL3
