/*
 * $Id: udfloat.c,v 2.5 1991/04/10 19:29:09 steve Exp $
 *
 * $__Header$
 */

/*LINTLIBRARY*/

#include "udposix.h"
#include <stdio.h>
#include <string.h>
#include "udres.h"
#include "uderrmsg.h"

extern char	*udstrdup();


/*
 * Convert a float.
 */
int
UdFloat(str, bin, mode)
    VOIDP	str;
    VOIDP	bin;
    int		mode;
{
    int		status	= 1;
    static char	me[]	= "UdFloat";

    if (mode == UD_MNEMONIC) {
	*(char**)str	= "float";

    } else if (mode == UD_POINTER) {
	*(float**)bin	= (float*)str;

    } else if (mode == UD_BIN_SIZE) {
	status	= sizeof(float);

    } else if (mode == UD_TO_STRING) {
	char	buf[80];

	(void)sprintf(buf, "%f", *(float*)bin);
	*(char**)str	= udstrdup(buf);

    } else if (mode == UD_TO_BINARY) {
	if (str != NULL) {
	    float	val;

	    if (sscanf((char*)str, "%f", &val) != 1) {
		udadvise("%s: \"%s\" is an invalid float.", me, (char*)str);
		status	= 0;
	    } else if (bin != NULL) {
		*(float*)bin	= val;
	    }
	}

    } else {
	status	= 0;
    }

    return status;
}
