/*
 * $Id: udposix.h,v 1.5 1991/06/28 16:49:31 steve Exp $
 * $__Header$
 *
 * Header-file for the SunOS 4.1 version of the Unidata POSIX
 * programming environment.
 */

#ifndef UDPOSIX_H_INCLUDED
#define	UDPOSIX_H_INCLUDED

#define	_POSIX_SOURCE

/*
 * Set NDEBUG according to DEBUG.
 */
#ifdef DEBUG
#   undef NDEBUG
#else
#   define NDEBUG
#endif

typedef	int		bool;
#define	NO		0
#define	YES		1
typedef	void		*VOIDP;
typedef	void		*voidp;
#define FREE_ARG	void*			/* argument to free(3) */

/*
 *	Macro for declaring functions regardless of the availability of 
 *	function prototypes.  NB: will need double parens in actual use (e.g.
 *	"int func PROTO((int a, char *cp))").
 */
#if defined(__STDC__) || defined(__GNUC__) \
    || defined(__cplusplus) || defined(c_plusplus)
#   define	PROTO(a)	a
#else
#   define	PROTO(a)	()
#endif

#if defined(__STDC__) || defined(__GNUC__) \
    || defined(__cplusplus) || defined(c_plusplus)
#   define	MAKESTRING(s)	# s
#   define	GLUE(a,b)	a##b
#else
#   define	volatile
#   define	const
#   define	signed
#   define	MAKESTRING(s)	"s"
#   define	GLUE(a,b)	a/**/b
#if 0
#   define UD_IDENT(x)	x
#   define GLUE(a,b)	UD_IDENT(a)b		/* alternative definition */
#endif
#endif

#endif	/* UDPOSIX_H_INCLUDED not defined */
