/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/



/*
 *                  File: X_ide_keyboard.c
 *                  Author: He, Taosong
 *                  Date: 1/19/93
 *           Description: The C routines of selection queue operations
 *
 *         who?         when?           why?
 *    -----------------------------------------------------------
 *
 */


/******************************************************************/
/*                The standard C include file                     */
/******************************************************************/

#include <varargs.h>
#include <stdio.h>

/******************************************************************/
/*                  VolVis include file                           */
/******************************************************************/

#include "C_ide.h"
#include "MOTIF_windefs.h"

C_IDE_keyboard_lookup keyboard_lookup[C_MAX_OPERATION_NUMBER];

void C_lookup_keyboard_op_map(event, operation_number)
XKeyEvent *event;
int *operation_number;
{
       int i;
       *operation_number = -1;

       for (i=0; i<C_MAX_OPERATION_NUMBER; i++)
        {
         if (keyboard_lookup[i].flag != -1)
          {
           if ((keyboard_lookup[i].state == event->state) &&
               (keyboard_lookup[i].keycode == event->keycode))
            {
              *operation_number = i;
              break;
            }
          }
        }
}
         


