/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/




/*
 *			File: MOTIF_oco_ui.c
 *		      Author: Lisa Sobierajski 
 *			Date: 03/07/92
 *		 Description: Motif Windowing Routines Of The Object Properties 
 *	Modification History:
 *
 *		Who?		When?		Why?
 *	--------------------------------------------------------------------
 *
 */

#include <stdio.h>
#include <math.h>
#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <X11/StringDefs.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/BulletinB.h>
#include <Xm/LabelG.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/DrawingA.h>
#include <Xm/Frame.h>
#include <Xm/Scale.h>

#include "C_volvis.h"
#include "MOTIF_windefs.h"
#include "C_help.h"
#include "C_oco.h"

/* Global Variables For Motif Windowing */
extern Widget			vv_toplevel;	/* Bulletin Board Dialog */
extern C_WindowDefs		window_defs;
extern C_World			world;
extern C_ObjectControlInfo	oco_info;


void oco_create_world_display()
{
	extern void			close_callback();
	extern void			help_callback();
	extern void			oco_set_bkgrnd_color();
	extern void			oco_set_ambient_color();
	extern void			oco_set_ambient_coef();
	extern void			oco_reset_bkgrnd_color();
	extern void			oco_reset_ambient_color();
	extern void			oco_reset_ambient_coef();
	extern C_ColorSelectInfo	*C_create_color_selection();	

	void		oco_update_world_display();

	Arg		args[20];
	int		n;
	Widget		label;
	Widget		slider;
	Widget		frame;
	Widget		rowcolumn;
	Widget		button;
	Widget		ambient_bboard;
	XmString	label_string;
	C_ColorSelectInfo	*ambient_info,
				*background_info;


	n=0;
        XtSetArg( args[n], XmNautoUnmanage, False ); n++;
        C_Set_Color_Dialog( args, n, window_defs );
        oco_info.world_info.world_displayed = 
			XmCreateBulletinBoardDialog( vv_toplevel,
                       "World Info", args, n );

	n = 0;
	XtSetArg( args[n], XmNx, 0 ); n++;
	XtSetArg( args[n], XmNy, 0 ); n++;
	C_Set_Color_Frame( args, n, window_defs );
	frame = XmCreateFrame( oco_info.world_info.world_displayed, 
			"frame", args, n );
	XtManageChild( frame );


	n=0;
	XtSetArg( args[n], XmNeditable, FALSE ); n++;
	XtSetArg( args[n], XmNeditMode, XmMULTI_LINE_EDIT ); n++;
	XtSetArg( args[n], XmNsensitive, FALSE ); n++;
	XtSetArg( args[n], XmNcursorPositionVisible, FALSE ); n++;
	XtSetArg( args[n], XmNrows, 10 ); n++;
	XtSetArg( args[n], XmNcolumns, 45 ); n++;
	C_Set_Color_Bboard( args, n, window_defs );

	oco_info.world_info.world_text = XmCreateText(frame,
			"World Text", args, n );

	XtManageChild( oco_info.world_info.world_text );

        n = 0;
        XtSetArg( args[n], XmNx, 0 ); n++;
        XtSetArg( args[n], XmNy, 230 ); n++;
	C_Set_Color_Frame( args, n, window_defs );
        frame = XmCreateFrame( oco_info.world_info.world_displayed, "frame",
                                         args, n );

	XtManageChild( frame );

	/****  Put a bulletin board in frame ****/
        n=0;
	C_Set_Color_Bboard( args, n, window_defs );
        ambient_bboard = XmCreateBulletinBoard( frame, "ambient_bboard",
                                             args, n );
        XtManageChild( ambient_bboard );


        /************************************************/
        /*     Create The Ambient Slider Label          */
        /************************************************/
        label_string = XmStringCreate("Ambient Coeffient: ", 
			              XmSTRING_DEFAULT_CHARSET );
        n=0;
        XtSetArg( args[n], XmNx, 10 ); n++;
        XtSetArg( args[n], XmNy, 25 ); n++;
        XtSetArg( args[n], XmNlabelString, label_string ); n++;
        label = XmCreateLabelGadget( ambient_bboard, 
					     "Ambient Coeffient:", 
					     args, n );
        XtManageChild( label );
        XmStringFree( label_string );



	n = 0;
	XtSetArg( args[n], XmNorientation, XmHORIZONTAL ); n++;
	XtSetArg( args[n], XmNminimum, 0 ); n++;
	XtSetArg( args[n], XmNmaximum, 100 ); n++;
	XtSetArg( args[n], XmNdecimalPoints, 2 ); n++;
	XtSetArg( args[n], XmNshowValue, TRUE ); n++;
	XtSetArg( args[n], XmNvalue, 
			(int)( 100 * world.world_shade.ambient_coef ) ); n++;
	XtSetArg( args[n], XmNscaleMultiple, 1 ); n++;
        XtSetArg( args[n], XmNscaleWidth, 200 ); n++;
        XtSetArg( args[n], XmNx, 150 ); n++;
        XtSetArg( args[n], XmNy, 0 ); n++;
	C_Set_Color_Scale( args, n, window_defs );
	slider = XtCreateManagedWidget("Ambient: ",
			xmScaleWidgetClass, ambient_bboard, args, n );


	ambient_info = 
		C_create_color_selection( oco_info.world_info.world_displayed, 
				  0, 310, 
				  "Ambient Color:", "",
				  &(world.world_shade.ambient_color) );

	background_info = 
		C_create_color_selection( oco_info.world_info.world_displayed, 
				  0, 450, 
				  "Background", "      Color:",
				  &(world.world_shade.bkgrnd_color) );

	oco_info.world_info.ambient_slider = slider;
	oco_info.world_info.ambient_info = ambient_info;
	oco_info.world_info.background_info = background_info;

	n = 0;
	XtSetArg( args[n], XmNx, 0 ); n++;
	XtSetArg( args[n], XmNy, 600 ); n++;
	C_Set_Color_Frame( args, n, window_defs );
	frame = XmCreateFrame( oco_info.world_info.world_displayed,
			"frame", args, n );
	XtManageChild( frame );

	/********************************************************/		
	/*	Create a RowColumn for Close and Help		*/
	/********************************************************/		
        n = 0;
	XtSetArg( args[n], XmNorientation, XmHORIZONTAL ); n++;
	C_Set_Color_RowColumn( args, n, window_defs );
        rowcolumn = 
		XmCreateRowColumn(frame, "rowcolumn", args, n);
        XtManageChild (rowcolumn);

	n = 0;
	C_Set_Color_Button( args, n, window_defs );
	button = XtCreateManagedWidget("Accept", 
			xmPushButtonWidgetClass, rowcolumn, args, n );

	XtAddCallback( button, XmNactivateCallback, 
		       oco_set_bkgrnd_color, background_info );
	
	XtAddCallback( button, XmNactivateCallback, 
		       oco_set_ambient_color, ambient_info );

	XtAddCallback( button, XmNactivateCallback, 
		       oco_set_ambient_coef, slider );

	
	n = 0;
	C_Set_Color_Button( args, n, window_defs );
	button = XtCreateManagedWidget("Cancel", 
			xmPushButtonWidgetClass, rowcolumn, args, n );

	XtAddCallback( button, XmNactivateCallback, 
		       oco_reset_bkgrnd_color, background_info );
	
	XtAddCallback( button, XmNactivateCallback, 
		       oco_reset_ambient_color, ambient_info );

	XtAddCallback( button, XmNactivateCallback, 
		       oco_reset_ambient_coef, slider );

	n=0;
	C_Set_Color_Button( args, n, window_defs );
	button = XtCreateManagedWidget( "Close", 
		xmPushButtonWidgetClass, rowcolumn, args, n );
	XtAddCallback( button, XmNactivateCallback,
		       close_callback, oco_info.world_info.world_displayed );

	n = 0;
	C_Set_Color_Button( args, n, window_defs );
	button = XtCreateManagedWidget("Help", 
			xmPushButtonWidgetClass, rowcolumn, args, n );
	XtAddCallback( button, XmNactivateCallback,
		       help_callback, C_OCO_MODIFY_WORLD_HELP );



	XtManageChild( oco_info.world_info.world_displayed );

	oco_update_world_display();
}

void oco_update_world_display()
{
	extern void	nav_update();

	XmTextPosition	last;
	char		string[100];

	nav_update();

	if (!oco_info.world_info.world_text) return;

	last = XmTextGetLastPosition( oco_info.world_info.world_text );

	sprintf( string, "Coordinate System:\n\n" );

	XmTextInsert( oco_info.world_info.world_text, last, string );	

	last = XmTextGetLastPosition( oco_info.world_info.world_text );

	sprintf( string, "     Origin: (%3.2f, %3.2f, %3.2f)\n",
		world.orig_c_sys.origin.x,
		world.orig_c_sys.origin.y,
		world.orig_c_sys.origin.z );

	XmTextInsert( oco_info.world_info.world_text, last, string );	

	last = XmTextGetLastPosition( oco_info.world_info.world_text );

	sprintf( string, "     X Axis: (%3.2f, %3.2f, %3.2f)\n", 
		world.orig_c_sys.x_axis.x,
		world.orig_c_sys.x_axis.y,
		world.orig_c_sys.x_axis.z );

	XmTextInsert( oco_info.world_info.world_text, last, string );	

	last = XmTextGetLastPosition( oco_info.world_info.world_text );

	sprintf( string, "     Y Axis: (%3.2f, %3.2f, %3.2f)\n", 
		world.orig_c_sys.y_axis.x,
		world.orig_c_sys.y_axis.y,
		world.orig_c_sys.y_axis.z );

	XmTextInsert( oco_info.world_info.world_text, last, string );	

	last = XmTextGetLastPosition( oco_info.world_info.world_text );

	sprintf( string, "     Z Axis: (%3.2f, %3.2f, %3.2f)\n\n", 
		world.orig_c_sys.z_axis.x,
		world.orig_c_sys.z_axis.y,
		world.orig_c_sys.z_axis.z );

	XmTextInsert( oco_info.world_info.world_text, last, string );	

	last = XmTextGetLastPosition( oco_info.world_info.world_text );

	sprintf( string, "Number of Volumes: %d\n\n", 
		world.num_volumes);

	XmTextInsert( oco_info.world_info.world_text, last, string );	

	last = XmTextGetLastPosition( oco_info.world_info.world_text );

	sprintf( string, "Number of  Lights: %d\n", 
		world.num_lights);

	XmTextInsert( oco_info.world_info.world_text, last, string );	


}



void oco_set_bkgrnd_color( w, client_data, call_data )
Widget                  w;
C_ColorSelectInfo       *client_data;
XtPointer               call_data;
{
	int		tmp_val;


        XmScaleGetValue( client_data->red_slider, &tmp_val );
	world.world_shade.bkgrnd_color.red = tmp_val;	

        XmScaleGetValue( client_data->green_slider, &tmp_val );
	world.world_shade.bkgrnd_color.green = tmp_val;	

        XmScaleGetValue( client_data->blue_slider, &tmp_val );
	world.world_shade.bkgrnd_color.blue = tmp_val;	

}

void oco_set_ambient_color( w, client_data, call_data )
Widget                  w;
C_ColorSelectInfo       *client_data;
XtPointer               call_data;
{
	int		tmp_val;


        XmScaleGetValue( client_data->red_slider, &tmp_val );
	world.world_shade.ambient_color.red = tmp_val;	

        XmScaleGetValue( client_data->green_slider, &tmp_val );
	world.world_shade.ambient_color.green = tmp_val;	

        XmScaleGetValue( client_data->blue_slider, &tmp_val );
	world.world_shade.ambient_color.blue = tmp_val;	
}

void oco_set_ambient_coef( w, client_data, call_data )
Widget                  w;
Widget       		client_data;
XtPointer               call_data;
{
	int		tmp_val;


        XmScaleGetValue( client_data, &tmp_val );
	world.world_shade.ambient_coef = (float)(tmp_val)/100.0;	
}

void oco_reset_bkgrnd_color( w, client_data, call_data )
Widget                  w;
C_ColorSelectInfo       *client_data;
XtPointer               call_data;
{

        XmScaleSetValue( client_data->red_slider, 
			 (int)(world.world_shade.bkgrnd_color.red) );

        XmScaleSetValue( client_data->green_slider, 
			 (int)(world.world_shade.bkgrnd_color.green) );

        XmScaleSetValue( client_data->blue_slider, 
			 (int)(world.world_shade.bkgrnd_color.blue) );

        C_change_color(  client_data->red_slider,
                         client_data, NULL );

}

void oco_reset_ambient_color( w, client_data, call_data )
Widget                  w;
C_ColorSelectInfo       *client_data;
XtPointer               call_data;
{

        XmScaleSetValue( client_data->red_slider, 
			 (int)(world.world_shade.ambient_color.red) );

        XmScaleSetValue( client_data->green_slider, 
			 (int)(world.world_shade.ambient_color.green) );

        XmScaleSetValue( client_data->blue_slider, 
			 (int)(world.world_shade.ambient_color.blue));

        C_change_color(  client_data->red_slider,
                         client_data, NULL );
}

void oco_reset_ambient_coef( w, client_data, call_data )
Widget                  w;
Widget       		client_data;
XtPointer               call_data;
{

        XmScaleSetValue( client_data, 
			 (int)(100*world.world_shade.ambient_coef) );
}

