/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/




/*
 *			File: MOTIF_nav_wf.c
 *		      Author: Rick Avila 
 *			Date: 08/15/92
 *		 Description: Motif Windowing Routines Of The 
 *			      Navigator Wireframe Window  
 *	Modification History:
 *
 *		Who?		When?		Why?
 *	--------------------------------------------------------------------
 *
 */

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/BulletinB.h>
#include <Xm/DrawingA.h>
#include <Xm/MainW.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>

#include "C_volvis.h"
#include "C_navigator.h"
#include "MOTIF_windefs.h"
#include "C_help.h"

/* Global Variables For Motif Windowing */
extern Widget		vv_toplevel;
extern Widget		nav_wf_bbdialog;
extern C_WindowDefs	window_defs;

extern void	close_callback();
extern void	help_callback();

nav_create_wf_window()
{
	Arg		args[20];	/* Argument List */
	int		n;		/* Argument Count */

	Widget		frame;
	Widget		rowcol;
	Widget		wf_drawing_area;
	Widget		wf_key_drawing_area;
	Widget		button;
	XmString	label_string;
	
	extern Widget	create_wf_drawing_area();
	extern Widget	create_wf_key_drawing_area();

	/*************************************************/		
	/* Create The Navigator Wireframe Bulletin Board */
	/*************************************************/		
	n=0;
	XtSetArg( args[n], XmNx, 0 ); n++;
	XtSetArg( args[n], XmNy, 0 ); n++;
	XtSetArg( args[n], XmNautoUnmanage, False ); n++;
	C_Set_Color_Dialog( args, n, window_defs );
	label_string = XmStringCreate( "Navigator Wireframe", 
					XmSTRING_DEFAULT_CHARSET);
        XtSetArg( args[n], XmNdialogTitle, label_string ); n++;
	nav_wf_bbdialog = XmCreateBulletinBoardDialog( vv_toplevel,
		"Navigator Wireframe", args, n );

	/*************************************************************/
	/*	Create A Frame For Wireframe Projection Drawing Area */
	/*************************************************************/
	n=0;
	XtSetArg( args[n], XmNx, 0 ); n++;
	XtSetArg( args[n], XmNy, 0 ); n++;
	C_Set_Color_Frame( args, n, window_defs );
	frame = XmCreateFrame( nav_wf_bbdialog, "nav_wf_frame", args, n );
	XtManageChild( frame );

	/********************************************************/		
	/*	Create a Drawing Area For Wireframe Projection	*/
	/********************************************************/		
	wf_drawing_area = create_wf_drawing_area( frame );

	/******************************************************/
	/*	Create A Frame For Wireframe Key Drawing Area */
	/******************************************************/
	n=0;
	XtSetArg( args[n], XmNx, 0 ); n++;
	XtSetArg( args[n], XmNy, 340 ); n++;
	C_Set_Color_Frame( args, n, window_defs );
	frame = XmCreateFrame( nav_wf_bbdialog, "nav_wf_key_frame", args, n );
	XtManageChild( frame );

	/*****************************************************/		
	/*	Create a Drawing Area For Wireframe Keys     */
	/*****************************************************/		
	wf_key_drawing_area = create_wf_key_drawing_area( frame );

	/************************************************/
	/*     Create The Close Button			*/
	/************************************************/
	n=0;
	XtSetArg( args[n], XmNx, 10 ); n++;
	XtSetArg( args[n], XmNy, 500 ); n++;
	C_Set_Color_Button( args, n, window_defs );
	button = XmCreatePushButton( nav_wf_bbdialog, "Close", args, n );
	XtManageChild( button );

	XtAddCallback( button, XmNactivateCallback, close_callback, 
			nav_wf_bbdialog );

	/************************************************/
	/*     Create The Help Button			*/
	/************************************************/
	n=0;
	XtSetArg( args[n], XmNx, 110 ); n++;
	XtSetArg( args[n], XmNy, 500 ); n++;
	C_Set_Color_Button( args, n, window_defs );
	button = XmCreatePushButton( nav_wf_bbdialog, "Help", args, n );
	XtManageChild( button );
	XtAddCallback(  button, XmNactivateCallback,
                        help_callback, C_NAV_WIREFRAME_HELP );

	XtManageChild( nav_wf_bbdialog );
}

/********************************************************/
/*							*/
/*		Wireframe Callbacks			*/
/*							*/
/********************************************************/
void nav_wf_expose_CB(w, client_data, call_data)
Widget		w;
int		client_data;
XtPointer	call_data;
{
	static int	first_call = TRUE;

	extern void	nav_wf_init();
        extern void 	nav_wireframe_draw();

	/**********************************************/
	/* Check To See If This Is The First Expose   */
	/* If So, Then Initialize The GL Drawing Area */
	/**********************************************/
	if( first_call )
	{
		/* Initialize The Navigator Wireframe Window */
		nav_wf_init();

		first_call = FALSE;
	}

        if( !(XtIsManaged(w)) )
                return;

        /* Draw The Contents Of The Navigator Wireframe Window */
        nav_wireframe_draw( C_NAV_WIREFRAME );
}

void nav_wf_resize_CB(w, client_data, call_data)
Widget          w;
int             client_data;
caddr_t         call_data;
{
        extern void	nav_wireframe_draw();

        nav_wireframe_draw( C_NAV_WIREFRAME );
}

void nav_wf_input_CB( w, client_data, event )
Widget		w;
XtPointer	client_data;
XEvent		*event;
{
	void	nav_fly();

	switch( event->type )
	{
		case KeyPress:
			break;
		case ButtonPress:
			break;
		case ButtonRelease:
			switch(event->xbutton.button)
			{
		  	   case Button1:
				nav_fly( w );
				break;
			}
			break;
		case MotionNotify:
			break;
	}

}

/********************************************************/
/*							*/
/*		Wireframe Key Callbacks			*/
/*							*/
/********************************************************/
void nav_wf_key_expose_CB(w, client_data, call_data)
Widget		w;
int		client_data;
XtPointer	call_data;
{
	static int	first_call = TRUE;

	extern void	nav_wf_key_init();
        extern void 	nav_wireframe_key_draw();

	/**********************************************/
	/* Check To See If This Is The First Expose   */
	/* If So, Then Initialize The GL Drawing Area */
	/**********************************************/
	if( first_call )
	{
		/* Initialize The Navigator Wireframe Key Window */
		nav_wf_key_init();

		first_call = FALSE;
	}

        if( !(XtIsManaged(w)) )
                return;

        /* Draw The Contents Of The Navigator Wireframe Key Window */
        nav_wireframe_key_draw();
}

void nav_wf_key_resize_CB(w, client_data, call_data)
Widget          w;
int             client_data;
caddr_t         call_data;
{
        extern void	nav_wireframe_key_draw();

        nav_wireframe_key_draw();
}
