/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/




/*
 *                  File: MOTIF_ide_spaceball_panel.c
 *                Author: Theodossiou, Andreas
 *                  Date: 05/11/1993
 *           Description: MOTIF routines for Spaceball panel creation
 *  Modification History:
 *
 *         who?               when?           why?
 *    -----------------------------------------------------------
 * 
 */
/******************************************************************/
/*                The standard C include files                    */
/******************************************************************/
# include <stdio.h>
# include <string.h>



/******************************************************************/
/*               The MOTIF include files                          */
/******************************************************************/
# include <X11/Intrinsic.h>
# include <X11/Shell.h>
# include <X11/Xlib.h>
# include <X11/Xutil.h>
# include <Xm/Xm.h>
# include <Xm/RowColumn.h>
# include <Xm/Frame.h>
# include <Xm/Form.h>
# include <Xm/ToggleBG.h>
# include <Xm/ToggleB.h>
# include <Xm/Text.h>
# include <Xm/TextF.h>
# include <Xm/PushB.h>
# include <Xm/PushBG.h>
# include <Xm/LabelG.h>
# include <Xm/CascadeB.h>
# include <Xm/BulletinB.h>
# include <Xm/FileSB.h>
# include <Xm/SelectioB.h>
# include <Xm/DialogS.h>
# include <Xm/MessageB.h>
# include <Xm/Scale.h>



/******************************************************************/
/*                  VolVis include files                          */
/******************************************************************/
#include "C_volvis.h"
#include "MOTIF_windefs.h"
#include "C_ide.h"

Widget spaceball_token_bulletin;

extern C_IDE_simulation_method C_ide_simulation_method;

void set_spaceball_translation_mode(w, client_data, call_data)
Widget w;
int client_data;
caddr_t *call_data;
{
    switch (client_data)
     {
       case 0: 
         C_ide_simulation_method.spaceball.translate_dominate = 0;
         break;
       case 1:
         C_ide_simulation_method.spaceball.translate_dominate = 1;
         break;
       case 2:
         C_ide_simulation_method.spaceball.translate_dominate = 2;
         break;
      }
}

void set_spaceball_rotation_mode(w, client_data, call_data)
Widget w;
int client_data;
caddr_t *call_data;
{
    switch (client_data)
     {
       case 0:
         C_ide_simulation_method.spaceball.rotation_dominate = 0;
         break;
       case 1:
         C_ide_simulation_method.spaceball.rotation_dominate = 1;
         break;
       case 2:
         C_ide_simulation_method.spaceball.rotation_dominate = 2;
         break;
     }
}

void set_spaceball_speed_mode(w, client_data, call_data)
Widget w;
int client_data;
caddr_t *call_data;
{
   if (!client_data)
    {
      C_ide_simulation_method.spaceball.acceleration_velocity_mode
            = C_VELOCITY_MODE;
    }
   else
      C_ide_simulation_method.spaceball.acceleration_velocity_mode 
         = C_ACCELERATION_MODE;
}

void set_spaceball_translation_rate(w, client_data, call_data)
Widget w;
int client_data;
XmScaleCallbackStruct *call_data;
{
   C_ide_simulation_method.spaceball.translation_rate = 
             call_data->value*0.0001;
}

void set_spaceball_rotation_rate(w, client_data, call_data)
Widget w;
int client_data;
XmScaleCallbackStruct *call_data;
{
   C_ide_simulation_method.spaceball.rotation_rate = 
            call_data->value*0.000001;
}

void create_spaceball_mode(parent)
Widget parent;
{
    extern  C_WindowDefs     window_defs;
    Arg args[20];
    XmString string;
    int n;

    Widget translation_pulldown;
    Widget translation_options[3];
    Widget translation_menu;

    Widget rotation_pulldown;
    Widget rotation_options[3];
    Widget rotation_menu;

    Widget speed_pulldown;
    Widget speed_options[2];
    Widget speed_menu;

    Widget frame, form, rc, flabel[3];

   
    n = 0;
    XtSetArg( args[n], XmNx, 10); n++;
    XtSetArg( args[n], XmNy, 110); n++;
    C_Set_Color_Frame( args, n, window_defs );
    frame = XmCreateFrame(parent, "frame", args, n );
    XtManageChild( frame );

    n = 0;
    C_Set_Color_RowColumn( args, n, window_defs );
    form = XmCreateForm(frame, "form", args, n);
    XtManageChild (form);

    n =0;
    C_Set_Color_RowColumn( args, n, window_defs );
    XtSetArg(args[n], XmNtopAttachment, XmATTACH_POSITION); n++;
    XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNleftAttachment, XmATTACH_POSITION); n++;
    XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION); n++;
    XtSetArg(args[n], XmNleftPosition, 40); n++;
    XtSetArg(args[n], XmNrightPosition, 100); n++;
    XtSetArg(args[n], XmNtopPosition,1); n++;
    XtSetArg(args[n], XmNbottomPosition, 99); n++;
    XtSetArg(args[n], XmNorientation, XmVERTICAL); n++;
    XtSetArg(args[n], XmNpacking, XmPACK_COLUMN); n++;
    XtSetArg(args[n], XmNnumColumns, 1); n++;
    rc = XmCreateRowColumn(form, "rc", args, n);
    XtManageChild (rc);

    n = 0;
    XtSetArg(args[n], XmNtopAttachment, XmATTACH_POSITION); n++;
    XtSetArg(args[n], XmNleftAttachment, XmATTACH_POSITION); n++;
    XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION); n++;
    XtSetArg(args[n], XmNleftPosition, 1); n++;
    XtSetArg(args[n], XmNrightPosition,38); n++;
    XtSetArg(args[n], XmNtopPosition, 10); n++;
    string = XmStringCreate ("Trans Mode:", XmSTRING_DEFAULT_CHARSET);
    XtSetArg (args[n], XmNlabelString, string); n++;
    flabel[0] = XmCreateLabelGadget(form, "Trans Mode", args, n);
    XtManageChild(flabel[0]);
    XmStringFree(string);

    n = 0;
    XtSetArg(args[n], XmNtopAttachment, XmATTACH_POSITION); n++;
    XtSetArg(args[n], XmNleftAttachment, XmATTACH_POSITION); n++;
    XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION); n++;
    XtSetArg(args[n], XmNleftPosition, 1); n++;
    XtSetArg(args[n], XmNrightPosition,38); n++;
    XtSetArg(args[n], XmNtopPosition, 42); n++;
    string = XmStringCreate ("Rot Mode:", XmSTRING_DEFAULT_CHARSET);
    XtSetArg (args[n], XmNlabelString, string); n++;
    flabel[1] = XmCreateLabelGadget(form, "Rotation", args, n);
    XtManageChild(flabel[1]);
    XmStringFree(string);

    n = 0;
    XtSetArg(args[n], XmNtopAttachment, XmATTACH_POSITION); n++;
    XtSetArg(args[n], XmNleftAttachment, XmATTACH_POSITION); n++;
    XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION); n++;
    XtSetArg(args[n], XmNleftPosition, 1); n++;
    XtSetArg(args[n], XmNrightPosition,38); n++;
    XtSetArg(args[n], XmNtopPosition, 75); n++;
    string = XmStringCreate ("Speed Mode:", XmSTRING_DEFAULT_CHARSET);
    XtSetArg (args[n], XmNlabelString, string); n++;
    flabel[2] = XmCreateLabelGadget(form, "Speed", args, n);
    XtManageChild(flabel[2]);
    XmStringFree(string);

    n = 0;
    C_Set_Color_PullDown( args, n, window_defs );
    translation_pulldown = XmCreatePulldownMenu(rc, "pulldown", args, n);

    n = 0;
    string = XmStringCreate ("Normal", XmSTRING_DEFAULT_CHARSET);
    XtSetArg (args[n], XmNlabelString, string); n++;
    translation_options[0] = XmCreatePushButtonGadget(
                              translation_pulldown, "Normal", args, n);
    XtAddCallback (translation_options[0], XmNactivateCallback,
                   set_spaceball_translation_mode, 0);
    XmStringFree (string);

    n = 0;
    string = XmStringCreate ("Dominate ", XmSTRING_DEFAULT_CHARSET);
    XtSetArg (args[n], XmNlabelString, string); n++;
    translation_options[1] = XmCreatePushButtonGadget(
                              translation_pulldown, "Dominate", args, n);
    XtAddCallback (translation_options[1], XmNactivateCallback,
                   set_spaceball_translation_mode, 1);
    XmStringFree (string);

    n = 0;
    string = XmStringCreate ("Off ", XmSTRING_DEFAULT_CHARSET);
    XtSetArg (args[n], XmNlabelString, string); n++;
    translation_options[2] = XmCreatePushButtonGadget(
                              translation_pulldown, "Dominate", args, n);
    XtAddCallback (translation_options[2], XmNactivateCallback,
                   set_spaceball_translation_mode, 2);
    XmStringFree (string);


    XtManageChildren (translation_options, 3);

    
    n = 0;
    XtSetArg (args[n], XmNsubMenuId, translation_pulldown); n++;
    XtSetArg (args[n], XmNmenuHistory,
              translation_options[0]); n++;
    C_Set_Color_OptionMenu( args, n, window_defs );
    translation_menu = XmCreateOptionMenu(
                        rc, "translation_option_menu", args, n);
    XtManageChild(translation_menu);

    
    n = 0;
    C_Set_Color_PullDown( args, n, window_defs );
    rotation_pulldown = XmCreatePulldownMenu(rc, "pulldown", args, n);
   

    n = 0;
    string = XmStringCreate ("Normal", XmSTRING_DEFAULT_CHARSET);
    XtSetArg (args[n], XmNlabelString, string); n++;
    rotation_options[0] = XmCreatePushButtonGadget(
                              rotation_pulldown, "Normal", args, n);
    XtAddCallback (rotation_options[0], XmNactivateCallback,
                   set_spaceball_rotation_mode, 0);
    XmStringFree (string);

    n = 0;
    string = XmStringCreate ("Dominate ", XmSTRING_DEFAULT_CHARSET);
    XtSetArg (args[n], XmNlabelString, string); n++;
    rotation_options[1] = XmCreatePushButtonGadget(
                              rotation_pulldown, "Dominate", args, n);
    XtAddCallback (rotation_options[1], XmNactivateCallback,
                   set_spaceball_rotation_mode, 1);
    XmStringFree (string);

    n = 0;
    string = XmStringCreate ("Off ", XmSTRING_DEFAULT_CHARSET);
    XtSetArg (args[n], XmNlabelString, string); n++;
    rotation_options[2] = XmCreatePushButtonGadget(
                              rotation_pulldown, "Dominate", args, n);
    XtAddCallback (rotation_options[2], XmNactivateCallback,
                   set_spaceball_rotation_mode, 2);
    XmStringFree (string);

    XtManageChildren (rotation_options, 3);

    n = 0;
    XtSetArg (args[n], XmNsubMenuId, rotation_pulldown); n++;
    C_Set_Color_OptionMenu( args, n, window_defs );
    XtSetArg (args[n], XmNmenuHistory,
              rotation_options[0]); n++;
    rotation_menu = XmCreateOptionMenu( rc, "rotation_option_menu", args, n);
    XtManageChild(rotation_menu);

    n = 0;
    C_Set_Color_PullDown( args, n, window_defs );
    speed_pulldown = XmCreatePulldownMenu(rc, "pulldown", args, n);
  
    n = 0;
    string = XmStringCreate ("Velocity   ", XmSTRING_DEFAULT_CHARSET);
    XtSetArg (args[n], XmNlabelString, string); n++;
    speed_options[0] = XmCreatePushButtonGadget(
                              speed_pulldown, "Velocity", args, n);
    XtAddCallback (speed_options[0], XmNactivateCallback,
                   set_spaceball_speed_mode, 0);
    XmStringFree (string);

    n = 0;
    string = XmStringCreate ("Accelera", XmSTRING_DEFAULT_CHARSET);
    XtSetArg (args[n], XmNlabelString, string); n++;
    speed_options[1] = XmCreatePushButtonGadget(
                              speed_pulldown, "Accelera", args, n);
    XtAddCallback (speed_options[1], XmNactivateCallback,
                   set_spaceball_speed_mode, 1);
    XmStringFree (string);

    XtManageChildren (speed_options, 2);

    n = 0;
    XtSetArg (args[n], XmNsubMenuId, speed_pulldown); n++;
    C_Set_Color_OptionMenu( args, n, window_defs );
    XtSetArg (args[n], XmNmenuHistory,
              speed_options[0]); n++;
    speed_menu = XmCreateOptionMenu( rc, "speed_option_menu", args, n);
    XtManageChild(speed_menu);

}

void create_speed_slide(parent)
Widget parent;
{


  extern  C_WindowDefs     window_defs;
  Arg args[20];
  XmString string;
  int n;

  Widget flabel[2];
  Widget trans_rate_slide;
  Widget rota_rate_slide;

  n = 0;
  C_Set_Color_Label( args, n, window_defs );
  XtSetArg( args[n], XmNx, 10 ); n++;
  XtSetArg( args[n], XmNy, 270); n++;
  flabel[0] = XmCreateLabelGadget(parent, "Trans Rate", args, n);
  XtManageChild(flabel[0]);

  n = 0;
  C_Set_Color_Label( args, n, window_defs );
  XtSetArg( args[n], XmNx, 10 ); n++;
  XtSetArg( args[n], XmNy, 340); n++;
  flabel[1] = XmCreateLabelGadget(parent, "Rota Rate", args, n);
  XtManageChild(flabel[1]);

  n = 0;
  C_Set_Color_Scale( args, n, window_defs );
  XtSetArg( args[n], XmNx, 120 ); n++;
  XtSetArg( args[n], XmNy, 270 ); n++;
  XtSetArg( args[n], XmNwidth, 250 ); n++;
  XtSetArg( args[n], XmNmaximum, 2500);n++;
  XtSetArg( args[n], XmNdecimalPoints, 4); n++;
  XtSetArg( args[n], XmNshowValue, TRUE );           n++;
  XtSetArg( args[n], XmNorientation, XmHORIZONTAL ); n++;
  trans_rate_slide = XtCreateManagedWidget( "trans_rate", xmScaleWidgetClass,
                                    parent, args, n );
  XmScaleSetValue(trans_rate_slide,  
             (int)(C_ide_simulation_method.spaceball.translation_rate*10000));
  XtAddCallback( trans_rate_slide, XmNvalueChangedCallback, 
                 set_spaceball_translation_rate, NULL);
  
  n = 0;
  C_Set_Color_Scale( args, n, window_defs );
  XtSetArg( args[n], XmNx, 120 ); n++;
  XtSetArg( args[n], XmNy, 340 ); n++;
  XtSetArg( args[n], XmNwidth, 250 ); n++;
  XtSetArg( args[n], XmNmaximum, 10000);n++;
  XtSetArg( args[n], XmNdecimalPoints, 6); n++;
  XtSetArg( args[n], XmNshowValue, TRUE ); n++;
  XtSetArg( args[n], XmNorientation, XmHORIZONTAL ); n++;
  rota_rate_slide = 
           XtCreateManagedWidget( "rota_rate_slide", xmScaleWidgetClass,
                                   parent, args, n );
  XmScaleSetValue(rota_rate_slide,  
             (int)(C_ide_simulation_method.spaceball.rotation_rate*1000000));
  XtAddCallback( rota_rate_slide, XmNvalueChangedCallback, 
                 set_spaceball_rotation_rate, NULL); 
}

void create_spaceball_control_panel_bottom(parent)
Widget parent;
{
    extern C_WindowDefs     window_defs;
    extern void  C_ide_quit();
    extern void C_create_operation_map();
    
    XmString string;
    int n;
    Arg args[20];

    Widget frame;
    Widget rc;
    Widget button[4];

    n = 0;
    XtSetArg( args[n], XmNx, 10); n++;
    XtSetArg( args[n], XmNy, 400); n++;
    C_Set_Color_Frame( args, n, window_defs );
    frame = XmCreateFrame( parent, "frame", args, n );

    n = 0;
    C_Set_Color_RowColumn( args, n, window_defs );
    XtSetArg( args[n], XmNorientation, XmHORIZONTAL); n++;
    rc = XmCreateRowColumn(frame, "rc", args, n);
    XtManageChild (rc);

    n=0;
    C_Set_Color_Button( args, n, window_defs );
    button[0] = XmCreatePushButton( rc, "Map", args, n );
    XtManageChild(button[0]);
    XtAddCallback(button[0], XmNactivateCallback,
                  C_create_operation_map, C_SPACEBALL);


    n=0;
    C_Set_Color_Button( args, n, window_defs );
    button[1] = XmCreatePushButton( rc, " Simulation", args, n );
    XtManageChild(button[1]);

    n=0;
    C_Set_Color_Button( args, n, window_defs );
    button[2] = XmCreatePushButton( rc, "Help", args, n );
    XtManageChild(button[2]);

    n=0;
    C_Set_Color_Button( args, n, window_defs );
    button[3] = XmCreatePushButton( rc, "Close", args, n);
    XtAddCallback(button[3], XmNactivateCallback, C_ide_quit, parent);
    XtManageChild(button[3]);

    XtManageChild(frame);
}


void create_spaceball_ui(top_spaceball_panel)
Widget top_spaceball_panel;
{
  extern  void gl_spaceball_rezero();
  extern  C_WindowDefs     window_defs;

  Widget flabel, frame;

  Widget rc, frame1, rezero;

  Arg args[20];
  XmString string;
  int n;

   n = 0;
   XtSetArg( args[n], XmNx, 10 ); n++;
   XtSetArg( args[n], XmNy, 10 ); n++;
   string = XmStringCreate ("Information", XmSTRING_DEFAULT_CHARSET);
   XtSetArg (args[n], XmNlabelString, string); n++;
   C_Set_Color_Label( args, n, window_defs );
   flabel = XmCreateLabelGadget(top_spaceball_panel, "", args, n);
   XtManageChild(flabel);

   n = 0;
   XtSetArg( args[n], XmNx, 110 ); n++;
   XtSetArg( args[n], XmNy, 10 ); n++;
   C_Set_Color_Frame(args, n, window_defs );
   frame = XmCreateFrame(top_spaceball_panel, "", args, n);
   XtManageChild(frame);


   n = 0;
   XtSetArg( args[n], XmNx, 120 ); n++;
   XtSetArg( args[n], XmNy, 10 ); n++;
   string = XmStringCreate ("     Spaceball data display panel    ",
                            XmSTRING_DEFAULT_CHARSET);
   XtSetArg (args[n], XmNlabelString, string); n++;
   C_Set_Color_Label( args, n, window_defs );
   spaceball_token_bulletin=XmCreateLabel (frame, " ", args, n);
   XtManageChild(spaceball_token_bulletin);
   XmStringFree (string);


   n = 0;
   XtSetArg (args[n], XmNx, 10);  n++;
   XtSetArg (args[n], XmNy, 50);  n++;
   C_Set_Color_Frame( args, n, window_defs );
   frame1 = XmCreateFrame (top_spaceball_panel, "frame", args, n);
   XtManageChild (frame1);


   n = 0;
   XtSetArg( args[n], XmNorientation, XmHORIZONTAL ); n++;
   C_Set_Color_RowColumn( args, n, window_defs );
   rc = XmCreateRowColumn (frame1, "rc", args, n);
   XtManageChild (rc);

   n = 0;
   string = XmStringCreate ("Rezero Spaceball", XmSTRING_DEFAULT_CHARSET);
   XtSetArg (args[n], XmNlabelString, string); n++;
   C_Set_Color_Button( args, n, window_defs );
   rezero = XmCreatePushButton( rc, "zero", args, n );
   XtAddCallback(rezero, XmNactivateCallback, gl_spaceball_rezero, NULL);
   XmStringFree (string);
   XtManageChild (rezero);

   create_spaceball_mode(top_spaceball_panel);

   create_speed_slide(top_spaceball_panel);

   create_spaceball_control_panel_bottom(top_spaceball_panel);
}


 

