/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/



/*
 *			File: C_volume_extent.c
 *		      Author: Lisa Sobierajski
 *			Date: //92
 *		 Description: Routines Of VolVis
 *	Modification History:
 *
 *		Who?		When?		Why?
 *	--------------------------------------------------------------------
 *
 */

#include <stdio.h>
#include "C_volvis.h"

void C_compute_volume_extent( world, min, max )
C_World			*world;
C_FPosition		*min;
C_FPosition		*max;
{

	int		loop;
	int		xloop, yloop, zloop;
	C_Volume	*volume;
	C_CoordSys	*c_sys;
	C_FPosition	test_pos;

	
	min->x =  C_BIG_FLOAT;
	min->y =  C_BIG_FLOAT;
	min->z =  C_BIG_FLOAT;
	max->x = -C_BIG_FLOAT;
	max->y = -C_BIG_FLOAT;
	max->z = -C_BIG_FLOAT;

	for ( loop = 0; loop < world->num_volumes; loop++ )
	{
	  volume = world->volume[loop];
	  c_sys  = &(volume->c_sys);

	  for ( xloop = 0; xloop < 2; xloop++ )
	    for ( yloop = 0; yloop < 2; yloop++ )
	      for ( zloop = 0; zloop < 2; zloop++ )
	      {
		test_pos.x = c_sys->origin.x + 
			xloop * volume->x_size_units * c_sys->x_axis.x +
			yloop * volume->y_size_units * c_sys->y_axis.x +
			zloop * volume->z_size_units * c_sys->z_axis.x;  

		test_pos.y = c_sys->origin.y + 
			xloop * volume->x_size_units * c_sys->x_axis.y +
			yloop * volume->y_size_units * c_sys->y_axis.y +
			zloop * volume->z_size_units * c_sys->z_axis.y;  

		test_pos.z = c_sys->origin.z + 
			xloop * volume->x_size_units * c_sys->x_axis.z +
			yloop * volume->y_size_units * c_sys->y_axis.z +
			zloop * volume->z_size_units * c_sys->z_axis.z;  

		if ( test_pos.x < min->x )
			min->x = test_pos.x;
		if ( test_pos.y < min->y )
			min->y = test_pos.y;
		if ( test_pos.z < min->z )
			min->z = test_pos.z;

		if ( test_pos.x > max->x )
			max->x = test_pos.x;
		if ( test_pos.y > max->y )
			max->y = test_pos.y;
		if ( test_pos.z > max->z )
			max->z = test_pos.z;
	      }
	}
}
