/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/



/*
 *                  File: supersample.c
 *                Author: Lisa Sobierajski
 *                  Date:
 *           Description:
 *  Modification History:
 *
 *         who?         when?           why?
 *    -----------------------------------------------------------
 *
 */

# include <stdio.h>
# include <math.h>

# include "C_volvis.h"
# include "C_raytrace.h"

C_setup_supersample( supersample_type, num_samples, sample_directions, view )

C_SuperSampleType	supersample_type;
int			*num_samples;
C_FVector		sample_directions[C_MAX_SAMPLES];
C_View			*view;

{
	float		x_spacing,
			y_spacing;

	x_spacing = view->width_units /
                    (float)view->width_pixels;

        y_spacing = view->height_units /
                    (float)view->height_pixels;

	switch ( supersample_type )
	{
	    case C_LOW_SUPER_SAMPLE:
		
		*num_samples = C_NUM_LOW_SAMPLES;

		sample_directions[0].x = view->c_sys.x_axis.x *
					 x_spacing * 0.25; 	
		sample_directions[0].y = view->c_sys.x_axis.y *
					 x_spacing * 0.25; 	
		sample_directions[0].z = view->c_sys.x_axis.z *
					 x_spacing * 0.25; 	

		sample_directions[1].x = view->c_sys.x_axis.x *
					 x_spacing * (-0.25); 	
		sample_directions[1].y = view->c_sys.x_axis.y *
					 x_spacing * (-0.25); 	
		sample_directions[1].z = view->c_sys.x_axis.z *
					 x_spacing * (-0.25); 	

		sample_directions[2].x = view->c_sys.y_axis.x *
					 y_spacing * 0.25; 	
		sample_directions[2].y = view->c_sys.y_axis.y *
					 y_spacing * 0.25; 	
		sample_directions[2].z = view->c_sys.y_axis.z *
					 y_spacing * 0.25; 	

		sample_directions[3].x = view->c_sys.y_axis.x *
					 y_spacing * (-0.25); 	
		sample_directions[3].y = view->c_sys.y_axis.y *
					 y_spacing * (-0.25); 	
		sample_directions[3].z = view->c_sys.y_axis.z *
					 y_spacing * (-0.25); 	

		break;

	    case C_MEDIUM_SUPER_SAMPLE:

		*num_samples = C_NUM_MEDIUM_SAMPLES;
	
		break;

	    case C_HIGH_SUPER_SAMPLE:

		*num_samples = C_NUM_HIGH_SAMPLES;

		break;

	    default:
		
		fprintf(stderr, "Invalid SuperSampleType!!!\n");
		exit( C_ERROR );

		break;
	}
}
