/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/

 *	Modification History:
 *
 *		Who?		When?		Why?
 *	--------------------------------------------------------------------
 *
 */

/****		Standard C Includes		****/
#include <stdio.h>
#include <fcntl.h>

/****		VolVis Includes			****/
#include "C_volvis.h"


#define	C_STDIN		0
#define	C_STDOUT	1

C_World         world;
C_View          view;
C_ImageTable   image_table;


/*
 *        Procedure Name: main
 *          Return Value: none
 *       Input Variables: argc	- Argument Count
 *			  argv  - Argument Array
 *      Output Variables: none
 *      Update Variables: none
 *      Global Variables: none
 *           Description: The VolVis Main Routine. The initialization of the
 *			  VolVis system is performed followed by the creation
 *			  of the windowing system. The windowing system 
 *			  initialization is responsible for starting the 
 *			  event loop.
 */
void main( argc, argv )
unsigned int	argc;
char		**argv;
{
	extern void	C_initialize_volvis();

	int		num_bytes;
	char		buffer[100];
	char		*buffer_ptr;
	int		fd;
	int		done;
	char		filename[100];
	char		basename[100];
	char		final_name[200];
	int		image_num;
	int		start, end;
	int		start_num;

	/* Initialize The VolVis Environment */
	C_initialize_volvis();

	buffer_ptr = buffer;

	done = FALSE;


	while( !done )
	{

		num_bytes = read( C_STDIN, buffer_ptr, 1 );

		if( num_bytes == 1 )
		{
			if( *buffer_ptr == 0 )
			{
				*buffer_ptr = 0;
				strcpy(	filename, buffer );
				buffer_ptr = buffer;
				done = TRUE;
			}
			else
			{
				buffer_ptr++;
			}
		}
	}

	done = FALSE; 

	while( !done )
	{

		num_bytes = read( C_STDIN, buffer_ptr, 1 );

		if( num_bytes == 1 )
		{
			if( *buffer_ptr == 0 )
			{
				*buffer_ptr = 0;
				strcpy(	basename, buffer );
				buffer_ptr = buffer;
				done = TRUE;
			}
			else
			{
				buffer_ptr++;
			}
		}
	}
	read( C_STDIN, &view.width_pixels, sizeof(int) );
	read( C_STDIN, &view.height_pixels, sizeof(int) );

	read( C_STDIN, &view.shadows_enabled, sizeof(int) );
	read( C_STDIN, &view.max_reflect_ray_level, sizeof(int) );
	read( C_STDIN, &view.max_transmit_ray_level, sizeof(int) );
	done = FALSE;

	while ( !done )
	{
		num_bytes = read( C_STDIN, &image_num, sizeof(int) );

		if ( image_num == -1 )
		{
			done = TRUE;
		}
		else
		{
			start = image_num;
			end = image_num + 1;
			
			C_setup_animation( filename, basename, 
					   start, &fd, &start_num );

        		C_view_animation( start, end, fd, NULL, 
				          basename, start_num, TRUE );

			write( C_STDOUT, &image_num, sizeof(int) );
		} 
	}
}

