/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/



typedef enum
{
        C_PERSPECTIVE_VIEW,
        C_PARALLEL_VIEW
} C_ViewType;

typedef enum
{
	C_RED_COLOR_EDIT,
	C_GREEN_COLOR_EDIT,
	C_BLUE_COLOR_EDIT,
	C_OPACITY_EDIT,
	C_NO_EDIT
} OcoEditType;

typedef struct
{
	Widget          	world_displayed;
        Widget          	world_text;
	C_ColorSelectInfo	*ambient_info;
	C_ColorSelectInfo	*background_info;
	Widget			ambient_slider;
} OcoWorldInfo;

typedef struct
{
	Widget          view_displayed;
        Widget          view_text;
        Widget          view_width_pixels;
        Widget          view_height_pixels;
        Widget          view_width_units;
        Widget          view_height_units;
        Widget          view_width_label;
        Widget          view_height_label;
        Widget          view_fov_label1;
        Widget          view_fov_label2;
        Widget          view_fov;
        Widget          view_type[2];
} OcoViewInfo;

typedef struct
{
	Widget		slider;
	C_AxisType	axis;
	Widget		draw_area;
	GC		gc;
	int		volume_num;
} OcoSliceInfo;

typedef struct
{
        Widget          seg_type[2];
        Widget          option_menu;
        int             volume_index;
        C_SegType       curr_seg_type;

	Widget		isosurface_frame;
	Widget		iso_text;

	Widget		s_opacity_frame;
        Widget          s_opacity_max_text;
        Widget          s_opacity_draw_area;
        GC              s_opacity_gc;
        float           s_opacity_max;
	Widget		s_opacity_x_label;
	Widget		s_opacity_y_label;
	Widget		s_opacity_opacity_label;
	Widget		s_opacity_r_label;
	Widget		s_opacity_g_label;
	Widget		s_opacity_b_label;
        int  		s_opacity[256];
	OcoEditType	s_opacity_edit_type;
	Widget		s_opacity_edit_toggle[4];

	Widget		parc_slider_frame;
	Widget		parc_slider;
	Widget		slice_buttons_frame;
	Widget		bottom_buttons_frame;

} OcoSegInfo;

typedef struct
{
        Widget          volume_data_displayed;
	OcoSegInfo	*seg_info;	
        Widget          volume_x_slices;
        Widget          volume_y_slices;
        Widget          volume_z_slices;
	OcoSliceInfo	*x_slice_info;
	OcoSliceInfo	*y_slice_info;
	OcoSliceInfo	*z_slice_info;
} OcoVolDataInfo;

typedef struct
{
        Widget          	volume_color_displayed;
        C_ColorSelectInfo       *volume_color_selector;
	Widget			color_type[3];
	Widget			bottom_buttons_frame;
	C_ColorType		curr_color_type;

        Widget         		single_color_frame;

	Widget			color_array_frame;
	Widget			color_array_draw_area;
	GC			color_array_gc;
	Widget			color_array_x_label;
	Widget			color_array_y_label;
	Widget			color_array_r_label;
	Widget			color_array_g_label;
	Widget			color_array_b_label;
	int			color_array_red[256];
	int			color_array_green[256];
	int			color_array_blue[256];
	OcoEditType		color_array_edit_type;
	Widget			color_array_edit_toggle[3];	

} OcoVolColorInfo;

typedef struct
{
        Widget          volume_shade_change;
        Widget          volume_sim_shade_diffuse_coef;
        Widget          volume_sim_shade_specular_coef;
        Widget          volume_sim_shade_specular_power;
        Widget          volume_sim_shade_transmit_coef;
        Widget          volume_sim_shade_transmissitivity;
        Widget          volume_sim_shade_index_of_refraction;
} OcoVolShadeInfo;

typedef struct
{
        Widget          volume_displayed;

        Widget          volume_text;

        Widget          volume_size_x;
        Widget          volume_size_y;
        Widget          volume_size_z;

	OcoVolDataInfo	data;
	OcoVolColorInfo color;
	OcoVolShadeInfo shade;


} OcoVolumeInfo;

typedef struct
{
        Widget          	light_displayed;
        Widget          	light_name;
        Widget          	light_position_x;
        Widget          	light_position_y;
        Widget          	light_position_z;
        Widget          	light_intensity;
        C_ColorSelectInfo       *light_color_selector;
        Widget          	light_modify_window;
} OcoLightInfo;

typedef struct
{
        int             active_object;
        Widget          oco_active_pulldown;
	int		num_active_options;
	Widget		delete_button;
	Widget		clone_button;
        Widget          create_window;
	Widget		create_geo_obj_window;
	Widget		create_light_window;
        Widget          oco_active_opt[C_MAX_VOLUMES+C_MAX_LIGHTS+2];
        Widget          oco_option_menu;

	Widget		control_window;
	Widget		view_frame;
	Widget		volume_frame;
	Widget		light_frame;
	Widget		button_frame;

	OcoWorldInfo	world_info;
	OcoViewInfo	view_info;
	OcoVolumeInfo	*volume_info[C_MAX_VOLUMES];
	OcoLightInfo	*light_info[C_MAX_LIGHTS];


} C_ObjectControlInfo;



