/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/



/*
 *                      File: C_animate.h
 *                    Author: Lisa Sobierajski 
 *                      Date: 
 *               Description: Animation Routines Of VolVis
 *      Modification History:
 *
 *              Who?            When?           Why?
 *      --------------------------------------------------------------------
 *
 */


#define C_MAX_PROCESSES         30
#define C_MAX_ANI_TIME          150

typedef enum
{
        C_SGI_R2000_WORKSTATION,
        C_SGI_R3000_WORKSTATION,
        C_HP_WORKSTATION,
        C_SUN1_WORKSTATION,
        C_SUN2_WORKSTATION
} C_WorkstationType;

typedef struct
{
        int             current_image;
        int             total_images;
        int             time_count;
} C_AniProcessInfo;

typedef struct
{
	C_UIWin		ani_flight_bbdialog;
	C_UIWin		ani_manual_bbdialog;
	C_UIWin		ani_view_bbdialog;

        C_UIWin         flight_file_text;
        C_UIWin         flight_base_text;
        C_UIWin         flight_start_text;
        C_UIWin         flight_end_text;
	C_UIWin		flight_frames_text;

        C_UIWin         view_base_text;
        C_UIWin         view_start_text;
        C_UIWin         view_end_text;

	C_NavCWInfo	*ani_cw_info;
	C_UIWin		manual_base_text;
	C_UIWin		manual_frames_text;
} C_AniInfo;

