/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/




/*
 *			File: C_time.c
 *		      Author: Rick Avila
 *			Date: 08/19/92
 *		 Description: Timing Routines Of VolVis
 *			      This includes a routine to get the current
 *			      time, and two routines to determine the time
 *			      between two time points.
 *	Modification History:
 *
 *		Who?		When?		Why?
 *	--------------------------------------------------------------------
 *
 */

/****		Standard C Includes		****/
#include <stdio.h>
#include <sys/time.h>

/****		VolVis Includes			****/
#include "C_volvis.h"


/*
 *        Procedure Name: C_get_time
 *          Return Value: int
 *       Input Variables: none
 *      Output Variables: c_time_val	- This is the time structure pointer 
 *					  which will contain the current time.
 *      Update Variables: none
 *      Global Variables: none
 *           Description: Obtains the current time from the system clock and
 *			  stores the result into the time structure pointed
 *			  to by c_time_val. The timing structure stores a
 *			  time in seconds + microseconds.
 */
void C_get_time( c_time_val )
C_Time_Val      *c_time_val;
{
        struct timeval          time_value;	/* Storage for timing call */

	/* Get The Current Time and Store In time_value */
        gettimeofday( &time_value, NULL );

	/* Store the Seconds and Microsends Into VolVis Timing Structure */
        c_time_val->sec         = time_value.tv_sec;
        c_time_val->usec        = time_value.tv_usec;
}

/*
 *        Procedure Name: C_diff_usec
 *          Return Value: long		- This represents the microsecond 
 *					  difference between time1 and time2
 *       Input Variables: time1		- Time point 1
 *			  time2		- Time point 2 (Usually > time1 )
 *      Output Variables: time_diff	- The time difference (time2 - time1)
 *					  in microseconds
 *      Update Variables: none
 *      Global Variables: none
 *           Description: Calculates the microsecond time difference between
 *			  time1 and time2. The calculation simply subtracts
 *			  the time1 microseconds from the time2 microseconds
 */
long C_diff_usec( time1, time2 )
C_Time_Val      *time1;
C_Time_Val      *time2;
{
        long    time_diff;	/* Storage For The Microsecond Difference */

	/* Calculate The Time Difference */
        time_diff =     (1000000*(time2->sec) + time2->usec) -
                        (1000000*(time1->sec) + time1->usec);

	/* Return The Time Difference */
        return( time_diff );
}

/*
 *        Procedure Name: C_diff_sec
 *          Return Value: double	- This represents the floating point
 *					  second difference between time1 and
 *					  time2
 *       Input Variables: time1		- Time point 1
 *			  time2		- Time point 2 (Usually > time1 )
 *      Output Variables: time_diff	- The time difference (time2 - time1)
 *					  in seconds
 *      Update Variables: none
 *      Global Variables: none
 *           Description: Calculates the time difference in seconds between
 *			  time1 and time2. The calculation simply subtracts
 *			  the time1 seconds from the time2 seconds 
 */
double C_diff_sec( time1, time2 )
C_Time_Val      *time1;
C_Time_Val      *time2;
{
        double  time_diff; 		/* Storage For The Seond Difference */

	/* Calculate The Time Difference */
        time_diff =((double)(time2->sec) + ((double)(time2->usec)/1000000.0)) -
                   ((double)(time1->sec) + ((double)(time1->usec)/1000000.0));

	/* Return The Time Difference */
        return( time_diff );
}

void C_wait( seconds )
double	seconds;	/* Delay Time In Seconds */
{
	double		difference;
	C_Time_Val	start_time;
	C_Time_Val	current_time;

	if( seconds <= 0.0 )
		return;

	C_get_time( &start_time );

	difference = 0.0;

	while( difference < seconds )
	{
		C_get_time( &current_time );

		difference = C_diff_sec( &start_time, &current_time );
	}
}

