.TH RAZ  1 "1992" "AHPCRC"
.SH NAME
raz \- disk based raster viewer
.SH SYNOPSIS
\fBraz\fR < script
.br
\fBcmdraz\fR [ options ] files | \fBraz\fR
.SH DESCRIPTION
\fBRaz\fR loads image files to either raw disk or memory, and
then plays them back to the screen.  At the AHPCRC several
striped disk partitions are kept open, with no file system on them,
for 2D and 3D raster streaming.  We call these drives "raw disks".  
Using fast drives we have been able
to stream at 13 MB/sec from disk to screen.  A couple of gigabytes
on each system are kept open so that long movies can be viewed
and manipulated.
.PP
Raz can use a simple file as it's "raw disk" if 
high performance isn't an issue.
.PP
The image file format for \fBraz\fR is very simple.  Mapped color images
use one byte per pixel.  Full color images use three bytes per pixel,
in either interleaved (rgbrgbrgb...) order or as planes (rrr...ggg...bbb...).
The image rows are ordered top to bottom.  There is no image header.
.PP
When loaded to raw disk, \fBraz\fR stores images in the most natural
format for the given graphics hardware.  All images are padded to a
multiple of four wide and rows are ordered bottom to top.  Full color
images are stored in BGR order.  The image data is padded to the next
block size, to support devices that only seek to block boundaries.
.PP
On machines without full support
for the pixmode() call, such as Indigo and the Personal Iris,
full color images are stored in ABGR order, and mapped color images
are stored two bytes per pixel.  A constant value of 1024 is also added
to each pixel of mapped color images if there are more than 
eight color planes.
.PP
In practice, once loaded to raw disk, 
image sequences can be saved and reloaded from
tape.  Careful users can also directly transfer prepared 
images to raw disk, using the \fBdd\fR command.
.PP
The program \fBraz\fR is only half of a user-friendly image display
program.  \fBraz\fR has no useful command line options, but instead takes
commands from standard input.
.PP
The other half, \fBxraz\fR, feeds commands
to \fBraz\fR, giving the user a nice push button interface.  Without
\fBxraz\fR the way to use \fBraz\fR is to feed it ascii
commands directly, or from a file.
.PP
In practice there are two ways to use \fBraz\fR directly:
.IP
raz < script
.br
cmdraz [ options ] [ files ] | raz
.PP
The first reads in a complete script, in which the last command should
probably be \fBplay\fR.  \fBraz\fR will run until quit from the window
menu or interrupted.
.PP
The second drives raz from a command line.  \fBcmdraz\fR is a shell
script that composes raz commands from a command line.  Type
.IP
cmdraz -h
.PP
to learn how to use cmdraz.
.SH OPTION
The \fB-a\fR option makes raz acknowledge each input line with
a null byte on output.  If there is a reply the null byte is appended
to the reply.  This option is used by \fBxraz\fR to synchronize with \fBraz\fR.
.SH "RAZ COMMANDS"
.PP
To save on typing, only the first three characters of any
keyword need to be typed.  Blank lines and lines that begin with \fB#\fR
are ignored.  Each line should have one command.  Commands may not
span lines, and there cannot not be multiple commands on a line.
The filename and colors commands read additional lines of input.
.IP "play [begin_frame [end_frame]]"
Play, stepping in the set direction.  If the direction is +1, the default,
then:
.br
.sp
\fBplay 1 100\fR	play from frame one to frame 100
.br
\fBplay beg end\fR	play from beginning to end
.br
.sp
If an ending frame is given raz will ignore commands until the
end frame is reached.
.IP stop
Stops playing.
.IP "goto frame#"
Jumps to a frame.
\fBgoto beg\fR jumps to the first frame.
.IP "load"
Loads files specified by \fBset filename\fR into memory or raw disk.
A load is automatically performed by play or goto if needed.
.IP "zoom on | off"
Controls presence of zoom window.  The zoom window shows a 
blowup of the region around the cursor.
.br
\fBzoom on\fR	exposes the zoom window.
.br
\fBzoom off\fR	hides the zoom window.
.IP "cmap on | off"
Controls whether color map is loaded.  This should only mater
for 8 bit machines.  For full color machines the colormap
is loaded above the standard X colors, so they do not conflict.
.IP ping
Responds \fBpong\fR.  Not useful for interactive use.
.IP quit
Exits raz with grace.  
.IP mark
Prints the frames per second and I/O throughput since the last mark command.
.IP "sleep #tick"
Sleep #tick hundredths of a second.
.IP "print"
Print the current \fBset\fR variables on standard output.
.IP "print frame"
Print the current frame number.
.IP "print numframe"
Print the total number of frames.
.IP "print colors"
Print the color table.
.IP "print filename"
Print file names.
.sp
.IP "set [variable] [arguments]"
Sets the state of \fBraz\fR.  Specifically:
.IP "set speed #fps"
Set the play frame rate to be no faster than #fps frames per second.
The maximum frame rate is 60 fps, and the minimum is 1 fps.
.IP "set direction #dir"
Set the frame step direction to #dir.  A value of 1 goes forward, 
-1 reverses.
.IP "set rawdiskname diskname"
Name of raw disk partition.
.br
\fBset rawdiskname /dev/anim0\fR	Default partition.
.IP "set double on | off"
Turns double buffering of the main image on or off.
.br
\fBset double on\fR		Default setting.
.IP "set bounce on | off"
Normally when playing the movie cycles to image #0 when the end
of the frames are reached (and visa versa).
.br
\fBset bounce on\fR		Reverse play direction at end.
.br
\fBset bounce off\fR		Default.  Cycle movie.
.IP "set playmode raw | memory"
Where to store images when \fBload\fRing, and where to fetch
images when \fBplay\fRing.
.br
\fBset playmode raw\fR	Default.  Use raw disk partition
.br
\fBset playmode memory\fR	Stuff images into memory
.IP "set source file | raw"
Where to read images from when \fBload\fRing.  If the source is raw
and the playmode is raw, then the load step does not require transferring
any images.  This is the proper setting when images have been 
pre-loaded to disk.
.br
\fBset source file\fR	Default.  Load files from file list
.br
\fBset source raw\fR		Images already on raw disk
.IP "set offset #bytes"
When playing or storing images on raw partition, start at #bytes
into partition.  #bytes can be specified using the letters k and
m to stand for kilo and mega respectively.
.br
\fBset offset 0\fR		Default setting
.br
\fBset offset 120m\fR	Start 120 megabytes into raw disk
.IP "set blocksize #bytes"
When playing or storing images on raw partition,  
read and write in #bytes size pieces.
.br
\fBset blocksize 4k\fR	Default setting.
.IP "set chunksize #frames"
When playing images from a raw partition,  
read frames in multiples of chunksize when possible.
Set chunksize to one to turn this feature off
.br
\fBset chunksize 1\fR	Default setting.
.IP "set colors"
Set color map from 256 integer "index R G B" quadruples.
This is only useful for pseudo color images.  Default is a grey scale
map, with 0 = black and 255 = white.  For example:
.br
\fBset colors\fR
.br
\fB0 10 100 203\fR
.br
\fB1 12 98 210\fR
.br
[ 254 more quadruples ]
.IP "set imgformat pseudo8 | rgbplane | rgbbyte"
Sets image format to full color or mapped color.
Images are stored row by row, first row at the top of the screen.
A \fBpseudo8\fR image has one byte per pixel.
An \fBrgbplane\fR full color image is composed of 
DimXxDimY red bytes followed by
the green bytes and the blue bytes, as in rrr...ggg...bbb....
An \fBrgbbyte\fR full color image is composed of DimXxDimY triples of bytes,
as in rgbrgbrgb....
.br
\fBset imgformat pseudo8\fR	Default setting.
.IP "set datadim #DimX #DimY"
Sets the image dimensions, in pixels.
.br
\fBset datadim 512 512\fR		Default setting.
.IP "set toptobot on | off"
Paints images top to bottom, if possible.
.br
\fBset toptobot off\fR		Default setting.
.IP "set border #borderX #borderY"
Sets the black image border, in pixels.
.br
\fBset border 0 0\fR			Default setting.
.IP "set replication #RepX #RepY"
Sets replication, or fill factor, of pixels in the main window.
Floating point replication factors work on the VGX.
.br
\fBset replication 1.0 1.0\fR	Default setting.
.IP "set zoom #ZoomX #ZoomY"
Sets zoom factor for zoom window.  This is on top of the replication
factor for the main window.
Floating point zoom factors work on the VGX.
.br
\fBset zoom 2.0 2.0\fR		Default setting.
.IP "set prefix pathname"
Prepend pathname to all file names.
.IP "set filename #files"
Specifies the file names to load images from with a \fBload\fR
command.  For example:
.br
\fBset filename 4\fR
.br
\fB/usr/local/tmp/ken/q42Hw0006ae33\fR
.br
\fB/usr/local/tmp/ken/q42Hw0007ae33\fR
.br
\fB/usr/local/tmp/ken/q42Hw0008ae33\fR
.br
\fB/usr/local/tmp/ken/q42Hw0009ae33\fR
.SH CAVEATS
The command syntax is very unsophisticated.
.PP
Loading can take a long time, during which the program will not
accept commands.  To cleanly exit during a load, select Quit from
the window manager menu.
.SH AUTHOR
Ken Chin-Purcell, AHPCRC
.br
Mail to gvlware@ahpcrc.umn.edu.
