
/* Copyright (C) 1992  AHPCRC, Univeristy of Minnesota
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program in a file named 'Copying'; if not, write to
 * the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139.
 */

/* Author:
 *	Ken Chin-Purcell (ken@ahpcrc.umn.edu)
 *	Army High Performance Computing Research Center (AHPCRC)
 *	Univeristy of Minnesota
 *
 * $Header: /usr/people/ken/gvl/icol/RCS/icol.h,v 2.1 92/10/19 16:59:33 ken Exp $
 *
 * $Log:	icol.h,v $
 * Revision 2.1  92/10/19  16:59:33  ken
 * *** empty log message ***
 * 
 * Revision 1.1  92/10/19  16:58:12  ken
 * Initial revision
 * 
 */

/* If you are starting to read this code, please first check out
 * the man page and icol itself.  
 */

/* Since global variables can be confusing when reading code
 * ("Where did *that* variable come from!"...)
 * all of the global information is lumped together in the Icol structure.
 */


typedef struct _Icol {
    Display	*display;
    XtAppContext app;
    Widget	shell;			/* The top level widget */

    XmString	scaleString[4][3];	/* text for scales in each mode */
    XmString	snapString[4][3];	/* text for snap menu items */

    Colormap	cmap;			/* The current color map */
    Colormap	usualmap;		/* No color stomping */
    Colormap	stompmap;		/* Stomp on someone's colors */

    FileFormat	format;			/* the desired file format */
    char	*openname;		/* input file name, - for stdin */
    char	*savename;		/* output file name, - for stdin */

    AxisBar	*abar;			/* colors for scales */
    ColorBar	*cbar;			/* color information */
    ColorMode	rgbmode;		/* color space */
    int		ncolor;			/* number of colors in map */

    int		bigmap;			/* room for all colors */
    int		mapsize;		/* number entries in color map */
    int		dirty;			/* changes since last save */
    
    Atom	xaColormap;
    Atom	xaAlphamap;
    Atom	xaInterest;

    /* resources */
    int		maxundo;		/* size of undo stack */
    int		autosave;		/* automatic save enabled */
    int		rootvis;		/* use root visual*/
    int		stomp;			/* stomp on lower colors */
    int		stompbase;		/* where to start stomping */
    int		colorAxis;		/* colorized scales */
    int		help;			/* just the facts, m'am */
    int		quickSeg;		/* number of line segments for sketch */
    int		slopediff;		/* slope difference to place knot */
    String	bugAddr;		/* where to send complaints */
    int		showCopyright;		/* post initial (c) box */
    int		expert;			/* Smaller size */

} Icol;

extern Icol	*icol;

typedef enum _FileReason {
    FILE_SAVE, FILE_OPEN, FILE_QUIT, FILE_OK, FILE_CANCEL
} FileReason;

typedef enum _PropReason {
    PROP_SET, PROP_GET, PROP_AUTO
} PropReason;

typedef enum _IcolMode {
    MODE_RGB, MODE_HSV, MODE_YUV, MODE_ALPHA, MODE_AUTO, MODE_STOMP
} IcolMode;

#define SNAP_THIS	-1
#define SNAP_ALL	-2

#define MENU_CONTROL	0
#define MENU_EDIT	1
#define MENU_MODE	2
#define MENU_BRUSH	3

#define MakeXmString(s)	XmStringCreateLtoR(s, XmSTRING_DEFAULT_CHARSET);

/* Prototypes */

/* icol.c */
void	SnapCB (Widget w, XtPointer closure, XtPointer callData);
void	PlaceKnotsCB (Widget w, XtPointer closure, XtPointer callData);
void	UndoCB (Widget w, XtPointer closure, XtPointer callData);
void	RedoCB (Widget w, XtPointer closure, XtPointer callData);
void	PickCB (Widget w, XtPointer closure, XtPointer callData);
void	GrabColorCB (Widget w, XtPointer closure, XtPointer callData);
void	SetColorCB (Widget w, XtPointer closure, XtPointer callData);
void	CascadeCB (Widget w, XtPointer closure, XtPointer callData);
void	BrushCB (Widget w, XtPointer closure, XtPointer callData);
void	FormatCB (Widget w, XtPointer closure, XtPointer callData);
void	QuitCB (Widget w, XtPointer closure, XtPointer callData);
void	FileCB (Widget w, XtPointer closure, XtPointer callData);
void	ModeCB (Widget w, XtPointer closure, XtPointer callData);
void	ScaleCB (Widget w, XtPointer closure, XtPointer callData);
void	ChartCB (Widget w, XtPointer closure, XtPointer callData);
void	ButtonCB (Widget w, XtPointer closure, XtPointer callData);
void	BugCB (Widget w, XtPointer closure, XtPointer callData);
void	PropCB (Widget w, XtPointer closure, XtPointer callData);
int	main	(unsigned int argc, char *argv []);
