
/* Copyright (C) 1992  AHPCRC, Univeristy of Minnesota
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program in a file named 'Copying'; if not, write to
 * the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139.
 */

/* Author:
 *	Ken Chin-Purcell (ken@ahpcrc.umn.edu)
 *	Army High Performance Computing Research Center (AHPCRC)
 *	Univeristy of Minnesota
 *
 * $Header: /usr/people/ken/gvl/icol/RCS/cbar.h,v 2.1 92/10/19 16:59:28 ken Exp $
 *
 * $Log:	cbar.h,v $
 * Revision 2.1  92/10/19  16:59:28  ken
 * *** empty log message ***
 * 
 * Revision 1.1  92/10/19  16:58:10  ken
 * Initial revision
 * 
 */

/* NFGCOLOR = "Number of foreground colors"
 * Used in ColorBar to set aside some alloc'd colors for labels, etc.
 */

#define NFGCOLOR	5


typedef enum _ColorMode {
    RGB_MODE, HSV_MODE, YUV_MODE, ALPHA_MODE
} ColorMode;


typedef struct _Color {
    float	channel[3];	/* Range = [0,1], no matter what the mode */
    XColor	*xcolor;	/* The XColor to represent this color */
    XColor	*xstomp;	/* The XColor to stomp this color */
    int		knot;		/* Whether this is a knot point */
    int		cx, cy;		/* upper left of the color rectangle */
    int		bx, by;		/* upper left of the knot rectangle */
} Color;


typedef struct _Icon {
    Pixmap	pixmap;
    int		width, height;
} Icon;


typedef struct _Rectangle {
    int		x, y;
    int		width, height;
} Rectangle;


typedef struct _Brush {
    int		index;		/* color index brush is centered over */
    float	value;		/* vertical position, range [0,1] */
    int		above;		/* above or below the line */
    int		channel;	/* which channel is being changed (0-2) */
    int		kind;		/* square, circle or diamond */
    int		**lift;		/* array of vertical brush sizes */
    Icon	icon[3];	/* icons of the three possible brushes */
} Brush;


typedef struct _SaveColor {	/* Kept in the undo stack */
    float	channel[3];
    int		knot;
} SaveColor;


typedef struct _SaveBar {	/* Kept in the undo stack */
    SaveColor	*color;
    int		focus;
    ColorMode	rgbmode;
} SaveBar;


typedef struct _SaveStack {
    SaveBar	*save;
    int		nsave;
    int		base;
    int		size;
} SaveStack;


typedef struct _ColorBar {
    Widget	chart;		/* upper XmDrawingArea,  bar & chart */
    Widget	button;		/* middle XmDrawingArea, buttons w/ knots */

    Display	*display;
    Rectangle	graphRect;
    Rectangle	barRect;
    Pixmap	barPixmap;

    Color	*color;		/* One for every color in map */
    int		ncolor;
    XColor	*xcolor;	/* Possibly fewer than ncolor */
    int		nxcolor;
    XColor	*xstomp;
    int		nxstomp;

    Colormap	cmap;
    Colormap	stompmap;

    GC		gc;
    Pixel	bg;
    Pixel	fg[NFGCOLOR];

    int		focus;		/* which knot has the focus */
    int		changeChannel;	/* which channel is being changed by the brush */
    ColorMode	rgbmode;	/* RGB, HSV or YUV */
    int		cellSize;	/* color cell button size */
    int		knotSize;	/* size of black dot in cell */
    Brush	brush;
    int		quickSeg;	/* number of segements to draw while sketching */

    SaveStack	*undo;
    SaveStack	*redo;
} ColorBar;



/* Prototypes */

/* cbar.c */
void	GetRGB (ColorBar *cbar, int i, float *r, float *g, float *b);
void	PutRGB (ColorBar *cbar, int i, float r, float g, float b);
void	ColorBarResizeButtons (ColorBar *cbar);
void	ColorBarResizeChart (ColorBar *cbar);
void	ColorBarSetWidget (ColorBar *cbar, Widget chart, Widget button);
void	ColorBarStore (ColorBar *cbar, Colormap cmap);
void	ColorBarStomp (ColorBar *cbar, Colormap cmap);
void	ColorBarDrawBar (ColorBar *cbar);
void	ColorBarClearGraph (ColorBar *cbar);
void	ColorBarDrawGraph (ColorBar *cbar, int xormode);
void	ColorBarDrawChart (ColorBar *cbar);
void	ColorBarDrawButtons (ColorBar *cbar);
int	ColorBarFindButton (ColorBar *cbar, int x, int y);
int	ColorBarFindChart (ColorBar *cbar, int x);
void	ColorBarSetFocus (ColorBar *cbar, int focus);
void	ColorBarUnsetFocus (ColorBar *cbar);
void	ColorBarPlaceKnots (ColorBar *cbar, int slopediff);
void	ColorBarSet (ColorBar *cbar, int ic, float value);
void	ColorBarSnap (ColorBar *cbar, int channel);
void	ColorBarSnapAll (ColorBar *cbar);
void	ColorBarHSV (ColorBar *cbar);
void	ColorBarRGB (ColorBar *cbar);
void	ColorBarYUV (ColorBar *cbar);
void	ColorBarAlpha (ColorBar *cbar);
void	ColorBarSetBrush (ColorBar *cbar, int brush, int x, int y);
void	ColorBarMoveBrush (ColorBar *cbar, int x, int y);
void	SaveBarWrite (SaveBar *save, ColorBar *cbar);
void	SaveBarRead (SaveBar *save, ColorBar *cbar);
void	ColorBarSave (ColorBar *cbar, int undo);
void	ColorBarRestore (ColorBar *cbar, int undo);
ColorBar	*ColorBarNew (Widget w, Colormap cmap, int mapsize, int ncolor, int nsave, int quickSeg, int stompbase);
