/*
 * header details for pixel files
 */
#define	_BASE		0xffff0000	/* base of magic number */

/*
 * format types
 */
#define	_FLAT		0x0000		/* straight rasters */
#define	_RUN_LENGTH	0x1000		/* run-length encoded file */
#define _COLOUR_MAP	0x2000		/* colour mapped image */
#define	_MIXED		0x4000		/* mixture of runs and straights */

/*
 * limits
 */
#define	OLDPIX_MAXRUN	255		/* max run in run-length encoded */

/*
 * channel types
 */
#define	_R		0x0100		/* red channel */
#define	_G		0x0200		/* green channel */
#define	_B		0x0400		/* blue channel */
#define	_A		0x0800		/* alpha channel */

/*
 * magic numbers and their format structures
 *	- type order is the same as byte order
 */
#define	OLDPIX_RGB	(_BASE | _R | _G | _B)
#define	OLDPIX_RLE	(_BASE | _RUN_LENGTH | _R | _G | _B)
#define	OLDPIX_MIX	(_BASE | _MIXED | _R | _G | _B)
#define	OLDPIX_RGBA	(_BASE | _R | _G | _B | _A)
#define	OLDPIX_RLEA	(_BASE | _RUN_LENGTH | _R | _G | _B | _A)
#define	OLDPIX_MIXA	(_BASE | _MIXED | _R | _G | _B | _A)

/*
 * colour map type - currently max size 256 so each pixel is a single byte index
 */
#define	OLDPIX_CMAP	(_BASE | _COLOUR_MAP | _R | _G | _B)
#define	OLDPIX_RLECMAP	(_BASE | _COLOUR_MAP | _RUN_LENGTH | _R | _G | _B)

/*
 * file name suffix
 */
#define	OLDPIX_SUFFIX	".pix"

/*
 * header format
 *
 *	note: 1. if the title field is non zero the title follows the header.
 *	      2. if the type is colour-mapped the size of the colour map,
 *		 and the colourmap follows the title.
 */
#ifdef PC
typedef struct __h {
	long		magic;		/* magic number */
	float		rw, rh;		/* width and height in real values */
	unsigned short	pw, ph;		/* width and height in pixels */
	long		date;		/* date created (secs from 1/1/1970) */
	long		tlength;	/* length of title */
} pixhdr;
#else
typedef struct __h {
	int		magic;		/* magic number */
	float		rw, rh;		/* width and height in real values */
	unsigned short	pw, ph;		/* width and height in pixels */
	long		date;		/* date created (secs from 1/1/1970) */
	int		tlength;	/* length of title */
} pixhdr;
#endif

/*
 * image structure details
 */

#define	IBUF_SIZE	4096			/* size of image buffer */

typedef struct __oi {
	int		fd;			/* file descriptor */
	int		reading;		/* are we open for reading? */
	int		written;		/* written to the file? */
	pixhdr		hdr;			/* header details */
	char		*title;			/* image title */
	unsigned char	run,			/* current position in run */
			r, g, b, a;		/* current pixel */
	unsigned char	ibuf[IBUF_SIZE];	/* current scanline buffer */
	unsigned char	*ibufp;			/* pointer to buffer position */
	unsigned char	*ebufp;			/* pointer to end of buffer */
	unsigned short	mapsize;
	unsigned char	*red, *green, *blue;	/* colour map details */
} oldimage;

/*
 * macros for checking and setting the type from the magic number
 */
#define	oldimagetype(a)		(a)->hdr.magic

#define	oldalphachannel(a)		((a)->hdr.magic & _A)

#define oldcolormapped(a)		((a)->hdr.magic & _COLOUR_MAP)

#define oldrlecoded(a)		((a)->hdr.magic & _RUN_LENGTH)
#define	oldmixcoded(a)		((a)->hdr.magic & _MIXED)

/*
 * image processing functions
 */
extern oldimage	*oldopenimage();
extern int	oldreadrgbline(), oldwritergbline();
extern int	oldreadrgbaline(), oldwritergbaline();

/*
 * general macros for getting access to image details
 */
#define	oldimagewidth(a)	(a)->hdr.pw
#define	oldimageheight(a)	(a)->hdr.ph

#define	oldimagexsize(a)	(a)->hdr.rw
#define	oldimageysize(a)	(a)->hdr.rh

#define	oldimagedate(a)	(a)->hdr.date

#define	oldimagefile(a)	(a)->fd

#define	oldimagetitle(a)	(a)->title
#define	oldtitlelength(a)	(a)->hdr.tlength

#define	oldcmapsize(a)	(a)->mapsize

#define	oldredmap(a)	(a)->red
#define	oldgreenmap(a)	(a)->green
#define	oldbluemap(a)	(a)->blue

