#include <stdio.h>
#include <math.h>
#ifdef PC
#include <signal.h>
#include <fcntl.h>
#include <string.h>
#define rindex strrchr
#else
#ifdef SYSV
#include <fcntl.h>
#else
#ifdef VMS
#include <types.h>
#include <file.h>
#else
#include <sys/types.h>
#include <sys/file.h>
#endif
#endif
#endif
#ifdef VMS
#include <string.h>
#define rindex strrchr
#endif
#ifdef MIPS
#include <string.h>
#define rindex strrchr
#endif
#ifdef PC
#ifdef TC
#include <time.h>
#ifdef _STKLEN
unsigned _stklen = _STKLEN;
#else
unsigned _stklen = 8192 * 2 * 2;
#endif
#else
#include <sys/timeb.h>
#endif
#else
#include <sys/times.h>
#endif
#ifdef CRAY
#include <string.h>
#define rindex strrchr
#endif

#include "art.h"
#include "objs.h"
#include "macro.h"
#include "gram.h"
#include "random.h"

extern char	*rindex();
extern hlist	*trace();
extern void	shade();
extern time_t	time();

extern object	*treeinit();

#ifndef VMS
FILE	*logfile = stdout;
#else
FILE	*logfile;
#endif

int	linecount;		/* line counter for parser */

object	*oblist;		/* object list */
object	*treeobjs, *otherobjs;	/* bsp-able and non-bsp-able objects */

light	*lights;		/* lights list */

objst	*ostackp;		/* object def stack */

attr	*astackp;		/* attribute stack */

mats	*mstackp;		/* transformation stack */

char	*title;			/* title of picture */

char	currentfile[MESLEN];	/* name of current "input" file */

int	perspective = TRUE;	/* projection - perspective or orthographic */
int	raysperpix = 1;		/* number of rays per pixel */
int	maxhitlevel = 6;	/* max number of rays traced in reflection */
long	filetype = PIX_RLE;	/* output file format */

short	raynumber = 1;		/* initial raynumber */

float	screenx = 1.0,		/* half screen width */
	screeny = 1.0;		/* half screen height */

float	tolerance;		/* tolerance value */

int	maxtreedepth = 35;	/* max depth for kd tree */

/*
 * ambient colour and background pixel stuff
 */
colour	ambient;
colour	backcol = { 0.0, 0.0, 0.0 };

/*
 * light falloff
 */
float	falloff = 0.0;

/*
 * global refractive index
 */
float	ri = 1.0;

/*
 * pointer to the free list for hit structures
 */
hlist	*fhlist;

/*
 * details for the primary rays
 */
vector	org;

vector	up = { 0.0, 1.0, 0.0 };

float	focallength = -1.0;

matrix	trans = {
	1.0, 0.0, 0.0, 0.0,
	0.0, 1.0, 0.0, 0.0,
	0.0, 0.0, 1.0, 0.0,
	0.0, 0.0, 0.0, 1.0
};

/*
 * shading stack
 */
shadedata	*sstack, *sstackp;

/*
 * haze stuff
 */
float	fogfactor = 0.0,		/* the fog factor */
	rfactor = 0.03;			/* the mysterious "r" factor */


colour	hazecolour = { 1.0, 1.0, 1.0 };	/* the haze colour */

float	sourceradius;		/* For ripple texture */

/*
 * temporary file pointer
 */
char	*tmpname;

/*
 * random number pointers
 */
float	*randp = randtable,
	*erandp = &randtable[sizeof(randtable) / sizeof(float)];

/*
 * function pointer tables for intersections, normals, etc...
 */
hlist	*(*intersects[NUM_OBJS])();
void	(*normal[NUM_OBJS])();
void	(*tilefun[NUM_OBJS])();

int	checkbbox[NUM_OBJS];	/* should we check bounding box of this type */
int	selfshadowing[NUM_OBJS];	/* is this object self shadowing? */

/*
 * x, y offsets, scale, and sampleing
 */
static int	xoff, yoff;
static float	xscale, yscale;
static int	ysperpix, xsperpix;

/*
 * frame id extension and frame number
 */
char	*frameid = "000";
int	frameno = 0;

/*
 * default name
 */
char	*defname = "pic.pix";

int shadow_rays	= FALSE;		/* are rays for shadow testing? */
 
/*
 * antialiasing stuff
 */
int		pixelgrid = FALSE;	/* pixel grid on or off */
static int	extrarays,      	/* spare rays for jittering */
		totrays;        	/* total number of rays per pixel */

static pixel	*topline;       /* scanline of sample grid at top of current scanline */

static pixel	others[2];      /* bottom 2 samples of pixel grid */

static float	averagefactor;	/* number to divide final samples through by */
			      
/*
 * statistics stuff
 */
#ifdef STATS
static int	totnodes;
static int	totleafs;
static int	neverentered;
static int	maxfinaldepth;
static int	maxinleaf;
static int	mininleaf;
static int	emptynodes;
static int	numobjptrs;
#endif

#ifdef TIME_STATS
static float    prev_time;
static time_t  start_time, rprev_time, tstart_time;
static struct tms       buffer;
#endif

#ifdef PC
int	EMS_available = FALSE;
void	ctrl_C(void);	/* CTRL-C trap processor */

#endif

static int	totobjs;

/*
 * debugging flag.
 */
int	debug = FALSE;

/*
 * usage
 *
 *	print out usage details for art.
 */
usage(s)
	char    *s;
{
	if (s != (char *)NULL)
		warning(s);

	fatal("usage: art [-v] file.scn x_res y_res [-x x1 x2] [-y y1 y2] [-f frameid] [-o outputname] [-n] [-D var=expr]\n");
}

/*
 * main driver
 */
main(ac, av)
	int	ac;
	char	*av[];
{
	int		y, x, chatty, indx, standardin, preprocess, nameset;
	char		*p, name[BUFSIZ], buf[BUFSIZ];
	image		*im;
	FILE		*infile;
	unsigned char	*red, *green, *blue, *alpha;
	int		i, fragment, xsize, ysize, xstart, xend, ystart, yend;
	object		*o, *nexto;
	float		k1, k2;
	expression	*e;
#ifdef LOSINGTRACK
	char		hostname[65], pathname[513];
#endif

	if (ac < 4)
		usage((char *)NULL);

#ifdef TIME_STATS
	times(&buffer);
	start_time = buffer.tms_utime + buffer.tms_stime;
#endif

#ifdef PC
	if (EMS_rdy()) EMS_available = TRUE;
	signal(SIGINT, ctrl_C); 			/* trap user aborts */
#endif

	if (strcmp(av[1], "-v") == 0) {
		indx = 2;
		chatty = TRUE;
	} else {
		chatty = FALSE;
		indx = 1;
	}

	xsize = atoi(av[indx + 1]);
	ysize = atoi(av[indx + 2]);

	xstart = 0;
	xend = xsize - 1;

	ystart = ysize - 1;
	yend = 0;

#ifndef OLDFOV
	if (xsize > ysize)
		focallength = -(float)xsize / (float)ysize;
	else
		focallength = -(float)ysize / (float)xsize;
#endif

	preprocess = TRUE;
	nameset = FALSE;
	standardin = FALSE;
	fragment = FALSE;
					/* check for other options */
	for (i = indx + 3; i < ac; i++) {
		if (strcmp(av[i], "-y") == 0) {
			if (av[i + 1] == (char *)NULL)
				usage("art: -y requires two numbers.\n");
			if (av[i + 2] == (char *)NULL)
				usage("art: -y requires two numbers.\n");
			ystart = ysize - atoi(av[i + 1]) - 1;
			yend = ysize - atoi(av[i + 2]) - 1;
			fragment = TRUE;
			i += 2;
		} else if (strcmp(av[i], "-x") == 0) {
			if (av[i + 1] == (char *)NULL)
				usage("art: -x requires two numbers.\n");
			if (av[i + 2] == (char *)NULL)
				usage("art: -x requires two numbers.\n");
			xstart = atoi(av[i + 1]);
			xend = atoi(av[i + 2]);
			fragment = TRUE;
			i += 2;
		} else if (strcmp(av[i], "-D") == 0) {
			if (av[i + 1] == (char *)NULL)
				usage("art: -D requires an assignment string.\n");
			doassignment(av[i + 1]);
			i += 1;
		} else if (strcmp(av[i], "-f") == 0) {
			if (av[i + 1] == (char *)NULL)
				usage("art: -f requires frame identifier.\n");
			frameid = av[i + 1];
			if ('0' <= frameid[0] && '9' >= frameid[0])
				frameno = atoi(frameid);
			i += 1;
		} else if (strcmp(av[i], "-o") == 0) {
			if (av[i + 1] == (char *)NULL)
				usage("art: -o requires name.\n");
			defname = av[i + 1];
			nameset = TRUE;
			i += 1;
		} else if (strcmp(av[i], "-n") == 0) {
			preprocess = FALSE;
		} else {
			sprintf(buf, "art: unknown option %s.\n", av[i]);
			usage(buf);
		}
	}

	sourceradius = 100.0;

	mstackp = (mats *)smalloc(sizeof(mats));
	mident4(mstackp->d.om);
	mident4(mstackp->d.vm);
	mident4(mstackp->d.obj2ray);
	mident4(mstackp->d.ray2obj);
	mstackp->d.maxscale = 1.0;
	mstackp->d.nscales.x = mstackp->d.nscales.y = mstackp->d.nscales.z = 1.0;

	mstackp->lst = mstackp->nxt = (mats *)NULL;

	astackp = (attr *)smalloc(sizeof(attr));

	astackp->d.s = (surface *)smalloc(sizeof(surface));
	astackp->d.s->falloff = 0.0;
	astackp->d.s->trans.r = astackp->d.s->trans.g = 0.0;
	astackp->d.s->trans.b = 0.0;
	astackp->d.s->refl.r = astackp->d.s->refl.g = 0.0;
	astackp->d.s->refl.b = 0.0;
	astackp->d.s->c.r = astackp->d.s->c.g = astackp->d.s->c.b = 1.0;
	astackp->d.s->a.r = astackp->d.s->a.g = astackp->d.s->a.b = 0.1;
	astackp->d.s->ri = astackp->d.s->kd = 1.0;
	astackp->d.s->ks = 0.0;
	astackp->d.s->shadows = TRUE;
	astackp->d.txtlist = (texture *)NULL;
	astackp->d.shadows = TRUE;
	astackp->d.slevel = 0;

	astackp->lst = astackp->nxt = (attr *)NULL;

	ostackp = (objst *)smalloc(sizeof(objst));
	ostackp->sym = (symbol *)NULL;

	ostackp->lst = ostackp->nxt = (objst *)NULL;

	linecount = 1;

	if (strcmp(av[indx], "-") == 0)
		standardin = TRUE;
		
	if (standardin || nameset) {
		strcpy(name, defname);

		if ((p = rindex(name, '.')) == (char *)NULL)
			fatal("art: output file should end with \".pix\".\n");
	} else {
		strcpy(name, av[indx]);

		if ((p = rindex(name, '.')) == (char *)NULL)
			fatal("art: input file should end with \".scn\".\n");
		standardin = FALSE;
	}

	strcpy(p, ".log");
	if ((logfile = fopen(name, "w")) == NULL) {
		sprintf(buf, "art: unable to open %s for writing.\n", name);
		fatal(buf);
	}

#ifdef LOSINGTRACK
	gethostname(hostname, 64);
	getwd(pathname, 512);
	fprintf(logfile, "Host: %s	Directory: %s\n", hostname, pathname);
	fflush(logfile);
#endif

	if (!standardin) {
		if (preprocess) {
			strcpy(p, "XXXXXX");
			mktemp(name);

			if ((infile = fopen(name, "w")) == NULL) {
				sprintf(buf, "art: unable to open temporary file %s.\n", name);
				fatal(buf);
			}

			prepro(av[indx], infile);

			fclose(infile);
		} else
			strcpy(name, av[indx]);
	}

	if (!standardin) {
#ifdef PC
		if ((infile = freopen(name, "rt", stdin)) == NULL) {
#else
		if ((infile = freopen(name, "r", stdin)) == NULL) {
#endif
			sprintf(buf, "art: unable to open file %s.\n", av[1]);
			fatal(buf);
		}
	}

#ifndef PC
	if (preprocess)
		unlink(name);
#endif

	/*
	 * initialise variable symbol table
	 */
	e = (expression *)smalloc(sizeof(expression));
	e->type = EXP_INT;
	e->u.i = 'x';
	defvar("x", e);

	e = (expression *)smalloc(sizeof(expression));
	e->type = EXP_INT;
	e->u.i = 'y';
	defvar("y", e);

	e = (expression *)smalloc(sizeof(expression));
	e->type = EXP_INT;
	e->u.i = 'z';
	defvar("z", e);

	/*
	 * initialise object symbol table
	 */
	defobj("geometry", GEOMETRY, (details *)NULL);
	defobj("sphere", SPHERE, (details *)NULL);
	defobj("ellipsoid", ELLIPSOID, (details *)NULL);
	defobj("box", BOX, (details *)NULL);
	defobj("torus", TORUS, (details *)NULL);
	defobj("algebraic", ALGEBRAIC, (details *)NULL);
	defobj("cylinder", CYLINDER, (details *)NULL);
	defobj("cone", CONE, (details *)NULL);
	defobj("superquadric", SUPERQUADRIC, (details *)NULL);
	defobj("ring", RING, (details *)NULL);
	defobj("disk", RING, (details *)NULL);
	defobj("light", LIGHT, (details *)NULL);
	defobj("polygon", POLYGON, (details *)NULL);

	if (preprocess)
		tmpname = name;
	else
		tmpname = (char *)NULL;

	yyparse();		/* read in model and set oblist */

#ifdef PC
	if (preprocess)
		unlink(name);
#endif

	if (!standardin)
		fclose(infile);	/* get rid of temp file (unlinked above) */

#ifdef TIME_STATS
	printtime("Preprocessing time		:");
#endif

	/*
	 * initialise shade stack
	 */
	sstack = (shadedata *)scalloc(sizeof(shadedata), maxhitlevel);

	sstack[0].ri = ri;
	sstack[0].falloff = falloff;

	sstackp = sstack;

	treeobjs = otherobjs = (object *)NULL;

	for (o = oblist; o != (object *)NULL; o = nexto) {
		nexto = o->nxt;
		if (o->type == ALGEBRAIC) {
			o->nxt = otherobjs;
			otherobjs = o;
			totobjs++;
		} else if (o->type == NULL_OBJ) 
			free(o);
		else {
			o->nxt = treeobjs;
			treeobjs = o;
			totobjs++;
		}
	}

	if (treeobjs != (object *)NULL) {
		oblist = treeinit(treeobjs);

		tolerance = sqrt(sqr(oblist->bb.max[X] - oblist->bb.min[X]) + sqr(oblist->bb.max[Y] - oblist->bb.min[Y]) + sqr(oblist->bb.max[Z] - oblist->bb.min[Z])) / 2.0 * TOLERANCE;

		for (o = treeobjs; o != (object *)NULL; o = o->nxt) {
			o->bb.min[X] -= tolerance;
			o->bb.min[Y] -= tolerance;
			o->bb.min[Z] -= tolerance;

			o->bb.max[X] += tolerance;
			o->bb.max[Y] += tolerance;
			o->bb.max[Z] += tolerance;
		}

		oblist->obj.tree->bb.min[X] -= tolerance;
		oblist->obj.tree->bb.min[Y] -= tolerance;
		oblist->obj.tree->bb.min[Z] -= tolerance;

		oblist->obj.tree->bb.max[X] += tolerance;
		oblist->obj.tree->bb.max[Y] += tolerance;
		oblist->obj.tree->bb.max[Z] += tolerance;

		oblist->nxt = otherobjs;
	} else {
		oblist = otherobjs;
		tolerance = TOLERANCE;
	}

	/*
	 * set up intersection and normal function pointers
	 */
	spheretabinit(intersects, normal, tilefun, checkbbox, selfshadowing);
	boxtabinit(intersects, normal, tilefun, checkbbox, selfshadowing);
	torustabinit(intersects, normal, tilefun, checkbbox, selfshadowing);
	cyltabinit(intersects, normal, tilefun, checkbbox, selfshadowing);
	conetabinit(intersects, normal, tilefun, checkbbox, selfshadowing);
	ellipstabinit(intersects, normal, tilefun, checkbbox, selfshadowing);
	geomtabinit(intersects, normal, tilefun, checkbbox, selfshadowing);
	polytabinit(intersects, normal, tilefun, checkbbox, selfshadowing);
	supertabinit(intersects, normal, tilefun, checkbbox, selfshadowing);
	ringtabinit(intersects, normal, tilefun, checkbbox, selfshadowing);
	csgtabinit(intersects, normal, tilefun, checkbbox, selfshadowing);
	algtabinit(intersects, normal, tilefun, checkbbox, selfshadowing);
	hfieldtabinit(intersects, normal, tilefun, checkbbox, selfshadowing);
	treetabinit(intersects, normal, tilefun, checkbbox, selfshadowing);

	strcpy(p, PIX_SUFFIX);

	imagebufsize(512);
	if ((im = openimage(name, "w")) == (image *)NULL) {
		sprintf(buf, "art: unable to open %s for writing\n", name);
		fatal(buf);
	}

	imagetype(im) = filetype;

	imagewidth(im) = xend - xstart + 1;
	imageheight(im) = ystart - yend + 1;

	imagedepth(im) = 24;

	imagedate(im) = time((time_t *)NULL);

	imagebackgnd(im).r = backcol.r * 255.0;
	imagebackgnd(im).g = backcol.g * 255.0;
	imagebackgnd(im).b = backcol.b * 255.0;

	if (title == (char *)NULL)
		titlelength(im) = 0;
	else {
		titlelength(im) = strlen(title) + 1;
		imagetitle(im) = title;
	}

	if (fragment) {
		imagefragment(im) = TRUE;
		imagexaddr(im) = xstart;
		imageyaddr(im) = ysize - 1 - ystart;
		imageorigwidth(im) = xsize;
		imageorigheight(im) = ysize;
	}

	writeheader(im);

	xoff = xsize / 2;
	yoff = ysize / 2;

	if (xsize > ysize)
		xscale = yscale = ysize / 2;
	else
		xscale = yscale = xsize / 2;

	red = (unsigned char *)scalloc(xsize, 1);
	green = (unsigned char *)scalloc(xsize, 1);
	blue = (unsigned char *)scalloc(xsize, 1);
	alpha = (unsigned char *)scalloc(xsize, 1);

	if (oblist != (object *)NULL)
		sprintf(buf, "world bounding box: %+11.4f %+11.4f %+11.4f\n                    %+11.4f %+11.4f %+11.4f\n",
		oblist->obj.tree->bb.min[X], oblist->obj.tree->bb.min[Y], oblist->obj.tree->bb.min[Z],
		oblist->obj.tree->bb.max[X] , oblist->obj.tree->bb.max[Y] , oblist->obj.tree->bb.max[Z]);

	if (chatty)
		printf(buf);
	message(buf);

	if (pixelgrid) {
		extrarays = raysperpix - 1;
		totrays = extrarays + 4;

		averagefactor = 255.0 / totrays;

		topline = (pixel *)scalloc(sizeof(pixel), xend + 2);

		k2 = (ystart + 1 - yoff) / yscale;

		for (i = xstart; i <= xend + 1; i++)
			gensample((i - xoff) / xscale, k2, &topline[i]);

		k1 = (xstart - xoff) / xscale;

		for (y = ystart; y >= yend; y--) {

			if (chatty)
				printf("\r(%03d)", ysize - y - 1);

			gensample(k1, (y - yoff) / yscale, &others[0]);

			for (x = xstart; x <= xend; x++) {
				dotrace2(x, y, &red[x - xstart], &green[x - xstart], &blue[x - xstart], &alpha[x - xstart]);
			}

			if (alphachannel(im))
				writergbaline(im, red, green, blue, alpha);
			else
				writergbline(im, red, green, blue);
		}

	} else {
		for (y = ystart; y >= yend; y--) {

			if (chatty)
				printf("\r(%03d)", ysize - y - 1);

			for (x = xstart; x <= xend; x++)
				dotrace1(x, y, &red[x - xstart], &green[x - xstart], &blue[x - xstart], &alpha[x - xstart]);

			if (alphachannel(im))
				writergbaline(im, red, green, blue, alpha);
			else
				writergbline(im, red, green, blue);
		}
	}

#ifdef PC
	/* deallocate storage used by tile patterns, esp. EMS */
	uninit_tiles();
#endif

	closeimage(im);

#ifdef TIME_STATS
	printtime("Total time taken		:");
#endif

#ifdef STATS
	sprintf(buf, "Total number of objects		: %d\n", totobjs);
	message(buf);

	if (treeobjs != (object *)NULL) {
		mininleaf = totobjs;

		getstats(oblist->obj.tree);

		sprintf(buf, "Total number of tree nodes	: %d\n", totnodes);
		message(buf);
		sprintf(buf, "Number of leaf nodes not entered: %d\n", neverentered);
		message(buf);
		sprintf(buf, "Number of leaf nodes entered	: %d\n", totleafs);
		message(buf);
		sprintf(buf, "Number of object pointers	: %d\n", numobjptrs);
		message(buf);
		sprintf(buf, "Min number of objects in a leaf	: %d\n", mininleaf);
		message(buf);
		sprintf(buf, "Max number of objects in a leaf	: %d\n", maxinleaf);
		message(buf);
		sprintf(buf, "Max depth of a leaf node	: %d\n", maxfinaldepth);
		message(buf);
		sprintf(buf, "Number of empty nodes		: %d\n", emptynodes);
		message(buf);
	}
#endif

	exit(ALLOK);
}

/*
 * gensample
 *
 *	generate a sample value for a given ray
 */
gensample(k1, k2, sample)
	float	k1, k2;
	pixel	*sample;
{
	ray	ir;
	hlist	*hit, *lp, *p;
	float	fact;

	if (perspective) {
		ir.org.x = ir.dir.x = k1;
		ir.org.y = ir.dir.y = k2;
		
		ir.org.z = 0.0;
		ir.dir.z = focallength;
		normalise(ir.dir);
	} else {
		ir.org.x = k1;
		ir.org.y = k2;
		ir.org.z = 0.0;

		ir.dir.x = 0.0;
		ir.dir.y = 0.0;
		ir.dir.z = -1.0;
	}

	ir.org.x *= screenx;
	ir.org.y *= screeny;

	ir.ri = ri;
	ir.type = PRIMARY_RAY;
	ir.raynumber = raynumber++;

	ir.orgobj = (object *)NULL;

	if ((hit = trace(&ir, oblist)) != (hlist *)NULL) {
		shade(sample, &ir, hit, 0);
		fact = 1.0 / (1.0 + falloff * hit->t);
		sample->r *= fact;
		sample->g *= fact;
		sample->b *= fact;
		sample->a = 1.0;
	} else {
		sample->r = backcol.r;
		sample->g = backcol.g;
		sample->b = backcol.b;
		sample->a = 0.0;
	}

	for (lp = hit; lp != (hlist *)NULL; lp = p) {
		p = lp->nxt;
		release(lp);
	}
}

/*
 * dotrace1
 *
 *	Generate a straight no-nonsense sampling for the image, if you
 * like weird filters and postprocessing this is the one for you!
 */
dotrace1(x, y, r, g, b, a)
	int		x, y;
	unsigned char	*r, *g, *b, *a;
{
	pixel	pix;
	object	*o;

	gensample((x - xoff + 0.5) / xscale, (y - yoff + 0.5) / yscale, &pix);

	if (raynumber < 0) {
		for (o = treeobjs; o != (object *)NULL; o = o->nxt)
			o->lastray.raynumber = 0;
		raynumber = 1;
	}

	*r = pix.r * 255.0;
	*g = pix.g * 255.0;
	*b = pix.b * 255.0;
	*a = pix.a * 255.0;
}

/*
 * dotrace2
 *
 *	traces the neccessary number of rays and calculates r,
 * g, b, and alpha info averaging the samples at the end.
 */
dotrace2(x, y, r, g, b, a)
	int		x, y;
	unsigned char	*r, *g, *b, *a;
{
	int	i;
	pixel	sample;
	float	red, green, blue, alpha;
	object	*o;

	red = green = blue = alpha = 0.0;

	gensample((x + 1 - xoff) / xscale, (y - yoff) / yscale, &others[1]);

	red = (topline[x].r + topline[x + 1].r + others[0].r + others[1].r);
	green = (topline[x].g + topline[x + 1].g + others[0].g + others[1].g);
	blue = (topline[x].b + topline[x + 1].b + others[0].b + others[1].b);
	alpha = (topline[x].a + topline[x + 1].a + others[0].a + others[1].a);

	topline[x] = others[0];
	others[0] = others[1];

	if (extrarays) {
		gensample((x - xoff + 0.5) / xscale, (y - yoff + 0.5) / yscale, &sample);
		red += sample.r;
		green += sample.g;
		blue += sample.b;
		alpha += sample.a;

		for (i = 1; i != extrarays; i++) {
			gensample((x - xoff + randnum()) / xscale, (y - yoff + randnum()) / yscale, &sample);

			red += sample.r;
			green += sample.g;
			blue += sample.b;
			alpha += sample.a;
		}
	}

	if (alpha != 0.0) {
		*r = red * averagefactor + randnum();
		*g = green * averagefactor + randnum();
		*b = blue * averagefactor + randnum();
		*a = alpha * averagefactor;
	} else {
		*r = red * averagefactor;
		*g = green * averagefactor;
		*b = blue * averagefactor;
		*a = alpha * averagefactor;
	}

	if (raynumber < 0) {
		for (o = treeobjs; o != (object *)NULL; o = o->nxt)
			o->lastray.raynumber = 0;
		raynumber = 1;
	}
}

#ifdef STATS
/*
 * getstats
 *
 *	calculate the statistics for the kd-tree pointed to by 
 * root.
 */
getstats(root)
	stree	*root;
{
	olist	*obs;
	int	count;

	totnodes++;

	if (root->type == SPLITABLELEAF)
		neverentered++;
	else if (root->type == LEAF) {
		if (maxfinaldepth < root->u.leaf.depth)
			maxfinaldepth = root->u.leaf.depth;
		if (root->u.leaf.oblist == (olist *)NULL)
			emptynodes++;
		else {
			count = 0;
			for (obs = root->u.leaf.oblist; obs != (olist *)NULL; obs = obs->nxt)
				count++;
			numobjptrs += count;
			if (mininleaf > count)
				mininleaf = count;
			if (maxinleaf < count)
				maxinleaf = count;
			totleafs++;
		}
	} else {
		getstats(root->u.branch.left);
		getstats(root->u.branch.right);
	}
}
#endif

#ifdef TIME_STATS
/*
 * printtime
 *
 *      print out how much time has been taken up.
 */
printtime(s)
	char    *s;
{
	float           diff;
	time_t          now, real;
	char            buf[BUFSIZ];

	times(&buffer);

	diff = buffer.tms_utime + buffer.tms_stime - start_time;

	sprintf(buf, "%s %.2f seconds.\n", s, diff / 60.0);       
	message(buf);
}

#endif

#ifdef PC
/****
 * Handle user abort requests.
 **/

void 	ctrl_C()
{
	signal(SIGINT, SIG_IGN);	/* ignore any abort requests in this routine */
	uninit_tiles();
	exit(1);
}
#endif




