/*
 * VORT - PCDISP.
 *
 * SuperVGA 256-Colour display routines.
 *
 * Adapted from the video routines contained in FRACTINT.
 *
 * Super VGA chipsets supported:
 *		
 * 		video7
 * 		tseng
 * 		tseng4000
 * 		paradise
 * 		chipstech
 * 		trident
 * 		ativga
 * 		everex
 * 		ahead (Ver. A & B)
 *		oaktech
 */

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <memory.h>
#include "pcdisp.h"


extern int	vega_palette();
extern int	vega_overscan();

static int svga_init();
static int svga_block();
static int svga_fill();
static int svga_front();
static int svga_back();
static int svga_swap();
static int svga_text();

extern int aheada_bank();
extern int aheadb_bank();
extern int video7_bank();
extern int tseng_bank();
extern int tseng4_bank();
extern int paradise_bank();
extern int chips_bank();
extern int trident_bank();
extern int ati_bank();
extern int everex_bank();
extern int oaktech_bank();
extern int svga_putline(void far *, int, int, int);
extern int svga_EMSdecode(int, ULONG, int, int, int, int);
extern int svga_getline(void far *, int, int, int);


/* structure for SuperVGA boards */
/* some values are set for specific manufacturer's boards */
static	ADAPTER	supervga = {
			NULL,
			0, 0,			/* width, height */
			8,				/* depth */
			0, 0,			/* register values for mode initialization (ax, bx) */
			0,				/* current video bank */
			svga_init,
			svga_putline,
			svga_EMSdecode,
			svga_getline,
			svga_block,
			svga_fill,
			vega_palette,
			vega_overscan,
			svga_front,
			svga_back,
			svga_swap,
			svga_text,
			NULL,			/* bank select function (specific to manufacturer) */
			NULL,
			};


/* currently defined adapter */
extern	ADAPTER	v_adapter;
extern	int		adapter_x,
				adapter_y;
extern	int		adapter_dbuf;
extern	UINT	adapter_bank;
UCHAR			svga_cur_bank = 0;

/* for doing system stuff */
static	union	REGS	regs;
static	struct	SREGS	segregs;


/* svga video buffer pointers */
static UCHAR far	*vfbuf,
					*vbbuf,
					*vp;

/* video buffer flag: == 0 front buffer; != 0 back buffer */
static	int		to_back_buffer = 0;



/*
 * Routines to set up a list of each mode supported for each
 * brand of SuperVGA board.
 */

int			setup_aheada(a)
ADAPTER		*a;
{
	a[0] = supervga;
	a[1] = supervga;
	a[2] = supervga;

	a[0].descr = "AHEAD (Ver. A) 640 x 400, 256 colour";
	a[0].width = 640; a[0].height = 400; a[0].ax = 0x0060; a[0].bx = 0x0000; a[0].select_bank = aheada_bank;
	a[1].descr = "AHEAD (Ver. A) 640 x 480, 256 colour";
	a[1].width = 640; a[1].height = 480; a[1].ax = 0x0061; a[1].bx = 0x0000; a[1].select_bank = aheada_bank;
	a[2].descr = "AHEAD (Ver. A) 800 x 600, 256 colour";
	a[2].width = 800; a[2].height = 600; a[2].ax = 0x0062; a[2].bx = 0x0000; a[2].select_bank = aheada_bank;
	return 3;
}


int			setup_aheadb(a)
ADAPTER		*a;
{
	a[0] = supervga;
	a[1] = supervga;
	a[2] = supervga;

	a[0].descr = "AHEAD (Ver. B) 640 x 400, 256 colour";
	a[0].width = 640; a[0].height = 400; a[0].ax = 0x0060; a[0].bx = 0x0000; a[0].select_bank = aheadb_bank;
	a[1].descr = "AHEAD (Ver. B) 640 x 480, 256 colour";
	a[1].width = 640; a[1].height = 480; a[1].ax = 0x0061; a[1].bx = 0x0000; a[1].select_bank = aheadb_bank;
	a[2].descr = "AHEAD (Ver. B) 800 x 600, 256 colour";
	a[2].width = 800; a[2].height = 600; a[2].ax = 0x0062; a[2].bx = 0x0000; a[2].select_bank = aheadb_bank;
	return 3;
}


int			setup_ati(a)
ADAPTER		*a;
{
	a[0] = supervga;
	a[1] = supervga;
	a[2] = supervga;

	a[0].descr = "ATI 640 x 400, 256 colour";
	a[0].width = 640; a[0].height = 400; a[0].ax = 0x0061; a[0].bx = 0x0000; a[0].select_bank = ati_bank;
	a[1].descr = "ATI 640 x 480, 256 colour";
	a[1].width = 640; a[1].height = 400; a[1].ax = 0x0062; a[1].bx = 0x0000; a[1].select_bank = ati_bank;
	a[2].descr = "ATI 800 x 600, 256 colour";
	a[2].width = 800; a[2].height = 600; a[2].ax = 0x0063; a[2].bx = 0x0000; a[2].select_bank = ati_bank;
	return 3;
}


int			setup_tseng(a)
ADAPTER		*a;
{
	a[0] = supervga;
	a[1] = supervga;
	a[2] = supervga;
	a[3] = supervga;
	a[4] = supervga;

	a[0].descr = "TSENG 640 x 350, 256 colour";
	a[0].width = 640; a[0].height = 350; a[0].ax = 0x002d; a[0].bx = 0x0000; a[0].select_bank = tseng_bank;
	a[1].descr = "TSENG 640 x 400, 256 colour";
	a[1].width = 640; a[1].height = 400; a[1].ax = 0x0000; a[1].bx = 0x00fe; a[1].select_bank = tseng_bank;
	a[2].descr = "TSENG 640 x 480, 256 colour";
	a[2].width = 640; a[2].height = 480; a[2].ax = 0x002e; a[2].bx = 0x0000; a[2].select_bank = tseng_bank;
	a[3].descr = "TSENG 720 x 512, 256 colour";
	a[3].width = 720; a[3].height = 512; a[3].ax = 0x002f; a[3].bx = 0x0000; a[3].select_bank = tseng_bank;
	a[4].descr = "TSENG 800 x 600, 256 colour";
	a[4].width = 800; a[4].height = 600; a[4].ax = 0x0030; a[4].bx = 0x0000; a[4].select_bank = tseng_bank;
	return 5;
}


int			setup_trident(a)
ADAPTER		*a;
{
	a[0] = supervga;
	a[1] = supervga;
	a[2] = supervga;

	a[0].descr = "TRIDENT 640 x 400, 256 colour";
	a[0].width = 640; a[0].height = 400; a[0].ax = 0x005c; a[0].bx = 0x0000; a[0].select_bank = trident_bank;
	a[1].descr = "TRIDENT 640 x 480, 256 colour";
	a[1].width = 640; a[1].height = 400; a[1].ax = 0x005d; a[1].bx = 0x0000; a[1].select_bank = trident_bank;
	a[2].descr = "TRIDENT 800 x 600, 256 colour";
	a[2].width = 640; a[2].height = 400; a[2].ax = 0x005e; a[2].bx = 0x0000; a[2].select_bank = trident_bank;
	return 3;
}


int			setup_paradise(a)
ADAPTER		*a;
{
	a[0] = supervga;
	a[1] = supervga;

	a[0].descr = "PARADISE 640 x 400, 256 colour";
	a[0].width = 640; a[0].height = 400; a[0].ax = 0x005e; a[0].bx = 0x0000; a[0].select_bank = paradise_bank;
	a[1].descr = "PARADISE 640 x 480, 256 colour";
	a[1].width = 640; a[1].height = 480; a[1].ax = 0x005f; a[1].bx = 0x0000; a[1].select_bank = paradise_bank;
	return 2;
}


int			setup_everex(a)
ADAPTER		*a;
{
	a[0] = supervga;
	a[1] = supervga;
	a[2] = supervga;
	a[3] = supervga;
	a[4] = supervga;

	a[0].descr = "EVEREX 640 x 350, 256 colour";
	a[0].width = 640; a[0].height = 350; a[0].ax = 0x0070; a[0].bx = 0x0013; a[0].select_bank = everex_bank;
	a[1].descr = "EVEREX 640 x 400, 256 colour";
	a[1].width = 640; a[1].height = 400; a[1].ax = 0x0070; a[1].bx = 0x0014; a[1].select_bank = everex_bank;
	a[2].descr = "EVEREX 512 x 480, 256 colour";
	a[2].width = 512; a[2].height = 480; a[2].ax = 0x0070; a[2].bx = 0x0015; a[2].select_bank = everex_bank;
	a[3].descr = "EVEREX 640 x 480, 256 colour";
	a[3].width = 640; a[3].height = 480; a[3].ax = 0x0070; a[3].bx = 0x0030; a[3].select_bank = everex_bank;
	a[4].descr = "EVEREX 800 x 600, 256 colour";
	a[4].width = 800; a[4].height = 600; a[4].ax = 0x0070; a[4].bx = 0x0031; a[4].select_bank = everex_bank;
	return 5;
}


int			setup_chips(a)
ADAPTER		*a;
{
	a[0] = supervga;
	a[1] = supervga;
	a[2] = supervga;

	a[0].descr = "CHIPS & TECH. 640 x 400, 256 colour";
	a[0].width = 640; a[0].height = 400; a[0].ax = 0x0078; a[0].bx = 0x0000; a[0].select_bank = chips_bank;
	a[1].descr = "CHIPS & TECH. 640 x 480, 256 colour";
	a[1].width = 640; a[1].height = 400; a[1].ax = 0x0079; a[1].bx = 0x0000; a[1].select_bank = chips_bank;
	a[2].descr = "CHIPS & TECH. 800 x 600, 256 colour";
	a[2].width = 640; a[2].height = 400; a[2].ax = 0x007b; a[2].bx = 0x0000; a[2].select_bank = chips_bank;
	return 3;
}


int			setup_video7(a)
ADAPTER		*a;
{
	a[0] = supervga;
	a[1] = supervga;
	a[2] = supervga;
	a[3] = supervga;

	a[0].descr = "VIDEO7 640 x 400, 256 colour";
	a[0].width = 640; a[0].height = 400; a[0].ax = 0x6f05; a[0].bx = 0x0066; a[0].select_bank = video7_bank;
	a[1].descr = "VIDEO7 640 x 480, 256 colour";
	a[1].width = 640; a[1].height = 400; a[1].ax = 0x6f05; a[1].bx = 0x0067; a[1].select_bank = video7_bank;
	a[2].descr = "VIDEO7 720 x 540, 256 colour";
	a[2].width = 720; a[2].height = 540; a[2].ax = 0x6f05; a[2].bx = 0x0068; a[2].select_bank = video7_bank;
	a[3].descr = "VIDEO7 800 x 600, 256 colour";
	a[3].width = 640; a[2].height = 400; a[2].ax = 0x6f05; a[2].bx = 0x0069; a[2].select_bank = video7_bank;
	return 4;
}


int			setup_oaktech(a)
ADAPTER		*a;
{
	a[0] = supervga;
	a[1] = supervga;

	a[0].descr = "OAKTECH (OTI-067) 640 x 480, 256 colour";
	a[0].width = 640; a[0].height = 480; a[0].ax = 0x0053; a[0].bx = 0x0000; a[0].select_bank = oaktech_bank;
	a[1].descr = "OAKTECH (OTI-067) 800 x 600, 256 colour";
	a[1].width = 800; a[1].height = 600; a[1].ax = 0x0054; a[1].bx = 0x0000; a[1].select_bank = oaktech_bank;
	return 2;
}


int			setup_tseng4000(a)
ADAPTER		*a;
{
	a[0] = supervga;
	a[1] = supervga;
	a[2] = supervga;
	a[3] = supervga;
	a[4] = supervga;

	a[0].descr = "TSENG4000 640 x 350, 256 colour";
	a[0].width = 640; a[0].height = 350; a[0].ax = 0x002d; a[0].bx = 0x0000; a[0].select_bank = tseng4_bank;
	a[1].descr = "TSENG4000 640 x 400, 256 colour";
	a[1].width = 640; a[1].height = 400; a[1].ax = 0x002f; a[1].bx = 0x0000; a[1].select_bank = tseng4_bank;
	a[2].descr = "TSENG4000 640 x 480, 256 colour";
	a[2].width = 640; a[2].height = 480; a[2].ax = 0x002e; a[2].bx = 0x0000; a[2].select_bank = tseng4_bank;
	a[3].descr = "TSENG4000 800 x 600, 256 colour";
	a[3].width = 800; a[3].height = 600; a[3].ax = 0x0030; a[3].bx = 0x0000; a[3].select_bank = tseng4_bank;
	a[4].descr = "TSENG4000 1024 x 768, 256 colour";
	a[4].width = 1024; a[4].height = 768; a[4].ax = 0x0038; a[4].bx = 0x0000; a[4].select_bank = tseng4_bank;
	return 5;
}



static
int			svga_init()
{
	regs.x.ax = v_adapter.ax;
	regs.x.bx = v_adapter.bx;
 	int86(0x10, &regs, &regs);
	svga_cur_bank = 0;
}



static
int			svga_block(p, w, h, x, y)
char		*p;
int			w,
			h,
			x,
			y;
{
	int		i;

	for (i = 0; i < h; i++) {
		svga_putline(p + i*w, w, x, y+i);
		}
}



static
int			svga_fill(x, y, w, h, palette_index)
int			x, y;
int			w, h;
int			palette_index;
{
	char	*s;
	int		i,j;

	if (!(s = malloc(w))) {
		/* fill the slow way */
		for (j = 0; j < h; j++) {
			for (i = 0; i < w; i++) {
				svga_putline((char *)(&palette_index), 1, x+i, j+y);
				}
			}
		}
	else {
		/* the fast way */
		memset(s, palette_index, w);
		for (j = 0; j < h; j++) {
			svga_putline(s, w, x, j+y);
			}
		free(s);
		}
}


static
int			svga_front()
{
}


static
int			svga_back()
{
}


static
int			svga_swap()
{
}


static
int			svga_text(p, x, y)
char		*p;
int			x,
			y;
{
}

