/*
 * Header file for VORT pcdisp.
 *
 */

#ifndef TRUE
#define TRUE	1
#define FALSE	0
#endif

#define	MAX_PALETTE	256			/* max size of a colour palette */
#define	MAX_IMGWIDTH	2048	/* max width for an image */

/* for brevity */
typedef unsigned char UCHAR;
typedef unsigned int UINT;
typedef unsigned long ULONG;

typedef UCHAR (far *VIDEO);		/* far pointer to video memory */
typedef int (*PFI)();			/* pointer to function returning int */
typedef void (far *(*PFP)());	/* pointer to function returning far pointer */

/* video adapter info */
typedef struct _ADAPTER {		/* description of adapter */
			char	*descr;			/* text description of adapter (for usage info) */
			int		width,			/* max width in pixels */
					height,			/* max height in pixels */
					depth;			/* max depth in bits */
								/* register values for initializing mode with BIOS (used by init())*/
			UINT	ax,				/* ax value */
					bx;				/* bx value - 0 if not used */
			UINT	cb;			/* current video bank */
								/* functions */
			PFI		init,			/* initialize the device */
					putline,		/* copy a line of pixels to video */
					EMSdecode,		/* decode a VORT RLE image in EMS to video */
					getline,		/* copy a line of pixels from video - NOT IMPLEMENTED FULLY */
					block,			/* copy a block of pixels to video */
					fill,			/* fill block of pixels */
					palette,		/* set colour palette */
					overscan,		/* set overscan palette index */
					front,			/* write to front video buffer */
					back,			/* write to back video buffer */
					swap,			/* swap front and back buffers */
					text,			/* write text */
					select_bank;	/* select video memory bank (used internally by "paddr" only) */
			PFP		paddr;			/* return address of pixel */
			} ADAPTER;

/*

	Adapter functions:

		setup_xxxx()		- called explictly by main() to set ADAPTER stuff
		init()				- puts adapter into required graphics mode
		putline(p, w, x, y)	- writes pixel line "p" of pixel width "w" at co-ord (x,y)
							  to selected video buffer (front or back). The line should
							  be clipped.
		EMSdecode(hdl, ofs, x, y, xlen, ylen)
							- decodes the VORT RLE colour mapped image at EMS offset "ofs"
							  (owned by EMS handle "hdl") to the selected video buffer
							  at co-ords (x, y). The image has the dimensions (xlen, ylen).
		getline(p, w, x, y)	- copies a line starting at co-ord (x, y) with a length "w"
							  from selected video buffer to pixel buffer "p"
		block(p, w, h, x, y)- writes a block of pixels "p" of pixel width "w"
							  and height "h" starting at top left co-ord (x,y) to selected
							  video buffer (front or back). The block should be clipped.
		fill(x, y, w, h, c)	- sets specified area of video buffer to palette colour index "c"
		palette(p, size)	- sets first "size" colour palette entries to values in "p".
							  "p" palette entries are groups of 3 unsigned chars (r, g, b).
		overscan(c)			- sets the overscan palette colour index to "c"
		front()				- select the front video buffer. Does nothing if double buffering
							  is not possible or practical.
		back()				- select the back video buffer. Does nothing if double buffering
							  is not possible or practical.
		swap()				- swaps the front video buffer. Does nothing if double buffering
							  is not possible or practical.
		text(p, x, y)		- write text "p" to video buffer at top left co-ord (x,y)

*/

