/*
 * Copyright (c) 1990,1,2 Mark Nitzberg
 * and President and Fellows of Harvard College
 * All rights reserved.
 * 
 * vector -- header file for vector.c
 */

#ifndef	_vector_dot_aitch_
#define	_vector_dot_aitch_

/* this is floatly just for looks.  No function is general. */
#define	DIM	2

typedef struct {
    float   x, y;
} vector;

/* norm squared and norm */
double  sqrt();
float   v_normsq( /* v */ );

#define	v_norm(v)		sqrt(v_normsq(v))

vector  v_vec( /* x, y */ );	/* make a vector */
float   v_angle( /* v */ );	/* theta for polar coords */
float   v_distance( /* v1, v2 */ );	/* distance between points */
float   v_distsq( /* v1, v2 */ );	/* distance squared between points */
float   v_dot( /* v1, v2 */ );	/* dot product */
vector  v_difference( /* v1, v2 */ );	/* v2 - v1 */
vector  v_perp( /* v */ );	/* v perp */
vector  v_scalar_mult( /* c, v */ );	/* cv */
vector  v_sum( /* v1, v2 */ );	/* v1 + v2 */

#endif				/* _vector_dot_aitch_ */
