/***
 * Copyright (c) 1990,1,2 Mark Nitzberg
 * and President and Fellows of Harvard College
 * All rights reserved.
 *
 * e2fig -- make curve list into fig format
 *
 * e2fig [ file ...]
 *	produces file.fig for each file.
 *
 * with no args, reads stdin, writes stdout
 */
#include "edgemap.h"
#include "fig.h"

char    Usage[] = "\
Usage: %s [edgemap_file ...]\n\
	converts edgemap file to fig; produces `edgemap_file.fig'\n";

main(argc, argv)
int     argc;
char  **argv;
{
    char    c;
    extern char *optarg;
    extern int optind;

    PgmName = argv[0];

    while ((c = getopt(argc, argv, " ")) != -1) {

	switch (c) {

	case '?':		/* getopt() arg not in list */
	    fprintf(stderr, Usage, PgmName);
	    exit(1);

	}
    }

    if (optind < argc) {
	while (optind < argc) {
	    FIGcurves(argv[optind]);
	    optind++;
	}
    } else
	FIGcurves(NULL);

    return Status;
}

FIGcurves(file)
char   *file;
{
    char    buf[512];
    PointList *curve;
    FILE   *fin = stdin, *fout = stdout;
    int     i;

    CurrentFile = file;
    CurrentLine = 1;

    if (file != NULL) {
	if ((fin = fopen(file, "r")) == NULL) {
	    fprintf(stderr,
		    "%s: no access to `%s', not processed\n",
		    PgmName, file);
	    Status = 1;
	    return;
	}
	strcpy(buf, FileName(file, ".fig"));
	if ((fout = fopen(buf, "w")) == NULL) {
	    fprintf(stderr,
		    "%s: can't create `%s'; not processed\n",
		    PgmName, buf);
	    Status = 1;
	    return;
	}
    }
    if (ReadContours(fin) == FALSE) {
	if (file != NULL)
	    fclose(fin);
	Status = 1;
	return;
    }
    fprintf(fout, FIG_header);

    for (i = 0; i < NContours; i++) {
	curve = Contours[i].p;
	DrawFIGCurve(fout, curve);
    }

    if (file != NULL) {
	fclose(fin);
	fclose(fout);
	fprintf(stderr, "%s: Wrote FIG output to %s\n",
		PgmName, buf);
    }
    /* reset */
    FreeContours();
}



DrawFIGCurve(stream, curve)
FILE   *stream;
PointList *curve;
{
    int     i;

    if (curve->n < 1)
	return;

    fprintf(stream, FIG_contour_start(curve));

    /* all points */
    for (i = 0; i < curve->n; i++)
	fprintf(stream, FIG_point_fmt(curve->x[i], curve->y[i]));

    /* repeat last if closed */
    if (curve->closed)
	fprintf(stream, FIG_point_fmt(curve->x[0], curve->y[0]));

    fprintf(stream, FIG_contour_end);
}
