/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		xdisplay.c - Display a VIP in X.  This program also
*				     works in monochrome screen (using some
*				     dithering technique).
* REVISION:             3.4
* AUTHOR:               DH
* CREATION DATE:        20 February 1991
* REVISION DATE:	4/5/94
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.4
* REVISION DATE:	5 April 1994
* COMMENT:		Added conversion to BYTETYPE for non-BYTE images.
* BY:			PK
*
* REVISION:		3.3
* REVISION DATE:	24 March 1994
* COMMENT:		Fixed call from perror to pperror, (line 120).
* BY:			CFF
*
* REVISION:		3.2
* REVISION DATE:	12 August 1992
* COMMENT:		Fixed call to dodgy ute : ppmtogif, and sporadic dumps.
* BY:			CFF
*
* REVISION:		3.1
* REVISION DATE:	11 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)xdisplay.c	3.4 4/5/94";

#endif



#include <stdio.h>
#include <stdlib.h>

#include "vip.h"

void            usage();
void            pperror( char *, char * );
int             xdisp_image( struct struct_vip_IMAGE *, char *,
                             char * );
void            xloadimage( struct struct_vip_IMAGE * );


/* ***** Global variables ***** */
unsigned char rgb[3][256];
int     full_map = 0;

/*-------------------------------------------------------------------------*/


void    usage()
{
    fprintf(stderr,
	"usage: xdisplay [-F] [-m map_name] [-n image_name] [imagefile1...imagefile10]\n");
    exit(1);
}


/*-------------------------------------------------------------------------*/


void    pperror(m1, m2)
char   *m1, *m2;
{
    fprintf(stderr, "xdisplay: %s %s.\n", m1, m2);
    exit(1);
}


/*-------------------------------------------------------------------------*/


int     xdisp_image(im, map_name, image_name)
IMAGE  *im;
char   *map_name, *image_name;
{
    register int i;
    char    instruction[10][80];

    if (full_map)
	do_instruction("0-255:black-white", rgb);
    else
	for (i = 0; i < 128; i++)
	    rgb[0][i] = rgb[1][i] = rgb[2][i] = i;

    if (map_name) {
	if (!read_map(map_name, rgb))
	    return (0);
	for (i = 0; i < 10; i++)
	    if (instruction[i][0])
		do_instruction(instruction[i], rgb);
	    else
		break;
    }
    xloadimage(im);
}


/*-------------------------------------------------------------------------*/


void    xloadimage(im)
IMAGE  *im;
{
    FILE   *f;
    register int i, r, c;
    unsigned char *buf, *tmp, col;
    int     n;
    char    fname[80];

    n = im->cols * 3;
    if (!(buf = (unsigned char *) malloc(n)))
	pperror("Fail to allocate temporary dynamic variable", "");
    sprintf(fname, "/tmp/%d.im", getpid());
    f = fopen(fname, "w");
    if (f == NULL)
	pperror("write_output:", "fail to open temporary output file");

    /* write magic number and image size */
    fprintf(f, "P6\n");
    fprintf(f, "%d %d %d\n", im->cols, im->rows, (full_map ? 255 : 127));
    /* write pixel values */
    if (full_map) {
	for (r = 0; r < im->rows; r++) {
	    for (c = 0, tmp = buf; c < im->cols; c++, tmp += 3) {
		col = im->i.c[r][c];
		sprintf(tmp, "%c%c%c", rgb[0][col], rgb[1][col], rgb[2][col]);
	    }
	    if (fwrite(buf, n, 1, f) != 1)
		pperror("Error in writing output to file", " ");;
	}
    }
    else {
	for (r = 0; r < im->rows; r++) {
	    for (c = 0, tmp = buf; c < im->cols; c++, tmp += 3) {
		col = im->i.c[r][c] / 2;
		sprintf(tmp, "%c%c%c", rgb[0][col], rgb[1][col], rgb[2][col]);
	    }
	    if (fwrite(buf, n, 1, f) != 1)
		pperror("Error in writing output to file", " ");;
	}
    }
    fclose(f);

    sprintf(buf, "xv %s", fname);
    system(buf);
    buf[0] = '\0';
    sprintf(buf, "rm %s", fname);
    system(buf);

    free(buf);
}


/*-------------------------------------------------------------------------*/


main(argc, argv)
int     argc;
char   *argv[];
{
    int     argn, handle, num_images = 0, pid;
    register int i;
    static char *image_arg[10] = {NULL, NULL, NULL, NULL, NULL, NULL,
    NULL, NULL, NULL, NULL},
           *image_name = NULL, *map_name = NULL;
    IMAGE  *im, *temp;

    for (argn = 1; argn < argc; argn++) {
	if (argv[argn][0] == '-') {
	    switch (argv[argn][1]) {
	    case 'F':
		full_map = 1;
		break;
	    case 'm':
		if (++argn < argc)
		    map_name = argv[argn];
		else
		    usage();
		break;
	    case 'n':
		if (++argn < argc)
		    image_name = argv[argn];
		break;
	    default:
		usage();
	    }
	}
	else if (num_images < 10 && !image_arg[num_images])
	    image_arg[num_images++] = argv[argn];
	else
	    usage();
    }

    if (num_images == 0) {
	image_name = (image_name == NULL) ? "stdin" : image_name;
	num_images = 1;
	image_arg[0] = NULL;
    }

    for (i = 0; i < num_images; i++) {
	if ((pid = fork()) == -1)
	    perror("fork error");
	if (pid != 0) {
	    if (!(im = (IMAGE *) Read_Image(image_arg[i]))) {
		pperror("Fail to read VIP image from file", image_arg[i]);
	    }
	    else {
		if (im->type != BYTETYPE) {
		    temp = Convert2Byte_Image(im);
		    Free_Image(im);
		    im = temp;
		}
		image_name = (image_name == NULL) ? image_arg[i] : image_name;
		xdisp_image(im, map_name, image_name);
		num_images = 0;
	    }
	}
    }
    exit(0);
}


/*-------------------------------------------------------------------------*/
