/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		vip2ppm.c - Convert a V.I.P. image to an image of the PPM
*				    format.  The conversion routine works only on
*				    BYTETYPE and RGBTYPE images.
* REVISION:             3.1
* AUTHOR:               DH
* CREATION DATE:        
* REVISION DATE:	7/17/92	
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.1
* REVISION DATE:	16 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)vip2ppm.c	3.1 7/17/92";
#endif


#include <stdio.h>
#include <stdlib.h>
#include "vip.h"
#include "misc.h"


/*- Usage -----------------------------------------------------------

Print 'usage' message and exit program.

--------------------------------------------------------------------*/

void Usage()
{
    (void) fprintf(stderr, "usage: vip2ppm [vip_image_file] [-o ppm_image_file]\n");
    exit(1);
}


/*- Pperror ---------------------------------------------------------

Print error message and exit program.

--------------------------------------------------------------------*/

void Pperror(e)
char   *e;
{
    (void) fprintf(stderr, "vip2ppm: %s\n", e);
    exit(1);
}


/*- Main ------------------------------------------------------------

Main body of the program.

--------------------------------------------------------------------*/

main(argc, argv)
int     argc;
char   *argv[];
{
    int     argn;
    char   *image_arg = NULL, *out_arg = NULL;
    IMAGE  *im;

    for (argn = 1; argn < argc; argn++)
	if (argv[argn][0] == '-')
	    switch (argv[argn][1]) {
	    case 'o':
		out_arg = argv[++argn];
		break;
	    default:
		Usage();
	    }
	else if (!image_arg)
	    image_arg = argv[argn];
	else
	    Usage();


    if (!(im = ( IMAGE * ) Read_Image(image_arg)))
	Pperror("vision system error in Read_Image");

    if (VIP2PPM_Image(im, out_arg) != OK)
	exit(1);
    else
	exit(0);
}
