/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		stat.c - Produce statistics of an image.
* REVISION:             3.2
* AUTHOR:               CA/DH
* CREATION DATE:        DH
* REVISION DATE:	9/16/93        
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.2
* REVISION DATE:	16 Sept 1993
* COMMENT:		Added more functionality - image type info etc.
* BY:			CFF
*
* REVISION:		3.1
* REVISION DATE:	11 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
* REVISION:		
* REVISION DATE:		08 Jan 1992
* COMMENT:			NEWVIP
* BY:				DH
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)stat.c	3.2 9/16/93";
#endif


#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "vip.h"
#include "misc.h"


/*- Usage -----------------------------------------------------------

Print error message and exit program.

--------------------------------------------------------------------*/

void Usage()
{
    (void) fprintf(stderr, "usage: stat [-d] [-v] [file]\n");
    exit(1);
}


/*- Pperror ---------------------------------------------------------

Print error message and exit program.

--------------------------------------------------------------------*/

void Pperror(e)
char   *e;
{
    (void) fprintf(stderr, "stat: %s\n", e);
    exit(1);
}


/*- Main ------------------------------------------------------------

Main body of the program.

--------------------------------------------------------------------*/

main(argc, argv)
int     argc;
char   *argv[];
{
    int     argn, i;
    int     cnt1[256], cnt2[256], cnt3[256];
    double  mean1, mean2, mean3, var1, var2, var3;
    double  min1, min2, min3, max1, max2, max3;
    IMAGE  *im;
    int     var_arg = 0, dist_arg = 0;
    char   *file_arg = NULL;
    static char *str[2][3] = {{"R", "G", "B"}, {"H", "S", "I"}};
    static char *image_type[8] = {"BYTETYPE","SHORTTYPE","LONGTYPE","FLOATTYPE","DOUBLETYPE","COMPLEXTYPE","RGBTYPE","HSITYPE"};

    for (argn = 1; argn < argc; argn++)
	if (argv[argn][0] == '-')
	    switch (argv[argn][1]) {
	    case 'd':
		dist_arg = argn;
		break;
	    case 'v':
		var_arg = argn;
		break;
	    default:
		Usage();
	    }
	else if (!file_arg)
	    file_arg = argv[argn];
	else
	    Usage();


    if (!(im = ( IMAGE * ) Read_Image(file_arg)))
	Pperror("Error return in Read_Image");

/*  
    if (dist_arg) {
        switch (im->type) {
        case 1:
	case 7:
	case 8:
	default:
	   Pperror("-d parameter only valid with image file");
	}
    }
*/

    Image_Mean(im, &mean1, &mean2, &mean3);
    Image_Min_Max(im, &min1, &max1, &min2, &max2, &min3, &max3);
    if (var_arg)
	Image_Variance(im, mean1, mean2, mean3, &var1, &var2, &var3);
    if (dist_arg)
	Image_Count(im, cnt1, cnt2, cnt3);

    (void) printf("image            = %s\n", file_arg);
    (void) printf("number of rows   = %d\n", im->rows);
    (void) printf("number of cols   = %d\n", im->cols);
    (void) printf("number of pixels = %ld\n", (long) im->rows * (long) im->cols);
    (void) printf("image type       = %s\n",image_type[im->type - 1]); 
				                      /* .....image types start with 1 not 0 */
    (void) printf("image version    = %d.%d\n",im->version[0],im->version[1]);
    (void) printf("image resolution = %f\n",im->resolution);
    (void) printf("image info       = %s\n",im->info);
    switch (im->type) {
    case BYTETYPE:
    case SHORTTYPE:
    case LONGTYPE:
    case FLOATTYPE:
    case DOUBLETYPE:
	(void) printf("minimum          = %f\n", min1);
	(void) printf("maximum          = %f\n", max1);
	(void) printf("mean             = %f\n", mean1);
	if (var_arg)
	    (void) printf("variance         = %f\n", var1);
	if (dist_arg) {
	    (void) printf("distribution     =\n");
	    for (i = 0; i < 256; i++)
		if (cnt1[i])
		    (void) printf("\t\t%d: %ld\n", i, cnt1[i]);
	}
	break;
    case COMPLEXTYPE:
	(void) printf("(min-real,min-imag)   = (%f,%f)\n", min1, min2);
	(void) printf("(max-real,max-imag)   = (%f,%f)\n", max1, max2);
	(void) printf("(mean-real,mean-imag) = (%f,%f)\n", mean1);
	if (var_arg)
	    (void) printf("(variance-real,variance-imag) = (%f,%f)\n", var1, var2);
	break;
    case RGBTYPE:
    case HSITYPE:
	(void) printf("(min-%s,min-%s,min-%s)   = (%f,%f,%f)\n",
	       str[im->type - RGBTYPE][0],
	       str[im->type - RGBTYPE][1],
	       str[im->type - RGBTYPE][2], min1, min2, min3);
	(void) printf("(max-%s,max-%s,max-%s)   = (%f,%f,%f)\n",
	       str[im->type - RGBTYPE][0],
	       str[im->type - RGBTYPE][1],
	       str[im->type - RGBTYPE][2],
	       max1, max2, max3);
	(void) printf("(mean-%s,mean-%s,mean-%s) = (%f,%f,%f)\n",
	       str[im->type - RGBTYPE][0],
	       str[im->type - RGBTYPE][1],
	       str[im->type - RGBTYPE][2],
	       mean1, mean2, mean3);
	if (var_arg)
	    (void) printf("(variance-%s,variance-%s,variance-%s) = (%f,%f,%f)\n",
		   str[im->type - RGBTYPE][0],
		   str[im->type - RGBTYPE][1],
		   str[im->type - RGBTYPE][2],
		   var1, var2, var3);
	break;
    default:
	break;
    }
    exit(0);
}
